jQuery( function() {
	jQuery( ".dap_add_coupon_datepicker" ).datepicker({dateFormat: 'yy-mm-dd'}).val();
	
	/*jQuery('.selected.add_product_coupon').click(function(){
		jQuery('.custom_dropdown').toggle();
	});	
	*/
	jQuery(".date_picker_div").on("click",function(){
		jQuery(this).siblings('.dap_add_coupon_datepicker').datepicker("show");
	});
	
	jQuery("#discount_type").on("change",function(){
			var discount_type_val = jQuery(this).val();
			
			if(discount_type_val == 'percent'){
				jQuery(".discount_amount,.recurring_discount_amount").hide();
				jQuery(".discount_amount_percent,.recurring_discount_percent").show();
				
			}else if(discount_type_val == 'amount'){
				jQuery(".discount_amount_percent,.recurring_discount_percent").hide();
				jQuery(".discount_amount,.recurring_discount_amount").show();
				
			}
	});
	
});

function dap_show_tab_by_id(tab_id){
	
	jQuery('html, body').animate({
		scrollTop: 0
	}, 100);
	
	jQueryCS('#add_new_coupon_tab a[href="'+tab_id+'"]').tab('show');
}

function dap_goto_next_tab(tab_id){
	jQuery('#add_new_coupon_tab a[href="'+tab_id+'"]').trigger('click');
}

function dap_add_new_coupons(next_tab_id = ''){
	
	var coupon_name = jQuery('input[name="coupon_name"]').val();
	if(coupon_name == ''){
		dap_goto_next_tab('#general');
		var msg  = 'Please enter coupon name';
		dap_show_alert(msg);
		return false;
	}
	var start_date = jQuery('input[name="start_date"]').val();
	if(start_date == ''){
		dap_goto_next_tab('#general');
		var msg  = 'Start date cannot be empty';
		dap_show_alert(msg);
		return false;
	}
	var end_date = jQuery('input[name="end_date"]').val();
	if(end_date == ''){
		dap_goto_next_tab('#general');
		var msg  = 'End date cannot be empty';
		dap_show_alert(msg);
		return false;
	}
	var discount_type = jQuery('select[name="discount_type"]').val();
	var initial_discount = jQuery('input[name="initial_discount"]').val();
	if(initial_discount == '' || parseInt(initial_discount) <= 0){
		dap_goto_next_tab('#general');
		if(discount_type == 'amount'){
			var msg  = 'Sorry, initial discount cannot be empty or 0.';
			
		}else if(discount_type == 'percent'){
			var msg  = 'Sorry, Discount amount percentage cannot be empty or 0.';
		}
		dap_show_alert(msg);
		return false;
	}
	
	
	var coupon_edit_id = jQuery('input[name="coupon_edit_id"]').val(); 
	var description = jQuery('input[name="description"]').val();
	var max_usage = jQuery('input[name="max_usage"]').val();
	var actual_usage = jQuery('input[name="actual_usage"]').val();
	
	var recurring_discount = jQuery('input[name="recurring_discount"]').val();
	var products_ids  = [];
	jQuery('.custom_dropdown_add_coupon_to_product input:checkbox[name=dap_product_id]:checked').each(function(){
		products_ids.push(jQuery(this).val());
		
	});
	
	if(next_tab_id == ''){
		if(products_ids.length == 0){
			var msg  = 'Please select one or more product.';
			dap_show_alert(msg);
			return false;
		}
	}
	var dataArray = {
						'coupon_name': coupon_name,
						'description': description,
						'start_date': start_date,
						'end_date': end_date,
						'max_usage': max_usage,
						'actual_usage': actual_usage,
						'discount_type': discount_type,
						'initial_discount': initial_discount,
						'recurring_discount': recurring_discount,
						'products_ids': products_ids,
						'coupon_edit_id': coupon_edit_id,
						};

		dap_add_update_coupon_info(dataArray,next_tab_id);
	
	
	
	
}

function dap_add_update_coupon_info(dataArray,next_tab_id){
	
	dap_show_loader();
	var ajax_url = 'ajax/manageProductsAjax.php';
	jQuery.ajax({
		url: ajax_url,
			type:'POST',
			data:{
				operation_name : 'add_update_coupon',		
				dataArray :dataArray,
			} ,
			success: function(response){
				dap_hide_loader();
				var response = JSON.parse(response);
				
				if(response.id){
					jQuery('#coupon_edit_id').val(response.id);
				}
				if(next_tab_id == ''){
					if(response.success){
						jQuery(".dap_coupons_add_messages").show();
						swal("Saved!", response.success, "success");
						jQuery('html,body', window.parent.document).animate({ scrollTop: '0px' }, 'slow');
					}
				}
				
				if(response.coupon_name){
					next_tab_id = "#general";
				}
				
				if(next_tab_id != ''){
					dap_goto_next_tab(next_tab_id);
				}
				if(response.error){
					swal("", response.error, "error");
					jQuery('html,body', window.parent.document).animate({ scrollTop: '0px' }, 'slow');
					return false;
				}
			}
	});
}


function dap_show_loader(){
	
	jQuery('.dap_coupon_loading_wrapper').show();
}

function dap_hide_loader(){
	jQuery('.dap_coupon_loading_wrapper').hide();
}

function dap_show_alert(msg){
	swal(msg);
	jQuery('html,body', window.parent.document).animate({ scrollTop: '0px' }, 'slow');
}
