google.charts.load('current', {'packages':['line']});
google.charts.setOnLoadCallback(drawTrackingChart);
    
    function drawTrackingChart(){
		var data = new google.visualization.DataTable();
		data.addColumn('date', 'Date');
		data.addColumn('number', 'Delivered');
		data.addColumn('number', 'Opens');
		data.addColumn('number', 'Clicks');
		data.addColumn('number', 'Bounced');
		data.addColumn('number', 'Unsubscribed');
		data.addColumn('number', 'Complained');

	
		for(i=0; i<tracking_data.length;i++){
			data.addRow([new Date(tracking_data[i].date),parseInt(tracking_data[i].delivered),parseInt(tracking_data[i].opens),parseInt(tracking_data[i].clicks),parseInt(tracking_data[i].bounced),parseInt(tracking_data[i].unsubscribed),parseInt(tracking_data[i].complained)]);
		}  
		
		var start = '';
		var end = '';
		
		if(tracking_data.length > 0){
			var start = new Date(tracking_data[0].date);
			var end   = new Date(tracking_data[tracking_data.length-1].date);
		}
		
		var options = {
		chart: {
		  title: '',
		  subtitle: '',
		},
		chartArea: {
			width: '94%'
		},
		hAxis: {
          title: 'Date',
          format: 'dd-MMMM',
          viewWindow: {
            min: start,   /* doing -1 because in js date object months start from 0 */
            max: end
          }
        },
		width: '100%',
		height: 420,
		pointSize: 30,
		legend: {position: 'none'},
		
		series: {
			0: { color: '#e2431e' },
			1: { color: '#e7711b' },
			2: { color: '#f1ca3a' },
			3: { color: '#6f9654' },
			4: { color: '#1c91c0' },
			5: { color: '#43459d' },
		},
		
		};

		var chart = new google.charts.Line(document.getElementById('trackingchart1'));

		chart.draw(data, options);
	}
	
	google.charts.load('current', {'packages':['corechart']});
    google.charts.setOnLoadCallback(drawTrackingPieChart);
	
	function drawTrackingPieChart(){
		
        var data = google.visualization.arrayToDataTable([
          ['Event', 'Total'],
          ['delivered',     piechartdata['delivered']],
          ['opens',     piechartdata['opens']],
          ['clicks',     piechartdata['clicks']],
          ['unique_clicks',     piechartdata['unique_clicks']],
          ['bounced',     piechartdata['bounced']],
          ['unsubscribed',     piechartdata['unsubscribed']],
          ['complained',     piechartdata['complained']],
        ]);

        var options = {
		chartArea: {
			width: '94%'
		},
		width: '100%',
		height: 420,
		legend: {position: 'bottom'}
	};

        var chart = new google.visualization.PieChart(document.getElementById('trackingpiechart'));

        chart.draw(data, options);
	}
    
    jQuery(document).ready(function(){
		jQuery(".date-picker").datepicker({
			dateFormat: "yy-mm-dd"
		});
		
		jQuery('#RunAll').on('click',function(){
			var start = jQuery('#start_date').val();
			var end = jQuery('#end_date').val();
			var url = window.location.href;
			var tracking_id = jQuery('#tracking_id:visible').val();
			
			if(url.indexOf("?")!="-1"){
				var a = url.indexOf("?");
				var b =  url.substring(a);
				var url = url.replace(b,"");
			}
			url = url+'?start='+start+'&end='+end;
			
			if(tracking_id != "" && tracking_id != undefined)
				url = url+'?start='+start+'&end='+end+'&tracking_id='+tracking_id;
			
			window.location = url;
		});
		
		jQuery('#tracking_details').DataTable({
			"initComplete": function (){
			},
			"aaSorting": [],
			"pageLength": 25,
			"bSort" : false
		});
		
		jQuery('#unique_tracking').DataTable({
			"initComplete": function (){
			},
			"aaSorting": [],
			"pageLength": 25,
			"bSort" : false
		});
		
		jQuery(document).on('click','.tracking_row',function(){
			var id = jQuery(this).attr('id');
			jQuery('.'+id).slideToggle('slow');
		});
	
		jQuery('#search_type').on('change',function(){
			if(jQuery(this).val() == 1){
				jQuery('#tracking_id').hide();
			}else{
				jQuery('#tracking_id').show();
			}
		});
	
	});
