jQuery(window).load(function(){
	var url = document.referrer;
	jQuery('#custom_role_save').click(function(){
		var top_height = jQuery(window.top).height();
		top_height = top_height - 200;
		var ori_text = jQuery(this).text();
		jQuery(this).text('Saving...');
		var roleId = jQuery('#roleId').val();
		
		var custom_role_name = jQuery('#custom_role_name').val();
		var custom_role_description = jQuery('#custom_role_description').val();
		if(jQuery("#custom_role_name").val().indexOf(' ') >=0 ){
			swal('Cannot use spaces in name');
			if(url != ''){
				jQuery('.swal-modal').css('top' , top_height);
			}
			return false;
		}
		if(custom_role_name == ''){
			swal('Please enter name for Role');
			if(jQuery('#page_url').val() != '' && jQuery('#page_url').val() == 'dapHome'){
				jQuery('.swal-modal').css('top' , top_height);
			}
			jQuery(this).text(ori_text);
			return false;
		}
		if(custom_role_description == ''){
			swal('Please enter description for Role');
			if(url != ''){
				jQuery('.swal-modal').css('top' , top_height);
			}
			jQuery(this).text(ori_text);
			return false;
		}
		
		jQuery.ajax({
			type: 'POST',
			url: '/dap/admin/ajax/dapProductRoleAjax.php',
			data: {'whatRequest':'saveCustomRole','roleId':roleId,'custom_role_name':custom_role_name , 'custom_role_description':custom_role_description},
			success: function(resource) {	
				if(resource == 'name_exists'){
					swal('Role name already exists');
				}else{
					jQuery('#close_custom_popup').trigger('click');
					location.reload();
				}
				jQuery('#custom_role_save').text(ori_text);
			},
			complete: function(){
				
			}
		});
		if(url != ''){
			jQuery('.swal-modal').css('top' , top_height);
		} 
	});
	
	jQuery('.update_custom').click(function(){
		var top_height = jQuery(window.top).height();
		top_height = top_height - 200;
		var id = jQuery(this).attr('data-id');
		var custom_role_name = jQuery('.input_custom_name_'+id).val();
		var custom_role_description = jQuery('.input_custom_desp_'+id).val();
		
		if(custom_role_name == ''){
			swal('Please enter name for Role');
		if(url != ''){
				jQuery('.swal-modal').css('top' , top_height);
		}
			return false;
		}
		if(custom_role_description == ''){
			swal('Please enter description for Role');
			if(url != ''){
				jQuery('.swal-modal').css('top' , top_height);
			}
			return false;
		}
		
		jQuery.ajax({
			type: 'POST',
			url: '/dap/admin/ajax/dapProductRoleAjax.php',
			data: {'whatRequest':'saveCustomRole','roleId':id,'custom_role_name':custom_role_name , 'custom_role_description':custom_role_description},
			success: function(resource) {	
				if(resource == 'name_exists'){
					swal('Role name already exists');
					if(url != '' ){
						jQuery('.swal-modal').css('top' , top_height);
					}
				}else{
					jQuery('.span_custom_name_'+id).text(custom_role_name);
					jQuery('.span_custom_desp_'+id).text(custom_role_description);
					jQuery('.input_custom_name_'+id).hide();
					jQuery('.input_custom_desp_'+id).hide();
					jQuery('.span_custom_name_'+id).show();
					jQuery('.span_custom_desp_'+id).show();
					jQuery('#edit_custom_'+id).show();
					jQuery('#update_custom_'+id).hide();
				}
			},
			complete: function(){
				
			}
		}); 
	});
	
	
	jQuery('.save_role_product').click(function(){
		var top_height = jQuery(window.top).height();
		top_height = top_height - 200;
		var productId = jQuery('#all_products').val();
		var roleId = jQuery('#select_custom_role').val();
		var number = jQuery('#priority_number').val();
		if(productId == ''){
			swal('Please select a Product');
			if(jQuery('#page_url').val() != '' && jQuery('#page_url').val() == 'dapHome'){
				jQuery('.swal-modal').css('top' , top_height);
			}
			return false;
		}else if(number == '' || number <= 0){
			swal('Priority cannot be blank or less than 1');
			if(url != ''){
				jQuery('.swal-modal').css('top' , top_height);
			}
			return false;
		}else{
			jQuery.ajax({
				type: 'POST',
				url: '/dap/admin/ajax/dapProductRoleAjax.php',
				data: {'whatRequest':'saveProductRoleMap','roleId':roleId,'productId':productId , 'number':number},
				success: function(resource) {	
					if(resource == 'priority_exists'){
						swal('This priorty number is already assigned to another product. Enter a different number.');
					}else if(resource == 'product_exists'){
						swal("You already have a role mapped to this product. You can edit that role and change it but can't create a new role mapping for the same product. A product cannot be assigned more than 1 role.");
					}else{
						location.reload();
					}
				},
				complete: function(){
					
				}
			}); 
		}
		if(url != ''){
			jQuery('.swal-modal').css('top' , top_height);
		}
	});
	
	jQuery('.update_role_product').click(function(){
		var top_height = jQuery(window.top).height();
		top_height = top_height - 200;
		var id = jQuery(this).attr('data-id');
		var productId = jQuery('#all_products_'+id).val();
		var roleId = jQuery('#select_custom_role_'+id).val();
		var number = jQuery('#priority_number_'+id).val();
		if(productId == ''){
			swal('Please select a Product');
			if(url != '' ){
				jQuery('.swal-modal').css('top' , top_height);
			}
			return false;
		}else if(number == '' || number <= 0){
			swal('Priority cannot be blank or less than 1');
			if(url != '' ){
				jQuery('.swal-modal').css('top' , top_height);
			}
			return false;
		}else{
			jQuery.ajax({
				type: 'POST',
				url: '/dap/admin/ajax/dapProductRoleAjax.php',
				data: {'whatRequest':'saveProductRoleMap', 'id':id , 'roleId':roleId,'productId':productId , 'number':number},
				success: function(resource) {	
					if(resource == 'priority_exists'){
						swal('This priorty number is already assigned to another product. Please enter a different number.');
					}else if(resource == 'product_exists'){
						swal("You already have role mapped to this product. You can edit that role and change it but can't create a new role mapping for the same product. A product cannot be assigned more than 1 role.");
					}else{
						location.reload();
					}
				},
				complete: function(){
					
				}
			}); 
		}
		if(url != ''){
			jQuery('.swal-modal').css('top' , top_height);
		}
	});
	
	
	jQuery('.del_role_product').click(function(){
		var top_height = jQuery(window.top).height();
		top_height = top_height - 200;
		var id = jQuery(this).attr('data-id');
		swal({
			title: "Are you sure?",
			text: "Do you really want to delete this Mapping?",
			icon: "warning",
			buttons: true,
			dangerMode: true,
		})
		.then((willDelete) => {
			if (willDelete) {
				jQuery.ajax({
					type: 'POST',
					url: '/dap/admin/ajax/dapProductRoleAjax.php',
					data: {'whatRequest':'deleteProductRoleMap', 'id':id},
					success: function(resource) {	
						location.reload();
					},
					complete: function(){

					}
				}); 
			}
		});
		if(url != ''){
			jQuery('.swal-modal').css('top' , top_height);
		}
	});
	
	
	jQuery('.del_custom_role').click(function(){
		var top_height = jQuery(window.top).height();
		top_height = top_height - 350;
		var id = jQuery(this).attr('data-id');
		swal({
			title: "Are you sure?",
			text: "Do you really want to delete this Role?",
			icon: "warning",
			buttons: true,
			dangerMode: true,
		})
		.then((willDelete) => {
			if (willDelete) {
				jQuery.ajax({
					type: 'POST',
					url: '/dap/admin/ajax/dapProductRoleAjax.php',
					data: {'whatRequest':'deleteCustomRole', 'id':id},
					success: function(resource) {	
						location.reload();
					},
					complete: function(){

					}
				}); 
			}
		});
		if(url != '' ){
			jQuery('.swal-modal').css('top' , top_height);
		}
	});
	
	jQuery('.create_new_role').click(function(){
		jQuery('#custom_role_modal').trigger('click');
		if(url != '' ){
			jQuery('.model-popup').css('top' , '250px');
		}	
		   
	});
	
	jQuery('#create_new_mapping').click(function(){
		jQuery('#custom_role_mapping').show();			
	});
	
	jQuery('.remove_role_product').click(function(){
		jQuery('#custom_role_mapping').hide();				
	});
	
	jQuery('.edit_role_product').click(function(){
		var id = jQuery(this).attr('data-id');
		jQuery('#priority_number_'+id).attr('disabled' , false);
		jQuery('#select_custom_role_'+id).attr('disabled' , false);	
		jQuery('#all_products_'+id).attr('disabled' , false);	
		jQuery('#edit_role_product_'+id).hide();
		jQuery('#update_role_product_'+id).show();
		
	});
	
	jQuery('.edit_custom').click(function(){
		var id = jQuery(this).attr('data-id');
		jQuery('.span_custom_name_'+id).hide();
		jQuery('.span_custom_desp_'+id).hide();
		jQuery('.input_custom_name_'+id).show();
		jQuery('.input_custom_desp_'+id).show();
		jQuery('#edit_custom_'+id).hide();
		jQuery('#update_custom_'+id).show();
	});
	

	
});
