<?php
class DAP_CreditsNotification{
	
	var $id;
	var $action;
	var $subject;
	var $body;
	var $date;
	var $status;
	
	function getStatus() {
		return $this->status;
	}
	
	function setStatus($o) {
		$this->status = $o;
	}
	
	function getId() {
		return $this->id;
	}
	
	function setId($o) {
		$this->id = $o;
	}
	
	function getAction() {
		return $this->action;
	}
	
	function setAction($o) {
		$this->action = $o;
	}
	
	
	function getSubject() {
		return $this->subject;
	}
	
	function setSubject($o) {
		$this->subject = $o;
	}
	
	function getBody() {
		return $this->body;
	}
	
	function setBody($o) {
		$this->body = $o;
	}
	 
	
	function getDate() {
		return $this->date;
	}
	function setDate($o) {
		$this->date = $o;
	}
	
	
	
	
	public function create() {
		try {
			$dap_dbh = Dap_Connection::getConnection();
			 
			$sql = "insert into dap_credits_email_notification
						(action, subject, body, date,status )
					values
						(:action, :subject, :body, :date, :status)";
			
		 
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':action', $this->getAction(), PDO::PARAM_STR);
 			$stmt->bindParam(':subject', $this->getSubject(), PDO::PARAM_STR);
			$stmt->bindParam(':body', $this->getBody(), PDO::PARAM_STR);
			$stmt->bindParam(':date', $this->getDate(), PDO::PARAM_STR);
			$stmt->bindParam(':status', $this->getStatus(), PDO::PARAM_STR);

			$stmt->execute();

			return $dap_dbh->lastInsertId();
			$stmt = null;
			$dap_dbh = null;

		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
	}

	
	
	
	public function update() {
		try {
			$dap_dbh = Dap_Connection::getConnection();
			
			$sql = "update dap_credits_email_notification set
						subject = :subject,
						body = :body,
						date = :date,
						status = :status
					where
						action = :action";
			
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':subject', $this->getSubject(), PDO::PARAM_STR);
			$stmt->bindParam(':body', $this->getBody(), PDO::PARAM_STR);
			$stmt->bindParam(':date', $this->getDate(), PDO::PARAM_STR);
			$stmt->bindParam(':status', $this->getStatus(), PDO::PARAM_INT);
			$stmt->bindParam(':action', $this->getAction(), PDO::PARAM_STR);
			$stmt->execute();
			$stmt = null;
			$dap_dbh = null;

			return;

		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
	}
	
	
	public static function loadByAction($action = ''){
		$LoadList = array(); 
		$sql = "select * from dap_credits_email_notification where	action = '".$action."'";		 

		try {
			$dap_dbh = Dap_Connection::getConnection();
			$stmt = $dap_dbh->prepare($sql);
			$stmt->execute();

			while ($row = $stmt->fetch()) {
				$data = new DAP_CreditsNotification();

				$data->setId( $row["id"] );
				$data->setSubject( $row["subject"] );
				$data->setBody( $row["body"] );
				$data->setAction( $row["action"] );
				$data->setDate( $row["date"] ); 
				$data->setStatus( $row["status"] ); 
				return $data;
			}
            return false;
			 
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
	} 
	
	
	public static function loadByActionAndStatus($action = ''){
		$LoadList = array(); 
		$sql = "select * from dap_credits_email_notification where	status = '1' and action = '".$action."'";		 
logToFile("dap_credits_email_notification loadByActionAndStatus(): sql".$sql,LOG_DEBUG_DAP); 
		try {
			$dap_dbh = Dap_Connection::getConnection();
			$stmt = $dap_dbh->prepare($sql);
			$stmt->execute();

			while ($row = $stmt->fetch()) {
				$data = new DAP_CreditsNotification();

				$data->setId( $row["id"] );
				$data->setSubject( $row["subject"] );
				$data->setBody( $row["body"] );
				$data->setAction( $row["action"] );
				$data->setDate( $row["date"] ); 
				$data->setStatus( $row["status"] ); 
				return $data;
			}
          return false;
			 
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
	} 
	 
	//Load  
	public static function load() {
		$LoadList = array(); 
		$sql = "select * from dap_credits_email_notification ";		 

		try {
			$dap_dbh = Dap_Connection::getConnection();
			$stmt = $dap_dbh->prepare($sql);
			$stmt->execute();

			while ($row = $stmt->fetch()) {
				$data = new DAP_CreditsNotification();

				$data->setId($row["id"] );
				$data->setSubject($row["subject"] );
				$data->setBody($row["body"] );
				$data->setAction($row["action"] );
				$data->setDate($row["date"] ); 
				$data->setStatus($row["status"] ); 
				$LoadList[] = $data;
			}

			return $LoadList;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
	}


	
	
}
