<?php
class DAP_EmailSetting{
	
	var $id;
	var $name;
	var $email;
	var $date;
	
	function getName() {
		return $this->name;
	}
	
	function setName($o) {
		$this->name = $o;
	}
	
	function getEmail() {
		return $this->email;
	}
	function setEmail($o) {
		$this->email = $o;
	}
	
	
	function getId() {
		return $this->id;
	}
	
	function setId($o) {
		$this->id = $o;
	}
	
	function getDate() {
		return $this->date;
	}
	function setDate($o) {
		$this->date = $o;
	}
	
	
	
	
	public function create() {
		try {
			$dap_dbh = Dap_Connection::getConnection();
			 
			$sql = "insert into dap_email_setting
						(name, email, date )
					values
						(:name, :email, :date)";
			
		 
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':name', $this->getName(), PDO::PARAM_STR);
 			$stmt->bindParam(':email', $this->getEmail(), PDO::PARAM_STR);
			$stmt->bindParam(':date', $this->getDate(), PDO::PARAM_STR);

			$stmt->execute();

			return $dap_dbh->lastInsertId();
			$stmt = null;
			$dap_dbh = null;

		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
	}

	
	
	
	public function update() {
		try {
			$dap_dbh = Dap_Connection::getConnection();
			
			$sql = "update dap_email_setting set
						name = :name,
						email = :email,
						date = :date
					where
						id = :id";
			
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':name', $this->getName(), PDO::PARAM_STR);
			$stmt->bindParam(':email', $this->getEmail(), PDO::PARAM_STR);
			$stmt->bindParam(':date', $this->getDate(), PDO::PARAM_STR);
			$stmt->bindParam(':id', $this->getId(), PDO::PARAM_INT);
			$stmt->execute();
			$stmt = null;
			$dap_dbh = null;

			return;

		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
	}
	
	
	//Load  
	public static function load() {
		$LoadList = array(); 
		$sql = "select * from dap_email_setting ";		 

		try {
			$dap_dbh = Dap_Connection::getConnection();
			$stmt = $dap_dbh->prepare($sql);
			$stmt->execute();

			while ($row = $stmt->fetch()) {
				$data = new DAP_EmailSetting();
				$data->setId($row["id"] );
				$data->setName($row["name"] );
				$data->setEmail($row["email"] );
				$data->setDate($row["date"] ); 
				$LoadList[] = $data;
			}

			return $LoadList;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
	}
	
	
	//Load  
	public static function loadById($id = 0) {
		
		$sql = "select * from dap_email_setting where id=".$id;		 

		try {
			$dap_dbh = Dap_Connection::getConnection();
			$stmt = $dap_dbh->prepare($sql);
			$stmt->execute();

			while ($row = $stmt->fetch()) {
				$data = new DAP_EmailSetting();
				$data->setId($row["id"] );
				$data->setName($row["name"] );
				$data->setEmail($row["email"] );
				$data->setDate($row["date"] ); 
				return  $data;
			}

			return false;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
	}
	
}
