<?php
class DAP_FailedPaymentSettings{
	var $id;
	var $payment_processor;
	var $type;	
	var $subject;	 
	var $body;	 
	var $send_email;
	
	function getId() {
		return $this->id;
	}
	
	function setId($o) {
		$this->id = $o;
	}
	
	function getPaymentProcessor() {
		return $this->payment_processor;
	}
	
	function setPaymentProcessor($o) {
		$this->payment_processor = $o;
	}
	
	function getTransactionType() {
		return $this->transaction_type;
	}
	
	function setTransactionType($o) {
		$this->transaction_type = $o;
	}
	
	function getSubject() {
		return $this->subject;
	}
	
	function setSubject($o) {
		$this->subject = $o;
	}
	
	function getBody() {
		return $this->body;
	}
	
	function setBody($o) {
		$this->body = $o;
	}
	
	function getSendEmail() {
		return $this->send_email;
	}
	
	function setSendEmail($o) {
		$this->send_email = $o;
	}
	
	public function create() {
		try {
			$dap_dbh = Dap_Connection::getConnection();
			 
			$sql = "insert into dap_failed_payment_settings
						(payment_processor, transaction_type, subject, body, send_email)
					values
						(:payment_processor, :transaction_type, :subject, :body, :send_email)";			
		 
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':payment_processor', $this->getPaymentProcessor(), PDO::PARAM_STR);
 			$stmt->bindParam(':transaction_type', $this->getTransactionType(), PDO::PARAM_STR);
			$stmt->bindParam(':subject', $this->getSubject(), PDO::PARAM_STR);			 	
			$stmt->bindParam(':body', $this->getBody(), PDO::PARAM_STR);			 	
			$stmt->bindParam(':send_email', $this->getSendEmail(), PDO::PARAM_STR);			 	

			$stmt->execute();
 
			return $dap_dbh->lastInsertId();
			$stmt = null;
			$dap_dbh = null;

		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
	}

	
	
	
	public function update() {
		try {
			$dap_dbh = Dap_Connection::getConnection();			
			
			$sql = "update dap_failed_payment_settings set
						payment_processor = :payment_processor,
						transaction_type = :transaction_type,
						subject = :subject,						
						body = :body,						
						send_email = :send_email
					where
						id = :id";
		 
	
		 
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':payment_processor', $this->getPaymentProcessor(), PDO::PARAM_STR);
 			$stmt->bindParam(':transaction_type', $this->getTransactionType(), PDO::PARAM_STR);
			$stmt->bindParam(':subject', $this->getSubject(), PDO::PARAM_STR);			 	
			$stmt->bindParam(':body', $this->getBody(), PDO::PARAM_STR);			 	
			$stmt->bindParam(':send_email', $this->getSendEmail(), PDO::PARAM_STR);			 
			$stmt->bindParam(':id', $this->getId(), PDO::PARAM_STR);

			$stmt->execute();		
			
			$stmt = null;
			$dap_dbh = null;

			return;

		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
	}
	
	
	public static function loadByPaymentProcessorAndType($payment_processor, $transaction_type) {
		$dap_dbh = Dap_Connection::getConnection();

		$sql = "select *
			from
				dap_failed_payment_settings
			where
				payment_processor = :payment_processor AND transaction_type = :transaction_type" ;
		
		logToFile("loadByPaymentProcessorAndType: ENTER", LOG_DEBUG_DAP);
		
		try {
			
		$stmt = $dap_dbh->prepare($sql);
		$stmt->bindParam(':payment_processor', $payment_processor, PDO::PARAM_STR);
		$stmt->bindParam(':transaction_type', $transaction_type, PDO::PARAM_STR);
		$stmt->execute();
		
		logToFile("loadByPaymentProcessorAndType: load transactions", LOG_DEBUG_DAP);
		
		if ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
			$failedPaymentSettings = new DAP_FailedPaymentSettings();
			$failedPaymentSettings->setId( $row["id"] );
			$failedPaymentSettings->setPaymentProcessor($row["payment_processor"]);
			$failedPaymentSettings->setTransactionType($row["transaction_type"]);
			$failedPaymentSettings->setSubject($row["subject"]);
			$failedPaymentSettings->setBody($row["body"]);
			$failedPaymentSettings->setSendEmail( $row["send_email"] );
			
			return $failedPaymentSettings;
		}
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}

		return;
	}


	
	
}
