<?php 
class DAP_GopShortcode{
	
	var $id;
	var $name;
	var $action;
	var $template;
	var $template_html;
	var $styling_options;
	var $date;

	
	function getId() {
		return $this->id;
	}
	function setId($o) {
		$this->id = $o;
	}
	
	function getName() {
		return $this->name;
	}
	function setName($o) {
		$this->name = $o;
	}
	
	function getAction() {
		return $this->action;
	}
	function setAction($o) {
		$this->action = $o;
	}
	
	function getTemplate() {
		return $this->template;
	}
	function setTemplate($o) {
		$this->template = $o;
	}
	
	function getTemplateHtml() {
		return $this->template_html;
	}
	function setTemplateHtml($o) {
		$this->template_html = $o;
	}
	
	function getStylingOptions() {
		return $this->styling_options;
	}
	function setStylingOptions($o) {
		$this->styling_options = $o;
	}
	
	function getDate() {
		return $this->date;
	}
	function setDate($o) {
		$this->date = $o;
	}
	
	
	
    public function create() {
		try {
			$dap_dbh = Dap_Connection::getConnection();
			
			$tableName = "dap_gop_shortcode";
			
			$sql = "insert into ".$tableName." 
						(name, action, template,template_html,styling_options,date )
					values
						(:name, :action, :template, :template_html, :styling_options, :date)";
			
		 
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':name', $this->getName(), PDO::PARAM_STR);
 			$stmt->bindParam(':action', $this->getAction(), PDO::PARAM_STR);
			$stmt->bindParam(':template', $this->getTemplate(), PDO::PARAM_STR);
			$stmt->bindParam(':template_html', $this->getTemplateHtml(), PDO::PARAM_STR);
			$stmt->bindParam(':styling_options', $this->getStylingOptions(), PDO::PARAM_STR);
			$stmt->bindParam(':date', $this->getDate(), PDO::PARAM_STR);
			$stmt->execute();
            $stmt = null;
            $last_id = $dap_dbh->lastInsertId();
			$dap_dbh = null;
			return $last_id;
			

		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
	}
    
   
	/*
	 * update message in database
	 */ 
	public function update() {
		
		try {
			$dap_dbh = Dap_Connection::getConnection();
			$tableName = "dap_gop_shortcode";
			
			$sql = "update ".$tableName." set
						name = :name,
						action = :action,
						template = :template,
						template_html = :template_html,
						styling_options = :styling_options,
						date = :date
						where	id = :id";
		
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':name', $this->getName(), PDO::PARAM_STR);
 			$stmt->bindParam(':action', $this->getAction(), PDO::PARAM_STR);
			$stmt->bindParam(':template', $this->getTemplate(), PDO::PARAM_STR);
			$stmt->bindParam(':template_html', $this->getTemplateHtml(), PDO::PARAM_STR);
			$stmt->bindParam(':styling_options', $this->getStylingOptions(), PDO::PARAM_STR);
			$stmt->bindParam(':date', $this->getDate(), PDO::PARAM_STR);
			$stmt->bindParam(':id', $this->getId(), PDO::PARAM_INT);
			$stmt->execute();
			$stmt = null;
			$dap_dbh = null;
			return $this->getId();

		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
	}
		
	
	/*
	 * load all messages
	*/ 
	public static function load() {
		$LoadList = array(); 
		$tableName = "dap_gop_shortcode";
		$sql = "select * from ".$tableName;		 

		try {
			$dap_dbh = Dap_Connection::getConnection();
			$stmt = $dap_dbh->prepare($sql);
			$stmt->execute();
			
			while ($row = $stmt->fetch()) {
				$data = new DAP_GopShortcode(); 

				$data->setId( $row["id"] );
				$data->setName( $row["name"] );
				$data->setAction( $row["action"] );
				$data->setTemplate( $row["template"] );
				$data->setTemplateHtml( $row["template_html"] );
				$data->setStylingOptions( $row["styling_options"] );
				$data->setDate( $row["date"] );
				$LoadList[] = $data;
			}
			$stmt = null;
			$dap_dbh = null;
			return $LoadList;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
			
	}
	
	
	public static function loadByAction($action = '') {
		
		$LoadList = array(); 
		$tableName = "dap_gop_shortcode";
			
		$sql = "select * from ".$tableName." where action = :action";


		try {
			$dap_dbh = Dap_Connection::getConnection();
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':action', $action, PDO::PARAM_STR); 
			$stmt->execute();

			while ($row = $stmt->fetch()) {
				$data = new DAP_GopShortcode(); 

				$data->setId( $row["id"] );
				$data->setName( $row["name"] );
				$data->setAction( $row["action"] );
				$data->setTemplate( $row["template"] );
				$data->setTemplateHtml( $row["template_html"] );
				$data->setStylingOptions( $row["styling_options"] );
				$data->setDate( $row["date"] );
				$LoadList[] = $data;
			}
			$stmt = null;
			$dap_dbh = null;
			return $LoadList;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
			
	}
	
	
	public static function loadById($id = 0) {
		
		$LoadList = false; 
		try {
			$dap_dbh = Dap_Connection::getConnection();
			$tableName = "dap_gop_shortcode";
			
			$sql = "select * from ".$tableName." where id = :id";
			
			$stmt = $dap_dbh->prepare($sql);
 			$stmt->bindParam(':id', $id, PDO::PARAM_INT);
			
			$stmt->execute();
			
			while ($row = $stmt->fetch()) {
				$data = new DAP_GopShortcode(); 
				$data->setId( $row["id"] );
				$data->setName( $row["name"] );
				$data->setAction( $row["action"] );
				$data->setTemplate( $row["template"] );
				$data->setTemplateHtml( $row["template_html"] );
				$data->setStylingOptions( $row["styling_options"] );
				$data->setDate( $row["date"] );
				$LoadList = $data;
			}
            $stmt = null;
			$dap_dbh = null;
			return $LoadList;
			

		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}			
	}
	
	
	public static function loadByPageId($name = 0) {
		
		$LoadList = false; 
		try {
			$dap_dbh = Dap_Connection::getConnection();
			$tableName = "dap_gop_shortcode";
			
			$sql = "select * from ".$tableName." where name = :name";
			
			$stmt = $dap_dbh->prepare($sql);
 			$stmt->bindParam(':name', $name, PDO::PARAM_INT);
			
			$stmt->execute();
			
			while ($row = $stmt->fetch()) {
				$data = new DAP_GopShortcode(); 
				$data->setId( $row["id"] );
				$data->setName( $row["name"] );
				$data->setAction( $row["action"] );
				$data->setTemplate( $row["template"] );
				$data->setTemplateHtml( $row["template_html"] );
				$data->setStylingOptions( $row["styling_options"] );
				$data->setDate( $row["date"] );
				$LoadList = $data;
			}
            $stmt = null;
			$dap_dbh = null;
			return $LoadList;
			

		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}			
	}
	
	
	
	public static function loadByPageIdAndAction($name = 0,$page_type = '') {
		
		$LoadList = false; 
		try {
			$dap_dbh = Dap_Connection::getConnection();
			$tableName = "dap_gop_shortcode";
			
			$sql = "select * from ".$tableName." where name = :name and action =:action";
			
			$stmt = $dap_dbh->prepare($sql);
 			$stmt->bindParam(':name', $name, PDO::PARAM_INT);
 			$stmt->bindParam(':action', $page_type, PDO::PARAM_STR);
			
			$stmt->execute();
			
			while ($row = $stmt->fetch()) {
				$data = new DAP_GopShortcode(); 
				$data->setId( $row["id"] );
				$data->setName( $row["name"] );
				$data->setAction( $row["action"] );
				$data->setTemplate( $row["template"] );
				$data->setTemplateHtml( $row["template_html"] );
				$data->setStylingOptions( $row["styling_options"] );
				$data->setDate( $row["date"] );
				$LoadList = $data;
			}
            $stmt = null;
			$dap_dbh = null;
			return $LoadList;
			

		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}			
	}
	
	public static function delete($id = ''){
        
        $tableName = "dap_gop_shortcode";
		$sql = "delete from ".$tableName." where `id` =:id";
		
		try{		
			$dap_dbh = Dap_Connection::getConnection();
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':id', $id, PDO::PARAM_INT);
			$stmt->execute();
			$stmt = null;
			$dap_dbh = null;
			return true;
	    } catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
				
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
       	 
	}
	
}
		
	
