<?php
class DAP_LeaderboadDisabledUsers{
	
	var $id;
	var $user_id;
	
	function getId() {
		return $this->id;
	}
	
	function setId($o) {
		$this->id = $o;
	}
	
	function getUserId() {
		return $this->user_id;
	}
	
	function setUserId($o) {
		$this->user_id = $o;
	}
	
	
	public function create() {
		
		try {
			$dap_dbh = Dap_Connection::getConnection();
			 
			$sql = "insert into dap_leaderboad_disabled_users
						(user_id)
					values
						(:user_id)";
			
		
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':user_id', $this->getUserId(), PDO::PARAM_INT);
			$stmt->execute();
			
			$last_id = $dap_dbh->lastInsertId();
			$dap_dbh = null;
			$stmt = null;
			return $last_id;
			
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
	
	}
	
	//Load  
	public static function loadByUserId($user_id = 0) {
		 
		$sql = "select * from dap_leaderboad_disabled_users where user_id = :user_id";		 
		try {
			$dap_dbh = Dap_Connection::getConnection();
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':user_id', $user_id, PDO::PARAM_INT);
			$stmt->execute();
			
			while($row = $stmt->fetch()){
				 return true;
			} 
			return false;
			
		}catch (PDOException $e){
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}catch (Exception $e){
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
	}
	
	 public static function loadAllUser(){

		$sql ="select `user_id` from dap_leaderboad_disabled_users";
		
		try {
			$dap_dbh = Dap_Connection::getConnection();
			$stmt = $dap_dbh->prepare($sql);
			$stmt->execute();
			
			while ($row = $stmt->fetch()) {
				$LoadList[] = $row['user_id'];
			}

			return $LoadList;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
	}
	
	
	 public static function deleteByUserId($user_id = 0){

		$sql = "delete from dap_leaderboad_disabled_users where `user_id` = :user_id";
		try{		
			$dap_dbh = Dap_Connection::getConnection();
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':user_id', $user_id, PDO::PARAM_INT);
			
			$stmt->execute();
			
			return true;
			
	    } catch (PDOException $e) {
				logToFile($e->getMessage(),LOG_FATAL_DAP);
				throw $e;
				
		} catch (Exception $e) {
				logToFile($e->getMessage(),LOG_FATAL_DAP);
				throw $e;
		}
       	 
	}  
	
}
