<?php 
class DAP_MemberPages{
	
	var $id;
	var $page_id;
	var $action;
	var $template;
	var $template_html;
	var $styling_options;
	var $date;
	
	function getId() {
		return $this->id;
	}
	function setId($o) {
		$this->id = $o;
	}
	
	function getPageId() {
		return $this->page_id;
	}
	function setPageId($o) {
		$this->page_id = $o;
	}
	
	function getAction() {
		return $this->action;
	}
	function setAction($o) {
		$this->action = $o;
	}
	
	function getTemplate() {
		return $this->template;
	}
	function setTemplate($o) {
		$this->template = $o;
	}
	
	function getTemplateHtml() {
		return $this->template_html;
	}
	function setTemplateHtml($o) {
		$this->template_html = $o;
	}
	
	function getStylingOptions() {
		return $this->styling_options;
	}
	function setStylingOptions($o) {
		$this->styling_options = $o;
	}
	
	function getDate() {
		return $this->date;
	}
	function setDate($o) {
		$this->date = $o;
	}
	
	
	
    public function create() {
		 
		try {
			$dap_dbh = Dap_Connection::getConnection();
			
			$tableName = "dap_memberpages";
			
			$sql = "insert into ".$tableName." 
						(page_id, action, template,template_html,styling_options,date )
					values
						(:page_id, :action, :template, :template_html, :styling_options, :date)";
			
		
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':page_id', $this->getPageId(), PDO::PARAM_INT);
 			$stmt->bindParam(':action', $this->getAction(), PDO::PARAM_STR);
			$stmt->bindParam(':template', $this->getTemplate(), PDO::PARAM_STR);
			$stmt->bindParam(':template_html', $this->getTemplateHtml(), PDO::PARAM_STR);
			$stmt->bindParam(':styling_options', $this->getStylingOptions(), PDO::PARAM_STR);
			$stmt->bindParam(':date', $this->getDate(), PDO::PARAM_STR);
			$stmt->execute();
           
            $last_id = $dap_dbh->lastInsertId();
            $stmt = null;
			$dap_dbh = null;
			return $last_id;
			

		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
	}
    
   
	/*
	 * update message in database
	 */ 
	public function update() {
		
		try {
			$dap_dbh = Dap_Connection::getConnection();
			$tableName = "dap_memberpages";
			
			$sql = "update ".$tableName." set
						page_id = :page_id,
						action = :action,
						template = :template,
						template_html = :template_html,
						styling_options = :styling_options,
						date = :date
						where	id = :id";
		
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':page_id', $this->getPageId(), PDO::PARAM_INT);
 			$stmt->bindParam(':action', $this->getAction(), PDO::PARAM_STR);
			$stmt->bindParam(':template', $this->getTemplate(), PDO::PARAM_STR);
			$stmt->bindParam(':template_html', $this->getTemplateHtml(), PDO::PARAM_STR);
			$stmt->bindParam(':styling_options', $this->getStylingOptions(), PDO::PARAM_STR);
			$stmt->bindParam(':date', $this->getDate(), PDO::PARAM_STR);
			$stmt->bindParam(':id', $this->getId(), PDO::PARAM_INT);
			$stmt->execute();
			$stmt = null;
			$dap_dbh = null;
			return $this->getId();

		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
	}
		
	
	/*
	 * load all messages
	*/ 
	public static function load() {
		$LoadList = array(); 
		$tableName = "dap_memberpages";
		$sql = "select * from ".$tableName;		 

		try {
			$dap_dbh = Dap_Connection::getConnection();
			$stmt = $dap_dbh->prepare($sql);
			$stmt->execute();
			
			while ($row = $stmt->fetch()) {
				$data = new DAP_MemberPages(); 

				$data->setId( $row["id"] );
				$data->setPageId( $row["page_id"] );
				$data->setAction( $row["action"] );
				$data->setTemplate( $row["template"] );
				$data->setTemplateHtml( $row["template_html"] );
				$data->setStylingOptions( $row["styling_options"] );
				$data->setDate( $row["date"] );
				$LoadList[] = $data;
			}
			$stmt = null;
			$dap_dbh = null;
			return $LoadList;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
			
	}
	
	
	public static function loadByAction($action = '') {
		
		$LoadList = array(); 
		$tableName = "dap_memberpages";
			
		$sql = "select * from ".$tableName." where action = :action";


		try {
			$dap_dbh = Dap_Connection::getConnection();
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':action', $action, PDO::PARAM_STR); 
			$stmt->execute();

			while ($row = $stmt->fetch()) {
				$data = new DAP_MemberPages(); 

				$data->setId( $row["id"] );
				$data->setPageId( $row["page_id"] );
				$data->setAction( $row["action"] );
				$data->setTemplate( $row["template"] );
				$data->setTemplateHtml( $row["template_html"] );
				$data->setStylingOptions( $row["styling_options"] );
				$data->setDate( $row["date"] );
				$LoadList[] = $data;
			}
			$stmt = null;
			$dap_dbh = null;
			return $LoadList;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
			
	}
	
	
	public static function loadById($id = 0) {
		
		$LoadList = false; 
		try {
			$dap_dbh = Dap_Connection::getConnection();
			$tableName = "dap_memberpages";
			
			$sql = "select * from ".$tableName." where id = :id";
			
			$stmt = $dap_dbh->prepare($sql);
 			$stmt->bindParam(':id', $id, PDO::PARAM_INT);
			
			$stmt->execute();
			
			while ($row = $stmt->fetch()) {
				$data = new DAP_MemberPages(); 
				$data->setId( $row["id"] );
				$data->setPageId( $row["page_id"] );
				$data->setAction( $row["action"] );
				$data->setTemplate( $row["template"] );
				$data->setTemplateHtml( $row["template_html"] );
				$data->setStylingOptions( $row["styling_options"] );
				$data->setDate( $row["date"] );
				$LoadList = $data;
			}
			
            $stmt = null;
			$dap_dbh = null;
			return $LoadList;
			

		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}			
	}
	
	
	public static function loadByPageId($page_id = 0) {
		
		$LoadList = false; 
		try {
			$dap_dbh = Dap_Connection::getConnection();
			$tableName = "dap_memberpages";
			
			$sql = "select * from ".$tableName." where page_id = :page_id";
			
			$stmt = $dap_dbh->prepare($sql);
 			$stmt->bindParam(':page_id', $page_id, PDO::PARAM_INT);
			
			$stmt->execute();
			
			while ($row = $stmt->fetch()) {
				$data = new DAP_MemberPages(); 
				$data->setId( $row["id"] );
				$data->setPageId( $row["page_id"] );
				$data->setAction( $row["action"] );
				$data->setTemplate( $row["template"] );
				$data->setTemplateHtml( $row["template_html"] );
				$data->setStylingOptions( $row["styling_options"] );
				$data->setDate( $row["date"] );
				$LoadList = $data;
			}
            $stmt = null;
			$dap_dbh = null;
			return $LoadList;
			

		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}			
	}
	
	
	
	public static function loadByPageIdAndAction($page_id = 0,$page_type = '') {
		
		$LoadList = false; 
		try {
			$dap_dbh = Dap_Connection::getConnection();
			$tableName = "dap_memberpages";
			
			$sql = "select * from ".$tableName." where page_id = :page_id and action =:action";
			
			$stmt = $dap_dbh->prepare($sql);
 			$stmt->bindParam(':page_id', $page_id, PDO::PARAM_INT);
 			$stmt->bindParam(':action', $page_type, PDO::PARAM_STR);
			
			$stmt->execute();
			
			while ($row = $stmt->fetch()) {
				$data = new DAP_MemberPages(); 
				$data->setId( $row["id"] );
				$data->setPageId( $row["page_id"] );
				$data->setAction( $row["action"] );
				$data->setTemplate( $row["template"] );
				$data->setTemplateHtml( $row["template_html"] );
				$data->setStylingOptions( $row["styling_options"] );
				$data->setDate( $row["date"] );
				$LoadList = $data;
			}
            $stmt = null;
			$dap_dbh = null;
			return $LoadList;
			

		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}			
	}
	
	public static function deleteById($id = ''){
        
        $tableName = "dap_memberpages";
		$sql = "delete from ".$tableName." where `id` =:id";
		
		try{		
			$dap_dbh = Dap_Connection::getConnection();
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':id', $id, PDO::PARAM_INT);
			$stmt->execute();
			$stmt = null;
			$dap_dbh = null;
			return true;
	    } catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
				
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
       	 
	}
	
}
		
	
