<?php 
class DAP_MemberPageSettings{
	
	var $id;
	var $action;
	var $name;
	var $value;
	
	function getId() {
		return $this->id;
	}
	function setId($o) {
		$this->id = $o;
	}
	
	function getAction() {
		return $this->action;
	}
	function setAction($o) {
		$this->action = $o;
	}
	function getName() {
		return $this->name;
	}
	function setName($o) {
		$this->name = $o;
	}
	
	function getValue() {
		return $this->value;
	}
	function setValue($o) {
		$this->value = $o;
	}
	
	
    
     public function create() {
		try {
			$dap_dbh = Dap_Connection::getConnection();
			
			$tableName = "dap_memberpages_settings";
			
			$sql = "insert into ".$tableName." 
						(action, name, value )
					values
						(:action, :name, :value)";
			
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':action', $this->getAction(), PDO::PARAM_STR);
 			$stmt->bindParam(':name', $this->getName(), PDO::PARAM_STR);
			$stmt->bindParam(':value', $this->getValue(), PDO::PARAM_STR);
			$stmt->execute();
            $stmt = null;
            $last_id = $dap_dbh->lastInsertId();
			$dap_dbh = null;
			return $last_id;
			

		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
	}
   
	/*
	 * update message in database
	 */ 
	public function update() {
		
		try {
			$dap_dbh = Dap_Connection::getConnection();
			$tableName = "dap_memberpages_settings";
			
			$sql = "update ".$tableName." set
						value = :value
					where
						action = :action and 
						name = :name";
		 
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':value', $this->getValue(), PDO::PARAM_STR);
 			$stmt->bindParam(':action', $this->getAction(), PDO::PARAM_STR);
			$stmt->bindParam(':name', $this->getName(), PDO::PARAM_STR);
			$stmt->execute();
			$stmt = null;
			$dap_dbh = null;
			return true;

		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
	}
		
	
	/*
	 * load all messages
	*/ 
	public function load() {
		
		$LoadList = array(); 
		$tableName = "dap_memberpages_settings";
		$sql = "select * from ".$tableName;		 

		try {
			$dap_dbh = Dap_Connection::getConnection();
			$stmt = $dap_dbh->prepare($sql);
			$stmt->execute();

			while ($row = $stmt->fetch()) {
				$data = new DAP_MemberPageSettings(); 

				$data->setId( $row["id"] );
				$data->setAction( $row["action"] );
				$data->setName( $row["name"] );
				$data->setValue( $row["value"] );
				$LoadList[] = $data;
			}
			$stmt = null;
			$dap_dbh = null;
			return $LoadList;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
			
	}
	
	public function loadByActionAndName($action = '',$name ='') {
		
		$data = false;
		try {
			$dap_dbh = Dap_Connection::getConnection();
			$tableName = "dap_memberpages_settings";
			
			$sql = "select * from ".$tableName." where action = :action and name = :name";
			
			
			$stmt = $dap_dbh->prepare($sql);
 			$stmt->bindParam(':action', $action, PDO::PARAM_STR);
			$stmt->bindParam(':name', $name, PDO::PARAM_STR);
			$stmt->execute();
			
			while ($row = $stmt->fetch()) {
				
				$data = new DAP_MemberPageSettings(); 
				$data->setId( $row["id"] );
				$data->setAction( $row["action"] );
				$data->setName( $row["name"] );
				$data->setValue( $row["value"] );
				
			}
            
            $stmt = null;
			$dap_dbh = null;
			return $data;
			

		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
			
	}
	
	
	
}	
	
