<?php 
class DAP_MemberPagesValues{ 
	 
	var $id;
	var $action_id;
	var $name;
	var $value;
	
	function getId() {
		return $this->id;
	}
	function setId($o) {
		$this->id = $o;
	}
	
	function getActionId() {
		return $this->action_id;
	}
	function setActionId($o) {
		$this->action_id = $o;
	}
	function getName() {
		return $this->name;
	}
	function setName($o) {
		$this->name = $o;
	}
	
	function getValue() {
		return $this->value;
	}
	function setValue($o) {
		$this->value = $o;
	}
	
	
    public function create() {
		try {
			$dap_dbh = Dap_Connection::getConnection();
			
			$tableName = "dap_memberpages_values";
			
			$sql = "insert into ".$tableName." 
						(action_id, name, value )
					values
						(:action_id, :name, :value)";
			
		 
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':action_id', $this->getActionId(), PDO::PARAM_INT);
 			$stmt->bindParam(':name', $this->getName(), PDO::PARAM_STR);
			$stmt->bindParam(':value', $this->getValue(), PDO::PARAM_STR);
			$stmt->execute();
            $stmt = null;
            $last_id = $dap_dbh->lastInsertId();
			$dap_dbh = null;
			return $last_id;
			

		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
	}
    
   
	/*
	 * update message in database
	 */ 
	public function update() {
		
		try {
			$dap_dbh = Dap_Connection::getConnection();
			$tableName = "dap_memberpages_values";
			
			$sql = "update ".$tableName." set
						value = :value
					where
						id = :id ";
						
		 
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':value', $this->getValue(), PDO::PARAM_STR);
			$stmt->bindParam(':id', $this->getID(), PDO::PARAM_STR);
			$stmt->execute();
			$stmt = null;
			$dap_dbh = null;
			return true;

		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
	}
		
	
	/*
	 * load all messages
	*/ 
	public static function load() {
		
		$LoadList = array(); 
		$tableName = "dap_memberpages_values";
		$sql = "select * from ".$tableName;		 

		try {
			$dap_dbh = Dap_Connection::getConnection();
			$stmt = $dap_dbh->prepare($sql);
			$stmt->execute();

			while ($row = $stmt->fetch()) {
				$data = new DAP_MemberPagesValues(); 

				$data->setId( $row["id"] );
				$data->setActionId( $row["action_id"] );
				$data->setName( $row["name"] );
				$data->setValue( $row["value"] );
				$LoadList[] = $data;
			}
			$stmt = null;
			$dap_dbh = null;
			return $LoadList;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
			
	}
	
	public static function loadByActionId($action_id = 0) {
		
		$LoadList = false;
		try {
			$dap_dbh = Dap_Connection::getConnection();
			$tableName = "dap_memberpages_values";
			
			$sql = "select * from ".$tableName." where action_id = :action_id";
			
			$stmt = $dap_dbh->prepare($sql);
 			$stmt->bindParam(':action_id', $action_id, PDO::PARAM_INT);
			
			$stmt->execute();
			
			while ($row = $stmt->fetch()) {
				$data = new DAP_MemberPagesValues(); 
				$data->setId( $row["id"] );
				$data->setActionId( $row["action_id"] );
				$data->setName( $row["name"] );
				$data->setValue( $row["value"] );
				$LoadList[] = $data;
			}
            $stmt = null;
			$dap_dbh = null;
			return $LoadList;
			

		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}			
	}
	
	
	public static function loadByActionIdAndName($action_id = 0 , $name = '') {
		
		$LoadList = false; 
		try {
			$dap_dbh = Dap_Connection::getConnection();
			$tableName = "dap_memberpages_values";
			
			$sql = "select * from ".$tableName." where action_id = :action_id and name = :name";
			
			$stmt = $dap_dbh->prepare($sql);
 			$stmt->bindParam(':action_id', $action_id, PDO::PARAM_INT);
 			$stmt->bindParam(':name', $name, PDO::PARAM_STR);
			
			$stmt->execute();
			
			while ($row = $stmt->fetch()) {
				$data = new DAP_MemberPagesValues(); 
				$data->setId( $row["id"] );
				$data->setActionId( $row["action_id"] );
				$data->setName( $row["name"] );
				$data->setValue( $row["value"] );
				$LoadList = $data;
			}
            $stmt = null;
			$dap_dbh = null;
			return $LoadList;
			

		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}			
	}
	
	public static function deleteByActionId($action_id = ''){
        
        $tableName = "dap_memberpages_values";
		$sql = "delete from ".$tableName." where `action_id` =:action_id";
		
		try{		
			$dap_dbh = Dap_Connection::getConnection();
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':action_id', $action_id, PDO::PARAM_INT);
			$stmt->execute();
			$stmt = null;
			$dap_dbh = null;
			return true;
	    } catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
				
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
       	 
	}
	
}
		
	
