<?php
class DAP_ProductsTabs{
	
	var $id;
	var $product_id;	 
	var $tab_list;	 
	var $maintain;	 
	
	function getId() {
		return $this->id;
	}
	
	function setId($o) {
		$this->id = $o;
	}
	 	
	function getProductId() {
		return $this->product_id;
	}
	
	function setProductId($o) {
		$this->product_id = $o;
	}
	function getTabList() {
		return $this->tab_list;
	}
	
	function setTabList($o) {
		$this->tab_list = $o;
	}
	function getMaintain() {
		return $this->maintain;
	}
	
	function setMaintain($o) {
		$this->maintain = $o;
	}
 
	
	public function create() {
		try {
			$dap_dbh = Dap_Connection::getConnection();
			 
			$sql = "insert into dap_products_tabs
						(product_id, tab_list, maintain)
					values
						(:product_id, :tab_list, :maintain)";			
		 
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':product_id', $this->getProductId(), PDO::PARAM_INT);
 			$stmt->bindParam(':tab_list', $this->getTabList(), PDO::PARAM_STR);
 			$stmt->bindParam(':maintain', $this->getMaintain(), PDO::PARAM_STR);
 			$stmt->execute();
 
			return $dap_dbh->lastInsertId();
			$stmt = null;
			$dap_dbh = null;

		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
	}

	
	
	
	public function update() {
		try {
			$dap_dbh = Dap_Connection::getConnection();			
			
			$sql = "update dap_products_tabs set
						product_id = :product_id,
						tab_list = :tab_list ,
						maintain = :maintain 
					where
						id = :id";
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':product_id', $this->getProductId(), PDO::PARAM_INT);
 			$stmt->bindParam(':tab_list', $this->getTabList(), PDO::PARAM_STR);
 			$stmt->bindParam(':maintain', $this->getMaintain(), PDO::PARAM_STR);
			$stmt->bindParam(':id', $this->getId(), PDO::PARAM_INT);

			$stmt->execute();		
			
			$stmt = null;
			$dap_dbh = null;

			return;

		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
	}
	
	
	//Load  
	public static function load() {
		$LoadList = array(); 
		$sql = "select * from dap_products_tabs ";		 

		try {
			$dap_dbh = Dap_Connection::getConnection();
			$stmt = $dap_dbh->prepare($sql);
			$stmt->execute();

			while ($row = $stmt->fetch()) {
				$data = new DAP_ProductsTabs(); 

				$data->setId( $row["id"] );
				$data->setProductId( $row["product_id"] );
				$data->setTabList( $row["tab_list"] ); 
				$data->setMaintain( $row["maintain"] ); 
				$LoadList[] = $data;
			}

			return $LoadList;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
	}
 	 
	 
	 
	 public static function loadByProductId($product_id) {
		$dap_dbh = Dap_Connection::getConnection();
		$product = null;  
		
		$sql = "select *
			from
				dap_products_tabs
			where
				product_id = :product_id";

		$stmt = $dap_dbh->prepare($sql);
		$stmt->bindParam(':product_id', $product_id, PDO::PARAM_INT);
		$stmt->execute();
 
		if ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
			$product = new DAP_ProductsTabs(); 
			$product->setId( $row["id"] );
			$product->setProductId( $row["product_id"] );
			$product->setTabList( $row["tab_list"] ); 		
			$product->setMaintain( $row["maintain"] ); 
 		}

		return $product;
	}
	
 
 
	
	
}
