<?php
class DAP_UserCreditsLimit{
	
	var $id;
	var $action;
	var $user_id;
	var $value;
	var $credits_earned;
	var $total_credits;
	var $comments;
	var $start_credits_date;
	var $last_credits_date;
	
	function getId() {
		return $this->id;
	}
	
	function setId($o) {
		$this->id = $o;
	}
	
	function getAction() {
		return $this->action;
	}
	
	function setAction($o) {
		$this->action = $o;
	}	
	
	function getUserId() {
		return $this->user_id;
	}
	
	function setUserId($o) {
		$this->user_id = $o;
	}
	
	function getValue() {
		return $this->value;
	}
	
	function setValue($o) {
		$this->value = $o;
	}	 
	
	function getCreditsEarned() {
		return $this->credits_earned;
	}
	function setCreditsEarned($o) {
		$this->credits_earned = $o;
	}
	
	function getTotalCredits() {
		return $this->total_credits;
	}
	function setTotalCredits($o) {
		$this->total_credits = $o;
	}	
	
	function getComments() {
		return $this->comments;
	}
	function setComments($o) {
		$this->comments = $o;
	}	
	
	function getStartCreditsDate() {
		return $this->start_credits_date;
	}
	
	function setStartCreditsDate($o) {
		$this->start_credits_date = $o;
	}
	
	function getLastCreditsDate() {
		return $this->last_credits_date;
	}
	
	function setLastCreditsDate($o) {
		$this->last_credits_date = $o;
	}
	
	
	public function create() {
		try {
			$dap_dbh = Dap_Connection::getConnection();
			 
			 $sql = "insert into dap_user_credit_limit
						(id, user_id, action, value, credits_earned, total_credits, comments, start_credits_date,last_credits_date)
					values
						(:id, :user_id, :action, :value, :credits_earned, :total_credits, :comments, :start_credits_date, :last_credits_date)";
			
			//logToFile("DAP_UserCreditsLimit. php create(): sql=".$sql,LOG_DEBUG_DAP); 
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':id', $this->getId(), PDO::PARAM_STR);
			$stmt->bindParam(':user_id', $this->getUserId(), PDO::PARAM_STR);
 			$stmt->bindParam(':action', $this->getAction(), PDO::PARAM_STR);
			$stmt->bindParam(':value', $this->getValue(), PDO::PARAM_STR);
			$stmt->bindParam(':credits_earned', $this->getCreditsEarned(), PDO::PARAM_STR);
			$stmt->bindParam(':total_credits', $this->getTotalCredits(), PDO::PARAM_STR);
			$stmt->bindParam(':comments', $this->getComments(), PDO::PARAM_STR);
			$stmt->bindParam(':start_credits_date', $this->getStartCreditsDate(), PDO::PARAM_STR);
			$stmt->bindParam(':last_credits_date', $this->getLastCreditsDate(), PDO::PARAM_STR);

			$stmt->execute();
			$last_insert_id = $dap_dbh->lastInsertId();
			 
			$stmt = null;
			$dap_dbh = null;
			return $last_insert_id;	

		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
	}

	
	
	
	public function update() {
		try {
			$dap_dbh = Dap_Connection::getConnection();
			
			$sql = "update dap_user_credit_limit set
						value = :value,
						credits_earned = :credits_earned,
						total_credits = :total_credits,
						comments = :comments,
						start_credits_date = :start_credits_date,
						last_credits_date = :last_credits_date
					where
						user_id = :user_id AND 
						action = :action";	 
		 
			$stmt = $dap_dbh->prepare($sql);
			//$stmt->bindParam(':id', $this->getId(), PDO::PARAM_STR);
			$stmt->bindParam(':user_id', $this->getUserId(), PDO::PARAM_STR);
 			$stmt->bindParam(':action', $this->getAction(), PDO::PARAM_STR);
			$stmt->bindParam(':value', $this->getValue(), PDO::PARAM_STR);
			$stmt->bindParam(':credits_earned', $this->getCreditsEarned(), PDO::PARAM_STR);
			$stmt->bindParam(':total_credits', $this->getTotalCredits(), PDO::PARAM_STR);
			$stmt->bindParam(':comments', $this->getComments(), PDO::PARAM_STR);
			$stmt->bindParam(':start_credits_date', $this->getStartCreditsDate(), PDO::PARAM_STR);
			$stmt->bindParam(':last_credits_date', $this->getLastCreditsDate(), PDO::PARAM_STR);

			$stmt->execute();		 
			$stmt = null;
			$dap_dbh = null;

			return ;

		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
	}	
	
	//Load  
	public static function load() {
		$LoadList = array(); 
		$sql = "select * from dap_user_credit_limit ";		 

		try {
			$dap_dbh = Dap_Connection::getConnection();
			$stmt = $dap_dbh->prepare($sql);
			$stmt->execute();

			while ($row = $stmt->fetch()) {
				$data = new DAP_UserCreditsLimit();

				$data->setId( $row["id"] );
				$data->setUserId( $row["user_id"] );
				$data->setAction( $row["action"] );
				$data->setValue( $row["value"] );
				$data->setCreditsEarned( $row["credits_earned"] ); 
				$data->setTotalCredits( $row["total_credits"] ); 
				$data->setComments( $row["comments"] ); 
				$data->setStartCreditsDate( $row["start_credits_date"] ); 
				$data->setLastCreditsDate( $row["last_credits_date"] ); 
				$LoadList[] = $data;
			}

			return $LoadList;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
	}

	public static function loadByAction($action) {
		 
	 
		try {
			$dap_dbh = Dap_Connection::getConnection();
			$sql = "select * from dap_user_credit_limit where action=:action";	
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':action', $action, PDO::PARAM_STR);
			$stmt->execute();


			while ($row = $stmt->fetch()) {
				$data = new DAP_UserCreditsLimit();

				$data->setId( $row["id"] );
				$data->setUserId( $row["user_id"] );
				$data->setAction( $row["action"] );
				$data->setValue( $row["value"] );
				$data->setCreditsEarned( $row["credits_earned"] ); 
				$data->setTotalCredits( $row["total_credits"] ); 
				$data->setComments( $row["comments"] ); 
				$data->setStartCreditsDate( $row["start_credits_date"] ); 
				$data->setLastCreditsDate( $row["last_credits_date"] ); 
				return $data;
			}

			 
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
	}
	public static function loadByUserId($user_id) {				 
	
	
		try {
			$dap_dbh = Dap_Connection::getConnection();
			$sql = "select * from dap_user_credit_limit where user_id=:user_id";	
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':user_id', $user_id, PDO::PARAM_STR);
			$stmt->execute();

			while ($row = $stmt->fetch()) {
				$data = new DAP_UserCreditsLimit();

				$data->setId( $row["id"] );
				$data->setUserId( $row["user_id"] );
				$data->setAction( $row["action"] );
				$data->setValue( $row["value"] );
				$data->setCreditsEarned( $row["credits_earned"] ); 
				$data->setTotalCredits( $row["total_credits"] ); 
				$data->setComments( $row["comments"] ); 
				$data->setStartCreditsDate( $row["start_credits_date"] ); 
				$data->setLastCreditsDate( $row["last_credits_date"] ); 
				return $data;
			}

		 
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
	}
	
	public static function loadByUserIdAndAction($user_id, $action) {	
	
		try {
			$dap_dbh = Dap_Connection::getConnection();
			$sql = "select * from dap_user_credit_limit where user_id=:user_id AND action =:action ";	
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':user_id', $user_id, PDO::PARAM_STR);
			$stmt->bindParam(':action', $action, PDO::PARAM_STR);
			$stmt->execute();

			while ($row = $stmt->fetch()) {
				$data = new DAP_UserCreditsLimit();

				$data->setId( $row["id"] );
				$data->setUserId( $row["user_id"] );
				$data->setAction( $row["action"] );
				$data->setValue( $row["value"] );
				$data->setCreditsEarned( $row["credits_earned"] ); 
				$data->setTotalCredits( $row["total_credits"] ); 
				$data->setComments( $row["comments"] ); 
				$data->setStartCreditsDate( $row["start_credits_date"] ); 
				$data->setLastCreditsDate( $row["last_credits_date"] ); 
				return $data;
			}

		 
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
	}
	
	public static function loadByUserIdAndActionAndValue($user_id, $action, $value) {	
	
		try {
			$dap_dbh = Dap_Connection::getConnection();
			$sql = "select * from dap_user_credit_limit where user_id=:user_id AND action =:action AND value=:value ";	
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':user_id', $user_id, PDO::PARAM_STR);
			$stmt->bindParam(':action', $action, PDO::PARAM_STR);
			$stmt->bindParam(':value', $value, PDO::PARAM_STR);
			$stmt->execute();

			while ($row = $stmt->fetch()) {
				$data = new DAP_UserCreditsLimit();

				$data->setId( $row["id"] );
				$data->setUserId( $row["user_id"] );
				$data->setAction( $row["action"] );
				$data->setValue( $row["value"] );
				$data->setCreditsEarned( $row["credits_earned"] ); 
				$data->setTotalCredits( $row["total_credits"] ); 
				$data->setComments( $row["comments"] ); 
				$data->setStartCreditsDate( $row["start_credits_date"] ); 
				$data->setLastCreditsDate( $row["last_credits_date"] ); 
				return $data;
			}

		 
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
	}
	
	
}
