<?php
	
class Dap_ActionPoints {
	
   	var $id;
   	var $action;
   	var $value;
   	var $credits;
   	var $max_credits;
   	var $duration;
   	var $date;
   	var $type;
   	var $courseid;
   	var $moduleid;
   	var $unitid;
   	var $set_max_limit;
	
	function getId() {
		return $this->id;
	}
	function setId($o) {
		$this->id = $o;
	}
	
	function getAction() {
		return $this->action;
	}
	function setAction($o) {
		$this->action = $o;
	}

	function getValue() {
		return $this->value;
	}
	function setValue($o) {
		$this->value = $o;
	}
		
	function getCredits() {
		return $this->credits;
	}
	function setCredits($o) {
		$this->credits = $o;
	}	
	
	function getMaxCredits() {
		return $this->max_credits;
	}
	function setMaxCredits($o) {
		$this->max_credits = $o;
	}
	
	function getDuration() {
		return $this->duration;
	}
	function setDuration($o) {
		$this->duration = $o;
	}
	
	function getDate() {
		return $this->date;
	}
	function setDate($o) {
		$this->date = $o;
	}
		
	function getType() {
		return $this->type;
	}
	function setType($o) {
		$this->type = $o;
	}
	function getCourseId() {
		return $this->courseid;
	}
	function setCourseId($o) {
		$this->courseid = $o;
	}
	function getModuleId() {
		return $this->moduleid;
	}
	function setModuleId($o) {
		$this->moduleid = $o;
	}
	function getUnitId() {
		return $this->unitid;
	}
	function setUnitId($o) {
		$this->unitid = $o;
	}
	
	function getMaxLimit() {
		return $this->set_max_limit;
	}
	function setMaxLimit($o) {
		$this->set_max_limit = $o;
	}
	
 	
	public function create() {
		
		try {
			$dap_dbh = Dap_Connection::getConnection();
			$sql = "insert into dap_action_points
						(id, action, type, value,  credits, max_credits, duration, set_max_limit, courseid ,moduleid,  unitid,  date)
					values 
						(:id, :action, :type, :value, :credits, :max_credits, :duration, :set_max_limit, :courseid, :moduleid, :unitid, :date)";

			$stmt = $dap_dbh->prepare($sql);
		
			$stmt->bindParam(':id', $this->getId(), PDO::PARAM_STR);
			$stmt->bindParam(':action', $this->getAction(), PDO::PARAM_STR);
			$stmt->bindParam(':type', $this->getType(), PDO::PARAM_STR);
			$stmt->bindParam(':value', $this->getvalue(), PDO::PARAM_STR);
			$stmt->bindParam(':credits', $this->getCredits(), PDO::PARAM_STR);
			$stmt->bindParam(':max_credits', $this->getMaxCredits(), PDO::PARAM_STR);
			$stmt->bindParam(':duration', $this->getDuration(), PDO::PARAM_STR);
			$stmt->bindParam(':set_max_limit', $this->getMaxLimit(), PDO::PARAM_STR);
			$stmt->bindParam(':courseid', $this->getCourseId(), PDO::PARAM_STR);
			$stmt->bindParam(':moduleid', $this->getModuleId(), PDO::PARAM_STR);
			$stmt->bindParam(':unitid', $this->getUnitId(), PDO::PARAM_STR);
			$stmt->bindParam(':date', $this->getDate(), PDO::PARAM_STR);
 			$stmt->execute();
			 
			$last_insert_id = $dap_dbh->lastInsertId();
			 
			//$this->setId($last_insert_id);
			
			$stmt = null;
			$dap_dbh = null;
			return $last_insert_id;
	
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}	
	}
 
	public function update() {
		try {
			logToFile("(Dap_Credits.update()) getMaxLimit : ".$this->getMaxLimit());
			$dap_dbh = Dap_Connection::getConnection();
 
			$sql = "update 
					dap_action_points
					set
						 value =:value, type=:type, credits =:credits, max_credits =:max_credits, duration =:duration, set_max_limit =:set_max_limit, courseid =:courseid, moduleid =:moduleid, unitid =:unitid, date=:date
					where
						action =:action ";
					
			$stmt = $dap_dbh->prepare($sql);	
			
			$stmt->bindParam(':action', $this->getAction(), PDO::PARAM_STR);
			$stmt->bindParam(':type', $this->getType(), PDO::PARAM_STR);
			$stmt->bindParam(':value', $this->getvalue(), PDO::PARAM_STR);
			$stmt->bindParam(':credits', $this->getCredits(), PDO::PARAM_STR);
			$stmt->bindParam(':max_credits', $this->getMaxCredits(), PDO::PARAM_STR);
			$stmt->bindParam(':duration', $this->getDuration(), PDO::PARAM_STR);
			$stmt->bindParam(':set_max_limit', $this->getMaxLimit(), PDO::PARAM_STR);
			$stmt->bindParam(':courseid', $this->getCourseId(), PDO::PARAM_STR);
			$stmt->bindParam(':moduleid', $this->getModuleId(), PDO::PARAM_STR);
			$stmt->bindParam(':unitid', $this->getUnitId(), PDO::PARAM_STR);
			$stmt->bindParam(':date', $this->getDate(), PDO::PARAM_STR);
			$stmt->execute();	
			 
			
			$stmt = null;
			$dap_dbh = null;
			
			return;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}	
	}
	
	
	public function updateByActionAndValue() {
		try {
			logToFile("(Dap_Credits.update()) userid: ".$this->getId());
			$dap_dbh = Dap_Connection::getConnection();
	
			$sql = "update 
					dap_action_points
					set
						 credits =:credits, type =:type, max_credits =:max_credits, duration =:duration,set_max_limit =:set_max_limit, courseid =:courseid, moduleid =:moduleid, unitid =:unitid, date=:date
					where
						action =:action  and  value =:value";
					
			$stmt = $dap_dbh->prepare($sql);	
			
			$stmt->bindParam(':action', $this->getAction(), PDO::PARAM_STR);
			$stmt->bindParam(':value', $this->getvalue(), PDO::PARAM_STR);
			$stmt->bindParam(':type', $this->getType(), PDO::PARAM_STR);
			$stmt->bindParam(':credits', $this->getCredits(), PDO::PARAM_STR);
			$stmt->bindParam(':max_credits', $this->getMaxCredits(), PDO::PARAM_STR);
			$stmt->bindParam(':duration', $this->getDuration(), PDO::PARAM_STR);
			$stmt->bindParam(':set_max_limit', $this->getMaxLimit(), PDO::PARAM_STR);
			$stmt->bindParam(':courseid', $this->getCourseId(), PDO::PARAM_STR);
			$stmt->bindParam(':moduleid', $this->getModuleId(), PDO::PARAM_STR);
			$stmt->bindParam(':unitid', $this->getUnitId(), PDO::PARAM_STR);
			$stmt->bindParam(':date', $this->getDate(), PDO::PARAM_STR);
			$stmt->execute();
			
			logToFile("update complete",LOG_DEBUG_DAP);
			
			$stmt = null;
			$dap_dbh = null;
			
			return;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}	
	}
	
	public static function load() {
		$userCreditsUsedList = array();
		
		try {
			$dap_dbh = Dap_Connection::getConnection();
			
			$sql = "SELECT 
						*
					FROM
						dap_action_points ORDER BY date DESC
					";
			//logToFile($sql,LOG_DEBUG_DAP);
			$stmt = $dap_dbh->prepare($sql);
			 
			$stmt->execute();
	
			while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
				$dapcredits = new Dap_ActionPoints();
 
				$dapcredits->setId( stripslashes($row["id"]) );
				$dapcredits->setAction( stripslashes($row["action"]) );
				$dapcredits->setvalue( stripslashes($row["value"]) );
				$dapcredits->setType( stripslashes($row["type"]) );
				$dapcredits->setCredits( stripslashes($row["credits"]) );
				$dapcredits->setMaxCredits( stripslashes($row["max_credits"]) );
				$dapcredits->setDuration( stripslashes($row["duration"]) );
				$dapcredits->setMaxLimit( stripslashes($row["set_max_limit"]) );
				$dapcredits->setCourseId( stripslashes($row["courseid"]) );
				$dapcredits->setModuleId( stripslashes($row["moduleid"]) );
				$dapcredits->setUnitId( stripslashes($row["unitid"]) );
				$dapcredits->setDate( stripslashes($row["date"]) ); 
				$userCreditsUsedList[] = $dapcredits;

			}
			
			
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
		
		return $userCreditsUsedList;
	}
	
	public static function loadUniqueActions() {
		$userCreditsUsedList = array();
		
		try {
			$dap_dbh = Dap_Connection::getConnection();
			
			$sql = "SELECT 
						DISTINCT action
					FROM
						dap_action_points ORDER BY action ASC
					";
			//logToFile($sql,LOG_DEBUG_DAP);
			$stmt = $dap_dbh->prepare($sql);
			 
			$stmt->execute();
	
			while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
				$dapcredits = new Dap_ActionPoints();
			
				$dapcredits->setAction( stripslashes($row["action"]) );
				$userCreditsUsedList[] = $dapcredits;

			}
			
			
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
		
		return $userCreditsUsedList;
	}
	
	 public static function loadUniqueCustomActions() {
		$userCreditsUsedList = array();
		
		try {
			$dap_dbh = Dap_Connection::getConnection();		 
					
			$sql = "SELECT DISTINCT action FROM dap_action_points where type='custom' ORDER BY action ASC";
			
			//logToFile($sql,LOG_DEBUG_DAP);
			$stmt = $dap_dbh->prepare($sql);
			 
			$stmt->execute();
	
			while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
				$dapcredits = new Dap_ActionPoints();
			
				$dapcredits->setAction( stripslashes($row["action"]) );
				$userCreditsUsedList[] = $dapcredits;

			}
			
			
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
		
		return $userCreditsUsedList;
	}
	
	public static function loadCreditsUsedByUserId($id) {
		$userCreditsUsedList = array();
		
		try {
			$dap_dbh = Dap_Connection::getConnection();
			
			$sql = "SELECT 
						*
					FROM
						dap_action_points
					WHERE
						id =:id
					";
			//logToFile($sql,LOG_DEBUG_DAP);
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':id', $id, PDO::PARAM_STR);
			$stmt->execute();
	
			while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
				$dapcredits = new Dap_ActionPoints();
				
				$dapcredits->setId( stripslashes($row["id"]) );
				$dapcredits->setAction( stripslashes($row["action"]) );
				$dapcredits->setvalue( stripslashes($row["value"]) );
				$dapcredits->setType( stripslashes($row["type"]) );
				$dapcredits->setCredits( stripslashes($row["credits"]) );
				$dapcredits->setMaxCredits( stripslashes($row["max_credits"]) );
				$dapcredits->setDuration( stripslashes($row["duration"]) );
				$dapcredits->setMaxLimit( stripslashes($row["set_max_limit"]) );
				$dapcredits->setCourseId( stripslashes($row["courseid"]) );
				$dapcredits->setModuleId( stripslashes($row["moduleid"]) );
				$dapcredits->setUnitId( stripslashes($row["unitid"]) );
				$dapcredits->setDate( stripslashes($row["date"]) ); 
				$userCreditsUsedList[] = $dapcredits;

			}			
			
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
		
		return $userCreditsUsedList;
	}
	
	public static function loadByAction($action) {
		$userCreditsUsedList = array();
		
		try {
			$dap_dbh = Dap_Connection::getConnection();
			
			$sql = "SELECT 
						*
					FROM
						dap_action_points
					WHERE
						action =:action
					";
			//logToFile($sql,LOG_DEBUG_DAP);
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':action', $action, PDO::PARAM_STR);
			$stmt->execute();
	
			while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
				$dapcredits = new Dap_ActionPoints();
				
				$dapcredits->setId( stripslashes($row["id"]) ); 
				$dapcredits->setAction( stripslashes($row["action"]) );
				$dapcredits->setType( stripslashes($row["type"]) );
				$dapcredits->setvalue( stripslashes($row["value"]) );
				$dapcredits->setCredits( stripslashes($row["credits"]) );
				$dapcredits->setMaxCredits( stripslashes($row["max_credits"]) );
				$dapcredits->setDuration( stripslashes($row["duration"]) );
				$dapcredits->setMaxLimit( stripslashes($row["set_max_limit"]) );
				$dapcredits->setCourseId( stripslashes($row["courseid"]) );
				$dapcredits->setModuleId( stripslashes($row["moduleid"]) );
				$dapcredits->setUnitId( stripslashes($row["unitid"]) );
				$dapcredits->setDate( stripslashes($row["date"]) ); 
				$userCreditsUsedList[] = $dapcredits;

			}			
			
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
		
		return $userCreditsUsedList;
	}
	
	
	public static function loadByActionAndValue($action, $value) {
		$userCreditsUsedList = array();
		
		try {
			$dap_dbh = Dap_Connection::getConnection();
			
			$sql = "SELECT 
						*
					FROM
						dap_action_points
					WHERE
						action =:action AND	value =:value 
						
					";
			// logToFile("sql=".$sql,LOG_DEBUG_DAP);
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':action', $action, PDO::PARAM_STR);
			$stmt->bindParam(':value', $value, PDO::PARAM_STR);
			$stmt->execute();
	         
			while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
				$dapcredits = new Dap_ActionPoints();
				
				$dapcredits->setId( stripslashes($row["id"]) );
				$dapcredits->setAction( stripslashes($row["action"]) );
				$dapcredits->setvalue( stripslashes($row["value"]) );
				$dapcredits->setType( stripslashes($row["type"]) );
				$dapcredits->setCredits( stripslashes($row["credits"]) );
				$dapcredits->setMaxCredits( stripslashes($row["max_credits"]) );
				$dapcredits->setDuration( stripslashes($row["duration"]) );
				$dapcredits->setMaxLimit( stripslashes($row["set_max_limit"]) );
				$dapcredits->setCourseId( stripslashes($row["courseid"]) );
				$dapcredits->setModuleId( stripslashes($row["moduleid"]) );
				$dapcredits->setUnitId( stripslashes($row["unitid"]) );
				$dapcredits->setDate( stripslashes($row["date"]) ); 
				$userCreditsUsedList[] = $dapcredits;

			}			
			
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
		
		return $userCreditsUsedList;
	}
	
	public static function loadByActionAndCourseId($action, $courseid) {
		$userCreditsUsedList = array();
		
		try {
			$dap_dbh = Dap_Connection::getConnection();
			
			$sql = "SELECT 
						*
					FROM
						dap_action_points
					WHERE
						action =:action AND	courseid =:courseid
						
					"; 
				 
			// logToFile("sql=".$sql,LOG_DEBUG_DAP);
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':action', $action, PDO::PARAM_STR);
			$stmt->bindParam(':courseid', $courseid, PDO::PARAM_STR);
			$stmt->execute();
	       
			while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
				$dapcredits = new Dap_ActionPoints();
				
				$dapcredits->setId( stripslashes($row["id"]) );
				$dapcredits->setAction( stripslashes($row["action"]) );
				$dapcredits->setvalue( stripslashes($row["value"]) );
				$dapcredits->setType( stripslashes($row["type"]) );
				$dapcredits->setCredits( stripslashes($row["credits"]) );
				$dapcredits->setMaxCredits( stripslashes($row["max_credits"]) );
				$dapcredits->setDuration( stripslashes($row["duration"]) );
				$dapcredits->setMaxLimit( stripslashes($row["set_max_limit"]) );
				$dapcredits->setCourseId( stripslashes($row["courseid"]) );
				$dapcredits->setModuleId( stripslashes($row["moduleid"]) );
				$dapcredits->setUnitId( stripslashes($row["unitid"]) );
				$dapcredits->setDate( stripslashes($row["date"]) ); 
				$userCreditsUsedList[] = $dapcredits;

			}			
			
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
		
		return $userCreditsUsedList;
	}
	
	public static function loadByActionAndCourseIdAndModuleId($action, $courseid , $moduleid) {
		 $userCreditsUsedList = array();
		
		try {
			$dap_dbh = Dap_Connection::getConnection();
			
			$sql = "SELECT 
						*
					FROM
						dap_action_points
					WHERE
						action =:action AND	courseid =:courseid AND	moduleid =:moduleid 
						
					";
			// logToFile("sql=".$sql,LOG_DEBUG_DAP);
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':action', $action, PDO::PARAM_STR);
			$stmt->bindParam(':courseid', $courseid, PDO::PARAM_STR);
			$stmt->bindParam(':moduleid', $moduleid, PDO::PARAM_STR);
			$stmt->execute();
	         
			while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
				$dapcredits = new Dap_ActionPoints();
				
				$dapcredits->setId( stripslashes($row["id"]) );
				$dapcredits->setAction( stripslashes($row["action"]) );
				$dapcredits->setvalue( stripslashes($row["value"]) );
				$dapcredits->setType( stripslashes($row["type"]) );
				$dapcredits->setCredits( stripslashes($row["credits"]) );
				$dapcredits->setMaxCredits( stripslashes($row["max_credits"]) );
				$dapcredits->setDuration( stripslashes($row["duration"]) );
				$dapcredits->setMaxLimit( stripslashes($row["set_max_limit"]) );
				$dapcredits->setCourseId( stripslashes($row["courseid"]) );
				$dapcredits->setModuleId( stripslashes($row["moduleid"]) );
				$dapcredits->setUnitId( stripslashes($row["unitid"]) );
				$dapcredits->setDate( stripslashes($row["date"]) ); 
				$userCreditsUsedList[] = $dapcredits;

			}
					
			
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
		
		return $userCreditsUsedList;
	}
	
	
	public static function loadByActionAndCourseIdAndModuleIdAndUnitId($action, $courseid , $moduleid, $unitid) {
		$userCreditsUsedList = array();
		
		try {
			$dap_dbh = Dap_Connection::getConnection();
			
			$sql = "SELECT 
						*
					FROM
						dap_action_points
					WHERE
						action =:action AND	courseid =:courseid AND	moduleid =:moduleid AND	unitid =:unitid 
						
					";
			// logToFile("sql=".$sql,LOG_DEBUG_DAP);
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':action', $action, PDO::PARAM_STR);
			$stmt->bindParam(':courseid', $courseid, PDO::PARAM_STR);
			$stmt->bindParam(':moduleid', $moduleid, PDO::PARAM_STR);
			$stmt->bindParam(':unitid', $unitid, PDO::PARAM_STR);
			$stmt->execute();
 
			while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
				$dapcredits = new Dap_ActionPoints();
				
				$dapcredits->setId( stripslashes($row["id"]) );
				$dapcredits->setAction( stripslashes($row["action"]) );
				$dapcredits->setvalue( stripslashes($row["value"]) );
				$dapcredits->setType( stripslashes($row["type"]) );
				$dapcredits->setCredits( stripslashes($row["credits"]) );
				$dapcredits->setMaxCredits( stripslashes($row["max_credits"]) );
				$dapcredits->setDuration( stripslashes($row["duration"]) );
				$dapcredits->setMaxLimit( stripslashes($row["set_max_limit"]) );
				$dapcredits->setCourseId( stripslashes($row["courseid"]) );
				$dapcredits->setModuleId( stripslashes($row["moduleid"]) );
				$dapcredits->setUnitId( stripslashes($row["unitid"]) );
				$dapcredits->setDate( stripslashes($row["date"]) ); 
				$userCreditsUsedList[] = $dapcredits;

			}			
			
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
		
		return $userCreditsUsedList;
	}
	
	
 
	public function delete($id) {
		try {
			$dap_dbh = Dap_Connection::getConnection();
			$dap_dbh->beginTransaction();
			
			//$id = $this->getId();
			//delete from usersproducts table
			  $sql = "delete from  
					dap_action_points
					where id =:id"; 
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':id', $id, PDO::PARAM_INT);
			$stmt->execute();
			
			$dap_dbh->commit(); 
			
			$stmt = null;
			$dap_dbh = null;		
			return;			
		} catch (PDOException $e) {
			$dap_dbh->rollback();
			$stmt = null;
			$dap_dbh = null;				
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			$dap_dbh->rollback();
			$stmt = null;
			$dap_dbh = null;			
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}		
	}
	
	
	public static function countData() {		 
		
		try {
			$dap_dbh = Dap_Connection::getConnection();
 
			$sql = "SELECT 
						COUNT(id) as count
					FROM
						dap_action_points 
					";
			//logToFile($sql,LOG_DEBUG_DAP);
			$stmt = $dap_dbh->prepare($sql);			 
			$stmt->execute();	
			
			while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
				$count = $row["count"];
			}
			
			
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
		$stmt = null;
		$dap_dbh = null;
		return $count;
	}
	
	
	public static function loadByType($type = '') {
		$userCreditsUsedList = array();
		
		try {
			$dap_dbh = Dap_Connection::getConnection();
			
			$sql = "SELECT 
						*
					FROM
						dap_action_points
					WHERE
						type =:type
						
					";
			// logToFile("sql=".$sql,LOG_DEBUG_DAP);
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':type', $type, PDO::PARAM_STR);
			
			$stmt->execute();
	        logToFile("sql=".$sql,LOG_DEBUG_DAP);
			while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
				$dapcredits = new Dap_ActionPoints();
				
				$dapcredits->setId( stripslashes($row["id"]) );
				$dapcredits->setAction( stripslashes($row["action"]) );
				$dapcredits->setType( stripslashes($row["type"]) );
				$dapcredits->setvalue( stripslashes($row["value"]) );
				$dapcredits->setCredits( stripslashes($row["credits"]) );
				$dapcredits->setMaxCredits( stripslashes($row["max_credits"]) );
				$dapcredits->setDuration( stripslashes($row["duration"]) );
				$dapcredits->setMaxLimit( stripslashes($row["set_max_limit"]) );
				$dapcredits->setCourseId( stripslashes($row["courseid"]) );
				$dapcredits->setModuleId( stripslashes($row["moduleid"]) );
				$dapcredits->setUnitId( stripslashes($row["unitid"]) );
				$dapcredits->setDate( stripslashes($row["date"]) ); 
				$userCreditsUsedList[] = $dapcredits;

			}			
			
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
		
		return $userCreditsUsedList;
	}
	
	
	
	public static function loadById($id = '') {
		$userCreditsUsedList = array();
		
		try {
			$dap_dbh = Dap_Connection::getConnection();
			
			$sql = "SELECT 
						*
					FROM
						dap_action_points
					WHERE
						id =:id
						
					";
			// logToFile("sql=".$sql,LOG_DEBUG_DAP);
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':id', $id, PDO::PARAM_INT);
			
			$stmt->execute();
	        logToFile("sql=".$sql,LOG_DEBUG_DAP);
			while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
				$dapcredits = new Dap_ActionPoints();
				
				$dapcredits->setId( stripslashes($row["id"]) );
				$dapcredits->setAction( stripslashes($row["action"]) );
				$dapcredits->setType( stripslashes($row["type"]) );
				$dapcredits->setvalue( stripslashes($row["value"]) );
				$dapcredits->setCredits( stripslashes($row["credits"]) );
				$dapcredits->setMaxCredits( stripslashes($row["max_credits"]) );
				$dapcredits->setDuration( stripslashes($row["duration"]) );
				$dapcredits->setMaxLimit( stripslashes($row["set_max_limit"]) );
				$dapcredits->setCourseId( stripslashes($row["courseid"]) );
				$dapcredits->setModuleId( stripslashes($row["moduleid"]) );
				$dapcredits->setUnitId( stripslashes($row["unitid"]) );
				$dapcredits->setDate( stripslashes($row["date"]) ); 
				$userCreditsUsedList[] = $dapcredits;

			}			
			
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
		
		return $userCreditsUsedList;
	}
	
}

?>
