<?php 

class Dap_ExternalNotifications{
	
	var $id;
	var $product_id;
	var $name;
	var $platform_name;
	var $action_type;
	var $key;
	var $value;
	var $plugin_notification_add;
	var $plugin_notification_remove;
	var $date;
	var $created_date;
	var $updated_date;
	var $active;
	var $trigger_id;
	var $trigger_action;
	var $destination;
	var $action_id;
	function getId() {
        return $this->id;
    }
    function setId($o) {
        $this->id = $o;
    }
    
    function getProduct_id(){
		return $this->product_id;
	}
	function setProduct_id($o){
		return $this->product_id = $o;
	}
	function getName(){
		return $this->name;
	}
	function setName($o){
		return $this->name = $o;
	}
	
	function getPlatform_name(){
		return $this->platform_name;
	}
	function setPlatform_name($o){
		return $this->platform_name = $o;
	}
	
	function getAction_type(){
		return $this->action_type;
	}
	function setAction_type($o){
		return $this->action_type = $o;
	}
	
	function getKey(){
		return $this->key;
	}
	function setKey($o){
		return $this->key = $o;
	}
	
	function getValue(){
		return $this->value;
	}
	function setValue($o){
		return $this->value = $o;
	}
	
	function getPlugin_notification_add(){
		return $this->plugin_notification_add;
	}
	function setPlugin_notification_add($o){
		return $this->plugin_notification_add = $o;
	}
	
	function getPlugin_notification_remove(){
		return $this->plugin_notification_remove;
	}
	function setPlugin_notification_remove($o){
		return $this->plugin_notification_remove = $o;
	}
	
	function getDate(){
		return $this->date;
	}
	function setDate($o){
		return $this->date = $o;
	}
	function getCreated_date(){
		return $this->created_date;
	}
	function setCreated_date($o){
		return $this->created_date = $o;
	}
	function getUpdated_date(){
		return $this->updated_date;
	}
	function setUpdated_date($o){
		return $this->updated_date = $o;
	}
	function getAuto_type(){
		return $this->type;
	}
	function setAuto_type($o){
		return $this->type = $o;
	}
	function getActive(){
		return $this->active;
	}
	function setActive($o){
		return $this->active = $o;
	}
	function getTrigger_Id(){
		return $this->trigger_id;
	}
	function setTrigger_Id($o){
		return $this->trigger_id = $o;
	}
	function getTrigger_action(){
		return $this->trigger_action;
	}
	function setTrigger_action($o){
		return $this->trigger_action = $o;
	}
	function getDestination(){
		return $this->destination;
	}
	function setDestination($o){
		return $this->destination = $o;
	}
	function getAction_Id(){
		return $this->action_id;
	}
	function setAction_Id($o){
		return $this->action_id = $o;
	}
	
	
	
	
	//save automation name in DB
	public function create() {
		logToFile("Dap_ExternalNotifications,create() entered",LOG_DEBUG_DAP);
		try {
			$dap_dbh = Dap_Connection::getConnection();
			
			$sql = "insert into dap_automation
						(name, created_date, updated_date, type , product_id, active)
					values
						(:name, :created_date, :updated_date, :type, :product_id, :active)";
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':name', $this->getName(), PDO::PARAM_STR);
			$stmt->bindParam(':created_date', $this->getCreated_date(), PDO::PARAM_STR);
			$stmt->bindParam(':updated_date', $this->getUpdated_date(), PDO::PARAM_STR);
			$stmt->bindParam(':type', $this->getAuto_type(), PDO::PARAM_STR);
			$stmt->bindParam(':product_id', $this->getProduct_id(), PDO::PARAM_STR);
			$stmt->bindParam(':active', $this->getActive(), PDO::PARAM_STR);
			
			$stmt->execute();
			
			return $dap_dbh->lastInsertId();
			$stmt = null;
			$dap_dbh = null;

		} catch (PDOException $e) {
			logToFile("Dap_ExternalNotifications,create() exception is ".$e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile("Dap_ExternalNotifications,create() exception is ".$e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
	}

	//update automation
	public function update(){
		logToFile("Dap_ExternalNotifications,update() entered",LOG_DEBUG_DAP);
		try {
			
			$dap_dbh = Dap_Connection::getConnection();
			
			$sql = "update dap_automation set
						name = :name,
						created_date = :created_date,
						updated_date = :updated_date,
						type = :type,
						product_id = :product_id,
						active = :active
						where
						id = :id";
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':name', $this->getName(), PDO::PARAM_STR);
			$stmt->bindParam(':created_date', $this->getCreated_date(), PDO::PARAM_STR);
			$stmt->bindParam(':updated_date', $this->getUpdated_date(), PDO::PARAM_STR);
			$stmt->bindParam(':type', $this->getAuto_type(), PDO::PARAM_STR);
			$stmt->bindParam(':product_id', $this->getProduct_id(), PDO::PARAM_STR);
			$stmt->bindParam(':active', $this->getActive(), PDO::PARAM_STR);
			
			$stmt->bindParam(':id', $this->getId(), PDO::PARAM_INT);
			$stmt->execute();
			
			$stmt = null;
			$dap_dbh = null;

		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
	}
	
	//get automation details
	public static function loadAutomationById($id){
		$automation_details = array();
		$whereClause = " where da.id = '$id'";
		$sql = "SELECT * FROM dap_automation WHERE id=".$id ;
		
		try {
			$dap_dbh = Dap_Connection::getConnection();
			$stmt = $dap_dbh->prepare($sql);
			$stmt->execute();
			
			while ($row = $stmt->fetch()) {
				$automation = new Dap_ExternalNotifications();
				$automation->setId( $row["id"] );
				$automation->setName( $row["name"] );
				$automation->setCreated_date( $row["created_date"] );
				$automation->setUpdated_date( $row["updated_date"] );
				$automation->setProduct_id( $row["product_id"] );
				$automation->setActive( $row["active"] );
				$automation->setAuto_type( $row["type"] );
				
				
				
			}

			return $automation;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
	}
	
	//get trigger details
	public static function loadTriggersById($id){
		$trigger_details = array();
		$sql = "SELECT * FROM dap_automation_trigger WHERE automation_id=".$id ;
		
		try {
			$dap_dbh = Dap_Connection::getConnection();
			$stmt = $dap_dbh->prepare($sql);
			$stmt->execute();
			
			while ($row = $stmt->fetch()) {
				$trigger = new Dap_ExternalNotifications();
				$trigger->setTrigger_Id( $row["id"] );
				$trigger->setTrigger_action( $row["trigger"] );
				$trigger_details[] =  $trigger;
			}

			return $trigger_details;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
	}
	
	//get action data
	public static function loadActionByAutomationId($id){
		$action_details = array();
		
		//$sql = "SELECT * FROM dap_automation_trigger_action as datac JOIN dap_automation_trigger_action_data as datacd ON datac.id = datacd.action_id  WHERE datac.trigger_id=".$id ;
		
		$sql = "SELECT id,`trigger` FROM dap_automation_trigger WHERE automation_id = ".$id;
		
		try {
			$dap_dbh = Dap_Connection::getConnection();
			$stmt = $dap_dbh->prepare($sql);
			$stmt->execute();
		
			$i = 0;
			while ($row = $stmt->fetch()) {
				//$action = new Dap_ExternalNotifications();
				$trigger = $row["trigger"];
				$trigger_id =  $row["id"];
				
				$query1 = "SELECT id,destination FROM dap_automation_trigger_action WHERE trigger_id = ".$trigger_id." ORDER BY id ASC";
				$stmt1 = $dap_dbh->prepare($query1);
				$stmt1->execute();
				
				while($row1 = $stmt1->fetch()){
					$query2 = "SELECT name,value,action_type FROM dap_automation_trigger_action_data WHERE action_id = ".$row1['id'];
					$stmt2 = $dap_dbh->prepare($query2);
					$stmt2->execute();
					
					if($row2 = $stmt2->fetch()){
						$action_details[$i]['trigger'] = $trigger;
						$action_details[$i]['trigger_id'] = $trigger_id;
							
						$action_details[$i]['destination'] = strtoupper($row1['destination']);
						$action_details[$i]['action_id'] = $row1['id'];
						
						$value = explode('||',$row2['value']);
						if($row2['action_type'] == "add"){
							if($row2['name'] != "Tag"){
								$action_details[$i]['A:'.$row2['name']] = $value[0];
								$action_details[$i]['A:Tag'] = $value[1];															
							}
							else{
								if($row1['destination'] == "activecampaign"){
									$action_details[$i]['A:Tag'] = $value[1];	
									$action_details[$i]['S:ListId'] = $value[0];
								}
								else if($row1['destination'] == "activecampaign"){
									$action_details[$i]['A:Url'] = $value[1];
								}
								else{
									$action_details[$i]['A:Tag'] = $value[1];	
								}
									
							}
							$action_details[$i]['send_password'] = $value[2];					
						}
						else{
							if($row1['destination'] == "aweber"){
								$action_details[$i]['R:Tag'] = $value[1];	
								$action_details[$i]['S:ListId'] = $value[0];
							}
							else{
								if($row2['name'] != "Tag"){
									$action_details[$i]['R:'.$row2['name']] = $value[0];
									$action_details[$i]['R:Tag'] = $value[1];										
								}
								else{
									$action_details[$i]['R:Tag'] = $value[1];	
								}								
							}
							
							
							
						}
						//$action_details[$i]['action_type'] = $row2['action_type'];
						//$action_details[$i]['key'] = $row2['name'];
						//$action_details[$i]['value'] = $row2['value'];
					}
					$i++;
				}	
				//$action_details[] =  $action;
			}
			
			return $action_details;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			echo $e->getMessage();
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			echo $e->getMessage();
			throw $e;
		}
	}
	
	
	//get autmation by name
	public static function loadAutomationByName($name){
		$automation_details = array();
		$whereClause = " where name = '$name'";
		$sql = "select * from dap_automation " . $whereClause ;
		try {
			$dap_dbh = Dap_Connection::getConnection();
			$stmt = $dap_dbh->prepare($sql);
			$stmt->execute();

			while ($row = $stmt->fetch()) {
				$automation = new Dap_ExternalNotifications();

				$automation->setId( $row["id"] );
				$automation->setName( $row["name"] );
				$automation->setCreated_date( $row["created_date"] );
				$automation->setUpdated_date( $row["updated_date"] );
				$automation->setAuto_type( $row["type"] );
				$automation->setProduct_id( $row["product_id"] );
				$automation->setActive( $row["active"] );
				
				
			}

			return $automation;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
	}
	
	//set automation triggers
	public function createTrigger(){
		try {
			$dap_dbh = Dap_Connection::getConnection();
			$sql = "insert into dap_automation_trigger
						(`automation_id`, `trigger`)
					values
						(:automation_id, :trigger)";
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':automation_id', $this->getId(), PDO::PARAM_INT);
			$stmt->bindParam(':trigger', $this->getTrigger_action(), PDO::PARAM_STR);
			
			$stmt->execute();
			return $dap_dbh->lastInsertId();
			$stmt = null;
			$dap_dbh = null;

		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
	}
	
	
	//set automation actions
	public function createAction(){
		logToFile("Dap_ExternalNotification.class: createAction ENter",LOG_DEBUG_DAP);
		try {
			$dap_dbh = Dap_Connection::getConnection();
			$sql = "insert into dap_automation_trigger_action
						(trigger_id, destination)
					values
						(:trigger_id, :destination)";
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':trigger_id', $this->getTrigger_Id(), PDO::PARAM_STR);
			$stmt->bindParam(':destination', $this->getDestination(), PDO::PARAM_STR);
			
			$stmt->execute();
			
			return $dap_dbh->lastInsertId();
			$stmt = null;
			$dap_dbh = null;

		} catch (PDOException $e) {
			logToFile("Dap_ExternalNotification.class: createAction Error is".$e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile("Dap_ExternalNotification.class: createAction Error is".$e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
	}
	
	
	public function updateAction(){
		logToFile("Dap_ExternalNotification.class: updateAction ENter",LOG_DEBUG_DAP);
		try {
			$dap_dbh = Dap_Connection::getConnection();
			$sql = "UPDATE dap_automation_trigger_action
						SET destination = :destination
					WHERE trigger_id  = :trigger_id AND id = :action_id";
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':trigger_id', $this->getTrigger_Id(), PDO::PARAM_STR);
			$stmt->bindParam(':destination', $this->getDestination(), PDO::PARAM_STR);
			$stmt->bindParam(':action_id', $this->getAction_Id(), PDO::PARAM_STR);
			$stmt->execute();
			$stmt = null;
			$dap_dbh = null;

		} catch (PDOException $e) {
			logToFile("Dap_ExternalNotification.class: updateAction error is".$e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile("Dap_ExternalNotification.class: updateAction error is".$e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
	}
	
	//set automation action data
	public function createActionData(){
		logToFile("Dap_ExternalNotification.class: createActionData ENter",LOG_DEBUG_DAP);
		try {
			$dap_dbh = Dap_Connection::getConnection();
			
			$sql = "insert into dap_automation_trigger_action_data
						(automation_id, action_id , action_type, name, value)
					values
						(:automation_id, :action_id, :action_type, :name, :value)";
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':automation_id', $this->getId(), PDO::PARAM_STR);
			$stmt->bindParam(':action_id', $this->getAction_Id(), PDO::PARAM_STR);
			$stmt->bindParam(':action_type', $this->getAction_type(), PDO::PARAM_STR);
			$stmt->bindParam(':name', $this->getKey(), PDO::PARAM_STR);
			$stmt->bindParam(':value', $this->getValue(), PDO::PARAM_STR);
			
			$stmt->execute();
			
			return $dap_dbh->lastInsertId();
			$stmt = null;
			$dap_dbh = null;

		} catch (PDOException $e) {
			logToFile("Dap_ExternalNotification.class: createActionData error ".$e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile("Dap_ExternalNotification.class: createActionData error".$e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
	}
	
	public function updateActionData(){
		logToFile("Dap_ExternalNotification.class: updateActionData ENter",LOG_DEBUG_DAP);
		try {
			$dap_dbh = Dap_Connection::getConnection();
			
			$sql = "UPDATE dap_automation_trigger_action_data
						SET  action_type = :action_type, name = :name , value = :value
					WHERE
						automation_id = :automation_id AND action_id = :action_id";
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':automation_id', $this->getId(), PDO::PARAM_STR);
			$stmt->bindParam(':action_id', $this->getAction_Id(), PDO::PARAM_STR);
			$stmt->bindParam(':action_type', $this->getAction_type(), PDO::PARAM_STR);
			$stmt->bindParam(':name', $this->getKey(), PDO::PARAM_STR);
			$stmt->bindParam(':value', $this->getValue(), PDO::PARAM_STR);
			
			$stmt->execute();
			$stmt = null;
			$dap_dbh = null;

		} catch (PDOException $e) {
			logToFile("Dap_ExternalNotification.class: updateActionData error ".$e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile("Dap_ExternalNotification.class: updateActionData error ".$e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
	}
	
	
	//get automation details
	public static function loadAutomation(){
		$automation_details = array();
		$sql = "select da.id , da.name , da.updated_date , da.product_id, da.active, datac.destination, datac.trigger_id, datacd.action_id,dat.trigger as `trigger`
		from dap_automation as da JOIN dap_automation_trigger as dat on da.id=dat.automation_id 
		JOIN dap_automation_trigger_action as datac ON dat.id=datac.trigger_id 
		JOIN dap_automation_trigger_action_data as datacd ON datac.id=datacd.action_id 
		ORDER BY da.id DESC" ;
		try {
			$dap_dbh = Dap_Connection::getConnection();
			$stmt = $dap_dbh->prepare($sql);
			$stmt->execute();
			while ($row = $stmt->fetch()) {
				$automation = new Dap_ExternalNotifications();
				
				$automation->setId( $row["id"] );
				$automation->setName( $row["name"] );
				$automation->setCreated_date( $row["created_date"] );
				$automation->setUpdated_date( $row["updated_date"] );
				$automation->setProduct_id( $row["product_id"] );
				$automation->setActive( $row["active"] );
				$automation->setAction_Id( $row["action_id"] );
				$automation->setDestination( $row["destination"] );
				$automation->setTrigger_Id( $row["trigger_id"] );
				$automation->setTrigger_action( $row["trigger"] );
				
				$automation_details[] = $automation;
			}

			return $automation_details;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
	}
	
	
	public static function DoesAutomationExist($product_id){
		if($product_id != ""){
			$automation_id = "";
			logToFile("Dap_externalNotifications.class:DoesAutomationExist(), productid is ".$product_id,LOG_DEBUG_DAP);
			
			$sql = "SELECT id FROM dap_automation WHERE product_id = $product_id AND active = 1 ORDER BY id DESC";			
			try{
				$dap_dbh = Dap_Connection::getConnection();
				$stmt = $dap_dbh->prepare($sql);
				$stmt->execute();
			
				if($row = $stmt->fetch(PDO::FETCH_ASSOC)){	
					$automation_id =  $row['id'];
				}
				return $automation_id;
			}
			catch (PDOException $e) {
				logToFile($e->getMessage(),LOG_FATAL_DAP);
				throw $e;
			} catch (Exception $e) {
				logToFile($e->getMessage(),LOG_FATAL_DAP);
				throw $e;
			}
		}
		else{
			logToFile("Dap_externalNotifications.class:DoesAutomationExist(), productid is missing",LOG_DEBUG_DAP);
			return;
		}
	}
	
	public static function GetAllAutomationRules($product_id,$automation_id,$type){
		logToFile("Dap_externalNotifications.class:GetAllAutomationRules(), productid is ".$product_id.",automation id = ".$automation_id.",type = ".$type,LOG_DEBUG_DAP);
		
		if($product_id != "" && $automation_id != "" && $type != ""){
			$table1 = "dap_automation_trigger";
			$table2 = "dap_automation_trigger_action";
			$table3 = "dap_automation_trigger_action_data";
			
			try{
				$data = array();
				$dap_dbh = Dap_Connection::getConnection();
				$sql1 = "SELECT id FROM ".$table1." WHERE automation_id = ".$automation_id." AND `trigger` = '".$type."'";
				$stmt = $dap_dbh->prepare($sql1);
				$stmt->execute();
				
				if($row = $stmt->fetch(PDO::FETCH_ASSOC)){	
					$trigger_id = $row['id'];
					//$data[0]['trigger_id'] = $trigger_id;
					$sql2 = "SELECT ta.id,ta.destination,tad.`name`,tad.`value`,tad.action_type FROM `dap_automation_trigger_action` ta INNER JOIN dap_automation_trigger_action_data tad ON ta.id =  tad.action_id WHERE ta.trigger_id = ".$trigger_id." AND tad.automation_id = ".$automation_id;
					$stmt1 = $dap_dbh->prepare($sql2);
					$stmt1->execute();
					
					$i = 0;
					while($row1 = $stmt1->fetch(PDO::FETCH_ASSOC)){
						$data[$i]['destination'] = $row1['destination'];
						$data[$i]['action_type'] = $row1['action_type'];
						$data[$i]['name'] = $row1['name'];
						$data[$i]['value'] = $row1['value'];
						$i++;
					}
					return $data;
				}
			}
			catch (PDOException $e) {
				logToFile("Dap_externalNotifications.class:GetAllAutomationRules(): ".$e->getMessage(),LOG_FATAL_DAP);
				throw $e;
			} catch (Exception $e) {
				logToFile("Dap_externalNotifications.class:GetAllAutomationRules(): ".$e->getMessage(),LOG_FATAL_DAP);
				throw $e;
			}
		}
		else{
			logToFile("Dap_externalNotifications.class:GetAllAutomationRules(), productid,automation id or type is missing",LOG_DEBUG_DAP);
		}
	}
	
	
	public static function DeleteAutomationAction($id="",$trigger_id="",$action_id){
		logToFile("Dap_externalNotifications.class:DeleteAutomationAction(), id is ".$id.",trigger_id id = ".$trigger_id.",action_id = ".$action_id,LOG_DEBUG_DAP);
		
		//if($id != "" && $trigger_id != "" && $action_id != ""){
		if($action_id != ""){			
			$table1 = "dap_automation_trigger_action";
			$table2 = "dap_automation_trigger_action_data";

			try{
				
				$dap_dbh = Dap_Connection::getConnection();
				
				$sql1 = "DELETE  FROM ".$table1." WHERE id = '".$action_id."'";
				$sql2 = "DELETE  FROM ".$table2." WHERE action_id = '".$action_id."'";
				
				$stmt1 = $dap_dbh->prepare($sql1);
				$stmt2 = $dap_dbh->prepare($sql2);
				
				$stmt1->execute();
				$stmt2->execute();
				  
				return "True";
			}
			catch (PDOException $e) {
				logToFile($e->getMessage(),LOG_FATAL_DAP);
				throw $e;
			} catch (Exception $e) {
				logToFile($e->getMessage(),LOG_FATAL_DAP);
				throw $e;
			}
		}
		else{
			logToFile("Dap_externalNotifications.class:DeleteAutomationAction(), productid,automation id or type is missing",LOG_DEBUG_DAP);
		}
	}
	
	public static function DAPDeleteTriggerData($trigger_id){
		logToFile("Dap_externalNotifications.class:DAPDeleteTriggerData(), trigger_id id = ".$trigger_id,LOG_DEBUG_DAP);
		if($trigger_id != ""){
			$table2 = "dap_automation_trigger";
			$table3 = "dap_automation_trigger_action";
			$table4 = "dap_automation_trigger_action_data";
			
			try{
				$dap_dbh = Dap_Connection::getConnection();
				$sql1 = "SELECT id FROM ".$table3." WHERE  trigger_id = '".$trigger_id."'";
				$stmt1 = $dap_dbh->prepare($sql1);
				$stmt1->execute();
				
				while ($row = $stmt1->fetch()) {
					$actionId = $row['id'];
					
					/*  delete from action data table */
					$sql2 = "DELETE FROM ".$table4." WHERE action_id = '".$actionId."'";
					$stmt2 = $dap_dbh->prepare($sql2);
					$stmt2->execute();
				}
				$sql3 = "DELETE FROM ".$table3." WHERE trigger_id = '".$trigger_id."'";
				$sql4 = "DELETE FROM ".$table2." WHERE id = '".$trigger_id."'";
				
				$stmt3 = $dap_dbh->prepare($sql3);
				$stmt4 = $dap_dbh->prepare($sql4);
				$stmt3->execute();
				$stmt4->execute();
			}
			catch (PDOException $e) {
				logToFile("Dap_externalNotifications.class:DAPDeleteTriggerData(),exception is ".$e->getMessage(),LOG_FATAL_DAP);
				throw $e;
			} catch (Exception $e) {
				logToFile("Dap_externalNotifications.class:DAPDeleteTriggerData(),exception is ".$e->getMessage(),LOG_FATAL_DAP);
				throw $e;
			}
		}
		
	}
	
	
	public static function DeleteAutomation($id,$trigger_id,$action_id){
		logToFile("Dap_externalNotifications.class:DeleteAutomation(), id is ".$id.",trigger_id id = ".$trigger_id.",action_id = ".$action_id,LOG_DEBUG_DAP);
		
		//if($id != "" && $trigger_id != "" && $action_id != ""){
		if($id != ""){
			$table1 = "dap_automation";
			$table2 = "dap_automation_trigger";

			try{				
				$dap_dbh = Dap_Connection::getConnection();
				
				$sql2 = "SELECT id FROM ".$table2." WHERE automation_id = '".$id."'";
				$stmt2 = $dap_dbh->prepare($sql2);
				$stmt2->execute();
				
				while($row = $stmt2->fetch(PDO::FETCH_ASSOC)){
					self::DAPDeleteTriggerData($row['id']);
				}
				
				$sql1 = "DELETE  FROM ".$table1." WHERE id = '".$id."'";
				$stmt1 = $dap_dbh->prepare($sql1);
				$stmt1->execute();	
			}
			catch (PDOException $e) {
				logToFile("Dap_externalNotifications.class:DeleteAutomation() error is".$e->getMessage(),LOG_FATAL_DAP);
				throw $e;
			} catch (Exception $e) {
				logToFile("Dap_externalNotifications.class:DeleteAutomation() error is".$e->getMessage(),LOG_FATAL_DAP);
				throw $e;
			}
		}
		else{
			logToFile("Dap_externalNotifications.class:GetAllAutomationRules(), productid,automation id or type is missing",LOG_DEBUG_DAP);
		}
	}
	
	/*  This function will tell that how many total number of automations are there for product.
	 *  We can have only 1 automation per product. So when creating a new automation we will be checking
	 *  If automation exists for the current product or not
	 * */
	public static function DapCountAutomationsForProduct($product_id){
		if($product_id != ""){
			$automation_id = "";
			logToFile("Dap_externalNotifications.class:DapCountAutomationsForProduct(), productid is ".$product_id,LOG_DEBUG_DAP);
			
			$sql = "SELECT id FROM dap_automation WHERE product_id = ".$product_id." ORDER BY id ASC";			
			try{
				$dap_dbh = Dap_Connection::getConnection();
				$stmt = $dap_dbh->prepare($sql);
				$stmt->execute();
			
				if($row = $stmt->fetch(PDO::FETCH_ASSOC)){	
					$automation_id =  $row['id'];	
					return $automation_id;
				}
				else{
					return 0;
				}

			}
			catch (PDOException $e) {
				logToFile($e->getMessage(),LOG_FATAL_DAP);
				throw $e;
			} catch (Exception $e) {
				logToFile($e->getMessage(),LOG_FATAL_DAP);
				throw $e;
			}
		}
		else{
			logToFile("Dap_externalNotifications.class:DapCountAutomationsForProduct(), productid is missing",LOG_DEBUG_DAP);
			return;
		}
	}
	
	public static function DAPAutomationUpdateStatus($id,$status){
		try{
			$dap_dbh = Dap_Connection::getConnection();
		
			$table1 = "dap_automation";
			$sql = "UPDATE ".$table1." SET active = '".$status."' WHERE id = '".$id."'";
			
			$stmt = $dap_dbh->prepare($sql);
			$stmt->execute();
		}
		catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
		
	}
	
}/* class ends */
