<?php

class Dap_FormBuilder {

   	var $id;
   	var $form_name;
	var $product_id;
	var $template_name;
	var $template_data;
	var $country;
	var $state;
	var $redirect_url;
	var $autologin;
	var $captcha;
	var $date;

	function getId() {
		return $this->id;
	}

	function setId($o) {
		$this->id = $o;
	}

	function getFormName() {
		return $this->form_name;
	}

	function setFormName($o) {
		$this->form_name = $o;
	}

	function getProductId() {
		return $this->product_id;
	}

	function setProductId($o) {
		$this->product_id = $o;
	}

	function getTemplateName() {
		return $this->template_name;
	}

	function setTemplateName($o) {
		$this->template_name = $o;
	}

	function getTemplateData() {
		return $this->template_data;
	}

	function setTemplateData($o) {
		$this->template_data = $o;
	}

	function getRedirectUrl() {
		return $this->redirect_url;
	}

	function setRedirectUrl($o) {
		$this->redirect_url = $o;
	}
	
	function getCountry() {
		return $this->country;
	}

	function setCountry($o) {
		$this->country = $o;
	}
		function getState() {
		return $this->state;
	}

	function setState($o) {
		$this->state = $o;
	}
	
	function getAutoLogin() {
		return $this->autologin;
	}

	function setAutoLogin($o) {
		$this->autologin = $o;
	}	
	
	function getCaptcha() {
		return $this->captcha;
	}

	function setCaptcha($o) {
		$this->captcha = $o;
	}
	function getDate() {
		return $this->date;
	}

	function setDate($o) {
		$this->date = $o;
	}

	public function create() {
		try {
			$dap_dbh = Dap_Connection::getConnection();
			//return $this->getFormName()."--".$this->getProductId();
			$sql = "insert into dap_form_builder
						(form_name, product_id, template_name, template_data, country, state, redirect_url, autologin, captcha, date)
					values
						(:form_name, :product_id, :template_name, :template_data, :country, :state, :redirect_url, :autologin, :captcha, now() )";  
						
			logToFile("Dap_FormFields.class.php, create() sql=".$sql, LOG_INFO_DAP);
			
			$stmt = $dap_dbh->prepare($sql);

			$stmt->bindParam(':form_name', $this->getFormName(), PDO::PARAM_STR);
			$stmt->bindParam(':product_id', $this->getProductId(), PDO::PARAM_STR);
			$stmt->bindParam(':template_name', $this->getTemplateName(), PDO::PARAM_STR);
			$stmt->bindParam(':template_data', $this->getTemplateData(), PDO::PARAM_STR);
			$stmt->bindParam(':country', $this->getCountry(), PDO::PARAM_STR);
			$stmt->bindParam(':state', $this->getState(), PDO::PARAM_STR);
			$stmt->bindParam(':redirect_url', $this->getRedirectUrl(), PDO::PARAM_STR);
			$stmt->bindParam(':autologin', $this->getAutoLogin(), PDO::PARAM_STR);
			$stmt->bindParam(':captcha', $this->getCaptcha(), PDO::PARAM_STR);
		
			$stmt->execute();

			$last_insert_id = $dap_dbh->lastInsertId();
			$this->setId($last_insert_id);
			$stmt = null;
			$dap_dbh = null;
			return $last_insert_id;
			
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
	}


	public function update() {
		try {
			$dap_dbh = Dap_Connection::getConnection();
				$sql = "update 
							dap_form_builder 
						set
							form_name = :form_name,
							product_id = :product_id,
							template_name = :template_name,
							template_data = :template_data,
							country = :country,
							state = :state,
							redirect_url = :redirect_url,
							autologin = :autologin,
							captcha = :captcha,
							date =now()
						where id = :id";

			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':form_name', $this->getFormName(), PDO::PARAM_STR);
			$stmt->bindParam(':product_id', $this->getProductId(), PDO::PARAM_STR);
			$stmt->bindParam(':template_name', $this->getTemplateName(), PDO::PARAM_STR);
			$stmt->bindParam(':template_data', $this->getTemplateData(), PDO::PARAM_STR);
			$stmt->bindParam(':country', $this->getCountry(), PDO::PARAM_STR);
			$stmt->bindParam(':state', $this->getState(), PDO::PARAM_STR);
			$stmt->bindParam(':redirect_url', $this->getRedirectUrl(), PDO::PARAM_STR);
			$stmt->bindParam(':autologin', $this->getAutoLogin(), PDO::PARAM_STR);
			$stmt->bindParam(':captcha', $this->getCaptcha(), PDO::PARAM_STR);
			$stmt->bindParam(':id', $this->getId(), PDO::PARAM_INT);

			logToFile("functions admin, form_name=" . $this->getFormName(),LOG_INFO_DAP);
			logToFile("functions admin, product_id=" . $this->getProductId(),LOG_INFO_DAP);
			logToFile("functions admin, template_name=" . $this->getTemplateName(),LOG_INFO_DAP);
			logToFile("functions admin, template_data=" . $this->getTemplateData(),LOG_INFO_DAP);
			logToFile("functions admin, country=" . $this->getCountry(),LOG_INFO_DAP);
			logToFile("functions admin, state=" . $this->getState(),LOG_INFO_DAP);
			logToFile("functions admin, redirect_url=" . $this->getRedirectUrl(),LOG_INFO_DAP);
			logToFile("functions admin, autologin=" . $this->getAutoLogin(),LOG_INFO_DAP);
			logToFile("functions admin, captcha=" . $this->getCaptcha(),LOG_INFO_DAP);
		
			$stmt->execute();
			$stmt = null;
			$dap_dbh = null;
			return;

		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}

	}
	
	public static function loadFormFieldById($id) {
		
		try{
			logToFile("Dap_FormFields.class.php, loadFormFieldById ()",LOG_INFO_DAP);

			$dap_dbh = Dap_Connection::getConnection();
			$FormFields = null;

			//Load FormFields details from database
			$sql = "SELECT * FROM dap_form_builder WHERE id=:id";
 
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':id', $id, PDO::PARAM_INT);
			$stmt->execute();

			if ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
				$formField = new Dap_FormBuilder();
				$formField->setId( $row["id"] );
				$formField->setFormName( $row["form_name"] );
				$formField->setProductId( $row["product_id"] );
				$formField->setTemplateName( $row["template_name"] );
				$formField->setTemplateData( $row["template_data"] );
				$formField->setCountry( $row["country"] );
				$formField->setState( $row["state"] );
				$formField->setRedirectUrl( $row["redirect_url"] );
				$formField->setAutoLogin( $row["autologin"] );
				$formField->setCaptcha( $row["captcha"] );
				$formField->setDate( $row["date"] );
			}

			return $formField;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}

	}
	
		
	public static function loadForms() {
		
		try{
			logToFile("Dap_FormFields.class.php, loadForms()",LOG_INFO_DAP);
			$dap_dbh = Dap_Connection::getConnection();
			$forms = null;
			$sql = "SELECT * FROM dap_form_builder ORDER BY id desc";

			$stmt = $dap_dbh->prepare($sql);
			$stmt->execute();
			$forms = array();
			
			while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
				$forms[] = $row;
			}
			return $forms;
			
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}

	}
	
	public static function deleteForms($id) {
				
		try {
			$dap_dbh = Dap_Connection::getConnection();
			$reponse = "";

			$sql = "DELETE 
					FROM 
						dap_form_builder
					WHERE 
						id = :id";
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':id', $id, PDO::PARAM_INT);
			$stmt->execute();
			
			$sql = null;
			$stmt = null;
			$dap_dbh = null;
			return "Row deleted";
			
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
	}
	
	public static function loadFormTemplateById($id) {

		try {
			$dap_dbh = Dap_Connection::getConnection();
			$FormFields = NULL;
			if(!isset($id)) {
				return $FormFields;
			}
			$sql = "SELECT 
						*
					FROM
						dap_form_builder
					WHERE
						id =:id
					";
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':id', $id, PDO::PARAM_INT);
			$stmt->execute();

			if ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
				$formField = $row["template_data"] ;
			}
			
			$sql = null;
			$stmt = null;
			$dap_dbh = null; 
			
			return $formField;	
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}

	}

}
?>