<?php 
class Dap_GDPR{
	
	var $id;
	var $filter_gdpr_transactions;
	var $send_gdpr_tags;
	var $filter_existing_users;
	var $user_country_for_gdpr;
	var $send_admin_email;
	
	function getId() {
        return $this->id;
    }
    function setId($o) {
        $this->id = $o;
    }
    
    function getFilter_gdpr_transactions() {
        return $this->filter_gdpr_transactions;
    }
    function setFilter_gdpr_transactions($o) {
        $this->filter_gdpr_transactions = $o;
    }
    
    function getSend_gdpr_tags() {
        return $this->send_gdpr_tags;
    }
    function setSend_gdpr_tags($o) {
        $this->send_gdpr_tags = $o;
    } 
    
    function getFilter_existing_users() {
        return $this->filter_existing_users;
    }
    function setFilter_existing_users($o) {
        $this->filter_existing_users = $o;
    } 
    
    function getUser_country_for_gdpr() {
        return $this->user_country_for_gdpr;
    }
    function setUser_country_for_gdpr($o) {
        $this->user_country_for_gdpr = $o;
    } 
    
    function getSend_admin_email() {
        return $this->send_admin_email;
    }
    function setSend_admin_email($o) {
        $this->send_admin_email = $o;
    } 
    
    function create(){
	//	logToFile("Dap_GDPR.class.php: create method called ", LOG_DEBUG_DAP);
		
		try{
			$dap_dbh = Dap_Connection::getConnection();
			
			$sql = "INSERT INTO dap_gdpr_settings
					(filter_gdpr_transactions,send_gdpr_tags, filter_existing_users,user_country_for_gdpr,send_admin_email) VALUES
					(:filter_gdpr_transactions, :send_gdpr_tags, :filter_existing_users,:user_country_for_gdpr,:send_admin_email)";
			
			$stmt = $dap_dbh->prepare($sql);

			$stmt->bindParam(':filter_gdpr_transactions', $this->getFilter_gdpr_transactions(), PDO::PARAM_STR);
			$stmt->bindParam(':send_gdpr_tags', $this->getSend_gdpr_tags(), PDO::PARAM_STR);
			$stmt->bindParam(':filter_existing_users', $this->getFilter_existing_users(), PDO::PARAM_STR);
			$stmt->bindParam(':user_country_for_gdpr', $this->getUser_country_for_gdpr(), PDO::PARAM_STR);
			$send_admin_email=$this->getSend_admin_email();
			if($send_admin_email=="")
				$send_admin_email="Y";
			$stmt->bindParam(':send_admin_email', $send_admin_email, PDO::PARAM_STR);
			$stmt->execute();
			return $dap_dbh->lastInsertId();
		}
		catch (PDOException $e) {
            logToFile("Dap_GDPR.class.php: create(), exception is ".$e->getMessage(), LOG_FATAL_DAP);
            throw $e;
        } 
		catch (Exception $e) {
            logToFile("Dap_GDPR.class.php: create(), exception is ".$e->getMessage(), LOG_FATAL_DAP);
            throw $e;
        }
    //    logToFile("Dap_GDPR.class.php: exit ", LOG_DEBUG_DAP);
		exit;
	}
	
	function update(){
		//logToFile("Dap_GDPR.class.php: update() method called ", LOG_DEBUG_DAP);
		
		try{
			$dap_dbh = Dap_Connection::getConnection();
			
			$sql = "UPDATE dap_gdpr_settings
					SET filter_gdpr_transactions = :filter_gdpr_transactions,send_gdpr_tags = :send_gdpr_tags,filter_existing_users = :filter_existing_users,user_country_for_gdpr = :user_country_for_gdpr,send_admin_email = :send_admin_email";
			
			$stmt = $dap_dbh->prepare($sql);

			$stmt->bindParam(':filter_gdpr_transactions', $this->getFilter_gdpr_transactions(), PDO::PARAM_STR);
			$stmt->bindParam(':send_gdpr_tags', $this->getSend_gdpr_tags(), PDO::PARAM_STR);
			$stmt->bindParam(':filter_existing_users', $this->getFilter_existing_users(), PDO::PARAM_STR);
			$stmt->bindParam(':user_country_for_gdpr', $this->getUser_country_for_gdpr(), PDO::PARAM_STR);
			$stmt->bindParam(':send_admin_email', $this->getSend_admin_email(), PDO::PARAM_STR);
			$stmt->execute();
		}
		catch (PDOException $e) {
            logToFile("Dap_GDPR.class.php: update(), exception is ".$e->getMessage(), LOG_FATAL_DAP);
            throw $e;
        } 
		catch (Exception $e) {
            logToFile("Dap_GDPR.class.php: update(), exception is ".$e->getMessage(), LOG_FATAL_DAP);
            throw $e;
        }
		
	//	logToFile("Dap_GDPR.class.php: update() exit ", LOG_DEBUG_DAP);
	}
	
	public static function load(){
		//logToFile("Dap_GDPR.class.php: load method called ", LOG_DEBUG_DAP);
		$gdpr_data="";
		try{
			$dap_dbh = Dap_Connection::getConnection();
			
			$sql = "SELECT * FROM dap_gdpr_settings";		
			$stmt = $dap_dbh->prepare($sql);
			$stmt->execute();
			if($row = $stmt->fetch(PDO::FETCH_ASSOC)){
				$gdpr = new Dap_GDPR();
				
				$gdpr->setId($row['id']);
				$gdpr->setFilter_gdpr_transactions($row['filter_gdpr_transactions']);
				$gdpr->setSend_gdpr_tags($row['send_gdpr_tags']);
				$gdpr->setFilter_existing_users($row['filter_existing_users']);
				$gdpr->setUser_country_for_gdpr($row['user_country_for_gdpr']);
				$gdpr->setSend_admin_email($row['send_admin_email']);
				$gdpr_data = $gdpr;
			}
			return $gdpr_data;
		}
		catch (PDOException $e) {
            logToFile("Dap_GDPR.class.php: load(), exception is ".$e->getMessage(), LOG_FATAL_DAP);
            throw $e;
        } 
		catch (Exception $e) {
            logToFile("Dap_GDPR.class.php: load(), exception is ".$e->getMessage(), LOG_FATAL_DAP);
            throw $e;
        }
       // logToFile("Dap_GDPR.class.php: exit ", LOG_DEBUG_DAP);
		exit;
		
	}
	
	
}
?>
