<?php
	
class Dap_OnlineCourse {
	
   	var $id;
   	var $name;
   	var $course_id;
   	var $html;
   	var $customize_data;
   	var $date; 
	
	function getId() {
		return $this->id;
	}
	function setId($o) {
		$this->id = $o;
	}
	function getName() {
		return $this->name;
	}
	function setName($o) {
		$this->name = $o;
	}
	
	function getCourseId() {
		return $this->course_id;
	}
	function setCourseId($o) {
		$this->course_id = $o;
	}

	function getHtml() {
		return $this->html;
	}
	function setHtml($o) {
		$this->html = $o;
	}
	function getCustomizeData() {
		return $this->customize_data;
	}
	function setCustomizeData($o) {
		$this->customize_data = $o;
	}
	 
	function getDate() {
		return $this->date;
	}
	function setDate($o) {
		$this->date = $o;
	}
 	
	public function create() {
		
		try {
			$dap_dbh = Dap_Connection::getConnection();
			$sql = "insert into dap_onlinecourse
						( name, course_id, html, customize_data, date)
					values 
						(:name,  :course_id, :html, :customize_data, now())";

			$stmt = $dap_dbh->prepare($sql);
				 
 
			$stmt->bindParam(':name', $this->getName(), PDO::PARAM_STR);
			$stmt->bindParam(':course_id', $this->getCourseId(), PDO::PARAM_STR);
			$stmt->bindParam(':html', $this->getHtml(), PDO::PARAM_STR);
			$stmt->bindParam(':customize_data', $this->getCustomizeData(), PDO::PARAM_STR);
 			$stmt->execute();
			 
			$last_insert_id = $dap_dbh->lastInsertId();
	 
			$stmt = null;
			$dap_dbh = null;
			return $last_insert_id;
	
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}	
	}
 
	public function update() {
		try {
			$dap_dbh = Dap_Connection::getConnection();
	
			$sql = "update 
					dap_onlinecourse
					set
						 name =:name, 
						 course_id =:course_id, 
						 html=:html,
						 customize_data=:customize_data,
						 date=now()
					where
						id =:id ";
					
			$stmt = $dap_dbh->prepare($sql);	
			
			$stmt->bindParam(':name', $this->getName(), PDO::PARAM_STR);
			$stmt->bindParam(':course_id', $this->getCourseId(), PDO::PARAM_STR);
			$stmt->bindParam(':html', $this->getHtml(), PDO::PARAM_STR);
			$stmt->bindParam(':customize_data', $this->getCustomizeData(), PDO::PARAM_STR);
			$stmt->bindParam(':id', $this->getId(), PDO::PARAM_INT);
			$stmt->execute();
			
			$stmt = null;
			$dap_dbh = null;
			
			return;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}	
	}
	
 
	public static function load() {
		$dataarr = array();
		
		try {
			$dap_dbh = Dap_Connection::getConnection();
			
			$sql = "SELECT 
						*
					FROM
						dap_onlinecourse ORDER BY date DESC
					";
			//logToFile($sql,LOG_DEBUG_DAP);
			$stmt = $dap_dbh->prepare($sql);
			 
			$stmt->execute();
	
			while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
				$data = new Dap_OnlineCourse();
 
				$data->setId( stripslashes($row["id"]) );
				$data->setName( stripslashes($row["name"]) );
				$data->setCourseId( stripslashes($row["course_id"]) );
				$data->setHtml( stripslashes($row["html"]) );
				$data->setCustomizeData( stripslashes($row["customize_data"]) );
				$data->setDate( stripslashes($row["date"]) ); 
				$dataarr[] = $data;

			}
			
			
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
		
		return $dataarr;
	}
	
	 public static function loadByCourseId($course_id) {
		$dataarr = array();
		
		try {
			$dap_dbh = Dap_Connection::getConnection();
			
			$sql = "SELECT 
						*
					FROM
						dap_onlinecourse
					WHERE
						course_id =:course_id 
						
					";
			// logToFile("sql=".$sql,LOG_DEBUG_DAP);
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':course_id', $course_id, PDO::PARAM_STR);
			$stmt->execute();
	         
			while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
				$data = new Dap_OnlineCourse();
				
				$data->setId( stripslashes($row["id"]) );
				$data->setName( stripslashes($row["name"]) );
				$data->setCourseId( stripslashes($row["course_id"]) );
				$data->setHtml( stripslashes($row["html"]) );
				$data->setCustomizeData( stripslashes($row["customize_data"]) );
				$data->setDate( stripslashes($row["date"]) ); 
				$dataarr[] = $data;

			}	
			$stmt = null;
			$dap_dbh = null;		
			
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
		
		return $dataarr;
	} 
	
	public static function loadByName($name) {
		$dataarr = array();
		
		try {
			$dap_dbh = Dap_Connection::getConnection();
			
			$sql = "SELECT 
						*
					FROM
						dap_onlinecourse
					WHERE
						name =:name 
						
					";
			// logToFile("sql=".$sql,LOG_DEBUG_DAP);
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':name', $name, PDO::PARAM_STR);
			$stmt->execute();
	         
			while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
				$data = new Dap_OnlineCourse();
				
				$data->setId( stripslashes($row["id"]) );
				$data->setName( stripslashes($row["name"]) );
				$data->setCourseId( stripslashes($row["course_id"]) );
				$data->setHtml( stripslashes($row["html"]) );
				$data->setCustomizeData( stripslashes($row["customize_data"]) );
				$data->setDate( stripslashes($row["date"]) ); 
				$dataarr[] = $data;

			}			
			
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
		
		return $dataarr;
	} 
 
	public function delete($id) {
		try {
			$dap_dbh = Dap_Connection::getConnection();
			$dap_dbh->beginTransaction();
			
			//$id = $this->getId();
			//delete from usersproducts table
			  $sql = "delete from  
					dap_onlinecourse
					where id =:id"; 
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':id', $id, PDO::PARAM_INT);
			$stmt->execute();
			
			$dap_dbh->commit(); 
			
			$stmt = null;
			$dap_dbh = null;		
			return;			
		} catch (PDOException $e) {
			$dap_dbh->rollback();
			$stmt = null;
			$dap_dbh = null;				
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			$dap_dbh->rollback();
			$stmt = null;
			$dap_dbh = null;			
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}		
	}
	
	public static function loadById($id) {
		$dataarr = null;
		
		try {
			$dap_dbh = Dap_Connection::getConnection();
			
			$sql = "SELECT 
						*
					FROM
						dap_onlinecourse
					WHERE
						id =:id 
						
					";
			// logToFile("sql=".$sql,LOG_DEBUG_DAP);
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':id', $id, PDO::PARAM_STR);
			$stmt->execute();
	        if ($row = $stmt->fetch()) {
				$data = new Dap_OnlineCourse();
				$data->setId( stripslashes($row["id"]) );
				$data->setName( stripslashes($row["name"]) );
				$data->setCourseId( stripslashes($row["course_id"]) );
				$data->setHtml( stripslashes($row["html"]) );
				$data->setCustomizeData( stripslashes($row["customize_data"]) );
				$data->setDate( stripslashes($row["date"]) ); 
				$dataarr = $data;

			}
			$stmt = null;
			$dap_dbh = null;
			return $dataarr;				
			
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
		
		return $dataarr;
	} 
	
 
}
 
