<?php

class Dap_PaymentPlan{

	var $id;
	var $btn_id;
	var $user_id;
	var $product_id;
	var $recurring_id;
	var $txn_id;
	var $max_payments;
	var $actual_payments;
	var $status;
	var $date;
	var $subscription_id;
	
	function getId() {
        return $this->id;
    }
    function setId($o) {
        $this->id = $o;
    }
	
	function getBtn_id() {
        return $this->btn_id;
    }
    function setBtn_id($o) {
        $this->btn_id = $o;
    }
	
	function getUser_id() {
        return $this->user_id;
    }
    function setUser_id($o) {
        $this->user_id = $o;
    }
	
	function getProduct_id() {
        return $this->product_id;
    }
    function setProduct_id($o) {
        $this->product_id = $o;
    }
	
	function getRecurring_id() {
        return $this->recurring_id;
    }
    function setRecurring_id($o) {
        $this->recurring_id = $o;
    }
	
	function getSubscription_id() {
        return $this->subscription_id;
    }
    function setSubscription_id($o) {
        $this->subscription_id = $o;
    }
	
	function getTxn_id() {
        return $this->txn_id;
    }
    function setTxn_id($o) {
        $this->txn_id = $o;
    }
	
	function getMax_payments() {
        return $this->max_payments;
    }
    function setMax_payments($o) {
        $this->max_payments = $o;
    }
	
	function getActual_payments() {
        return $this->actual_payments;
    }
    function setActual_payments($o) {
        $this->actual_payments = $o;
    }
	
	function getStatus() { 
        return $this->status;
    }
    function setStatus($o) {
        $this->status = $o;
    }
	
	function getDate() {
        return $this->date;
    }
    function setDate($o) {
        $this->date = $o;
    }
    
    function setMultiPlan($o){
		$this->multi_plan = $o;
	}
	
	function getMultiPlan(){
		return $this->multi_plan;
	}
	
	public function create(){
		logToFile("Dap_PaymentPlan.class.php: create metod called ", LOG_DEBUG_DAP);
		
		try{
			$dap_dbh = Dap_Connection::getConnection();
			$plan_exists = array();
			if($this->getMultiPlan() == 'yes'){
				logToFile("Dap_PaymentPlan.class.php: First of all we are going to check whether the pyment plan exist or not for this user ", LOG_DEBUG_DAP);
				$plan_exists = self::loadPaymentPlan($this->getUser_id(),"");
			}
			if(!empty($plan_exists)){
				logToFile("Dap_PaymentPlan.class.php: plan already exist so update", LOG_DEBUG_DAP);
				self::updateExistingPlan($this->getUser_id(),$this->getProduct_id(),$this->getMax_payments(),$this->getTxn_id());
			}

			else{
				logToFile("Dap_PaymentPlan.class.php: plan is new so insert", LOG_DEBUG_DAP);
				$sql = "INSERT INTO dap_payment_plan
					(btn_id, user_id, product_id, recurring_id ,txn_id ,max_payments ,actual_payments ,status,date ) VALUES
					(:btn_id, :user_id, :product_id ,:recurring_id, :txn_id, :max_payments, :actual_payments, :status, :date)";
			
			
				logToFile("Dap_PaymentPlan.class.php: create, sql is ".$sql, LOG_DEBUG_DAP);
				
				$stmt = $dap_dbh->prepare($sql);

				$stmt->bindParam(':btn_id', $this->getBtn_id(), PDO::PARAM_STR);
				$stmt->bindParam(':user_id', $this->getUser_id(), PDO::PARAM_INT);
				$stmt->bindParam(':product_id', $this->getProduct_id(), PDO::PARAM_INT);
				$stmt->bindParam(':recurring_id', $this->getRecurring_id(), PDO::PARAM_STR); 
				$stmt->bindParam(':txn_id', $this->getTxn_id(), PDO::PARAM_STR);
				$stmt->bindParam(':max_payments', $this->getMax_payments(), PDO::PARAM_INT);
				$stmt->bindParam(':actual_payments', $this->getActual_payments(), PDO::PARAM_INT);
				$stmt->bindParam(':status', $this->getStatus(), PDO::PARAM_STR);
				$stmt->bindParam(':date', date('Y-m-d'), PDO::PARAM_STR); 
				
				$stmt->execute();
				return $dap_dbh->lastInsertId();
				$stmt = null;
				$dap_dbh = null;
			}
		} 
		catch (PDOException $e) {
            logToFile($e->getMessage(), LOG_FATAL_DAP);
            throw $e;
        } 
		catch (Exception $e) {
            logToFile($e->getMessage(), LOG_FATAL_DAP);
            throw $e;
        }
		logToFile("Dap_PaymentPlan.class.php: create metod ,EXIT ", LOG_DEBUG_DAP);
	}
	
	public static function updateActualPayments($user_id,$product_id,$actual_payments){
		logToFile("Dap_PaymentPlan.class.php: updateActualPayments metod called ", LOG_DEBUG_DAP);
		logToFile("Dap_PaymentPlan.class.php: updateActualPayments metod, user_id = $user_id,product_id =$product_id ", LOG_DEBUG_DAP);
		
		try{
			$dap_dbh = Dap_Connection::getConnection();
			
			$sql = "UPDATE dap_payment_plan SET actual_payments = $actual_payments,date = '".date('Y-m-d')."' WHERE user_id = $user_id AND product_id = $product_id";
			
			$stmt = $dap_dbh->prepare($sql);
			$dap_dbh->query($sql);
			logToFile("Dap_PaymentPlan.class.php: updateActualPayments , Actual paymenst updated", LOG_DEBUG_DAP);
		}
		catch(PDOException $e){
			logToFile($e->getMessage(), LOG_FATAL_DAP);
            throw $e;
		}
		catch(Exception $e){
			logToFile($e->getMessage(), LOG_FATAL_DAP);
            throw $e;
		}
		logToFile("Dap_PaymentPlan.class.php: updateActualPayments metod , EXIT ", LOG_DEBUG_DAP);
	} 
	
	
	public static function loadPaymentPlan($user_id,$product_id=''){
		logToFile("Dap_PaymentPlan.class.php: loadPaymentPlan metod , called ", LOG_DEBUG_DAP);
		$payment_plan = "";
		
		try{
			$dap_dbh = Dap_Connection::getConnection();
			
			if($product_id != ""){
				$query = "AND product_id = $product_id";
			}
			else{
				$query = "";
			}
			
			$sql = "SELECT * FROM dap_payment_plan WHERE user_id = $user_id ".$query;
			$stmt = $dap_dbh->prepare($sql);
			$stmt->execute();
			
			if($row = $stmt->fetch(PDO::FETCH_ASSOC)){
				$payment_plan = new Dap_PaymentPlan();
				
				$payment_plan->setId($row['id']);
				$payment_plan->setBtn_id($row['btn_id']);
				$payment_plan->setUser_id($row['user_id']);
				$payment_plan->setProduct_id($row['product_id']);
				$payment_plan->setRecurring_id($row['recurring_id']);
				$payment_plan->setSubscription_id($row['subscription_id']);
				$payment_plan->setTxn_id($row['txn_id']);
				$payment_plan->setMax_payments($row['max_payments']);
				$payment_plan->setActual_payments($row['actual_payments']);
				$payment_plan->setStatus($row['status']);
				$payment_plan->setDate($row['date']);
			}
			return $payment_plan;
		}
		catch(PDOException $e){
			logToFile($e->getMessage(), LOG_FATAL_DAP);
			throw $e;
		}
		catch(Exception $e){
			logToFile($e->getMessage(), LOG_FATAL_DAP);
			throw $e;
		}
	}
	
	public static function loadAllPaymentPlans(){
		logToFile("Dap_PaymentPlan.class.php: loadAllPaymentPlans metod , called ", LOG_DEBUG_DAP);
		$payment_plans = array();
		
		try{
			$dap_dbh = Dap_Connection::getConnection();
			
			$sql = "SELECT * FROM dap_payment_plan ORDER BY id DESC";
			$stmt = $dap_dbh->prepare($sql);
			$stmt->execute();
			
			while($row = $stmt->fetch(PDO::FETCH_ASSOC)){
				$payment_plan = new Dap_PaymentPlan();
				
				$payment_plan->setId($row['id']);
				$payment_plan->setBtn_id($row['btn_id']);
				$payment_plan->setUser_id($row['user_id']);
				$payment_plan->setProduct_id($row['product_id']);
				$payment_plan->setRecurring_id($row['recurring_id']);
				$payment_plan->setSubscription_id($row['subscription_id']);
				$payment_plan->setTxn_id($row['txn_id']);
				$payment_plan->setMax_payments($row['max_payments']);
				$payment_plan->setActual_payments($row['actual_payments']);
				$payment_plan->setStatus($row['status']);
				$payment_plan->setDate($row['date']);
				
				$payment_plans[] = $payment_plan;
			}
			return $payment_plans;
		}
		catch(PDOException $e){
			logToFile($e->getMessage(), LOG_FATAL_DAP);
			throw $e;
		}
		catch(Exception $e){
			logToFile($e->getMessage(), LOG_FATAL_DAP);
			throw $e;
		}
	}
	
	
	public static function updateSubscriptionId($user_id,$product_id,$subscription_id){
		logToFile("Dap_PaymentPlan.class.php: updateSubscriptionId metod called ", LOG_DEBUG_DAP);
		logToFile("Dap_PaymentPlan.class.php: updateSubscriptionId metod, user_id = $user_id,product_id =$product_id ", LOG_DEBUG_DAP);
		
		try{
			$dap_dbh = Dap_Connection::getConnection();
			
			$sql = "UPDATE dap_payment_plan SET subscription_id = '$subscription_id',date = '".date('Y-m-d')."' WHERE user_id = $user_id AND product_id = $product_id AND status = 'ACTIVE' ";

			$stmt = $dap_dbh->prepare($sql);
			$dap_dbh->query($sql);
			logToFile("Dap_PaymentPlan.class.php: updateSubscriptionId , subscription_id updated", LOG_DEBUG_DAP);
		}
		catch(PDOException $e){
			logToFile($e->getMessage(), LOG_FATAL_DAP);
            throw $e;
		}
		catch(Exception $e){
			logToFile($e->getMessage(), LOG_FATAL_DAP);
            throw $e;
		}
		logToFile("Dap_PaymentPlan.class.php: updateSubscriptionId metod , EXIT ", LOG_DEBUG_DAP);
	} 
	
	public static function updateStatus($user_id,$product_id = ""){
		logToFile("Dap_PaymentPlan.class.php: updateStatus metod called ", LOG_DEBUG_DAP);
		logToFile("Dap_PaymentPlan.class.php: updateStatus metod, user_id = $user_id,product_id =$product_id ", LOG_DEBUG_DAP);
		
		try{
			$dap_dbh = Dap_Connection::getConnection();
			
			if($product_id != ""){
				$query = "AND product_id = $product_id";
			}
			else{
				$query = "";
			}
			
			$sql = "UPDATE dap_payment_plan SET status = 'CANCELLED' WHERE user_id = $user_id ".$query." AND status = 'ACTIVE' ";

			$stmt = $dap_dbh->prepare($sql);
			$dap_dbh->query($sql);
			logToFile("Dap_PaymentPlan.class.php: updateStatus , status updated", LOG_DEBUG_DAP);
		}
		catch(PDOException $e){
			logToFile($e->getMessage(), LOG_FATAL_DAP);
            throw $e;
		}
		catch(Exception $e){
			logToFile($e->getMessage(), LOG_FATAL_DAP);
            throw $e;
		}
		logToFile("Dap_PaymentPlan.class.php: updateStatus metod , EXIT ", LOG_DEBUG_DAP);
	} 
	
	public static function deleteDAPPaymentPlan($user_id){
		logToFile("Dap_PaymentPlan.class.php: deleteDAPPaymentPlan metod called for userId = ".$user_id, LOG_DEBUG_DAP);
		
		try{
			$dap_dbh = Dap_Connection::getConnection();
			if($user_id != ""){
				$sql = "DELETE FROM dap_payment_plan WHERE user_id = ".$user_id;

				$stmt = $dap_dbh->prepare($sql);
				$dap_dbh->query($sql);
			}
			else{
				logToFile("Dap_PaymentPlan.class.php: deleteDAPPaymentPlan metod missing userId", LOG_DEBUG_DAP);
				return;
			}
		}
		catch(PDOException $e){
			logToFile("Dap_PaymentPlan.class.php: deleteDAPPaymentPlan".$e->getMessage(), LOG_FATAL_DAP); 
		}
		catch(Exception $e){
			logToFile("Dap_PaymentPlan.class.php: deleteDAPPaymentPlan".$e->getMessage(), LOG_FATAL_DAP);
		}
	}
	
	public static function updateExistingPlan($user_id,$product_id,$max_payments,$txn_id){
		logToFile("Dap_PaymentPlan.class.php: updateExistingPlan metod called ".$txn_id, LOG_DEBUG_DAP);
		logToFile("Dap_PaymentPlan.class.php: updateExistingPlan metod, user_id = $user_id,product_id =$product_id ", LOG_DEBUG_DAP);
		
		try{
			$dap_dbh = Dap_Connection::getConnection();
			
			$sql = "UPDATE dap_payment_plan SET status = 'ACTIVE',actual_payments = 1,max_payments = $max_payments,txn_id='$txn_id',date='".date('Y-m-d')."',product_id = $product_id WHERE user_id = $user_id";

			$stmt = $dap_dbh->prepare($sql);
			$dap_dbh->query($sql);
			logToFile("Dap_PaymentPlan.class.php: updateExistingPlan , Plan updated", LOG_DEBUG_DAP);
		}
		
		catch(PDOException $e){
			logToFile($e->getMessage(), LOG_FATAL_DAP);
            throw $e;
		}
		catch(Exception $e){
			logToFile($e->getMessage(), LOG_FATAL_DAP);
            throw $e;
		}
		logToFile("Dap_PaymentPlan.class.php: updateExistingPlan metod , EXIT ", LOG_DEBUG_DAP);
	} 
	
	
	public static function updateRecurringID($recurring_id , $user_id, $act_payment){
		logToFile("Dap_PaymentPlan.class.php: updateRecurringID method, recurring_id = $recurring_id,user_id =$user_id ", LOG_DEBUG_DAP);
		
		try{
			$dap_dbh = Dap_Connection::getConnection();
			
			$sql = "UPDATE dap_payment_plan SET actual_payments ='" .$act_payment. "', recurring_id ='". $recurring_id . "' WHERE user_id = $user_id";

			$stmt = $dap_dbh->prepare($sql);
			$dap_dbh->query($sql);
			logToFile("Dap_PaymentPlan.class.php: updateRecurringID , Plan updated", LOG_DEBUG_DAP);
		}
		
		catch(PDOException $e){
			logToFile($e->getMessage(), LOG_FATAL_DAP);
            throw $e;
		}
		catch(Exception $e){
			logToFile($e->getMessage(), LOG_FATAL_DAP);
            throw $e;
		}
		logToFile("Dap_PaymentPlan.class.php: updateRecurringID method , EXIT ", LOG_DEBUG_DAP);
	} 
	
	
	public static function updateExistingPlanMulti($user_id,$product_id,$max_payments,$txn_id , $act_payments , $recurring_id){
		logToFile("Dap_PaymentPlan.class.php: updateExistingPlanMulti metod called ".$txn_id, LOG_DEBUG_DAP);
		logToFile("Dap_PaymentPlan.class.php: updateExistingPlanMulti metod, user_id = $user_id,product_id =$product_id ", LOG_DEBUG_DAP);
		
		try{
			$dap_dbh = Dap_Connection::getConnection();
			
			$sql = "UPDATE dap_payment_plan SET status = 'ACTIVE', recurring_id = '".$recurring_id."' ,actual_payments = $act_payments ,max_payments = $max_payments,txn_id='$txn_id' WHERE user_id = $user_id  and product_id = $product_id  and date='".date('Y-m-d')."'" ;
			logToFile($sql, LOG_DEBUG_DAP);
			$stmt = $dap_dbh->prepare($sql);
			$dap_dbh->query($sql);
			logToFile("Dap_PaymentPlan.class.php: updateExistingPlanMulti , Plan updated", LOG_DEBUG_DAP);
		}
		
		catch(PDOException $e){
			logToFile($e->getMessage(), LOG_FATAL_DAP);
            throw $e;
		}
		catch(Exception $e){
			logToFile($e->getMessage(), LOG_FATAL_DAP);
            throw $e;
		}
		logToFile("Dap_PaymentPlan.class.php: updateExistingPlanMulti metod , EXIT ", LOG_DEBUG_DAP);
	}
	
	
} /*END OF CLASS*/

?>
