<?php

class Dap_ProductPlanMapping {

	function getId() {
		return $this->id;
	}
	function setId($o) {
		$this->id = $o;
	}
	
	function getProduct_id() {
		return $this->product_id;
	}
	function setProduct_id($o) {
		$this->product_id = $o;
	}
	
	function getStripe_plan() {
		return $this->stripe_plan;
	}
	function setStripe_plan($o) {
		$this->stripe_plan = $o;
	}
	
	function getStripe_mode() {
		return $this->mode;
	}
	function setStripe_mode($o) {
		$this->mode = $o;
	}
	
	
	public function create() {
		try {
			$dap_dbh = Dap_Connection::getConnection();
			
			$sql = "insert into dap_product_plan_mapping
						(product_id, stripe_plan, stripe_mode)
					values
						(:product_id, :stripe_plan, :mode)";

			$stmt = $dap_dbh->prepare($sql);
		
			$stmt->bindParam(':product_id', $this->getProduct_id(), PDO::PARAM_INT);
			$stmt->bindParam(':stripe_plan', $this->getStripe_plan(), PDO::PARAM_STR);
			$stmt->bindParam(':mode', $this->getStripe_mode(), PDO::PARAM_STR);
			
			$stmt->execute();
			
			return $dap_dbh->lastInsertId();

		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
	}
	
	public function update() {
		try {
			$dap_dbh = Dap_Connection::getConnection();
			
			$sql = "update dap_product_plan_mapping set
							product_id = :product_id,
							stripe_plan = :stripe_plan,							
							stripe_mode = :mode							
						where id = :id";

			$stmt = $dap_dbh->prepare($sql);
			
			$stmt->bindParam(':product_id', $this->getProduct_id(), PDO::PARAM_INT);
			$stmt->bindParam(':stripe_plan', $this->getStripe_plan(), PDO::PARAM_STR);
			$stmt->bindParam(':mode', $this->getStripe_mode(), PDO::PARAM_STR);
			$stmt->bindParam(':id', $this->getId(), PDO::PARAM_INT);
			$stmt->execute();
			$stmt = null;
			$dap_dbh = null;

			return $this->getId();

		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
	}
	
	function delete(){
		logToFile("Dap_ProductPlanMapping.class.php: delete() method called ", LOG_DEBUG_DAP);
		
		try{
			$dap_dbh = Dap_Connection::getConnection();
			
			$sql = "DELETE FROM
						dap_product_plan_mapping
					WHERE
						id=:id";
			
			$stmt = $dap_dbh->prepare($sql);
			
			$stmt->bindParam(':id', $this->getId(), PDO::PARAM_INT);
			$stmt->execute();
		}
		catch (PDOException $e) {
            logToFile("Dap_ProductPlanMapping.class.php: delete(), exception is ".$e->getMessage(), LOG_FATAL_DAP);
            throw $e;
        } 
		catch (Exception $e) {
            logToFile("Dap_ProductPlanMapping.class.php: delete(), exception is ".$e->getMessage(), LOG_FATAL_DAP);
            throw $e;
        }
		
		logToFile("Dap_ProductPlanMapping.class.php: delete() exit ", LOG_DEBUG_DAP);
	}
	
	public static function load(){
		logToFile("Dap_ProductPlanMapping.class.php: load method called ", LOG_DEBUG_DAP);
		$productPlanMapArr = array();
	
		try{
			$dap_dbh = Dap_Connection::getConnection();
			
			$sql = "SELECT * FROM dap_product_plan_mapping ORDER BY id desc";		
			$stmt = $dap_dbh->prepare($sql);
			$stmt->execute();
			
			while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
				$product_plan = new Dap_ProductPlanMapping();
				
				$product_plan->setId($row['id']);
				$product_plan->setProduct_id($row['product_id']);
				$product_plan->setStripe_plan($row['stripe_plan']);
				$product_plan->setStripe_mode($row['stripe_mode']);
				$productPlanMapArr[] = $product_plan;
			}
			return $productPlanMapArr;
		}
		catch (PDOException $e) {
            logToFile("Dap_ProductPlanMapping.class.php: load(), exception is ".$e->getMessage(), LOG_FATAL_DAP);
            throw $e;
        } 
		catch (Exception $e) {
            logToFile("Dap_ProductPlanMapping.class.php: load(), exception is ".$e->getMessage(), LOG_FATAL_DAP);
            throw $e;
        }
        logToFile("Dap_ProductPlanMapping.class.php: exit ", LOG_DEBUG_DAP);
		exit;
		
	}
	
	public static function loadByProductId($pid , $id, $mode){
		logToFile("Dap_ProductPlanMapping.class.php: loadByProductId method called ", LOG_DEBUG_DAP);
		try{
			$dap_dbh = Dap_Connection::getConnection();
			
			if($id != '' && $mode != ''){
				$sql = "SELECT * FROM dap_product_plan_mapping WHERE product_id = :product_id AND stripe_mode = :mode AND id != :id";	
			}else if($mode != ''){
				$sql = "SELECT * FROM dap_product_plan_mapping WHERE product_id = :product_id AND stripe_mode = :mode";		
			}else if($id != ''){
				$sql = "SELECT * FROM dap_product_plan_mapping WHERE product_id = :product_id AND id != :id";	
			}else{
				$sql = "SELECT * FROM dap_product_plan_mapping WHERE product_id = :product_id";		
			}
			
			$stmt = $dap_dbh->prepare($sql);
			
			if($id != ''){
			
				$stmt->bindParam(':id', $id, PDO::PARAM_INT);
			}
			if($mode != ''){
				$stmt->bindParam(':mode', $mode, PDO::PARAM_INT);
			}
			$stmt->bindParam(':product_id', $pid, PDO::PARAM_INT);
			
			$stmt->execute();
			
			if($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
				$product_plan = new Dap_ProductPlanMapping();
				$product_plan->setId($row['id']);
				$product_plan->setProduct_id($row['product_id']);
				$product_plan->setStripe_plan($row['stripe_plan']);
				$product_plan->setStripe_mode($row['stripe_mode']);
				
			}
			
			return $product_plan;
		}
		catch (PDOException $e) {
            logToFile("Dap_ProductPlanMapping.class.php: loadByProductId(), exception is ".$e->getMessage(), LOG_FATAL_DAP);
            throw $e;
        } 
		catch (Exception $e) {
            logToFile("Dap_ProductPlanMapping.class.php: loadByProductId(), exception is ".$e->getMessage(), LOG_FATAL_DAP);
            throw $e;
        }
        logToFile("Dap_ProductPlanMapping.class.php: exit ", LOG_DEBUG_DAP);
		exit;
		
	}
	
	
	public static function loadByPlanName($plan_name){
		logToFile("Dap_ProductPlanMapping.class.php: loadByProductId method called ", LOG_DEBUG_DAP);
		$productPlanArr = array();
		try{
			$dap_dbh = Dap_Connection::getConnection();
			
			$sql = "SELECT * FROM dap_product_plan_mapping WHERE stripe_plan = :plan_name order by id desc";		
			
			$stmt = $dap_dbh->prepare($sql);
			
			$stmt->bindParam(':plan_name', $plan_name, PDO::PARAM_INT);
			
			$stmt->execute();
			
			while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
				$product_plan = new Dap_ProductPlanMapping();
				
				$product_plan->setId($row['id']);
				$product_plan->setProduct_id($row['product_id']);
				$product_plan->setStripe_plan($row['stripe_plan']);
				$product_plan->setStripe_mode($row['stripe_mode']);
				$productPlanArr[] = $product_plan;
			}
			return $productPlanArr;
			
			
		}
		catch (PDOException $e) {
            logToFile("Dap_ProductPlanMapping.class.php: loadByProductId(), exception is ".$e->getMessage(), LOG_FATAL_DAP);
            throw $e;
        } 
		catch (Exception $e) {
            logToFile("Dap_ProductPlanMapping.class.php: loadByProductId(), exception is ".$e->getMessage(), LOG_FATAL_DAP);
            throw $e;
        }
        logToFile("Dap_ProductPlanMapping.class.php: exit ", LOG_DEBUG_DAP);
		exit;
		
	}
}
