<?php

class Dap_SecurityScan{
	
	var $id;
   	var $name;
   	var $value;
   	   	
   	function getId() {
		return $this->id;
	}
	function setId($o) {
		$this->id = $o;
	}
	
	function getName() {
		return $this->name;
	}
	function setName($o) {
		$this->name = $o;
	}

	function getValue() {
		return $this->value;
	}
	function setValue($o) {
		$this->value = $o;
	}
	
	
	public function create() {
		try {
			$dap_dbh = Dap_Connection::getConnection();
			$sql = "insert into dap_security_scan_settings
						(name, value)
					values 
						(:name, :value)";
			 
			$stmt = $dap_dbh->prepare($sql);
			
			$stmt->bindParam(':name', $this->getName(), PDO::PARAM_STR);
			$stmt->bindParam(':value', $this->getValue(), PDO::PARAM_STR);
			$stmt->execute();
			
			$last_insert_id = $dap_dbh->lastInsertId();
			return $last_insert_id ;
			$stmt = null;
			$dap_dbh = null;
			return $last_insert_id;
	
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}	
	}

	public function update() {
		try {
			$dap_dbh = Dap_Connection::getConnection();
			$sql = "update 
					dap_security_scan_settings
					set
						value =:value
					where
						name =:name";
					

			$stmt = $dap_dbh->prepare($sql);			
			$stmt->bindParam(':value', $this->getValue(), PDO::PARAM_STR);
			$stmt->bindParam(':name', $this->getName(), PDO::PARAM_STR);
			$stmt->execute();
			
			$stmt = null;
			$dap_dbh = null;
			
			return;
	
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}	
	}
	 
	 
	 public static function loadByName($name) {
		$loadall = array();
		
		try {
			$dap_dbh = Dap_Connection::getConnection();
			
			$sql = "SELECT 
						*
					FROM
						dap_security_scan_settings
					WHERE
						name =:name
					";
 			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':name', $name, PDO::PARAM_STR);
			$stmt->execute();
	
			while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
				$dapsecurity = new Dap_SecurityScan();
				
				$dapsecurity->setValue( stripslashes($row["value"]) );				 
				$dapsecurity->setName( stripslashes($row["name"]) );				 
				$loadall[] = $dapsecurity;
			}
			return $loadall;	
			
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}		
		
	}
	
}
 
