<?php

class Dap_SecurityScanReport{
	
	var $id;
   	var $filename;
   	var $filepath;
   	var $date;
   	   	
   	function getId() {
		return $this->id;
	}
	function setId($o) {
		$this->id = $o;
	}
	
	function getFileName() {
		return $this->filename;
	}
	function setFileName($o) {
		$this->filename = $o;
	}

	function getFilePath() {
		return $this->filepath;
	}
	function setFilePath($o) {
		$this->filepath = $o;
	}
	
	function getDate() {
		return $this->date;
	}
	function setDate($o) {
		$this->date = $o;
	}
	
	public function create() {
		try {
			$dap_dbh = Dap_Connection::getConnection();
			$sql = "insert into dap_security_scan_report
						(filename, filepath, date )
					values 
						(:filename, :filepath, :date)";
			 
			$stmt = $dap_dbh->prepare($sql);
			
			$stmt->bindParam(':filename', $this->getFileName(), PDO::PARAM_STR);
			$stmt->bindParam(':filepath', $this->getFilePath(), PDO::PARAM_STR);
			$stmt->bindParam(':date', $this->getDate(), PDO::PARAM_STR);
			$stmt->execute();
			
			$last_insert_id = $dap_dbh->lastInsertId();
			return $last_insert_id ;
			$stmt = null;
			$dap_dbh = null;
			return $last_insert_id;
	
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}	
	}

	public function update() {
		try {
			$dap_dbh = Dap_Connection::getConnection();
			$sql = "update 
					dap_security_scan_report
					set
						filename =:filename,
						filepath =:filepath,
						date =:date,
					where
						id =:id";
					

			$stmt = $dap_dbh->prepare($sql);			
			$stmt->bindParam(':filename', $this->getName(), PDO::PARAM_STR);
			$stmt->bindParam(':filepath', $this->getValue(), PDO::PARAM_STR);
			$stmt->bindParam(':date', $this->getValue(), PDO::PARAM_STR);
			$stmt->execute();
			
			$stmt = null;
			$dap_dbh = null;
			
			return;
	
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}	
	}
	 
	 
	 public static function load() {
		$loadall = array();
		
		try {
			$dap_dbh = Dap_Connection::getConnection();
			
			$sql = "SELECT 
						*
					FROM
						dap_security_scan_report					 
					";
 			$stmt = $dap_dbh->prepare($sql);
			$stmt->execute();
	
			while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
				$dapsecurity = new Dap_SecurityScanReport();				
				$dapsecurity->setId($row["id"]);				 
				$dapsecurity->setFileName($row["filename"] );				 
				$dapsecurity->setFilePath($row["filepath"]);				 
				$dapsecurity->setDate($row["date"]);				 
				$loadall[] = $dapsecurity;
			}
			return $loadall;	
			
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}		
		
	}
	
	public static function delete($id='') {
		 
		try {
			$dap_dbh = Dap_Connection::getConnection();
			if($id == ''){
			$sql = "DELETE 						 
					FROM
						dap_security_scan_report	
						";
			}else{
				$sql = "DELETE 						 
					FROM
						dap_security_scan_report WHERE id=$id	
						";
			}			
					 
			$stmt = $dap_dbh->prepare($sql);
			$stmt->execute();
			$stmt = null;
			$dap_dbh = null;		
			return;		
			
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}		
		
	}
	
}
 
