<?php 
class Dap_UserRoles{
	var $role_id;
	var $role;
	var $role_description;
	var $capability_id;
	var $capability;
	var $is_allowed;
	
	function getRole_id() {
		return $this->role_id;
	}
	function setRole_id($o) {
		$this->role_id = $o;
	}
	
	function getRole() {
		return $this->role;
	}
	function setRole($o) {
		$this->role = $o;
	}
	
	function getRole_description() {
		return $this->role_description;
	}
	function setRole_description($o) {
		$this->role_description = $o;
	}
	
	function getCapability_id() {
		return $this->capability_id;
	}
	function setCapability_id($o) {
		$this->capability_id = $o;
	}
	
	function getCapability() {
		return $this->capability;
	}
	function setCapability($o) {
		$this->capability = $o;
	}
	
	function getIs_allowed() {
		return $this->is_allowed;
	}
	function setIs_allowed($o) {
		$this->is_allowed = $o;
	}
	
	
	public static function updateUserPermissions($role_id,$permission,$allowed){
		logToFile("Dap_UserRoles.class.php:updateUserPermissions() Entered",LOG_DEBUG_DAP);
		
		try{
			$capability_id = Dap_UserRoles::getCapabilityIdFromName($permission);

			if($capability_id != "" && $role_id != ""){
				logToFile("Dap_UserRoles.class.php:updateUserPermissions(),got capability_id, now check if rows exists for this or not",LOG_DEBUG_DAP);
				$dap_dbh = Dap_Connection::getConnection();
				$sql = "SELECT 
							id
						FROM
							dap_roles_caps_jn
						WHERE
							roles_id = $role_id &&
							caps_id = $capability_id
						";
				$stmt = $dap_dbh->prepare($sql);
				$stmt->execute();
			
				if($row = $stmt->fetch(PDO::FETCH_ASSOC)){
					logToFile("Dap_UserRoles.class.php:updateUserPermissions(),Rule already exists so update",LOG_DEBUG_DAP);
					$sql1 = "UPDATE
								dap_roles_caps_jn
							SET
								caps_id = $capability_id,allowed = '".$allowed."'
							WHERE
								id = ".$row['id']
							;
					$stmt1 = $dap_dbh->prepare($sql1);
					$stmt1->execute();
				}
				else{
					logToFile("Dap_UserRoles.class.php:updateUserPermissions(),Rule does not exists so create",LOG_DEBUG_DAP);
					$sql1 = "INSERT INTO
								dap_roles_caps_jn(roles_id,caps_id,allowed)
							VALUES
								($role_id,$capability_id,'".$allowed."')							
							";
					$stmt1 = $dap_dbh->prepare($sql1);
					$stmt1->execute();
				}
			}
		
		}
		catch (PDOException $e) {
			logToFile("Dap_UserRoles.class.php: updateUserPermissions() error is ".$e->getMessage(),LOG_FATAL_DAP);
		} catch (Exception $e) {
			logToFile("Dap_UserRoles.class.php: updateUserPermissions() error is ".$e->getMessage(),LOG_FATAL_DAP);
		}	
	} 
	
	public static function updateUserRoleProductAccess($role_id,$products){
		try{
			$dap_dbh = Dap_Connection::getConnection();
			$sql = "SELECT 
						id
					FROM
						dap_roles_product_access
					WHERE
						role_id = '".$role_id."' 
					";
			$stmt = $dap_dbh->prepare($sql);
			$stmt->execute();
		
			if($row = $stmt->fetch(PDO::FETCH_ASSOC)){
				logToFile("Dap_UserRoles.class.php:updateUserRoleProductAccess(),Rule already exists so update",LOG_DEBUG_DAP);
				$sql1 = "UPDATE
							dap_roles_product_access
						SET
							products = '".$products."'
						WHERE
							id = ".$row['id']
						;
				$stmt1 = $dap_dbh->prepare($sql1);
				$stmt1->execute();
			}
			else{
				logToFile("Dap_UserRoles.class.php:updateUserRoleProductAccess(),Rule does not exists so create",LOG_DEBUG_DAP);
				$sql1 = "INSERT INTO
							dap_roles_product_access(role_id,products)
						VALUES
							('".$role_id."','".$products."')							
						";
				$stmt1 = $dap_dbh->prepare($sql1);
				$stmt1->execute();
			}
		}
		catch (PDOException $e) {
			logToFile("Dap_UserRoles.class.php: updateUserRoleProductAccess() error is ".$e->getMessage(),LOG_FATAL_DAP);
		} catch (Exception $e) {
			logToFile("Dap_UserRoles.class.php: updateUserRoleProductAccess() error is ".$e->getMessage(),LOG_FATAL_DAP);
		}	
	}
	
	public static function loadProductAccessListForRole($role_id){
		$products = "";
		try{
			$dap_dbh = Dap_Connection::getConnection();
			$sql = "SELECT 
						products
					FROM
						dap_roles_product_access
					WHERE
						role_id = '".$role_id."'
					";
			$stmt = $dap_dbh->prepare($sql);
			$stmt->execute();
			if($row = $stmt->fetch(PDO::FETCH_ASSOC)){
				$products = explode(",",$row['products']);
			}
			return $products;
		}
		catch (PDOException $e) {
			logToFile("Dap_UserRoles.class.php: loadProductAccessListForRole() error is ".$e->getMessage(),LOG_FATAL_DAP);
		} catch (Exception $e) {
			logToFile("Dap_UserRoles.class.php: loadProductAccessListForRole() error is ".$e->getMessage(),LOG_FATAL_DAP);
		}
	}
	
	public static function getCapabilityIdFromName($name){
		logToFile("Dap_UserRoles.class.php:getCapabilityIdFromName() Entered",LOG_DEBUG_DAP);
		$cap_id = "";
		
		try{
			$dap_dbh = Dap_Connection::getConnection();
			$sql = "SELECT 
						id
					FROM
						dap_capabilities
					WHERE
						name = '".$name."'
					";
			$stmt = $dap_dbh->prepare($sql);
			$stmt->execute();
			if($row = $stmt->fetch(PDO::FETCH_ASSOC)){
				$cap_id = $row['id'];
			}
			return $cap_id;
		}
		catch (PDOException $e) {
			logToFile("Dap_UserRoles.class.php: getCapabilityIdFromName() error is ".$e->getMessage(),LOG_FATAL_DAP);
		} catch (Exception $e) {
			logToFile("Dap_UserRoles.class.php: getCapabilityIdFromName() error is ".$e->getMessage(),LOG_FATAL_DAP);
		}
	}
	
	public static function loadRolePermissionsForPage($role_id,$page){
		$capabilities = array();
		try{
			$dap_dbh = Dap_Connection::getConnection();
		
			$sql = "SELECT t1.name,t2.allowed FROM `dap_capabilities` t1 INNER JOIN `dap_roles_caps_jn` t2 ON t1.id = t2.caps_id     INNER JOIN `dap_roles` t3 ON t3.id = t2.roles_id WHERE t1.name LIKE '%%-".$page."' AND t3.id = '".$role_id."'";
			
			$stmt = $dap_dbh->prepare($sql);
			$stmt->execute();
			while($row = $stmt->fetch(PDO::FETCH_ASSOC)){
				$capabilities[$row['name']] = $row['allowed'];
			}
			return $capabilities;
		}
		catch (PDOException $e) {
			logToFile("Dap_UserRoles.class.php: loadRolePermissionsForPage() error is ".$e->getMessage(),LOG_FATAL_DAP);
		} catch (Exception $e) {
			logToFile("Dap_UserRoles.class.php: loadRolePermissionsForPage() error is ".$e->getMessage(),LOG_FATAL_DAP);
		}
	}
	
	public static function getRoleIdFromName($role){
		$id = "";
		try{
			$dap_dbh = Dap_Connection::getConnection();
		
			$sql = "SELECT t1.id FROM `dap_roles` t1 WHERE t1.name = '".$role."'";
			
			$stmt = $dap_dbh->prepare($sql);
			$stmt->execute();
			if($row = $stmt->fetch(PDO::FETCH_ASSOC)){
				$id = $row['id'];
			}
			return $id;
		}
		catch (PDOException $e) {
			logToFile("Dap_UserRoles.class.php: getRoleIdFromName() error is ".$e->getMessage(),LOG_FATAL_DAP);
		} catch (Exception $e) {
			logToFile("Dap_UserRoles.class.php: getRoleIdFromName() error is ".$e->getMessage(),LOG_FATAL_DAP);
		}
	}
	
	public static function loadRoleById($role_id){
		$id = "";
		try{
			$dap_dbh = Dap_Connection::getConnection();
		
			$sql = "SELECT * FROM `dap_roles` t1 WHERE t1.id = '".$role_id."'";
			
			$stmt = $dap_dbh->prepare($sql);
			$stmt->execute();
			if($row = $stmt->fetch(PDO::FETCH_ASSOC)){
				return $row;
			}
			 
		}
		catch (PDOException $e) {
			logToFile("Dap_UserRoles.class.php: getRoleIdFromName() error is ".$e->getMessage(),LOG_FATAL_DAP);
		} catch (Exception $e) {
			logToFile("Dap_UserRoles.class.php: getRoleIdFromName() error is ".$e->getMessage(),LOG_FATAL_DAP);
		}
	}
	
	public static function loadAllRoles(){
		$roles = array();
		
		try{
			$dap_dbh = Dap_Connection::getConnection();
		
			$sql = "SELECT * FROM `dap_roles`";
			
			$stmt = $dap_dbh->prepare($sql);
			$stmt->execute();
			While($row = $stmt->fetch(PDO::FETCH_ASSOC)){
				$roles[] = $row;
			}
			return $roles;
		}
		catch (PDOException $e) {
			logToFile("Dap_UserRoles.class.php: getRoleIdFromName() error is ".$e->getMessage(),LOG_FATAL_DAP);
		} catch (Exception $e) {
			logToFile("Dap_UserRoles.class.php: getRoleIdFromName() error is ".$e->getMessage(),LOG_FATAL_DAP);
		}
	}
	
	public static function getRoleByName($name){
		$role = array();
		
		try{
			$dap_dbh = Dap_Connection::getConnection();
		
			$sql = "SELECT * FROM `dap_roles` WHERE name = '$name'";
			
			$stmt = $dap_dbh->prepare($sql);
			$stmt->execute();
			if($row = $stmt->fetch(PDO::FETCH_ASSOC)){
				return $row;
			}
			return $role;
		}
		catch (PDOException $e) {
			logToFile("Dap_UserRoles.class.php: getRoleByName() error is ".$e->getMessage(),LOG_FATAL_DAP);
		} catch (Exception $e) {
			logToFile("Dap_UserRoles.class.php: getRoleByName() error is ".$e->getMessage(),LOG_FATAL_DAP);
		}
	}
	
	public static function createRole($name,$desc){
		try{
			$dap_dbh = Dap_Connection::getConnection();
		
			$sql = "INSERT INTO `dap_roles`(name,description) VALUES ('$name','$desc')";			
			$stmt = $dap_dbh->prepare($sql);
			$stmt->execute();
		}
		catch (PDOException $e) {
			logToFile("Dap_UserRoles.class.php: createRole() error is ".$e->getMessage(),LOG_FATAL_DAP);
		} catch (Exception $e) {
			logToFile("Dap_UserRoles.class.php: createRole() error is ".$e->getMessage(),LOG_FATAL_DAP);
		}
	}
	
	public static function updateRole($id,$desc,$name){
		try{
			$dap_dbh = Dap_Connection::getConnection();
		
			$sql = "UPDATE `dap_roles` SET description = '$desc',name = '".$name."' WHERE id = $id";			
			$stmt = $dap_dbh->prepare($sql);
			$stmt->execute();
		}
		catch (PDOException $e) {
			logToFile("Dap_UserRoles.class.php: updateRole() error is ".$e->getMessage(),LOG_FATAL_DAP);
		} catch (Exception $e) {
			logToFile("Dap_UserRoles.class.php: updateRole() error is ".$e->getMessage(),LOG_FATAL_DAP);
		}
	}
	
	public static function deleteRole($id){
		try{
			$dap_dbh = Dap_Connection::getConnection();
		
			$sql = "DELETE FROM `dap_roles` WHERE id = '$id'";			
			$stmt = $dap_dbh->prepare($sql);
			$stmt->execute();
		}
		catch (PDOException $e) {
			logToFile("Dap_UserRoles.class.php: deleteRole() error is ".$e->getMessage(),LOG_FATAL_DAP);
		} catch (Exception $e) {
			logToFile("Dap_UserRoles.class.php: deleteRole() error is ".$e->getMessage(),LOG_FATAL_DAP);
		}
	}
	

	
}// class ends 
