<?php
class Dap_UsersProducts {

	var $user_id  ;
	var $product_id ;
	var $access_start_date ;
	var $access_end_date ;
	var $transaction_id;
	var $coupon_id;
	var $status;
	var $redeem_type;

	//Additional field from dap_products
	var $product_name ;

	function getUser_id()  {
	       return $this->user_id;
	}
	function setUser_id($o) {
	      $this->user_id = $o;
	}
	
	function getProduct_id()  {
	       return $this->product_id;
	}
	function setProduct_id($o) {
	      $this->product_id = $o;
	}

	function getCoupon_id()  {
	       return $this->coupon_id;
	}
	function setCoupon_id($o) {
	      $this->coupon_id = $o;
	}
	
	function getAccess_start_date()  {
	       return $this->access_start_date;
	}
	function setAccess_start_date($o) {
	      $this->access_start_date = $o;
	}	

	function getAccess_end_date()  {
	       return $this->access_end_date;
	}
	function setAccess_end_date($o) {
	      $this->access_end_date = $o;
	}	
	
	function getTransaction_id()  {
	       return $this->transaction_id;
	}
	function setTransaction_id($o) {
	      $this->transaction_id = $o;
	}		
	
	function getStatus()  {
	       return $this->status;
	}
	function setStatus($o) {
	      $this->status = $o;
	}		
	
	function getProduct_name()  {
	       return $this->product_name;
	}
	function setProduct_name($o) {
	      $this->product_name = $o;
	}
 
	function getRedeem_type()  {
	       return $this->redeem_type;
	}
	function setRedeem_type($o) {
	      $this->redeem_type = $o;
	}
 
	public static function expireUserProductAccessOnCancel($userId, $productId) {
		logToFile("(Dap_UsersProducts.expireUserProductAccessOnCancel() - Method Init.");
		
		try {

			$dap_dbh = Dap_Connection::getConnection();
			logToFile("(Dap_UsersProducts.expireUserProductAccessOnCancel() - move forward the entire block...set access end date to previous date from current date.");
			// move forward the entire block (set access end date to previous date from current date)
			$update_sql = "update dap_products p, dap_users_products_jn upj, dap_users u
						   set upj.access_start_date=DATE( now() - INTERVAL (DATEDIFF( upj.access_end_date,upj.access_start_date) + 1) DAY ),
						   upj.access_end_date =  DATE ( now() - INTERVAL (1) DAY )
						   where upj.user_id = u.id 
						   AND upj.product_id = p.id 
						   AND u.id = :userId
						   AND product_id = :productId 
						   AND datediff( curdate( ) , upj.access_end_date ) >0
						   AND datediff( curdate( ) , DATE( now() - INTERVAL (DATEDIFF( upj.access_end_date,upj.access_start_date) + 1) DAY ) ) !=  curdate( )";
						  
			$update_stmt = $dap_dbh->prepare($update_sql);
			
			logToFile("Dap_UsersProducts.expireUserProductAccessOnCancel()- action=EXPIREACCESS : uid=$userId, pid=$productId",LOG_DEBUG_DAP);  
			
			$update_stmt->bindParam(':userId', $userId, PDO::PARAM_INT);
			$update_stmt->bindParam(':productId', $productId, PDO::PARAM_INT);
			$update_stmt->execute();  
			
			$update_stmt = null;
			$dap_dbh = null;

			return;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
	}
	
	
	
	function makeItCurrentAccess($extend_days,$future_start_date="") {
		if($future_start_date!="")
		{
		  $date = new DateTime($future_start_date);
		  $date->modify("+".$extend_days." day");
		  $this->access_end_date =  $date->format("Y-m-d");
		  logToFile("Dap_UsersProducts::extendEndDays ($future_start_date) extending access_end_date=" . $this->access_end_date);
		}
 		else if($this->access_end_date != "9999-12-31") {
		  $date = new DateTime();
		  
		  $date->modify("+".$extend_days." day");
		  $this->access_end_date =  $date->format("Y-m-d");
		  logToFile("Dap_UsersProducts::makeItCurrentAccess extending access_end_date=" . $this->access_end_date);
		} 
		else {
			logToFile("Dap_UsersProducts::makeItCurrentAccess not extending, date already 9999-12-31");
		}
		
	}
	
	function extendEndDays($extend_days,$future_start_date="") {
		if($future_start_date!="")
		{
		  $date = new DateTime($future_start_date);
		  $date->modify("+".$extend_days." day");
		  $this->access_end_date =  $date->format("Y-m-d");
		  logToFile("Dap_UsersProducts::extendEndDays ($future_start_date) extending access_end_date=" . $this->access_end_date);
		}
 		else if($this->access_end_date != "9999-12-31") {
		  $date = new DateTime($this->access_end_date);
		  
		  $date->modify("+".$extend_days." day");
		  $this->access_end_date =  $date->format("Y-m-d");
		  logToFile("Dap_UsersProducts::extendEndDays extending access_end_date=" . $this->access_end_date);
		} 
		else {
			logToFile("Dap_UsersProducts::extendEndDays not extending, date already 9999-12-31");
		}
		
	}
	//do diff between access end date and access start date
	function getActiveDays() {
		logToFile("Dap_UsersProducts::getActiveDays access_start_date:".$this->access_start_date.", access_end_date:".$this->access_end_date);
		
		$start_date = new DateTime($this->access_start_date);
	//	logToFile("Dap_UsersProducts::getActiveDays start_date:".$start_date);
		$ts1 =  $start_date->format("Y-m-d");
		logToFile("Dap_UsersProducts::getActiveDays ts1:".$ts1);
	//	logToFile("Dap_UsersProducts::getActiveDays access_end_date:".$this->access_end_date);
		$end_date = new DateTime($this->access_end_date);
		//logToFile("Dap_UsersProducts::getActiveDays end_date:".$end_date);
		$ts2 =  $end_date->format("Y-m-d");
		logToFile("Dap_UsersProducts::getActiveDays ts2:".$ts2);
		$date_diff = abs(strtotime($ts2) - strtotime($ts1));
		logToFile("Dap_UsersProducts::getActiveDays date_diff:".$date_diff);
		//echo $date_diff;
		$full_days = floor($date_diff / 86400) + 1;
		logToFile("Dap_UsersProducts::getActiveDays Start Date:".$ts1.", End Date:".$ts2.", Date Diff:".$date_diff . ", full_days:" . $full_days);
		return $full_days;
	}

	
	function deriveAccessEndDate($extend_days) {
		if($extend_days < 0) {
			$this->access_end_date = "9999-12-31";
		} else {
			$date = new DateTime($this->access_start_date);
			$date->modify("+".$extend_days." day");
			$this->access_end_date =  $date->format("Y-m-d");	
		}
	}
	
	public static function loadArray($userId, $productId) {
		try {
		
			$dap_dbh = Dap_Connection::getConnection();
			$userProductRelArray = array();
	
			$sql = "select
						upj.user_id,
						upj.product_id,
						upj.access_start_date,
						upj.access_end_date,
						upj.transaction_id,
						upj.coupon_id,
						upj.status,				
						upj.redeem_type				
					from 
						dap_users_products_jn upj
					where
						upj.user_id = :userId and
						upj.product_id = :productId
					";
	
			//logToFile($sql,LOG_DEBUG_DAP);
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':userId', $userId, PDO::PARAM_INT);
			$stmt->bindParam(':productId', $productId, PDO::PARAM_INT);
			$stmt->execute();	
			
			if ($obj = $stmt->fetch()) {
				$userProductRelArray[] = $obj;
			}
	
			return $userProductRelArray;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}		
	}
	
	public static function loadUsersByIds($userId, $productId, $inClause) {
		try {
		
			$dap_dbh = Dap_Connection::getConnection();
			$userProductRelArray = array();
	
			$sql = "select
						u.id,
						u.first_name,
						u.last_name,
						u.email,
						u.paypal_email,
						upj.product_id,
						upj.access_start_date,
						upj.access_end_date,
						upj.transaction_id,
						upj.status,
						upj.transaction_id,
						upj.coupon_id,
						p.name as product_name
					from 
						dap_users u,
						dap_users_products_jn upj,
						dap_products p
					where
						u.id in $inClause and
						u.id = upj.user_id and
						upj.product_id = $productId and
						upj.product_id = p.id
					";
	
			//logToFile($sql,LOG_DEBUG_DAP);
			$stmt = $dap_dbh->prepare($sql);
			//$stmt->bindParam(':userId', $inClause, PDO::PARAM_STR);
			//$stmt->bindParam(':productId', $productId, PDO::PARAM_INT);
			$stmt->execute();	
			
			if ($obj = $stmt->fetch()) {
				$userProductRelArray[] = $obj;
			}
	
			return $userProductRelArray;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}		
	}
	
	public static function load($userId, $productId) {
		try {
		
			$dap_dbh = Dap_Connection::getConnection();
			$userProduct = NULL;
	
			$sql = "select
						upj.user_id,
						upj.product_id,
						upj.access_start_date,
						upj.access_end_date,
						upj.transaction_id,
						upj.coupon_id,
						upj.status,		
						upj.redeem_type				
					from 
						dap_users_products_jn upj
					where
						upj.user_id = :userId and
						upj.product_id = :productId
					";
	
			//logToFile($sql,LOG_DEBUG_DAP);
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':userId', $userId, PDO::PARAM_INT);
			$stmt->bindParam(':productId', $productId, PDO::PARAM_INT);
			$stmt->execute();	
			
			if ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
				$userProduct = new Dap_UsersProducts();
				$userProduct->setUser_id($row['user_id']);
				$userProduct->setProduct_id($row['product_id']);
				$userProduct->setAccess_start_date($row['access_start_date']);
				$userProduct->setAccess_end_date($row['access_end_date']);
				$userProduct->setTransaction_id($row['transaction_id']);
				$userProduct->setCoupon_id($row['coupon_id']);
				$userProduct->setStatus($row['status']);				
				$userProduct->setRedeem_type($row['redeem_type']);				
			}
			$stmt = null;
			$dap_dbh = null;

			return $userProduct;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}		
	}

	//Load UsersProducts relationships for a given user.	
	public static function loadProducts($userId) {
		try {
		
			$dap_dbh = Dap_Connection::getConnection();
			$userProductRelArray = array();
	
			$sql = "select
						upj.user_id,
						upj.product_id,
						upj.access_start_date,
						upj.access_end_date,
						upj.transaction_id,
						upj.coupon_id,
						upj.status				
					from 
						dap_users_products_jn upj
					where
						upj.user_id = :userId and
						upj.status = 'A' and
						CURDATE() >= access_start_date
					";
	
			//logToFile($sql,LOG_DEBUG_DAP);
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':userId', $userId, PDO::PARAM_INT);
			$stmt->execute();	
			
			while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
				$userProduct = new Dap_UsersProducts();
				$userProduct->setUser_id($row['user_id']);
				$userProduct->setProduct_id($row['product_id']);
				$userProduct->setAccess_start_date($row['access_start_date']);
				$userProduct->setAccess_end_date($row['access_end_date']);
				$userProduct->setTransaction_id($row['transaction_id']);
				$userProduct->setCoupon_id($row['coupon_id']);
				$userProduct->setStatus($row['status']);				
				$userProductRelArray[] = $userProduct;
			}
			$stmt = null;
			$dap_dbh = null;

			return $userProductRelArray;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}		
	}	
	
	public static function loadProductsForUser($userId) {
		try {
		
			$dap_dbh = Dap_Connection::getConnection();
			$userProductRelArray = array();
	
			$sql = "select
						upj.user_id,
						upj.product_id,
						upj.access_start_date,
						upj.access_end_date,
						upj.transaction_id,
						upj.coupon_id,
						upj.status				
					from 
						dap_users_products_jn upj
					where
						upj.user_id = :userId
					";
	
			//logToFile($sql,LOG_DEBUG_DAP);
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':userId', $userId, PDO::PARAM_INT);
			$stmt->execute();	
			
			while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
				$userProduct = new Dap_UsersProducts();
				$userProduct->setUser_id($row['user_id']);
				$userProduct->setProduct_id($row['product_id']);
				$userProduct->setAccess_start_date($row['access_start_date']);
				$userProduct->setAccess_end_date($row['access_end_date']);
				$userProduct->setTransaction_id($row['transaction_id']);
				$userProduct->setCoupon_id($row['coupon_id']);
				$userProduct->setStatus($row['status']);				
				$userProductRelArray[] = $userProduct;
			}
			$stmt = null;
			$dap_dbh = null;

			return $userProductRelArray;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}		
	}
	
	//Load UsersProducts relationships for a given user.	
	public static function loadProductsIgnoreStatus($userId) {
		try {
		
			$dap_dbh = Dap_Connection::getConnection();
			$userProductRelArray = array();
	
			$sql = "select
						upj.user_id,
						upj.product_id,
						upj.access_start_date,
						upj.access_end_date,
						upj.transaction_id,
						upj.coupon_id,
						upj.status				
					from 
						dap_users_products_jn upj
					where
						upj.user_id = :userId and
						CURDATE() >= access_start_date
					";
	
			//logToFile($sql,LOG_DEBUG_DAP);
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':userId', $userId, PDO::PARAM_INT);
			$stmt->execute();	
			
			while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
				$userProduct = new Dap_UsersProducts();
				$userProduct->setUser_id($row['user_id']);
				$userProduct->setProduct_id($row['product_id']);
				$userProduct->setAccess_start_date($row['access_start_date']);
				$userProduct->setAccess_end_date($row['access_end_date']);
				$userProduct->setTransaction_id($row['transaction_id']);
				$userProduct->setCoupon_id($row['coupon_id']);
				$userProduct->setStatus($row['status']);				
				$userProductRelArray[] = $userProduct;
			}
			$stmt = null;
			$dap_dbh = null;

			return $userProductRelArray;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}		
	}
	
	//Create
	public function create($dap_dbh=NULL,$send_welcome_email="") {
		try {
			$dap_dbh = Dap_Connection::getConnection($dap_dbh);
			$product = Dap_Product::loadProduct($this->getProduct_id());
			$status = "A";
			
			if( ($product->getDouble_optin_subject() != "") && ($product->getDouble_optin_body() != "") ) {
				//This is double option - so set UPJ status = "I"
			
				$status = "I";
			}
			
			logToFile("Dap_UsersProducts.class.php: status() =".$status); 
				
			if($this->getCoupon_id() == "") $this->setCoupon_id(null);

			$sql = "insert into dap_users_products_jn
						(user_id, product_id, access_start_date, access_end_date, transaction_id, coupon_id, status,redeem_type)
					values
						(:user_id, :product_id, :access_start_date, :access_end_date, :transaction_id, :coupon_id, :status, :redeem_type)
					";
			//logToFile($sql,LOG_INFO_DAP);
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':user_id', $this->getUser_id(), PDO::PARAM_INT);
			$stmt->bindParam(':product_id', $this->getProduct_id(), PDO::PARAM_INT);
			$stmt->bindParam(':access_start_date', $this->getAccess_start_date(), PDO::PARAM_STR);
			$stmt->bindParam(':access_end_date', $this->getAccess_end_date(), PDO::PARAM_STR);
			$stmt->bindParam(':transaction_id', $this->getTransaction_id(), PDO::PARAM_STR);		
			$stmt->bindParam(':coupon_id', $this->getCoupon_id(), PDO::PARAM_INT);		
			$stmt->bindParam(':status', $status, PDO::PARAM_STR);
			$stmt->bindParam(':redeem_type', $this->getRedeem_type(), PDO::PARAM_STR);
			$stmt->execute();
			$lastid = $dap_dbh->lastInsertId();
			//logToFile("lastid: $lastid"); 
			$stmt = null;
			
			//Send out welcome/activation email only if access_start_date of product is greater than or equal to today
			//Meaning, don't send out any emails for post-dated products	
			$access_start_date = $this->getAccess_start_date();
			
			logToFile("newdate=".$newdate); 
			logToFile("currdate=".strtotime(date("Y-m-d"))); 
			if( date("Y-m-d", strtotime($access_start_date)) > date("Y-m-d")) {
				return $lastid; //simply return without sending emails
			}
			
			if( ($product->getDouble_optin_subject() != "") && ($product->getDouble_optin_body() != "") ) {
				logToFile("This is double optin"); 
				$user = Dap_User::loadUserById($this->getUser_id());
				sendUserProductActivationEmail($user, $this->getProduct_id());
			} else {
				logToFile("This is single optin"); 
				if($send_welcome_email != "N"){
					logToFile("Send welcome email is set to be ".$send_welcome_email,LOG_DEBUG_DAP); 
					sendUserProductWelcomeEmail($this->getUser_id(), $this->getProduct_id());
				}
				else{
					logToFile("Send welcome email is set to N",LOG_DEBUG_DAP); 
				}
			}
			
			//$dap_dbh = null;
			return $lastid;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}		
		
	}
	//Update
	
	public function update($dap_dbh=NULL) {
		try {
			
			$coupon_id=$this->getCoupon_id();
			if(!is_numeric($coupon_id)) 
				$coupon_id=0;
				
			$dap_dbh = Dap_Connection::getConnection($dap_dbh);
			$sql = "update dap_users_products_jn set
						access_start_date =:access_start_date,
						access_end_date =:access_end_date,
						transaction_id =:transaction_id,
						coupon_id =:coupon_id,
						status =:status,
						redeem_type =:redeem_type
					where
						user_id = :userId and
						product_id = :productId
					";

			$stmt = $dap_dbh->prepare($sql);
			logToFile("Dap_UsersProducts.update() - Sql:".$sql);
			logToFile("Dap_UsersProducts.update() - UserId:".$this->getUser_id().", ProductId:".$this->getProduct_id());
			$stmt->bindParam(':access_start_date', $this->getAccess_start_date(), PDO::PARAM_STR);
			$stmt->bindParam(':access_end_date', $this->getAccess_end_date(), PDO::PARAM_STR);
			$stmt->bindParam(':transaction_id', $this->getTransaction_id(), PDO::PARAM_STR);
			$stmt->bindParam(':status', $this->getStatus(), PDO::PARAM_STR);
			$stmt->bindParam(':redeem_type', $this->getRedeem_type(), PDO::PARAM_STR);
			$stmt->bindParam(':userId', $this->getUser_id(), PDO::PARAM_INT);
			$stmt->bindParam(':productId', $this->getProduct_id(), PDO::PARAM_INT);
			
			
			logToFile("Dap_UsersProducts.update() - coupon:".$coupon_id);	
			$stmt->bindParam(':coupon_id', $coupon_id, PDO::PARAM_INT);
				
			$stmt->execute();	
			$stmt = null;
			//$dap_dbh = null;
			Dap_UsersProducts::cleanUsersProducts($dap_dbh);
			return;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}		
		
	}
	
	//Delete
	public function delete($dap_dbh=NULL) {
		try {
			$dap_dbh = Dap_Connection::getConnection($dap_dbh);
			//delete from usersproducts table
			$sql = "delete from  
					dap_users_products_jn
					where user_id =:user_id and
					product_id =:product_id";
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':user_id', $this->getUser_id(), PDO::PARAM_INT);
			$stmt->bindParam(':product_id', $this->getProduct_id(), PDO::PARAM_INT);
			$stmt->execute();
			$stmt = null;
			//$dap_dbh = null;		
			return;			
		} catch (PDOException $e) {
			$stmt = null;
			//$dap_dbh = null;				
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			$stmt = null;
			//$dap_dbh = null;			
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}		
	}	
	/*
		move all users from srcProduct to targetProduct. Assume the srce and target products given are valid.
	*/
	public static function moveUsersProducts($srcProduct, $targetProduct)  {
		try {
			$dap_dbh = Dap_Connection::getConnection();
			$sql = "update dap_users_products_jn set
						product_id =:target_product_id
					where
						product_id =:source_product_id
					";

			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':source_product_id', $srcProduct, PDO::PARAM_INT);
			$stmt->bindParam(':target_product_id', $targetProduct, PDO::PARAM_INT);
			$stmt->execute();	
			$stmt = null;
			$dap_dbh = null;
			
			return;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}	
	}
	
	/*
		Copy all users from one product to other product keeping all other information same as the original product. 
		SQL : insert into  `dap_users_products_jn` (user_id, product_id, access_start_date, access_end_date, transaction_id, status)
		select user_id, 2, access_start_date, access_end_date, transaction_id, status
		from `dap_users_products_jn`
		where product_id = 1
	*/	
	public static function copyUsersProducts($srcProduct, $targetProduct)  {	
		try {
			$dap_dbh = Dap_Connection::getConnection();
			$sql = "insert into  dap_users_products_jn
						(user_id, product_id, access_start_date, access_end_date, transaction_id, status)
					select 
						user_id, :target_product_id, access_start_date, access_end_date, transaction_id, status
					from dap_users_products_jn
					where product_id =:source_product_id
					";

			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':source_product_id', $srcProduct, PDO::PARAM_INT);
			$stmt->bindParam(':target_product_id', $targetProduct, PDO::PARAM_INT);
			$stmt->execute();	
			$stmt = null;
			$dap_dbh = null;			
			return;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}	
	
	
	}	
	
	/*
		THIS MIGHT BE DEPRECATED - CHECK FOLLOWING FUNCTION RIGHT BELOW THIS
		addNewUserToProduct(...)
		
		Add user to product, but
		a) Create user if not exists
		b) Assume product id exists
		
		All parameters are mandatory.
	*/
	
		public static function addUserToProduct($email, $firstname, $lastname="", $productid, $ispaid="n", $activeStatus="U", $coupon_id="", $accessStartDate="", $accessEndDate="") {
		$trans_id = -1;
		$uid = 0;
		
		logToFile("Dap_UsersProducts.addUserToProduct ispaid = " . $ispaid);
		if(strtolower($ispaid) == "y") {
			//admin added paid product
			logToFile("Dap_UsersProducts.addUserToProduct ispaid=" . $ispaid);
			$trans_id = -3;
		}
		
		//check to see if product exists
		$product = Dap_Product::loadProduct($productid);
		if( !isset($product) || ($product == NULL) ) return;
		//$doesProductExist = Dap_Product::isExists($productid);
		//if($doesProductExist === FALSE) return;
		
		$user = Dap_User::loadUserByEmail($email);
		if( !isset($user) || ($user == NULL) ) {
			$user = new Dap_User();
			$user->setEmail($email);
			$user->setFirst_name($firstname);
			$user->setLast_name($lastname);
			
			//Figure out what should be user's status
			if( ($product->getDouble_optin_subject() == "") || ($product->getDouble_optin_body() == "") ) {
				//This is single optin, so take what caller sent as $activeStatus
				$userStatus = (strtolower($activeStatus) == "u") ? "U" : "A";
					
			} else {
				//Double optin. So ignore what caller sent in as $activeStatus and set user status to "U"
				$userStatus = "U";
			}
			
			logToFile("Dap_UsersProducts.class.php: addUserToProduct(): subject= ". $product->getDouble_optin_subject()); 

			logToFile("Dap_UsersProducts.class.php: addUserToProduct(): userStatus: =".$userStatus); 
			$user->setStatus($userStatus);
			
			$uid = $user->create();
			//$user = Dap_User::loadUserById($uid);
		} else {
			$uid = $user->getId();
		}
		
		
		//$uid = $user->getId();
		Dap_UsersProducts::addUsersProducts($uid, $productid, $trans_id, $accessStartDate, $coupon_id, $accessEndDate);
		logToFile("Dap_UsersProducts.addUserToProduct all done");
		return $uid;
	}
	
	
	
	
	public static function addMassUserToProduct($dest_productid, $email, $accessdate, $ispaid) {
		 
		$trans_id = -1;
		$uid = 0;
		$post=array();
		if(strtolower($ispaid) == "y") {
			//admin added paid product
			$trans_id = -3;
		}
		
		$post['ispaid'] = $ispaid;
 
		//check to see if product exists
		
		$product = Dap_Product::loadProduct($dest_productid);
		if( !isset($product) || ($product == NULL) ) 
			return "Could not find product Id=" . $dest_productid;
		
		$post["item_name"]=$product->getName();
		$post['item_number'] = $productid;
		$post['email'] = $email;
		$post['accessdate'] = $accessdate;
		
		if ($post['email'] == '') {
			return "missing email in data";
		}	
		
		$user = Dap_User::loadUserByEmail($post['email']);
	
		if(isset($user)) {
				
			logToFile("Dap_UsersProducts.addMassUserToProduct EXIT:  ispaid=". $post["ispaid"]);
			
			$post['first_name'] = $user->getFirst_name();
			$post['last_name'] = $user->getLast_name();
			
			if($accessdate == "today") {
					//leave empty
						//$post['access_start_date']
			//$post['access_end_date']
			}
		    else {
				//$post['access_start_date'] = start date of the user to the source product
				//$post['access_end_date'] = end date of the user to the source product
			}	
			
			//$post['first_name'], $post['last_name'], $product->getId(), $ispaid, "A", "", $post['access_start_date'], $post['access_end_date']
		
		
			$uid = Dap_UsersProducts::bulkExtendedImport($post);
			if ( (is_numeric($uid)) && ($uid>=0) ) {
				//logToFile("Dap_UsersProducts.addMassUserToProduct :Added " . $post['first_name'] . ":" . $post['email'] . " with ispaid status of " . $post['ispaid']);
			}
			
			return $uid;
		}
		
	}
	
	
	
	public static function addExtNewUserToProduct($productid, $ispaid, $fieldlist, $data, $dateformat) {
		$trans_id = -1;
		$uid = 0;
		$post=array();
		if(strtolower($ispaid) == "y") {
			//admin added paid product
			$trans_id = -3;
		}
		
		$post['ispaid'] = $ispaid;
		
		logToFile("Dap_UsersProducts.addExtNewUserToProduct Enter:  productId=". $productid);
		logToFile("Dap_UsersProducts.addExtNewUserToProduct Enter:  dateformat=". $dateformat);
		logToFile("Dap_UsersProducts.addExtNewUserToProduct Enter:  ispaid=". $ispaid);
		//check to see if product exists
		$product = Dap_Product::loadProduct($productid);
		if( !isset($product) || ($product == NULL) ) 
			return "Could not find product Id=" . $productid;
		
		$fieldarr=explode("|",$fieldlist);
		$dataarr=explode(",",$data);
		
		$post["item_name"]=$product->getName();
		$post['item_number'] = $productid;
		
		for ($i=0;$i<count($fieldarr);$i++) {
			switch ($fieldarr[$i]) {
				  case "email":
					  $post['email']=$dataarr[$i];
					  $post['payer_email']=$dataarr[$i];
					  break;
			      case "first_name":
					  $post['first_name']=$dataarr[$i];
					  break;
				  case "last_name":
					  $post['last_name']=$dataarr[$i];
					  break;
				  case "user_name":
					  $post['user_name']=$dataarr[$i];
					  break;
			      case "password":
					  $post['password']=$dataarr[$i];
					  break;
				  case "address1":
					  $post['address1']=$dataarr[$i];
					  break;
				  case "city":
					  $post['city']=$dataarr[$i];
					  break;
				  case "state":
					  $post['state']=$dataarr[$i];
					  break;
				  case "zip":
					  $post['zip']=$dataarr[$i];
					  break;
				  case "country":
					  $post['country']=$dataarr[$i];
					  break;
			      case "phone":
					  $post['phone']=$dataarr[$i];
					  break;	  	  	  	  	  		  	  
				  case "company":
					  $post['company']=$dataarr[$i];
					  break;
				  case "access_start_date":
				   	  if($dateformat != "YYYY-MM-DD") {
						  
						if( isset($dataarr[$i]) && ($dataarr[$i]!="") ) {
				  	 	 	$dataarr[$i]=str_replace("-", "/", $dataarr[$i]);
						  	$dataarr[$i]=date("Y-m-d", strtotime($dataarr[$i]));
							logToFile("(Dap_Cron.handleBulkExtentedAddCsvToProduct() - accessstartdate:".$dataarr[$i]);
						}
						
					  }
					  
					  $post['access_start_date']=$dataarr[$i];
					  break;
				  case "access_end_date":
				  
				  	  if($dateformat != "YYYY-MM-DD") {
						  
						if( isset($dataarr[$i]) && ($dataarr[$i]!="") ) {
				  	 	 	$dataarr[$i]=str_replace("-", "/", $dataarr[$i]);
						  	$dataarr[$i]=date("Y-m-d", strtotime($dataarr[$i]));
							logToFile("(Dap_Cron.handleBulkExtentedAddCsvToProduct() - accessenddate:".$dataarr[$i]);
						}
						
					  }
					  $post['access_end_date']=$dataarr[$i];
					  break;
				  case "credits":
					  $post['credits']=$dataarr[$i];
					  break;
			      
				  default: // check custom
				  		
				  		if(strstr($fieldarr[$i],"custom_")) {
							$fieldname=$fieldarr[$i];
							logToFile("(Dap_Cron.handleBulkExtentedAddCsvToProduct() - fieldname:".$fieldname);
							$post[$fieldname]=$dataarr[$i];
				  	  		
							//$customIdArr=explode("_",$fieldarr[$i]);
							//$customId=$customIdArr[1];
							logToFile("(Dap_Cron.handleBulkExtentedAddCsvToProduct() - custom val:".$post[$fieldname]);
						}
				        break;  
			}
		}
		
		if ($post['first_name'] == '') {
			return "missing firstname in data";
		}
		if ($post['email'] == '') {
			return "missing email in data";
		}	
		
		logToFile("Dap_UsersProducts.addExtNewUserToProduct EXIT:  ispaid=". $post["ispaid"]);
		
		$uid = Dap_UsersProducts::bulkExtendedImport($post);
		if ( (is_numeric($uid)) && ($uid>=0) ) {
			logToFile("Dap_UsersProducts.addExtNewUserToProduct :Added " . $post['first_name'] . ":" . $post['email'] . " with ispaid status of " . $post['ispaid']);
		}
			
		return $uid;
	}
	
	public static function bulkExtendedImport($post) 
	{
		logToFile("Dap_UsersProducts.bulkExtendedImport:  ENTER", LOG_DEBUG_DAP);
		logToFile("Dap_UsersProducts.bulkExtendedImport:  ENTER isPaid=".$post["ispaid"], LOG_DEBUG_DAP);	
		if ($post['item_name'] == "") {
			$dap_error = "missing product name in the bulkImport notification for the user: " . $post['email'];
			logToFile("Dap_UsersProducts.bulkExtendedImport: " . $dap_error, LOG_DEBUG_DAP);
			sendAdminEmail("DAP Data Import: missing product name", $dap_error);
			return "Missing product name in data";
		}
		
		//$post['txn_id'] = $post['orderID'];
		$post['txn_type'] = "bulkextimport";
			
		if ( !isset($post['payer_email']) || $post['payer_email'] == '' )
			$post['payer_email'] = $post['email'];
		
		if(!isset($post['payment_status'])) { 
			$post['payment_status'] = 'Completed';
		}
		
		//logToFile("dap-bulkImport: bulkImport - calling recordIncoming", LOG_DEBUG_DAP);
		
		//Lets try to get user and see if it exists
		$user = Dap_User::loadUserByEmail($post['email']);
		$uid=-1;
		
		if($post["ispaid"] == "|Y"){
			$post["ispaid"] ="Y";
		}
		 	
		if (isset($post["ispaid"]) && (($post["ispaid"] == 'Y') || ($post["ispaid"] == 'y'))){
			$ispaid =  "y";
		} else { 
			$ispaid = "n";
		}	
			
		//TODO: Should we check for id > 0 or something like that ?
		if(isset($user)) {
			logToFile("Dap_UsersProducts.bulkExtendedImport: User " . $post['email'] . ":" . $post['first_name'] . " exists. Checking if user is already tied to product");
			
			$product = Dap_Product::loadProductByName($post['item_name']);
			
			if( !isset($product) || ($product == NULL) ) {
				logToFile("Dap_UsersProducts.bulkExtendedImport: Added user " . $post['email'] . ":" . $post['first_name'] . "but Product " . $post['item_name'] . " not found in DAP");
				return "Could not find the product (" . $post['item_name'] . ")";
			}
			
			$userProduct = Dap_UsersProducts::load($user->getId(), $product->getId());
			
			if( isset($userProduct) || ($userProduct != NULL) ) {
				logToFile("Dap_UsersProducts.bulkExtendedImport: User=" . $post['email'] . ":" . $post['first_name'] . " already has access to the product=".$product->getId());
				return "User already has access to product. No action taken."; //already has access, no action taken
			}
		
			$uid = Dap_UsersProducts::addUserToProduct($post['email'], $post['first_name'], $post['last_name'], $product->getId(), $ispaid, "A", "", $post['access_start_date'], $post['access_end_date']);
			
			$i=0;
			foreach ($post as $key => $value) {
				logToFile("Dap_UsersProducts.class: bulkExtendedImport(): POST $key = " . $value, LOG_DEBUG_DAP);
				
				if(strstr($key,"custom_")) {
					$customIdArr=explode("_",$key);
					$customId=$customIdArr[1];
					$customVal=$value;	
					
					logToFile("Dap_UsersProducts.class: bulkExtendedImport(): update value of $customId to = " . $value, LOG_DEBUG_DAP);
						
					$userId=$user->getId();
					$cf = Dap_UserCustomFields::loadUserCustomFieldsByCustomFieldId($customId, $userId );
					$usercustom = new Dap_UserCustomFields();
			
					$usercustom->setUser_id($userId);
					$usercustom->setCustom_value($value);
					$usercustom->setCustom_id($customId);
					if ($cf) {
						logToFile("Dap_UsersProducts.class: bulkExtendedImport(): update value of $customId to = " . $value, LOG_DEBUG_DAP);
						$usercustom->update();
					}
					else {
						logToFile("Dap_UsersProducts.class: bulkExtendedImport(): add custom value of $value to customId=$customId", LOG_DEBUG_DAP);
						$usercustom->create();
					}
				}
				$i++;
			}
			
			return $uid;
		}
		
		$product = Dap_Product::loadProductByName($post['item_name']);
		if( !isset($product) || ($product == NULL) ) {
			logToFile("Dap_UsersProducts.bulkExtendedImport: Product=" . $post['item_name'] . " not found in DAP");
			return "Could not find the product (" . $post['item_name'] . ")";
		}
		
		logToFile("Dap_UsersProducts.bulkExtendedImport: new user: addUserToProduct() ispaid=".$ispaid);
		
		
		$uid = Dap_UsersProducts::addUserToProduct($post['email'], $post['first_name'], $post['last_name'], $product->getId(), $post['ispaid'], "A", "", $post['access_start_date'], $post['access_end_date']);
		
		//Get user object from uid
		$user = Dap_User::loadUserByEmail($post['email']);
		
		//logToFile("dap-bulkImport :CheckingUser: New User, FirstName:".$post['first_name'].":".$post['cname']);
	
		//store shipping info in user profile 
		if(array_key_exists('ship_to_first_name',$post)) {
			$user->setFirst_name( $post["ship_to_first_name"] );
			$user->setLast_name( $post["ship_to_last_name"] );
		}
		if(array_key_exists('first_name',$post)) {
			$user->setFirst_name( $post["first_name"] );
			$user->setLast_name( $post["last_name"] );
		} else if(array_key_exists('cname',$post)) {
			$user->setFirst_name( $post["cname"] );
			$user->setLast_name( $post["cname"] );
		}
		
		
		
		if(array_key_exists('ship_to_address1',$post)) {
			$user->setAddress1( $post["ship_to_address1"] );
		} else if (array_key_exists('address1',$post)) {
			$user->setAddress1( $post["address1"] );
		}
		
		if(array_key_exists('ship_to_address2',$post)) {
			$user->setAddress2( $post["ship_to_address2"] );
		} else if (array_key_exists('address2',$post)) {
			$user->setAddress2( $post["address2"] );
		}
		
		if(array_key_exists('ship_to_city',$post)) {
			$user->setCity( $post["ship_to_city"] );
		} else if(array_key_exists('city',$post)) {
			$user->setCity( $post["city"] );
		} 
		
		if(array_key_exists('ship_to_state',$post)) {
			$user->setState( $post["ship_to_state"] );
		} else if(array_key_exists('ship_to_state',$post)) {
			$user->setState( $post["ship_to_state"] );
		}
		
		if(array_key_exists('ship_to_zip',$post)) {
			$user->setZip( $post["ship_to_zip"] );
		} else if(array_key_exists('zip',$post)) {
			$user->setZip( $post["zip"] );
		} 
		
		if(array_key_exists('ship_to_country',$post)) {
			$user->setCountry( $post["ship_to_country"] );
		} else if(array_key_exists('country',$post)) {
			$user->setCountry( $post["country"] );
		}
		
		if(array_key_exists('phone',$post)) {
			$user->setPhone( $post["phone"] );
		} 
		if(array_key_exists('fax',$post)) {
			$user->setFax( $post["fax"] );
		} 
		if(array_key_exists('company',$post)) {
			$user->setCompany( $post["company"] );
		} 
		
		if(isset($post["credits"]))
			$user->setCredits_available( $post["credits"]);	
	
		$user->setEmail( $post["email"]);		
		$user->setStatus("A");
		
		if ($post['password'] != '')		 	
			$user->setPassword($post['password']);
		
		//logToFile("Dap_UsersProducts.bulkExtendedImport: password: " . $user->getPassword()); 
		 
		try {
			$user->update();
			$i=0;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_DEBUG_DAP);
			return $e->getMessage();
			//eat it
		}
		
		if(array_key_exists('user_name',$post)) {
			$user->setUser_name( $post["user_name"] );
		} 
		
		try {
			$user->update();
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_DEBUG_DAP);
			//return $e->getMessage();
			//eat it
		}
		
		
		$i=0;
		foreach ($post as $key => $value) {
		  logToFile("Dap_UsersProducts.class: bulkExtendedImport(): NEW USER: POST $key = " . $value, LOG_DEBUG_DAP);
		  if(strstr($key,"custom_")) {
			  $customIdArr=explode("_",$key);
			  $customId=$customIdArr[1];
			  $customVal=$value;	
			  
			  logToFile("Dap_UsersProducts.class: bulkExtendedImport(): update value of $customId to = " . $value, LOG_DEBUG_DAP);
				  
			  $userId=$user->getId();
			  $cf = Dap_UserCustomFields::loadUserCustomFieldsByCustomFieldId($customId, $userId );
			  $usercustom = new Dap_UserCustomFields();
	  
			  $usercustom->setUser_id($userId);
			  $usercustom->setCustom_value($value);
			  $usercustom->setCustom_id($customId);
			  if ($cf) {
				  logToFile("Dap_UsersProducts.class: bulkExtendedImport(): update value of $customId to = " . $value, LOG_DEBUG_DAP);
				  $usercustom->update();
			  }
			  else {
				  logToFile("Dap_UsersProducts.class: bulkExtendedImport(): add custom value of $value to customId=$customId", LOG_DEBUG_DAP);
				  $usercustom->create();
			  }
		  }
		  $i++;
		}
				
		if (($post['ispaid'] != '') && (($post['ispaid'] == 'Y') || ($post['ispaid'] == 'y')))
			$ispaid =  "y";
		else 
			$ispaid = "n";
		
		logToFile("Dap_UsersProducts.bulkExtendedImport: Imported " . $post['email'].":".$post['first_name']);

	    logToFile("Dap_UsersProducts.bulkExtendedImport: added user to product " . $uid.":".$post['item_name']);
		
		return $uid;
	}
	
	public static function addNewUserToProduct($email, $firstname, $lastname="", $username="", $productid, $ispaid="n", $activeStatus="U", $coupon_id="", $password="",$source="") {
		$trans_id = -1;
		$uid = 0;
		
		if(strtolower($ispaid) == "y") {
			//admin added paid product
			$trans_id = -3;
		}
		
		logToFile("Dap_UsersProducts.addNewUserToProduct Enter:  productId=". $productid);
		
		//check to see if product exists
		$product = Dap_Product::loadProduct($productid);
		if( !isset($product) || ($product == NULL) ) return;
		
		$user = Dap_User::loadUserByEmail($email);
		if( !isset($user) || ($user == NULL) ) {
			$user = new Dap_User();
			$user->setEmail($email);
			$user->setFirst_name($firstname);
			$user->setLast_name($lastname);
			if( isset($password) && ($password != "") ) { //if specific password provided, then take that
				$user->setPassword($password);
			}

			if ($username != "")
				$user->setUser_name($username);
			else {
				//$user->setUser_name(NULL);
				$uname=generateUsername("Dap_UsersProducts.class.php.addNewUserToProduct()",$email,$firstname,$lastname);
				if($uname=="") {
					$uname=NULL;
					logToFile("Dap_UsersProducts.class.php: addNewUserToProduct(): username set to NULL",LOG_INFO_DAP);
				}
				else 
					logToFile("Dap_UsersProducts.class.php: addNewUserToProduct(): username set to ".$uname,LOG_INFO_DAP);
					
				$user->setUser_name($uname);
				
			}
			//Figure out what should be user's status
			if( ($product->getDouble_optin_subject() == "") || ($product->getDouble_optin_body() == "") ) {
				//This is single optin, so take what caller sent as $activeStatus
				$userStatus = (strtolower($activeStatus) == "u") ? "U" : "A";
			} else {
				//Double optin. So ignore what caller sent in as $activeStatus and set user status to "U"
				$userStatus = "U";
			}
			$user->setStatus($userStatus);
			
			logToFile("Dap_UsersProducts.addNewUserToProduct create new user:  userStatus=". $userStatus);
			
			$uid = $user->create();
			//$user = Dap_User::loadUserById($uid);
		} else {
			$uid = $user->getId();
		}
		
		$str = "DAP New User: addNewUserToProduct: Source = " . $source . ". Admin Added User - ".$email . ", gave user access to product = " .  $productid; 
		logToFile($str,LOG_DEBUG_DAP);
		//sendAdminEmail("DAP New User: addNewUserToProduct: Source = " . $source . ", Admin Added User - ".$email, $str);
						
		//$uid = $user->getId();
		if ( isset($uid) && !is_null($uid) && ($uid != 0) ) {
			Dap_UsersProducts::addUsersProducts($uid, $productid, $trans_id, '', $coupon_id);
			logToFile("Dap_UsersProducts.addNewUserToProduct all done");
		}
		return $uid;
	}
	
	
	public static function markUserProductAsSomething($userId, $productId, $transactionId) {
		//transactionId values: -1: Direct Signup, etc...
		$userProduct = Dap_UsersProducts::load($userId, $productId);
		if($userProduct == NULL) {
			//logToFile("No Such UsersProducts relationship exists..".$userId.":".$productId);
			throw new Exception("This product id:".$productId." does not belong to user id:".$userId);
		}
		$userProduct->setTransaction_id($transactionId);
		$userProduct->update();
	}
	
	/*
	This function is single entry point to add user-product relationship. 
	NOTES:
	1. This function does not care if product is active or not.
	2. It does not add if product doesnt exist.
	3. It does not add if user doesnt exist.
	
	insert into dap_users_products_jn
	
	Parameters: Existing User Id, Existing Product Id, Transaction Id (optional,not validated), Access Start Date (optional)
	
	Transaction Id:
	Payment - valid transaction
	Direct Signup - 
	Admin Added - 
	TODO: Send notification to admin if the product does not exist. 
	*/
	
		
	public static function addUsersProducts($userId, $productId, $transId='-1', $accessStartDate='', $coupon_id="", $accessEndDate='',$addCredits="", $redeem_type = "") {
		//check if its valid user id (doesnt matter if active or inactive
		//$user = Dap_User::loadUserById($userId);
		//if(!isset($user)) return;
	
		//logToFile("addUserProducts: active user: $userId");
		//logToFile("accessEndDate: $accessEndDate");
		//load the product and see if it exists
		
		 logToFile("(Dap_UsersProducts.addUsersProducts()), redeem_type:".$redeem_type,LOG_DEBUG_DAP);
		 logToFile("(Dap_UsersProducts.addUsersProducts()), enter productId".$productId,LOG_DEBUG_DAP);
		$product = Dap_Product::loadProduct($productId);		
			
		//check if product exists
		if(!isset($product)) return;
		
		//is free or paid
		$allow_free_signup = $product->getAllow_free_signup();
		
		if($allow_free_signup=="N") {
			//paid product
			$transaction = Dap_Transactions::load($transId);
			if(!isset($transaction)) {
				// no transaction, check if admin
				if( Dap_Session::isLoggedIn() ) { 
					$session = Dap_Session::getSession();
					$user = $session->getUser();
					if(isset($user)) {
					  if($user->getAccount_type() != "A") {
						  // check if access via payment						
						 
						  // check if coming from "redeem"
						  
						 if (!isset($_SESSION["gameofpointsredeem"]) || ($_SESSION["gameofpointsredeem"] == "") ) {
						     logToFile("(Dap_UsersProducts.addUsersProducts()),not an admin, can't allow",LOG_DEBUG_DAP);
						    return;
						 }
						 else {
						       logToFile("(Dap_UsersProducts.addUsersProducts()),not an admin but via gameofpoints redeem, so allow",LOG_DEBUG_DAP);
						 }
						 
						 
					  } else {
						  logToFile("(Dap_UsersProducts.addUsersProducts()),is admin - allow",LOG_DEBUG_DAP);
					  }
					  
					} else {
						logToFile("(Dap_UsersProducts.addUsersProducts()),no user found, can't allow",LOG_DEBUG_DAP);
						return;
					}
				} else if (!isset($_SESSION["bulkadduser"]) || ($_SESSION["bulkadduser"] == "") ) {
						logToFile("(Dap_UsersProducts.addUsersProducts()),no transaction and user not logged-in, can't allow",LOG_DEBUG_DAP);
						return;
				}
			}
			else {
				 logToFile("(Dap_UsersProducts.addUsersProducts()), valid payment transaction - allow",LOG_DEBUG_DAP);
			}
		}
		 logToFile("(Dap_UsersProducts.addUsersProducts()) recurring".$recurring,LOG_DEBUG_DAP);
		$recurring="N";
		//logToFile("(Dap_UsersProducts.addUsersProducts()) we have active product: $productId");
		//by the time we are here, we should be ready with valid uesrid and productid.
		$userProduct = Dap_UsersProducts::load($userId, $productId);
		if($userProduct != NULL) {
			$cs_first_payment =false;
			$recurring="Y";
			logToFile("(Dap_UsersProducts.addUsersProducts()) active usersproducts name: ".$product->getName());
			logToFile("(Dap_UsersProducts.addUsersProducts()) active usersproducts isrecurring: ".$product->getIs_recurring());
			//we have existing users-products relationship, so we need to modify this.
			$userProduct->setTransaction_id($transId);
			$userProduct->setStatus("A");		
			
			logToFile("(Dap_UsersProducts.addUsersProducts()) couponId=".$coupon_id);
			$userProduct->setCoupon_id($coupon_id);
			
			if($accessStartDate != "") {
				$userProduct->setAccess_start_date($accessStartDate);
			}
			if($accessEndDate != "") {
				$userProduct->setAccess_end_date($accessEndDate);
			}
			else {
			  //lets check if this is recurring
			  if(strtolower($product->getIs_recurring()) == "y") {
				  //this is recurring so lets adjust end date
				  //TODO: calculate what recurring cycle we are in.
				  //get current active days
				  logToFile("(Dap_UsersProducts.addUsersProducts()) active Days: ".$active_days);
				  $active_days = $userProduct->getActiveDays();
				  logToFile("(Dap_UsersProducts.addUsersProducts()) active Days: ".$active_days);
				  //Took the negative -1 
				  $extend_days = $product->deriveRecurringDaysFromTotal($active_days) ; //$product->getRecurring_cycle_1() - 1;
				  logToFile("(Dap_UsersProducts.addUsersProducts()) recurring payment: extend_days: ".$extend_days);
				  //$extend_days =  $extend_days + 1; //$product->getRecurring_cycle_1() - 1;
				  $expirationStatus = $product->getAccessExpirationAction();
				  logToFile("(Dap_UsersProducts.addUsersProducts()) recurring payment: expirationStatus: ".$expirationStatus);
				  
				logToFile("(Dap_UsersProducts.addUsersProducts()) final_payment_access =".$_SESSION['final_payment_access']);
				if(isset($_SESSION["final_payment_access"]) && $_SESSION["final_payment_access"] != '' && $_SESSION["final_payment_access"] != 0){
					logToFile("(Dap_UsersProducts.addUsersProducts()) final_payment_access is set , so add last payment access days to the end date");	
					$extend_days +=  $_SESSION["final_payment_access"];
				}
				  
				  
				  if($expirationStatus == "MAKEITCURRENT") {
				  	 logToFile("(Dap_UsersProducts.addUsersProducts()) calling makeitcurrent");
					$userProduct->makeItCurrentAccess($extend_days);	
				  }
				  else 
					$userProduct->extendEndDays($extend_days);	

				 //Send plugin notification even for recurring payments.
				  global $includeList;
				  global $classname;
			
				  $includeList = array();
			  	  $classname = array();
				
				  registeredPlugins($includeList, $email, "Add", $product);
			
				  foreach ($includeList as $key => $value) {
					if(defined('TRIGGER_PLUGIN_NOTIFY_FOR_RECURRING_PAYMENTS') && (TRIGGER_PLUGIN_NOTIFY_FOR_RECURRING_PAYMENTS=="Y")) {
						logToFile("(Dap_UsersProducts.addUsersProducts()): recurring payment and TRIGGER_PLUGIN_NOTIFY_FOR_RECURRING_PAYMENTS = Y",LOG_DEBUG_DAP);
						Dap_UsersProducts::pluginAdd($userId, $productId, $value, $product);
					}
				  }
			
				  if(defined('TRIGGER_PLUGIN_NOTIFY_FOR_RECURRING_PAYMENTS') && (TRIGGER_PLUGIN_NOTIFY_FOR_RECURRING_PAYMENTS=="Y")) {			
					logToFile("(Dap_UsersProducts.addUsersProducts()) recurring payment: going to call the automation function",LOG_DEBUG_DAP);
					/* This function is for implementing the automation rules */
					try{
						Dap_UsersProducts::DAPApplyAutomationRules($productId,$userId,$product,"add");
					}
					catch(Exception $e){
						logToFile("(Dap_UsersProducts.addUsersProducts()),Automation Exception is ".$e->getMessage(),LOG_DEBUG_DAP);
					}
				  }	
			
			    } else {
				  $extend_days = $product->getRecurring_cycle_1();
				  if( is_null($extend_days) || ($extend_days == 0) || ($extend_days == "") || ($extend_days == "9999") ) {
					  $userProduct->deriveAccessEndDate(-1);
				  } else {
					  //logToFile("New extend_days in addUserToProduct: $extend_days"); 
					  
					  $expirationStatus = $product->getAccessExpirationAction();
					  logToFile("(Dap_UsersProducts.addUsersProducts()) one time payment: expirationStatus: ".$expirationStatus);
				      if($expirationStatus == "MAKEITCURRENT") {
				  	     logToFile("(Dap_UsersProducts.addUsersProducts()) calling makeitcurrent");
					     $userProduct->makeItCurrentAccess($extend_days);	
				      }
				      else 
				      	 $userProduct->extendEndDays($extend_days);	
				   }
				}
			    
			}
				  
			
			logToFile("(Dap_UsersProducts.addUsersProducts()) recurring payment: before update access start: ".$userProduct->getAccess_start_date());
			logToFile("(Dap_UsersProducts.addUsersProducts()) recurring payment: before update access end: ".$userProduct->getAccess_end_date());
			
			logToFile("(Dap_UsersProducts.addUsersProducts()) recurring payment: extend_days: ".$extend_days);
			$userProduct->setRedeem_type($redeem_type);
			$userProduct->update();
			//$userProduct->adjustUserResourceClickCounts(true);
		} else {
			//first payment
			$cs_first_payment =true;
			
			logToFile( "Dap_UsersProducts.class.php: addProductToUser()");
			if($accessStartDate == '') {
				$accessStartDate = date("Y-m-d");
			}
			
			Dap_UsersProducts::addProductToUser($userId, $product, $productId, $transId, $accessStartDate, $coupon_id, $accessEndDate,'','','',$redeem_type);
			/*
			if(strtolower($product->getIs_recurring()) == "y") {
			  logToFile( "Dap_UsersProducts.class.php: addProductToUser(): new user - extend access by 1 day");
			  $userProduct = Dap_UsersProducts::load($userId, $productId);
			  $accessEndDate=$userProduct->getAccess_end_date();
			  //logToFile("Dap_UsersProducts::extendEndDays current access_end_date=" . $accessEndDate);
			  $date = new DateTime($accessEndDate);
			  $date->modify('+1 day');
			  $accessEndDate =  $date->format("Y-m-d");
			  $userProduct->setAccess_end_date($accessEndDate);
			  //logToFile("Dap_UsersProducts::extendEndDays extended access_end_date=" . $accessEndDate);
			  $userProduct->update();	  
			  //comment out extend_days
			}*/
			
			global $includeList;
			global $classname;
			
			$includeList = array();
			$classname = array();
			
			registeredPlugins($includeList, $email, "Add", $product);
			
			foreach ($includeList as $key => $value) {
				
				logToFile( "Dap_UsersProducts.class.php: addUsersProducts(): INCLUDELIST=" . $key . ", Value=" . $value );
				
				if (stristr($value, "vbulletin")) {
					//nothing to do yet.. wait till all chaining rules are done for final list of valid products for user		
				}
				else {
					$notify=true;
					if(defined('PLUGIN_NOTIFY_UPON_DOUBLE_OPT_IN')) {
						if($product->getAllow_free_signup() == "Y") {
							if( ($product->getDouble_optin_subject() != "") && ($product->getDouble_optin_body() != "") ) {
								$notify=false;
								logToFile( "Dap_UsersProducts.class.php: addUsersProducts(): trigger plugin notification upon activation" );		
							}
						}
					}
					if($notify) {
						Dap_UsersProducts::pluginAdd($userId, $productId, $value, $product);
					}
				}
				
			} // for include_list
			
			$notify = true;			
			if(defined('PLUGIN_NOTIFY_UPON_DOUBLE_OPT_IN')) {
				if($product->getAllow_free_signup() == "Y") {
					if( ($product->getDouble_optin_subject() != "") && ($product->getDouble_optin_body() != "") ) {
						$notify=false;
						logToFile( "Dap_UsersProducts.class.php: addUsersProducts(): trigger DapAUtomation upon activation" );		
					}
				}
			}
			if($notify){
				logToFile("(Dap_UsersProducts.addUsersProducts()) going to call the automation function",LOG_DEBUG_DAP);
				/* This function is for implementing the automation rules */
				try{
					Dap_UsersProducts::DAPApplyAutomationRules($productId,$userId,$product,"add");
				}
				catch(Exception $e){
					logToFile("(Dap_UsersProducts.addUsersProducts()),Automation Exception is ".$e->getMessage(),LOG_DEBUG_DAP);
				}
			}
			else{
				logToFile( "Dap_UsersProducts.class.php: addUsersProducts(): trigger DapAUtomation upon activation" );	
			}
			
			logToFile("Dap_UsersProducts.class.php: addUsersProducts(): EXITING", LOG_INFO_DAP);
			
		}// else
		
		$sourceAction="AT";
		$productChainingList = Dap_ProductChaining::loadChainedProductsByProductId($productId, $sourceAction);
		
	
		foreach ($productChainingList as $chainedProductArray) { 
			logToFile("Dap_UsersProducts.addUsersProducts(): source_operation=" . $chainedProductArray["source_operation"],LOG_INFO_DAP);
			logToFile("source_product_id=" . $chainedProductArray["source_product_id"],LOG_INFO_DAP);
			logToFile("target_operation=" . $chainedProductArray["target_operation"],LOG_INFO_DAP);
			logToFile("target_product_id=" . $chainedProductArray["target_product_id"],LOG_INFO_DAP);
			logToFile("add_days=" . $chainedProductArray["add_days"],LOG_INFO_DAP);
			
			$chainedProduct = $chainedProductArray["target_product_id"];
						
			$product = Dap_Product::loadProduct($chainedProduct);		
			//check if product exists
			if(!isset($product)) {
				logToFile("(Dap_UsersProducts.addUsersProducts()) chained productId=" . $chainedProduct . " does not exist");
				continue;
			}
			
			$targetAction =  $chainedProductArray["target_operation"];
			$transId =  $chainedProductArray["transaction_id"];
			$addDays =  $chainedProductArray["add_days"];
			$future_access_date = $chainedProductArray["future_access_date"];
			$send_welcome_email = $chainedProductArray["send_welcome_email"];
			$payment_processor_action = $chainedProductArray["payment_processor_action"];
			
			logToFile("future_access_date=" . $chainedProductArray["future_access_date"],LOG_INFO_DAP);
			logToFile("send_welcome_email=" . $chainedProductArray["send_welcome_email"],LOG_INFO_DAP);
			
			if($userId == "on"){
			   break;
			}
			$dapuser = Dap_User::loadUserById($userId);
			$hasAccess = $dapuser->hasEverHadAccessTo($chainedProduct);
		
			if ($targetAction == "A") {
				
				if ($hasAccess) {
					$userProduct = Dap_UsersProducts::load($userId, $chainedProduct);
					if($userProduct != NULL) {
						logToFile("(Dap_UsersProducts.addUsersProducts()) active chained usersproducts name: ".$product->getName());
						logToFile("(Dap_UsersProducts.addUsersProducts()) active chained usersproducts isrecurring: ".$product->getIs_recurring());
						//we have existing users-products relationship, so we need to modify this.
						$userProduct->setTransaction_id($transId);
						$userProduct->setStatus("A");		
						
						//lets check if this is recurring
						if(strtolower($product->getIs_recurring()) == "y") {
							//this is recurring so lets adjust end date
							//TODO: calculate what recurring cycle we are in.
							//get current active days
							logToFile("(Dap_UsersProducts.addUsersProducts()) active Days: ".$active_days);
							$active_days = $userProduct->getActiveDays();
							logToFile("(Dap_UsersProducts.addUsersProducts()) active Days: ".$active_days);
							//Took the negative -1 
							$extend_days = $product->deriveRecurringDaysFromTotal($active_days) ; //$product->getRecurring_cycle_1() - 1;
							$extend_days= $extend_days+1;
							$userProduct->extendEndDays($extend_days);		
						} else {
							$extend_days = $product->getRecurring_cycle_1();
							if( is_null($extend_days) || ($extend_days == 0) || ($extend_days == "") || ($extend_days == "9999") ) {
								$userProduct->deriveAccessEndDate(-1);
							} else {
								//logToFile("New extend_days in addUserToProduct: $extend_days"); 
								$userProduct->extendEndDays($extend_days);
								//$userProduct->setAccess_end_date("9999-12-31");
							}
						}
					    $userProduct->setRedeem_type($redeem_type);
						$userProduct->update();
						
						//$userProduct->adjustUserResourceClickCounts(true);
					}
				}
				else {
					
					logToFile("(Dap_UsersProducts.addUsersProducts()) current access start=" . $accessStartDate);
					
					$date = new DateTime();
					
					if($future_access_date != "" && $future_access_date != "0000-00-00 00:00:00" && $future_access_date != "2000-01-01 00:00:00"){
						logToFile("(Dap_UsersProducts.addUsersProducts()) future access date is set so add this date as access start date" );
						$accessStartDate = $future_access_date;
					}
					else{
						logToFile("(Dap_UsersProducts.addUsersProducts()) future access date is not set so add days" );
						$date->modify("+".$addDays." day");
						$future_access_date = $accessStartDate = $date->format("Y-m-d");
					}
					
					logToFile("(Dap_UsersProducts.addUsersProducts()) updated access start=" . $accessStartDate);
					
					Dap_UsersProducts::addProductToUser($userId, $product, $chainedProduct, $transId, $accessStartDate,"","",$send_welcome_email,$addDays,$future_access_date,$redeem_type);
					/*
					if(strtolower($product->getIs_recurring()) == "y") {
						
					  $userProduct = Dap_UsersProducts::load($userId, $chainedProduct);
					  $accessEndDate=$userProduct->getAccess_end_date();
					  //logToFile("Dap_UsersProducts::extendEndDays current access_end_date=" . $accessEndDate);
					  $date = new DateTime($accessEndDate);
					  $date->modify('+1 day');
					  $accessEndDate =  $date->format("Y-m-d");
					  $userProduct->setAccess_end_date($accessEndDate);
					  //logToFile("Dap_UsersProducts::extendEndDays extended access_end_date=" . $accessEndDate);
					  $userProduct->update();	
					}*/
					
					// call 3rd party plugins that's configued under every individual chained product being added to main product.
					global $includeList;
					global $classname;
					$includeList = array();
					$classname = array();
					registeredPlugins($includeList, $email, "Add", $product);
					
					foreach ($includeList as $key => $value) {
						logToFile( "Dap_UsersProducts.class.php: addUsersProducts(): INCLUDELIST=" . $key . ", Value=" . $value );
						if (strstr($value, "vbulletin") != FALSE) { }
						else { 
  						  logToFile( "Dap_UsersProducts.class.php: call pluginAdd()");
						  Dap_UsersProducts::pluginAdd($userId, $chainedProduct, $value, $product);
						}
					}
					
					try{
						Dap_UsersProducts::DAPApplyAutomationRules($chainedProduct,$userId,$product,"add");
					}
					catch(Exception $e){
						logToFile("(Dap_UsersProducts.addUsersProducts()),chained product automation exception is ".$e->getMessage(),LOG_DEBUG_DAP);
					}
					
					logToFile("(Dap_UsersProducts.addUsersProducts()) adding chained productId=" . $chainedProduct);
				}
			}
			else if ($targetAction == "R") {
			  $complete="Y";	
			  
			  if ($hasAccess) {
				  
				  if($addDays == -1) {
					  logToFile("(Dap_UsersProducts.addUsersProducts()) updated upgraded products access start to match the access start of product being removed, addDays=" . $addDays);
					  $userProduct = Dap_UsersProducts::load($userId, $chainedProduct);
					  $accessStartDate = 	$userProduct->getAccess_start_date();
					  
					  $userProduct = Dap_UsersProducts::load($userId, $productId);
					  if($userProduct != NULL) {
						  $userProduct->setAccess_start_date($accessStartDate);
						  $userProduct->setRedeem_type($redeem_type);
						  $userProduct->update();
						  logToFile("(Dap_UsersProducts.addUsersProducts()) updated upgraded products access start to match the access start of product being removed, productId=" . $productId);
					  }
				  }
				  Dap_UsersProducts::removeProductFromUser ($userId, $chainedProduct, $transId, $complete, $dap_dbh);
			      //  call 3rd party plugins that's configued under every individual chained product being added to main product.
				  global $includeList;
				  global $classname;
				  $includeList = array();
				  $classname = array();
				  registeredPlugins($includeList, $email, "Remove", $product);
				  foreach ($includeList as $key => $value) {
					  logToFile( "Dap_UsersProducts.class.php: addUsersProducts(): INCLUDELIST=" . $key . ", Value=" . $value );
					  if (strstr($value, "vbulletin") != FALSE) { }
					  else { 
						Dap_UsersProducts::pluginRemove($userId, $chainedProduct, $value, $product, $productId);
					  }
				  }
				  
				  try{
						Dap_UsersProducts::DAPApplyAutomationRules($chainedProduct,$userId,$product,"remove");
				  }
				  catch(Exception $e){
					  logToFile("(Dap_UsersProducts.addUsersProducts()),removing chained product automation exception is ".$e->getMessage(),LOG_DEBUG_DAP);
				  }
					
					
				  logToFile("(Dap_UsersProducts.addUsersProducts()) removing chained productId=" . $chainedProduct . " from the main product=" . $productId);
				  logToFile("(Dap_UsersProducts,addUsersProducts()),payment_processor_action ". $payment_processor_action,LOG_DEBUG_DAP);
					if($payment_processor_action == 'R'){
						logToFile("(Dap_UsersProducts,addUsersProducts()),payment_processor_action ". $payment_processor_action,LOG_DEBUG_DAP);
						  Dap_UsersProducts::DAPCancelSubscriptionInPaymentGateway($chainedProduct,$userId);
					}
			  }
			   
			}
			
		}
			
		global $includeList;
		global $classname;
		
		$includeList = array();
		$classname = array();
		
		logToFile( "Dap_UsersProducts.class.php: addUsersProducts(): READY FOR VB, productName=" . $product->getName());
		
		registeredPlugins($includeList, $email, "Add", $product);
		foreach ($includeList as $key => $value) {
			
			logToFile( "Dap_UsersProducts.class.php: addUsersProducts(): INCLUDELIST=" . $key . ", Value=" . $value );
			
			if (stristr($value, "vbulletin")) {
				logToFile( "Dap_UsersProducts.class.php: addUsersProducts(): VALUE is =" . $value );
				if (AUTO_CREATE_VB_ACCOUNT_UPON_DAP_REG == "Y") {
					
					logToFile( "Dap_UsersProducts.class.php: addUsersProducts(): Key=" . $key . ", Value=" . $value );
					
					include_once ($value);
					$forum = new Dap_Vbulletin();
					$errmsg = $forum->syncUser($userId, $productId);
					
					if ($errmsg != NULL) {
						$str = "Dap_UsersProducts.class.php: addUserToProduct(): Forum Reg Failed. " . $errmsg; 
						logToFile($str,LOG_INFO_DAP);
						sendAdminEmail("Dap_UsersProducts.class.php: addUsersProducts(): could not register to the vB forum", $str);
					}
					else {
						$dapuser = Dap_User::loadUserById($userId);
						$username = trim($dapuser->getUser_name());
						
						
						//Update username in dap_user if the username was registered to vB successfully and it's not already populated in DAP
						if ((!isset($username)) || ($username=="") || (strcmp($username,"") == 0)) {
							logToFile("User: " . $username . " in DAP",LOG_INFO_DAP);
							$user = new Dap_User();
							$user->setId($userId);
							logToFile("Userid set",LOG_INFO_DAP);
							//$user->setUser_name($dapuser->getFirst_name().$dapuser->getLast_name());
							//logToFile("username set",LOG_INFO_DAP);
							$uname=generateUsername("Dap_UsersProducts.class.php.addUsersProducts()",$dapuser->getEmail(),$dapuser->getFirst_name(),$dapuser->getLast_name());
							$user->setUser_name($uname);
							logToFile("Dap_UsersProducts.class.php: addUsersProducts(): username set to ".$uname,LOG_INFO_DAP);
							$user->setFirst_name($dapuser->getFirst_name());
							$user->setLast_name($dapuser->getLast_name());
							logToFile("firstname and lastname set",LOG_INFO_DAP);
							$user->setEmail($dapuser->getEmail());
							$user->setPassword($dapuser->getPassword());
							$user->setAddress1($dapuser->getAddress1());
							$user->setAddress2($dapuser->getAddress2());
							$user->setCity($dapuser->getCity());
							$user->setState($dapuser->getState());
							$user->setZip($dapuser->getZip());
							$user->setCountry($dapuser->getCountry());
							$user->setPhone($dapuser->getPhone());
							$user->setFax($dapuser->getFax());
							$user->setCompany($dapuser->getCompany());
							$user->setTitle($dapuser->getTitle());
							$user->setStatus($dapuser->getStatus());
							$user->setAccount_type($dapuser->getAccount_type());
							logToFile("account set",LOG_INFO_DAP);
							$user->setPaypal_email( $dapuser->getPaypal_email() );	
							//$user->setCredits_earned( $dapuser->getCredits_earned() );	
							$user->setCredits_available( $dapuser->getCredits_available() );	
							
							$user->setPaypal_email( $dapuser->getPaypal_email() );	
							
							logToFile("Ready to update user",LOG_INFO_DAP);
							try {
								$user->update();
								$response = "SUCCESS! User has been successfully updated.";
								logToFile("User: " . $username . " successfully added to DAP",LOG_INFO_DAP);
							} catch (PDOException $e) {
								$response = ERROR_GENERAL;
								logToFile("User: " . $username . " could not be added:  Exception: " . $response,LOG_INFO_DAP);
								sendAdminEmail("Dap_UsersProducts.addUsersProducts(): could not add username=" . $username, $response);
							} catch (Exception $e) {
								$response = ERROR_GENERAL;
								logToFile("User: " . $username . " could not be added:  Exception: " . $response,LOG_INFO_DAP);
								sendAdminEmail("Dap_UsersProducts.addUsersProducts(): could not add username=" . $username, $response);
							}
						}
					}
				} //End if AUTO_CREATE_VB_ACCOUNT_UPON_DAP_REG
			}
		} //for
 		
		logToFile("Dap_UsersProducts.addUsersProducts(): load before exit: userId=".$userId . ", productId=" . $productId,LOG_DEBUG_DAP); 
		
		$userProduct = Dap_UsersProducts::load($userId, $productId);
		$product = Dap_Product::loadProduct($productId);
		
		if(isset($userProduct)) {
		  logToFile("Dap_UsersProducts.addUsersProducts(): USERPROUCTSTATUS=" . $userProduct->getStatus(),LOG_DEBUG_DAP); 
		}
	
		 /*check if product is in points table for gameofpoints*/
		$points ="";
		$type ="";

		$getAllow_free_signup = $product->getAllow_free_signup();
		$getIs_free_product = $product->getIs_free_product();
		$recurr_prod = $product->getIs_recurring();
		$double_optin_sub = $product->getDouble_optin_subject();
		$double_optin_body = $product->getDouble_optin_body();
		$givePoints = checkForRegisterAndPurchaseAndRecurring($cs_first_payment, $productId, $userId, $getIs_free_product, $getAllow_free_signup, $double_optin_sub,$double_optin_body,$recurr_prod,$recurring);				 
		
		logToFile("Dap_UsersProducts.addUsersProducts(): calling checkForRegisterAndPurchaseAndRecurring() to see if points assigned for these actions.".$type, LOG_DEBUG_DAP);  
		
		$explodepoints = explode("||",$givePoints);
		$points =	$explodepoints[0];
		$type =	$explodepoints[1];
		
		if($type=="") 
			logToFile("Dap_UsersProducts.addUsersProducts(): no entry found for these actions (type is empty)... do not award points.", LOG_DEBUG_DAP);  
		
		if($points=="") 
			logToFile("Dap_UsersProducts.addUsersProducts(): points is empty. No rules found  in action table... do not award points", LOG_DEBUG_DAP);  
		
		if($points >= 0 && $type !=""){ 
			//add to  User Credits table function			
			
			logToFile("Dap_UsersProducts.addUsersProducts(): calling addUserCredits() to award points. Action=" . $type . " and Points=". $points, LOG_DEBUG_DAP);  
			addUserCredits($type, $productId, $userId, "", "","");
			
		}else
		  if ( isset($userProduct) && ($userProduct->getStatus() == "A") && ($product->getCredits() > 0) && (($product->getIs_master() == "Y") || (($product->getSelf_service_allowed() == "Y") && ($product->getIs_master() == "N"))) && ($addCredits != "N")) {
		   
		  //SSS
		  logToFile("Dap_UsersProducts.addUsersProducts(): SSS: recurring=".$recurring,LOG_DEBUG_DAP); 
		  $productId=$product->getId();
		  $isSSSMaster=$product->getIs_master();
		  
		  if( strtolower($product->getIs_recurring()) != "y") {
			 if($product->getAllow_free_signup() != "Y") {
			   $credits=$product->getCredits();
			   logToFile("Dap_UsersProducts.addUsersProducts(): SSS: recurring=".$recurring . ", credits=".$credits,LOG_DEBUG_DAP); 
			 }
			 else {
				//free product, only give credits if not double opt-in, if double-optin, credit shd be at activation only (activate())
				if( ($product->getDouble_optin_subject() == "") && ($product->getDouble_optin_body() == "") ) {
					if ($recurring == "N") {
						logToFile("Dap_UsersProducts.addUsersProducts(): SSS: recurring=".$recurring . ", doubltoptin=N, free signup=Y, addign firsttime allow",LOG_DEBUG_DAP); 
						$credits=$product->getCredits();
					}
					else {
						logToFile("Dap_UsersProducts.addUsersProducts(): SSS: recurring=".$recurring . ", doubltoptin=Y, free signup=Y, addign not the firsttime, dont allow",LOG_DEBUG_DAP); 
					}
				}
				else {
					logToFile("Dap_UsersProducts.addUsersProducts(): SSS: DOUBLE OPTIN, free prodcut: credits assigned during activation",LOG_DEBUG_DAP); 
				}
			 }
			 	
		  }
		  else if ($recurring == "N") { //first time adding user to recurring product 
			$credits=$product->getCredits();
		  }
		  else { //recurring payment, user already exists
			if( strtolower($product->getIs_recurring()) == "y") {
			  if($product->getAllow_free_signup() != "Y")	{
			 	 $credits=$product->getRecurringCredits();
			  }
			  else {
				  logToFile("Dap_UsersProducts.addUsersProducts(): SSS: recurring product, free product: not adding for first time",LOG_DEBUG_DAP); 
			  }
			}
			else {
			  logToFile("Dap_UsersProducts.addUsersProducts(): SSS: it's a recurring payment for a non-recurring product (free product), no credits assigned. Looks like same user is trying to re-sign for the free product to earn credits. To prevent free product/signup abuse, no credits assigned",LOG_DEBUG_DAP); 
			}
		  }
		  
		  
		  if(($credits > 0) || (($product->getSelf_service_allowed() == "Y") && ($product->getIs_master() == "N"))) {
			if($product->getIs_master() == "Y") {
				
			  logToFile("Dap_UsersProducts.addUsersProducts(): master product, assign recurring credits",LOG_DEBUG_DAP); 	
			  if($transId>0) {
				$accesshow="Master Purchased Via Payment";
				
				$messagebody = "Assign Credits = " . $credits . " . Recurring payment received for  userId=" . $userId . " and product = " . $productId . ". Going to add credits";
				logToFile("Dap_UsersProducts.addUsersProducts: assign credits " . $messagebody, LOG_DEBUG_DAP);
				sendAdminEmail("Assign Recurring Credits to User=" . $userId, $messagebody);
			
			  	Dap_UserCredits::addCredits($userId, $productId, $transId, $credits, 0, $accesshow);
			  }
			  else {
				$accesshow="Admin Added-Master";
				
				logToFile("Dap_UsersProducts.addUsersProducts(): SSS: adding child, credits added to total",LOG_DEBUG_DAP); 
			  	Dap_UserCredits::addCredits($userId, $productId, $transId, $credits, 0, $accesshow);
			  }
			  
			  
			} else {
			  logToFile("Dap_UsersProducts.addUsersProducts(): SSS: adding child, credits added to total, transId=".$transId,LOG_DEBUG_DAP); 
			  
			  if(($product->getSelf_service_allowed() == "Y") && ($product->getIs_master() == "N")) {
			  	$credits=0;
			  	logToFile("Dap_UsersProducts.addUsersProducts():set SSS:credits=".$credits,LOG_DEBUG_DAP); 
			  }
			  
			  if($transId>0) {
			  	Dap_UserCredits::redeemCreditsAtProductLevel($userId, $productId, $credits, "Child Purchased Via Payment");
				$accesshow="Child Purchased Via Payment";
			  }
			  else {
				Dap_UserCredits::redeemCreditsAtProductLevel($userId, $productId, $credits, "Admin Added-Manual");
				$accesshow="Admin Added-Child";
			  }
			  
			  $UserResources = Dap_FileResource::loadFileResourcesSSS($userId, $productId);
			  foreach( $UserResources as $resource ) {
				 logToFile("Dap_UsersProducts.addUsersProducts(): SSS: purchased full product,add individual resources in usercredits: productId: " . $productId, LOG_DEBUG_DAP);
				 logToFile("Dap_UsersProducts.addUsersProducts(): SSS: purchased full product,add individual resources in usercredits: resourceId: " .$resource['id'], LOG_DEBUG_DAP);
				 logToFile("Dap_UsersProducts.addUsersProducts(): SSS: purchased full product,add individual resources in usercredits: Credits: " . $resource['credits_assigned'], LOG_DEBUG_DAP);
				 $resId = $resource["id"];
				 if(($product->getSelf_service_allowed() == "Y") && ($product->getIs_master() == "N")) {
				  	$resource['credits_assigned']=0;
					logToFile("Dap_UsersProducts.addUsersProducts():set SSS:resource credits=".$resource['credits_assigned'],LOG_DEBUG_DAP); 
				 }
				 Dap_UserCredits::redeemCredits($userId, $productId, $resId, $resource['credits_assigned'], $accesshow);
			   }

			}
			/*else {
			  logToFile("Dap_UsersProducts.addUsersProducts(): SSS: addign child, credits deducted from total",LOG_DEBUG_DAP); 
			  Dap_UserCredits::redeemCreditsAtProductLevel($userId, $productId, $credits, "Admin gave access in users->manage");
			  if ($credits != 0) {
				$user = Dap_User::loadUserById($userId); 
				logToFile("In addCredits UPDATE CREDITS=".$credits,LOG_DEBUG_DAP); 

				$user->updateCredits(0,-$credits);
			  }
			
			}*/
		  }
		}
		
		logToFile("(Dap_UsersProducts.addUsersProducts()) SUCCESS");
		
		return $userProduct;				
	}
	
	public static function addProductToUser ($userId, $product, $productId, $transId, $accessStartDate, $coupon_id="", $accessEndDate="",$send_welcome_email = "",$addDays="",$future_start_date="",$redeem_type = '') {
		$userProduct = new Dap_UsersProducts();
		$userProduct->setUser_id($userId);
		$userProduct->setProduct_id($productId);
		$userProduct->setTransaction_id($transId);
		$userProduct->setCoupon_id($coupon_id);
		
		logToFile("(Dap_UsersProducts.addProductToUser()) redeem_type=".$redeem_type);
		logToFile("(Dap_UsersProducts.addProductToUser()) couponId=".$coupon_id);
		logToFile("(Dap_UsersProducts.addProductToUser()) accessEndDate=".$accessEndDate);
		logToFile("(Dap_UsersProducts.addProductToUser()) future_start_date=".$future_start_date);
		
		//$userProduct->setStatus("A");
		$userProduct->setAccess_start_date($accessStartDate);
		
		// we dont have existing users-products relationship, so we need to insert.
		//insert this thing into dap_users_products_jn
		//lets check if this is recurring
		
		if ($accessEndDate != "") {
			logToFile("(Dap_UsersProducts.addProductToUser()) SET accessEndDate=".$accessEndDate);
			$userProduct->setAccess_end_date($accessEndDate);	
		}
		else {
			if(strtolower($product->getIs_recurring()) == "y") {
				//this is recurring so lets adjust end date
				//This is new user/product association, so take recurring cycle 1
				$active_days = 0;
				$extend_days = $product->deriveRecurringDaysFromTotal($active_days) - 1 ; //$product->getRecurring_cycle_1() - 1;
				$extend_days= $extend_days+1;
				$userProduct->deriveAccessEndDate($extend_days);
			} else {
				//this is not recurring, so just update enddate to recurring cycle 1 - previously was set to 9999-12-31
				//$userProduct->deriveAccessEndDate(-1);
				$extend_days = $product->getRecurring_cycle_1();
				if( is_null($extend_days) || ($extend_days == 0) || ($extend_days == "") || ($extend_days == "9999") ) {
					  $userProduct->deriveAccessEndDate(-1);
				} else {
					//logToFile("New extend_days in addUserToProduct: $extend_days");
					$userProduct->extendEndDays($extend_days,$future_start_date);
					//$userProduct->setAccess_end_date("9999-12-31");
				}
			}
		}
		logToFile("(Dap_UsersProducts.userproduct create");
		$userProduct->setRedeem_type($redeem_type);
		$userProduct->create(NULL,$send_welcome_email); 
		
		$userProduct->adjustUserResourceClickCounts(true);
		//TODO send email communication to a) user, external systems on this successful create	
		sendUserProductNE($userProduct->getUser_id(), $product);
		
		return;
	}
	
	public static function pluginAdd($userId, $productId, $value, $product, $sourceProductId="") {
		logToFile("Dap_UsersProducts.class.php: in pluginAdd()", LOG_INFO_DAP);
		
		/* First of all going to check the GDPR data */
		
		$GDPRdata = self::DAPcheckGDPRrules($userId);

		if(isset($GDPRdata['applyautomation']) && $GDPRdata['applyautomation'] == "no"){
			logToFile("(Dap_UsersProducts,pluginAdd()), GDPR rules dont allow to send data. So dont apply pluginAdd().",LOG_DEBUG_DAP);
			return;
		}
		 
		$params = explode(":",$value); 
		
		logToFile("Dap_UsersProducts.class.php: pluginAdd(): params = " . $value, LOG_INFO_DAP);
		
		/* Going to append GDPR tags with the normal tags in each automation action */
		if($GDPRdata['gdprtag'] != ""){
			logToFile("(Dap_UsersProducts,pluginAdd()), GDPR tags are available so append them to string",LOG_DEBUG_DAP);
			
			if($params[0] == "activecampaign"){
				$tags = $params[5].",".$GDPRdata['gdprtag'];
				$value = "activecampaign:".$params[1].":".$params[2].":".$params[3].":".$params[4].":".$tags.":".$params[6].":".$params[7].":".$params[8];
			}
			else if($params[0] == "convertkit"){
				$value = $value.",".$GDPRdata['gdprtag']; //doing this because tags param is at the end.	
			}
			else if($params[0] == "drip"){
				// in case of drip , in old plugin notifications, we used to send tags with | separated
				if (strpos($params[4], '|') !== false) {
					$value = $value."|".$GDPRdata['gdprtag']; //doing this because tags param is at the end.
				}
				else{
					$value = $value.",".$GDPRdata['gdprtag']; //doing this because tags param is at the end.
				}
				
			}
			else if($params[0] == "aweber"){
				$tags = $params[3].",".$GDPRdata['gdprtag'];
				$value = "aweber:".$params[1].":".$params[2].":".$tags.":".$params[4];
			}
			logToFile("(Dap_UsersProducts,pluginAdd()), notification string after GDPR tags is ".$value,LOG_DEBUG_DAP);
		}

		
		
		$className = $params[0];
		$lldocroot = defined('SITEROOT') ? SITEROOT : $_SERVER['DOCUMENT_ROOT'];
		$filename = $lldocroot . "/dap/plugins/" . $className . "/" . $className . ".class.php";
		//$filename = $lldocroot . "/dap/plugins/" . "plugins/vbulletin/Dap_VBulletin.class.php";
		logToFile("Dap_UsersProducts.class.php: pluginAdd(): filename = " . $filename, LOG_INFO_DAP);
		
		include_once ($filename);
						
		//$name = "Dap_VBulletin.class.php";
		try {
					
			$plugin=new $className();
			logToFile("Dap_UsersProducts.class.php:  pluginAdd(): NAME = " . $className, LOG_INFO_DAP);
			
		} catch (Exception $e) {
			$response = ERROR_GENERAL;
			logToFile("Exception=" . $e->getMessage(),LOG_FATAL_DAP);
			
		}
		//$classname = new $name();
		
		logToFile("Dap_UsersProducts.class.php:  pluginAdd(): calling register()", LOG_INFO_DAP);
		
			  
	  logToFile("(Dap_UsersProducts.pluginAdd(): calling register(): classname= $className", LOG_INFO_DAP);
	  logToFile("(Dap_UsersProducts.pluginAdd(): calling register(): sourceProductId = $sourceProductId", LOG_INFO_DAP);
	  logToFile("(Dap_UsersProducts.pluginAdd(): calling register(): productId = $productId", LOG_INFO_DAP);
	  if( ($className=="getresponse") && ($sourceProductId != "")) {
	    logToFile("(Dap_UsersProducts.pluginAdd(): calling register(): getresponse()", LOG_INFO_DAP);
		$errmsg = $plugin->register($userId, $productId, $value, $sourceProductId);
	  }
	  else
		$errmsg = $plugin->register($userId, $productId, $value);
		
		logToFile("Dap_UsersProducts.class.php:  pluginAdd(): called register()", LOG_INFO_DAP);
		
		if ($errmsg != 0) {		
			$str = "Dap_UsersProducts.class.php:  pluginAdd(): for plugin= " . $value . " failed with " . $errmsg; 
			logToFile($str,LOG_INFO_DAP);
			sendAdminEmail("Dap_UsersProducts.class.php: pluginAdd(): could not subscribe to the plugin=" . $filename, $str);
		}
		else {
			logToFile("Dap_UsersProducts.class.php:  pluginAdd(): registration completed successfully", LOG_INFO_DAP);
		}
	}
	
	//decrement and/or remove users products relationship.
	//TODO: should we return UsersProducts data back to the caller ?
	public static function removeUsersProducts($userId, $productId, $transId='-1', $complete = FALSE, $dap_dbh=NULL, $accessStartDate='') {
		$sourceAction="RF";
		$productChainingList = Dap_ProductChaining::loadChainedProductsByProductId($productId, $sourceAction);
		logToFile("(Dap_UsersProducts.removeUsersProducts()) complete=" . $complete);
		
		foreach ($productChainingList as $chainedProductArray) { 
			logToFile("(Dap_UsersProducts.removeUsersProducts()) - list chainedproduct");
			$chainedProduct = $chainedProductArray["target_product_id"];
			$product = Dap_Product::loadProduct($chainedProduct);		
			//check if product exists
			if(!isset($product)) {
				logToFile("(Dap_UsersProducts.removeUsersProducts()) chained productId=" . $chainedProduct . " does not exist");
				continue;
			}
			
			$targetAction =  $chainedProductArray["target_operation"];
			$transactionId =  $chainedProductArray["transaction_id"];
			$addDays = $chainedProductArray["add_days"];
			$setComplete = "Y";
			
			$dapuser = Dap_User::loadUserById($userId);
			$hasAccess = $dapuser->hasAccessTo($chainedProduct);
			
			if($accessStartDate == '') {
				$accessStartDate = date("Y-m-d");
			}
			$added=false;	
			if ($targetAction == "A") { 
				$added=true;
				if ($hasAccess) {
					$userProduct = Dap_UsersProducts::load($userId, $chainedProduct);
					if($userProduct != NULL) {
						logToFile("(Dap_UsersProducts.removeUsersProducts()) active chained usersproducts name: ".$product->getName());
						logToFile("(Dap_UsersProducts.removeUsersProducts()) active chained usersproducts isrecurring: ".$product->getIs_recurring());
						
						logToFile("(Dap_UsersProducts.removeUsersProducts()) transId: ".$transId);
						//we have existing users-products relationship, so we need to modify this.
						$userProduct->setTransaction_id($transId);
						$userProduct->setStatus("A");		
						
						//lets check if this is recurring
						if(strtolower($product->getIs_recurring()) == "y") {
							//this is recurring so lets adjust end date
							//TODO: calculate what recurring cycle we are in.
							//get current active days
							logToFile("(Dap_UsersProducts.removeUsersProducts()) active Days: ".$active_days);
							$active_days = $userProduct->getActiveDays();
							logToFile("(Dap_UsersProducts.removeUsersProducts()) active Days: ".$active_days);
							//Took the negative -1 
							$extend_days = $product->deriveRecurringDaysFromTotal($active_days) ; //$product->getRecurring_cycle_1() - 1;
							$userProduct->extendEndDays($extend_days);		
						} else {
							$extend_days = $product->getRecurring_cycle_1();
				  			if( is_null($extend_days) || ($extend_days == 0) || ($extend_days == "") || ($extend_days == "9999") ) {
								$userProduct->deriveAccessEndDate(-1);
							} else {
								//logToFile("New extend_days in addUserToProduct: $extend_days"); 
								$userProduct->extendEndDays($extend_days);
								//$userProduct->setAccess_end_date("9999-12-31");
							}
						}
						//logToFile("(Dap_UsersProducts.removeUsersProducts()) call update()");
						$userProduct->update();
						//logToFile("(Dap_UsersProducts.removeUsersProducts())  update()");
						//$userProduct->adjustUserResourceClickCounts(true);
					}
				}
				else {
					logToFile("(Dap_UsersProducts.removeUsersProducts()) current access start=" . $accessStartDate);
					
					$date = new DateTime($accessStartDate);
					$date->modify("+".$addDays." day");
					$accessStartDate = $date->format("Y-m-d");	
					logToFile("(Dap_UsersProducts.removeUsersProducts()) updated access start=" . $accessStartDate);
					
					Dap_UsersProducts::addProductToUser($userId, $product, $chainedProduct, $transactionId, $accessStartDate);
					
					$includeList = array();
					$product = Dap_Product::loadProduct($chainedProduct);		
					registeredPlugins($includeList, $email, "Add", $product);
					$dapuser = Dap_User::loadUserById($userId);
					foreach ($includeList as $key => $value) {
						if (strstr($value, "vbulletin") != FALSE) {
						}
						else {
							logToFile("(Dap_UsersProducts.removeUsersProducts()): call pluginAdd(): chainedProduct=" . $chainedProduct);
							Dap_UsersProducts::pluginAdd($userId, $productId, $value, $product, $chainedProduct);
						}
					} // foreach includeList
					$added=true;	
					logToFile("(Dap_UsersProducts.removeUsersProducts()) adding chained productId=" . $chainedProduct);
					
					try{
						Dap_UsersProducts::DAPApplyAutomationRules($chainedProduct,$userId,$product,"add");
					}
					catch(Exception $e){
						logToFile("(Dap_UsersProducts.addUsersProducts()),removing chained product automation exception is ".$e->getMessage(),LOG_DEBUG_DAP);
					}	
				}
			}
			else if ($targetAction == "R") {
				if ($hasAccess) {
					
					Dap_UsersProducts::removeProductFromUser ($userId, $chainedProduct, $transId, $setComplete, $dap_dbh);
					logToFile("(Dap_UsersProducts.removeUsersProducts()) removing chained productId=" . $chainedProduct . " from the main product=" . $productId);	
					$includeList = array();
					$product = Dap_Product::loadProduct($chainedProduct);		
					registeredPlugins($includeList, $email, "Remove", $product);
					$dapuser = Dap_User::loadUserById($userId);
					foreach ($includeList as $key => $value) {
						if (strstr($value, "vbulletin") != FALSE) {
						}
						else {
							logToFile("(Dap_UsersProducts.removeUsersProducts()) call pluginRemove1()");	
							Dap_UsersProducts::pluginRemove($userId, $productId, $value, $product);
						}
					} // foreach includeList	
					
					try{
						Dap_UsersProducts::DAPApplyAutomationRules($productId,$userId,$product,"remove");
    				  }
    				  catch(Exception $e){
    					  logToFile("(Dap_UsersProducts.addUsersProducts()),removing chained product automation exception is ".$e->getMessage(),LOG_DEBUG_DAP);
    				  }
				}
			}
			
		}
		
		$includeList = array();
		$product = Dap_Product::loadProduct($productId);		
		registeredPlugins($includeList, $email, "Remove", $product);
		$dapuser = Dap_User::loadUserById($userId);
		
		foreach ($includeList as $key => $value) {
			if (strstr($value, "vbulletin") != FALSE) {
			
				// call VB after the product is removed from the user			
			}
			else if (strstr($value, "getresponse") != FALSE) {
			
				// call VB after the product is removed from the user	
				if($added==false)  // if added is true, chaining would have resulted in user move to right list
					Dap_UsersProducts::pluginRemove($userId, $productId, $value, $product,$added);
			}
			else {
				
				logToFile("(Dap_UsersProducts.removeUsersProducts()) call pluginRemove2()");
				
				Dap_UsersProducts::pluginRemove($userId, $productId, $value, $product,$added);
			}
						
		} // foreach includeList
		
		logToFile("(Dap_UsersProducts.removeUsersProducts()) removing main productId=" . $productId);
		
		/* Automation code for Remove product rules  */
					
		logToFile("(Dap_UsersProducts.removeUsersProducts()) going to call the automation function ",LOG_DEBUG_DAP);
		
		/* This function is for implementing the automation rules */
		try{
			Dap_UsersProducts::DAPApplyAutomationRules($productId,$userId,$product,"remove");
		}
		catch(Exception $e){
			logToFile("(Dap_UsersProducts.removeUsersProducts()),Automation Exception is ".$e->getMessage(),LOG_DEBUG_DAP);
		}
		
		
		// START - SSS credits remove for master.. add for child
		$product = Dap_Product::loadProduct($productId);
		$userProduct = Dap_UsersProducts::load($userId, $productId);
		$recurring="N";
		if($userProduct != NULL) {
			$recurring="Y";
		}
		//SSS
		/*if (($product->getCredits() > 0) && ($product->getSelf_service_allowed() == "Y")) {
		  logToFile("Dap_UsersProducts.removeUsersProducts(): SSS: recurring=".$recurring,LOG_DEBUG_DAP); 
		  $productId=$product->getId();
		  $isSSSMaster=$product->getIs_master();
		  
		  if($isSSSMaster == "Y") {
			$credits = Dap_UserCredits::getTotalCreditsEarnedForProduct($userId,$productId);
			$credits=-($credits);
			logToFile("Dap_UsersProducts.removeUsersProducts(): SSS: adding child, credits added to total=".$credits,LOG_DEBUG_DAP); 
			Dap_UserCredits::addCredits($userId, $productId, -1, $credits, 0, "By Purchase");
		  }
		  else {
			$credits = Dap_UserCredits::getTotalCreditsUsedToRedeemProduct($userId,$productId);
			logToFile("Dap_UsersProducts.removeUsersProducts(): SSS: addign child, credits deducted from total=".$credits,LOG_DEBUG_DAP); 
			Dap_UserCredits::addCredits($userId, $productId, -1, 0, $credits, "Admin removed access, add back credits");
		  }
		  
		}*/
		// DONE: SSS credits remove for master.. add for child
		
		
	//	logToFile("(Dap_UsersProducts.removeUsersProducts())++++++++1: userId " . $userId.', productId:'.$productId.', transId:'.$transId,', complete: '.$complete.', dap_dbh:'.$dap_dbh, LOG_DEBUG_DAP);
		logToFile("(Dap_UsersProducts.removeUsersProducts())++++++++3: complete ".$complete, LOG_DEBUG_DAP);
	//	logToFile("(Dap_UsersProducts.removeUsersProducts())++++++++4: dap_dbh:".$dap_dbh, LOG_DEBUG_DAP);
		Dap_UsersProducts::removeProductFromUser ($userId, $productId, $transId, $complete, $dap_dbh);
	
		//logToFile("(Dap_UsersProducts.removeUsersProducts())++++++++: userId " . $userId.', productId:'.$productId.', transId:'.$transId,', complete: '.$complete.', dap_dbh:'.$dap_dbh, LOG_DEBUG_DAP);
		
		foreach ($includeList as $key => $value) {
			if (strstr($value, "vbulletin") != FALSE) {
				logToFile( "Dap_UsersProducts.class.php: addUsersProducts(): VALUE is =" . $value );
				if (AUTO_CREATE_VB_ACCOUNT_UPON_DAP_REG == "Y") {
					logToFile( "Dap_UsersProducts.class.php: addUsersProducts(): Key=" . $key . ", Value=" . $value );
					
					include_once ($value);
					$forum = new Dap_Vbulletin();
					$errmsg = $forum->syncUser($userId, $productId);
					
					if ($errmsg != NULL) {
						$str = "Dap_UsersProducts.class.php: addUserToProduct(): Forum Reg Failed. " . $errmsg; 
						logToFile($str,LOG_INFO_DAP);
						sendAdminEmail("Dap_UsersProducts.class.php: addUsersProducts(): could not register to the vB forum", $str);
					}
					else {
						$dapuser = Dap_User::loadUserById($userId);
						$username = trim($dapuser->getUser_name());
						
						//Update username in dap_user if the username was registered to vB successfully and it's not already populated in DAP
						if ((!isset($username)) || ($username=="") || (strcmp($username,"") == 0)) {
							logToFile("User: " . $username . " in DAP",LOG_INFO_DAP);
							$user = new Dap_User();
							$user->setId($userId);
							logToFile("Userid set",LOG_INFO_DAP);
							//$user->setUser_name($dapuser->getFirst_name().$dapuser->getLast_name());
							//logToFile("username set",LOG_INFO_DAP);
							$uname=generateUsername("Dap_UsersProducts.class.php.addUsersProducts()",$dapuser->getEmail(),$dapuser->getFirst_name(),$dapuser->getLast_name());
							$user->setUser_name($uname);
							logToFile("Dap_UsersProducts.class.php: addUsersProducts(): username set to ".$uname,LOG_INFO_DAP);
							$user->setFirst_name($dapuser->getFirst_name());
							$user->setLast_name($dapuser->getLast_name());
							logToFile("firstname and lastname set",LOG_INFO_DAP);
							$user->setEmail($dapuser->getEmail());
							$user->setPassword($dapuser->getPassword());
							$user->setAddress1($dapuser->getAddress1());
							$user->setAddress2($dapuser->getAddress2());
							$user->setCity($dapuser->getCity());
							$user->setState($dapuser->getState());
							$user->setZip($dapuser->getZip());
							$user->setCountry($dapuser->getCountry());
							$user->setPhone($dapuser->getPhone());
							$user->setFax($dapuser->getFax());
							$user->setCompany($dapuser->getCompany());
							$user->setTitle($dapuser->getTitle());
							$user->setStatus($dapuser->getStatus());
							$user->setAccount_type($dapuser->getAccount_type());
							logToFile("account set",LOG_INFO_DAP);
							$user->setPaypal_email( $dapuser->getPaypal_email() );	
							//$user->setCredits_earned( $dapuser->getCredits_earned() );	
							$user->setCredits_available( $dapuser->getCredits_available() );	
							
							$user->setPaypal_email( $dapuser->getPaypal_email() );	
							
							logToFile("Ready to update user",LOG_INFO_DAP);
							try {
								$user->update();
								$response = "SUCCESS! User has been successfully updated.";
								logToFile("User: " . $username . " successfully added to DAP",LOG_INFO_DAP);
							} catch (PDOException $e) {
								$response = ERROR_GENERAL;
								logToFile("User: " . $username . " could not be added:  Exception: " . $response,LOG_INFO_DAP);
								sendAdminEmail("Dap_UsersProducts.addUsersProducts(): could not add username=" . $username, $response);
							} catch (Exception $e) {
								$response = ERROR_GENERAL;
								logToFile("User: " . $username . " could not be added:  Exception: " . $response,LOG_INFO_DAP);
								sendAdminEmail("Dap_UsersProducts.addUsersProducts(): could not add username=" . $username, $response);
							}
						}
					}
				} //End if AUTO_CREATE_VB_ACCOUNT_UPON_DAP_REG
				
				
			}
						
		} // foreach includeList
		
		
		
		return;
	}	
	
	public static function pluginRemove($userId, $productId, $value, $product, $sourceProductId="",$added=false) {
	  $params = explode(":",$value);
	  logToFile("(Dap_UsersProducts.removeUsersProducts()): pluginRemove(): params = " . $value, LOG_INFO_DAP);
	  
	  $GDPRdata = self::DAPcheckGDPRrules($userId);

	  if(isset($GDPRdata['applyautomation']) && $GDPRdata['applyautomation'] == "no"){
		 logToFile("(Dap_UsersProducts,pluginRemove()), GDPR rules dont allow to send data. So dont apply pluginRemove().",LOG_DEBUG_DAP);
		 return;
	   }
	  
	  
	  $className = $params[0];
	  $lldocroot = defined('SITEROOT') ? SITEROOT : $_SERVER['DOCUMENT_ROOT'];
	  $filename = $lldocroot . "/dap/plugins/" . $className . "/" . $className . ".class.php";
	  //$filename = $lldocroot . "/dap/plugins/" . "plugins/vbulletin/Dap_VBulletin.class.php";
	  logToFile("(Dap_UsersProducts.removeUsersProducts()): pluginRemove(): filename = " . $filename, LOG_INFO_DAP);
	  
	  include_once ($filename);
					  
	  //$name = "Dap_VBulletin.class.php";
	  try {
				  
		  $plugin=new $className();
		  logToFile("(Dap_UsersProducts.removeUsersProducts()): pluginRemove(): NAME = " . $className, LOG_INFO_DAP);
		  
	  } catch (Exception $e) {
		  $response = ERROR_GENERAL;
		  logToFile("(Dap_UsersProducts.removeUsersProducts()): pluginRemove(): Exception=" . $e->getMessage(),LOG_FATAL_DAP);
		  
	  }
	  //$classname = new $name();
	  
	  logToFile("(Dap_UsersProducts.pluginRemove(): calling unregister(): classname= $className", LOG_INFO_DAP);
	  logToFile("(Dap_UsersProducts.pluginRemove(): calling unregister(): sourceProductId = $sourceProductId", LOG_INFO_DAP);
	  
	  if( ($className=="getresponse") && ($sourceProductId != "")) {
	    logToFile("(Dap_UsersProducts.pluginRemove(): calling unregister(): getresponse()", LOG_INFO_DAP);
		$errmsg = $plugin->unregister($userId, $productId, $value, $sourceProductId,$added);
	  }
	  else
		$errmsg = $plugin->unregister($userId, $productId, $value);
	  
	  logToFile("(Dap_UsersProducts.pluginRemove(): called unregister()", LOG_INFO_DAP);
	  
	  if ($errmsg != 0) {
		  $str = "(Dap_UsersProducts.pluginRemove(): for userID = " . $userId . ", plugin= " . $value . " failed with " . $errmsg; 
		  logToFile($str,LOG_INFO_DAP);
		  sendAdminEmail("(Dap_UsersProducts.pluginRemove(): could not subscribe to the plugin=" . $filename, $str);
	  }
	  else {
		  logToFile("(Dap_UsersProducts.pluginRemove(): userID = " . $userId . " unregistered successfully", LOG_INFO_DAP);
	  }
	  
	}
	
	public static function removeProductFromUser($userId, $productId, $transId, $complete, $dap_dbh) {

		//load the product and see if it exists
		$product = Dap_Product::loadProduct($productId);	
		logToFile("(Dap_UsersProducts.removeUserProducts()) active product: $productId");
		
		//by the time we are here, we should be ready with valid uesrid and productid.
		$userProduct = Dap_UsersProducts::load($userId, $productId); //loadUserProducts($userId, $productId);
		if($userProduct != NULL) {
			 logToFile("removeUserProducts: active usersproducts: ".$product->getName());
			//logToFile("removeUserProducts: active usersproducts: ".$product->getIs_recurring());
			//if product exists, and request is not for complete removal and product is recurring then do negation of extend days.
			if(isset($product) && !($complete) && (strtolower($product->getIs_recurring()) == "y")) {
				logToFile("Updating UsersProducts as the product is recurring..");
				//this is recurring so lets adjust end date
				//TODO initially we were doing 0 - recurring days + 1, but took +1 out on 7/26/
				//TODO we need to calculate what to negate - based on what recurring cycle we are on.
				$extend_days = 0 - $product->getRecurring_cycle_1();
				$userProduct->extendEndDays($extend_days);
				$userProduct->update($dap_dbh);
				$userProduct->adjustUserResourceClickCounts(false);
			} else {
				logToFile("Deleting UsersProducts.."); //.$userProduct->getId());
				//this is not recurring, so just update enddate to '12-31-9999				
				$userProduct->delete($dap_dbh);
				logToFile("No Such UsersProducts deleted");
				$userProduct->adjustUserResourceClickCounts(false);
			}			
		} else {
			logToFile("No Such UsersProducts relationship exists..".$userId.":".$productId);
			throw new Exception("This product id:".$productId." does not belong to user id:".$userId);
		}
		logToFile("removeProductFromUser: return");
	}	
	
	
	//clean up all Users Products relationships where acces start date is equal to or less than access end date. 
	function cleanUsersProducts($dap_dbh=NULL) {
		try {
			$dap_dbh = Dap_Connection::getConnection($dap_dbh);
		
			$sql = "DELETE 
					from 
					dap_users_products_jn 
					where 
					access_start_date > access_end_date
					";
			$stmt = $dap_dbh->prepare($sql);
			$stmt->execute();	
			//logToFile("in cleanUsersProducts - after execute",LOG_DEBUG_DAP);
			$stmt = null;
			//$dap_dbh = null;			
			return;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}	
	}	
	// check out the user-resouce relationship with max allowed resource click counts.
	//ASSM we assume product id and user id associated with this userproduct is valid and all checks such as valid product etc are already done.
	//ASSM we also assume that num clicks are present for file resources only in product resource join.

	function adjustUserResourceClickCounts($credit) {
		try {
			//logToFile("Dap_UsersProducts.adjustUserResourceClickCounts ..");
			$dap_dbh = Dap_Connection::getConnection();
		
			$sql = "select prj.resource_id, prj.num_clicks 
					from 
					dap_products_resources_jn prj
					where 
					prj.product_id = :product_id and
					prj.status = 'A' and
					(prj.num_clicks <> null or prj.num_clicks <> 0)
					
					";
			if($credit) {
				$update_sql = "insert into dap_users_resources_jn
						(user_id, resource_id, click_count)
					values
						(:user_id, :resource_id, :click_count)
					ON DUPLICATE KEY
					update click_count = click_count + :click_count
					";
			} else {
				$update_sql = "insert into dap_users_resources_jn
						(user_id, resource_id, click_count)
					values
						(:user_id, :resource_id, :click_count)
					ON DUPLICATE KEY
					update click_count = click_count - :click_count
					";
			}
			$stmt = $dap_dbh->prepare($sql);
			$update_stmt = $dap_dbh->prepare($update_sql);
			//
			$stmt->bindParam(':product_id', $this->product_id, PDO::PARAM_INT);
			//logToFile($sql,LOG_INFO_DAP);
			$stmt->execute();	
			//now we got resource url and num clicks allowed on that url as part of a product-resource association.
			//Lets add it to the user-resource table with insert update if exists. 	
			while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
				//$url = $row['user_id'];
				$update_stmt->bindParam(':user_id', $this->user_id, PDO::PARAM_INT);
				$update_stmt->bindParam(':resource_id', $row['resource_id'], PDO::PARAM_INT);
				$update_stmt->bindParam(':click_count', $row['num_clicks'], PDO::PARAM_INT);
				$update_stmt->execute();	
				
			}
			$stmt = null;
			$update_stmt = null;
			$dap_dbh = null;			
			return;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}	
	}	

	
	public static function storeGenerateCSVReportOnSyncJobToQueue($syncorder,$csvFileName) {
		try {
			$actionType = "REPORTSYNCISSUES";
			$payload = $csvFileName."||".$syncorder;
			$status = "NEW";
			
			$dap_dbh = Dap_Connection::getConnection();
			$key = mktime();
                        //Insert into dap_mass_actions
			
			logToFile("Dap_UsersProducts.class.php:reportSyncIssuesDAPWPAjax. payload - $payload");
						
			$sql = "insert into dap_mass_actions
									(actionType, actionKey, payload, status)
									values
									(:actionType, :key, :payload, 'NEW')";
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':actionType', $actionType, PDO::PARAM_STR);
			$stmt->bindParam(':key', $key, PDO::PARAM_STR);
			$stmt->bindParam(':payload', $payload, PDO::PARAM_STR);
			$stmt->execute();
			$stmt = null;
			$dap_dbh = null;
			
			return;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}		
		
	}
	
	public static function storeSyncJobToQueue($foldername,$csvFileName,$pickacat) {
		try {
			$actionType = "SYNCUSERSWPDAP";
			$payload = $csvFileName."||".$pickacat."||".$foldername;
			$status = "NEW";
			
			logToFile("in storeSyncJobToQueue - $foldername,$csvFileName,$pickacat",LOG_DEBUG_DAP);
			
			$dap_dbh = Dap_Connection::getConnection();
			$key = mktime();
                        //Insert into dap_mass_actions

			$sql = "insert into dap_mass_actions
									(actionType, actionKey, payload, status)
									values
									(:actionType, :key, :payload, 'NEW')";
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':actionType', $actionType, PDO::PARAM_STR);
			$stmt->bindParam(':key', $key, PDO::PARAM_STR);
			$stmt->bindParam(':payload', $payload, PDO::PARAM_STR);
			$stmt->execute();
			$stmt = null;
			$dap_dbh = null;
			
			return;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}		
		
	}
	
		
	public static function bulkExtendedAddCSVToProduct($productId,$fieldvalue,$paid,$fieldlist,$dateformat) {
		try {
			$actionType = "BULKEXTADDCSVTOPROD";
			$payload = $productId."||".$fieldvalue."||".$paid."||".$fieldlist."||".$dateformat;
			$status = "NEW";
			
			$dap_dbh = Dap_Connection::getConnection();
			$key = mktime();
                        //Insert into dap_mass_actions

                        $sql = "insert into dap_mass_actions
                                                (actionType, actionKey, payload, status)
                                                values
                                                (:actionType, :key, :payload, 'NEW')";
                        $stmt = $dap_dbh->prepare($sql);
                        $stmt->bindParam(':actionType', $actionType, PDO::PARAM_STR);
                        $stmt->bindParam(':key', $key, PDO::PARAM_STR);
                        $stmt->bindParam(':payload', $payload, PDO::PARAM_STR);
                        $stmt->execute();
			$stmt = null;
			$dap_dbh = null;
			
			return;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}		
		
	}
	
	public static function massAddToProduct($access_source_product_id, $noaccess_source_product_id, $dest_product_id, $accessdate, $paid) {
		try {
			
			$actionType = "MASSADDTOPROD";
			$payload = $access_source_product_id."||".$noaccess_source_product_id."||".$dest_product_id."||".$accessdate."||".$paid ;
			$status = "NEW";
			
			logToFile("in massAddToProduct - $actionType",LOG_DEBUG_DAP);
			
			$dap_dbh = Dap_Connection::getConnection();
			$key = mktime();
                        //Insert into dap_mass_actions

                        $sql = "insert into dap_mass_actions
                                                (actionType, actionKey, payload, status)
                                                values
                                                (:actionType, :key, :payload, 'NEW')";
                        $stmt = $dap_dbh->prepare($sql);
                        $stmt->bindParam(':actionType', $actionType, PDO::PARAM_STR);
                        $stmt->bindParam(':key', $key, PDO::PARAM_STR);
                        $stmt->bindParam(':payload', $payload, PDO::PARAM_STR);
                        $stmt->execute();
			$stmt = null;
			$dap_dbh = null;
			
			return;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}		
		
	}

	
	public static function bulkAddCSVToProduct($productId,$csvFileName,$paid) {
		try {
			$actionType = "BULKADDCSVTOPRODUCT";
			$payload = $productId."||".$csvFileName."||".$paid;
			$status = "NEW";
			
			$dap_dbh = Dap_Connection::getConnection();
			$key = mktime();
                        //Insert into dap_mass_actions

                        $sql = "insert into dap_mass_actions
                                                (actionType, actionKey, payload, status)
                                                values
                                                (:actionType, :key, :payload, 'NEW')";
                        $stmt = $dap_dbh->prepare($sql);
                        $stmt->bindParam(':actionType', $actionType, PDO::PARAM_STR);
                        $stmt->bindParam(':key', $key, PDO::PARAM_STR);
                        $stmt->bindParam(':payload', $payload, PDO::PARAM_STR);
                        $stmt->execute();
			$stmt = null;
			$dap_dbh = null;
			
			return;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}		
		
	}

	public static function isProtectedResourceAvailableToUser1($uid, $pid, $url, $sss="N") {
		try {
			logToFile("Dap_UsersResources.getActiveResources() - Init...User Id:".$uid.", Product Id:".$pid);
			logToFile("Dap_UsersResources.getActiveResources() - Init...url:".$url);
			logToFile("Dap_UsersResources.getActiveResources() - SSS=" . $sss);
			
			
			$product = Dap_Product::loadProduct($pid);
			$isSSSMaster=$product->getIs_master();
			logToFile("userlinks.inc: isSSSMaster=". $isSSSMaster);
			
			if (($sss == "N") || ($isSSSMaster == "Y")){
				$sql = "select 
						upj.transaction_id as transid,
						TO_DAYS(now()) as today,
						TO_DAYS(upj.access_start_date) as access_start_days,
						TO_DAYS(upj.access_end_date) as access_end_days,
						prj.is_free as is_free,
						prj.start_day as start_day,
						prj.end_day as end_day,
						TO_DAYS(prj.start_date) as res_start_days,
						TO_DAYS(prj.end_date) as res_end_days,
						prj.num_clicks as num_clicks,
						prj.resource_id as resource_id,
						p.error_page_url as error_page_url,
						fr.url as url,
						fr.name as name
				from
					dap_products p,
					dap_products_resources_jn prj,
					dap_file_resources fr,
					dap_users u,
					dap_users_products_jn upj				
				where
					u.id =:uid and
					u.status = 'A' and 
					prj.resource_id = fr.id and 					
					prj.resource_type = 'F' and
					p.id = prj.product_id and
					p.status = 'A' and
					upj.user_id = u.id and
					upj.product_id = p.id and
					upj.status = 'A' and
					fr.url = :url
					";
			}
			else {
				
				   $hasAccess=Dap_UserCredits::hasAccessTo($uid, $pid); 
				   $sssHasAccess=true;
				   if($hasAccess) {
					   $sql = "select DISTINCT 
						upj.transaction_id as transid,
						TO_DAYS(now()) as today,
						TO_DAYS(upj.access_start_date) as access_start_days,
						TO_DAYS(upj.access_end_date) as access_end_days,
						prj.is_free as is_free,
						prj.start_day as start_day,
						prj.end_day as end_day,
						TO_DAYS(prj.start_date) as res_start_days,
						TO_DAYS(prj.end_date) as res_end_days,
						prj.num_clicks as num_clicks,
						prj.resource_id as resource_id,
						p.error_page_url as error_page_url,
						fr.url as url,
						fr.name as name
				from
					dap_products p,
					dap_products_resources_jn prj,
					dap_file_resources fr,
					dap_users u,
					dap_users_products_jn upj,
					dap_users_credits duc
				where
					u.id =:uid and
					u.status = 'A' and 
					prj.resource_id = fr.id and 					
					prj.resource_type = 'F' and
					p.id = prj.product_id and
					p.status = 'A' and
					upj.user_id = u.id and
					upj.product_id = p.id and
					upj.status = 'A' and
					duc.user_id = u.id and
					duc.product_id = p.id  and
					fr.url = :url
					";
				   }
				   else {
					   	$sql = "select 
						upj.transaction_id as transid,
						TO_DAYS(now()) as today,
						TO_DAYS(upj.access_start_date) as access_start_days,
						TO_DAYS(upj.access_end_date) as access_end_days,
						prj.is_free as is_free,
						prj.start_day as start_day,
						prj.end_day as end_day,
						TO_DAYS(prj.start_date) as res_start_days,
						TO_DAYS(prj.end_date) as res_end_days,
						prj.num_clicks as num_clicks,
						prj.resource_id as resource_id,
						p.error_page_url as error_page_url,
						fr.url as url,
						fr.name as name
				from
					dap_products p,
					dap_products_resources_jn prj,
					dap_file_resources fr,
					dap_users u,
					dap_users_products_jn upj,
					dap_users_credits duc
				where
					u.id =:uid and
					u.status = 'A' and 
					prj.resource_id = fr.id and 					
					prj.resource_type = 'F' and
					p.id = prj.product_id and
					p.status = 'A' and
					upj.user_id = u.id and
					upj.product_id = p.id and
					upj.status = 'A' and
					duc.user_id = u.id and
					duc.product_id = p.id and
					duc.resource_id = prj.resource_id and
					fr.url = :url
					";
				   }
			}
				//	now() between upj.access_start_date and upj.access_end_date	and
				//	(TO_DAYS(NOW()) - TO_DAYS(access_start_date)) between prj.start_day and prj.end_day
			
			//echo "sql: $sql<br>"; exit;
			$dap_dbh = Dap_Connection::getConnection();
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':uid', $uid, PDO::PARAM_INT);

			$stmt->bindParam(':url', $url, PDO::PARAM_STR);
			$stmt->execute();
			
			$access=false;
			$post_cancel_access = Dap_Config::get("POST_CANCEL_ACCESS");
			if(isset($post_cancel_access)) {
				$post_cancel_access = strtolower($post_cancel_access);
			}			
			//lets loop over the resource list
			while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
				$row["name"] = mb_convert_encoding($row["name"], "UTF-8", "auto");
				logToFile("Resource URL:".$row["url"]);
				
			  //lets present two modes of operation 
			  if($sssHasAccess){
				  logToFile("DAP_UsersProducts.class.php: getActiveResources(): SSS product, show content list");
			  }
			  else if($post_cancel_access == 'y') {
				  //we have dates on the resource
				  if($row["res_start_days"] <> 0 && $row["res_start_days"] <> "" &&
					  $row["res_end_days"] <> 0 && $row["res_end_days"] <> "" ) {
					  //set resource start days 
					  $resource_start_days = $row["res_start_days"];
					  $resource_end_days = $row["res_end_days"];
				  }
							  
				  //we have "days" on the resource
				  if($row["start_day"] <> 0 && $row["start_day"] <> "" &&
					  $row["end_day"] <> 0 && $row["end_day"] <> "" ) {
					  //set resource start days 
					  $resource_start_days = $row["access_start_days"] + $row["start_day"] - 1 ;
					  $resource_end_days = $row["access_start_days"] + $row["end_day"] - 1 ;
					  
					  //logToFile("We have 'days' on the resource"); 
					  //logToFile("resource_start_days: $resource_start_days"); 
					  //logToFile("resource_end_days: $resource_end_days"); 
					  //logToFile("User's row[access_start_days]: " . $row["access_start_days"]); 
					  
					  
					  /**
						  So if resource "days" are hard-coded, but resource end day is in the past,
						  then do not allow access. Will help offer expiring bonuses even though post-cancel-access is yes.
					  */
					  if($row["today"] > $resource_end_days ) { //Expiring Bonuses
						  //logToFile("Sorry: The 'end day' for this content is in the past...");
						  //logToFile("DAP001");
						  continue;
					  }					
				  }
  
				  //if resource starts in future, lets not grant access.
				  if($row["today"] < $resource_start_days ) {
					  //logToFile("Resource Start Date is in future...");
					  //logToFile("DAP001");
					  continue;
				  }					
  
				  
				  //
				  // If resource ends before upj start date - then no acesss. This could only happen 
				  //    when calendar dates are used at the resource level.
				  // If resource starts after upj end date - then no access. This could only happen
				  //    when calendar dates are used at the resource level.
				  //
				  //
				  if($resource_end_days < $row["access_start_days"] ||
					  $resource_start_days > $row["access_end_days"]) {
					  //logToFile("Product Start Date is in future...");
					  //logToFile("Resource Start Days:".$resource_start_days);
					  //logToFile("Resource End Days:".$resource_end_days);
					  //logToFile("Access Start Days:".$row["access_start_days"]);
					  //logToFile("Access End Days:".$row["access_end_days"]);
					  //logToFile("DAP005");
					  //logToFile($ERROR_CODES["DAP005"]);
					  continue;						
				  }				
			  
			  } else {				
				  //Product did not lauch yet.
				  if($row["today"] < $row["access_start_days"]) {
					  //logToFile("Product Start Date is in future...");
					  //logToFile("DAP001");
					  continue;
					  //return $resource;						
					  //$_SESSION['DAP_ERROR'] = $ERROR_CODES["DAP001"];
					  //$_SESSION['ERROR_URL'] = $row['error_page_url'];
					  //return FALSE;
				  }
				  //Product expired 
				  if($row["today"] > $row["access_end_days"]) {
					  //logToFile("Product End Date is in past...");
					  //logToFile("DAP002");
					  continue;
				  }
				  //product is available.
				  //check start date(days).
				  if($row["res_start_days"] <> 0 && $row["res_start_days"] <> "" &&
					  $row["res_end_days"] <> 0 && $row["res_end_days"] <> "" ) {
					  //resource is available in future.
					  if($row["today"] < $row["res_start_days"]) {
						  //logToFile("Resource Start Date  is in future...");
						  //logToFile("DAP003");
						  continue;
					  }
					  //resource  expired.
					  if($row["today"] > $row["res_end_days"]) {
						  //logToFile("Resource End Date  is in past...");
						  //logToFile("DAP004");
						  continue;
					  }
					  //logToFile("Start Days(Date) and End Days(Date) check passed...");
	  
				  } else {
					  //logToFile("Start Days(Date) and End Days(Date) are empty or ZERO.. not checking...");
				  }
				  //check start day
				  $lag_days = $row["today"] - $row["access_start_days"] + 1;
				  //check resource start and end day only if they are both non zero. 
				  if($row["start_day"] <> 0 && $row["start_day"] <> "" &&
					  $row["end_day"] <> 0 && $row["end_day"] <> "" ) {
  
					  //resource is available in future.
					  if($lag_days < $row["start_day"]) {
						  //logToFile("Lag Days:".$lag_days);
						  //logToFile("Start Day:".$row["start_day"]);
						  //logToFile("Resource Start Day  is in future...");
						  //logToFile("DAP003");
						  continue;
						  //return $resource;
						  //$_SESSION['DAP_ERROR'] = $ERROR_CODES["DAP003"];
						  //$_SESSION['DAP_ERROR_URL'] = $row['error_page_url'];
						  //return FALSE;
					  }
					  //resource availability expired.
					  if($lag_days > $row["end_day"]) {
						  //logToFile("Lag Days:".$lag_days);
						  //logToFile("End Days:".$row["end_day"]);
						  //logToFile("Resource Start Day  is in past...");
						  //logToFile("DAP004");
						  continue;
						  //return $resource;
						  //$_SESSION['DAP_ERROR'] = $ERROR_CODES["DAP004"];
						  //$_SESSION['DAP_ERROR_URL'] = $row['error_page_url'];
						  //return FALSE;
					  }
					  //logToFile("Start Day and End Day check passed...");
					  } else {
						  //logToFile("Start Day and End Day are empty or ZERO.. not checking...");
					  }
				  } //end of config allow post cancel access
				  if(!Dap_Resource::isCountAvailable($uid, $row['url'])) {
					  //logToFile("Click Count is Negative...");
					  continue;
				  }
				  if(!Dap_Resource::displayResource($row['url'])) {
					  //logToFile("This Resource is not displayable...");
					  continue;
				  }
				  //grant access - we should reach here ONLY IF THE PRODUCT RESOURCE RELATIONSHIP IS CLEAN AND ALLOWED.
				  //return $resource;
				  //$_SESSION['DAP_ERROR'] = $ERROR_CODES["DAP002"];
				  //logToFile("Granting Access To Resource URL:".$row["url"].", Resource ID:".$row["resource_id"]);
				  if($row['name'] == "") {
					  $name = $row['url'];
				  }
				  else {
					  $name = mb_convert_encoding($row["name"], "UTF-8", "auto");
					  //$name = "";
				  }
  
				  $name = stripslashes($name);
				  $access=true;
				  //logToFile("HTML: " . $html);
			  } //while
			
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			return $access;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			return $access;
		}		
		return $access;
	}

	public static function isProtectedResourceAvailableToUser($uid, $pid, $url, &$accesserrstr) {
		try {
			logToFile("Dap_UsersResources.isProtectedResourceAvailableToUser() - Init...User Id:".$uid.", Product Id:".$pid);
			logToFile("Dap_UsersResources.isProtectedResourceAvailableToUser() - Init...url:".$url);
			
			$sql = "select 
						upj.transaction_id as transid,
						upj.status as pstatus,
						TO_DAYS(now()) as today,
						TO_DAYS(upj.access_start_date) as access_start_days,
						TO_DAYS(upj.access_end_date) as access_end_days,
						prj.is_free as is_free,
						prj.start_day as start_day,
						prj.end_day as end_day,
						TO_DAYS(prj.start_date) as res_start_days,
						TO_DAYS(prj.end_date) as res_end_days,
						prj.num_clicks as num_clicks,
						prj.resource_id as resource_id,
						p.error_page_url as error_page_url,
						fr.url as url,
						fr.name as name
				from
					dap_products p,
					dap_products_resources_jn prj,
					dap_file_resources fr,
					dap_users u,
					dap_users_products_jn upj				
				where
					u.id =:uid and
					u.status = 'A' and 
					prj.resource_id = fr.id and 					
					prj.resource_type = 'F' and
					p.id = prj.product_id and
					p.status = 'A' and
					upj.user_id = u.id and
					upj.product_id = p.id and
					fr.url = :url
					";
		
			
		
				//	now() between upj.access_start_date and upj.access_end_date	and
				//	(TO_DAYS(NOW()) - TO_DAYS(access_start_date)) between prj.start_day and prj.end_day
			
			//echo "sql: $sql<br>"; exit;
			
			$dap_dbh = Dap_Connection::getConnection();
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':uid', $uid, PDO::PARAM_INT);

			$stmt->bindParam(':url', $url, PDO::PARAM_STR);
			$stmt->execute();
			
			$access=true;
			$post_cancel_access = Dap_Config::get("POST_CANCEL_ACCESS");
			if(isset($post_cancel_access)) {
				$post_cancel_access = strtolower($post_cancel_access);
			}	
			
			$sql1rows=false;
			$inactproduct="";
			$entered=false;
			//lets loop over the resource list
			while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
				
				logToFile("Dap_UsersResources.isProtectedResourceAvailableToUser() - found rows");
			
				$entered=true;
				if($row["pstatus"]!="A") {
					$inactproduct="Y";
					$access=false;
					$errmsg="This user's status to the product is 'I' (INACTIVE) in DAP Users=>Manage page. The user cannot access any content under this product.";
					continue;
				}
				
				$inactproduct="N";
				
				$row["name"] = mb_convert_encoding($row["name"], "UTF-8", "auto");
				logToFile("Resource URL:".$row["url"]);
				
			  //lets present two modes of operation 
			  if($sssHasAccess){
				  logToFile("DAP_UsersProducts.class.php: getActiveResources(): SSS product, show content list");
			  }
			  else if($post_cancel_access == 'y') {
				  //we have dates on the resource
				  logToFile("post cance = y");
				  if($row["res_start_days"] <> 0 && $row["res_start_days"] <> "" &&
					  $row["res_end_days"] <> 0 && $row["res_end_days"] <> "" ) {
					  //set resource start days 
					  $resource_start_days = $row["res_start_days"];
					  $resource_end_days = $row["res_end_days"];
				  }
							  
				  //we have "days" on the resource
				  if($row["start_day"] <> 0 && $row["start_day"] <> "" &&
					  $row["end_day"] <> 0 && $row["end_day"] <> "" ) {
					  //set resource start days 
					  $resource_start_days = $row["access_start_days"] + $row["start_day"] - 1 ;
					  $resource_end_days = $row["access_start_days"] + $row["end_day"] - 1 ;
					  
					  //logToFile("We have 'days' on the resource"); 
					  //logToFile("resource_start_days: $resource_start_days"); 
					  //logToFile("resource_end_days: $resource_end_days"); 
					  //logToFile("User's row[access_start_days]: " . $row["access_start_days"]); 
					  
					  
					  /**
						  So if resource "days" are hard-coded, but resource end day is in the past,
						  then do not allow access. Will help offer expiring bonuses even though post-cancel-access is yes.
					  */
					  if($row["today"] > $resource_end_days ) { //Expiring Bonuses
						  //logToFile("Sorry: The 'end day' for this content is in the past...");
						  //logToFile("DAP001");
						  $access=false;
						  $errmsg="Sorry, the 'drip end date' for this protected content is in the past... You can find the drip setting for this content in the content responder tab of this product.";
						  continue;
					  }					
				  }
  
				  //if resource starts in future, lets not grant access.
				  if($row["today"] < $resource_start_days ) {
					  //logToFile("Resource Start Date is in future...");
					  //logToFile("DAP001");
					  $access=false;
					  $errmsg="Sorry, the 'Drip Start Date' for this protected content is in future... You can find the drip setting for this content in the content responder tab of this product.";
					  continue;
				  }					
  
				  
				  //
				  // If resource ends before upj start date - then no acesss. This could only happen 
				  //    when calendar dates are used at the resource level.
				  // If resource starts after upj end date - then no access. This could only happen
				  //    when calendar dates are used at the resource level.
				  //
				  //
				  if($resource_end_days < $row["access_start_days"] ||
					  $resource_start_days > $row["access_end_days"]) {
					  //logToFile("Product Start Date is in future...");
					  //logToFile("Resource Start Days:".$resource_start_days);
					  //logToFile("Resource End Days:".$resource_end_days);
					  //logToFile("Access Start Days:".$row["access_start_days"]);
					  //logToFile("Access End Days:".$row["access_end_days"]);
					  //logToFile("DAP005");
					  //logToFile($ERROR_CODES["DAP005"]);
					  $access=false;
					  $errmsg="Sorry, the user's 'Access Start Date' for the Product is in future... You can find the access start date of this user->product in dap users->manage page.";
					  continue;						
				  }		
				  
				  $access=true;
				  break;
			  
			  } else {				
				  //Product did not lauch yet.
				  logToFile("post cancel = n");
				  if($row["today"] < $row["access_start_days"]) {
					  logToFile("Product Start Date is in future...");
					  //logToFile("DAP001");
					  $access=false;
					    $errmsg="Sorry, the user's 'Access Start Date' for the Product is in future... You can find the access start date of this user->product in dap users->manage page.";
					  continue;
					  //return $resource;						
					  //$_SESSION['DAP_ERROR'] = $ERROR_CODES["DAP001"];
					  //$_SESSION['ERROR_URL'] = $row['error_page_url'];
					  //return FALSE;
				  }
				  //Product expired 
				  if($row["today"] > $row["access_end_days"]) {
					  logToFile("Product End Date is in past...");
					  //logToFile("DAP002");
					      $errmsg="Sorry, the user's 'Access End Date' for the Product is in past... You can find the access end date of this user->product in dap users->manage page.";
					  $access=false;
					  continue;
				  }
				  //product is available.
				  //check start date(days).
				  if($row["res_start_days"] <> 0 && $row["res_start_days"] <> "" &&
					  $row["res_end_days"] <> 0 && $row["res_end_days"] <> "" ) {
					  //resource is available in future.
					  if($row["today"] < $row["res_start_days"]) {
						  logToFile("Resource Start Date  is in future...");
						  //logToFile("DAP003");
						  $errmsg="Sorry, the user's 'Access End Date' for the Product is in past... You can find the access end date of this user->product in dap users->manage page.";
						  $access=false;
						  continue;
					  }
					  //resource  expired.
					  if($row["today"] > $row["res_end_days"]) {
						  logToFile("Resource End Date  is in past...");
						   $errmsg="Sorry, the 'drip end date' for this protected content is in the past... Check the drip setting for this content in the content responder tab of this product.";
						  //logToFile("DAP004");
						  $access=false;
						  continue;
					  }
					  //logToFile("Start Days(Date) and End Days(Date) check passed...");
	  
				  } else {
					  logToFile("Start Days(Date) and End Days(Date) are empty or ZERO.. not checking...");
				  }
				  //check start day
				  $lag_days = $row["today"] - $row["access_start_days"] + 1;
				  //check resource start and end day only if they are both non zero. 
				  if($row["start_day"] <> 0 && $row["start_day"] <> "" &&
					  $row["end_day"] <> 0 && $row["end_day"] <> "" ) {
  
					  //resource is available in future.
					  if($lag_days < $row["start_day"]) {
						  //logToFile("Lag Days:".$lag_days);
						  //logToFile("Start Day:".$row["start_day"]);
						  //logToFile("Resource Start Day  is in future...");
						  $errmsg="Sorry, the 'Drip Start Date' for this protected content is in future... Check the drip setting for this content in the content responder tab of this product.";
						  logToFile("DAP003");
						  $access=false;
						  continue;
						  //return $resource;
						  //$_SESSION['DAP_ERROR'] = $ERROR_CODES["DAP003"];
						  //$_SESSION['DAP_ERROR_URL'] = $row['error_page_url'];
						  //return FALSE;
					  }
					  //resource availability expired.
					  if($lag_days > $row["end_day"]) {
						  //logToFile("Lag Days:".$lag_days);
						  //logToFile("End Days:".$row["end_day"]);
						  //logToFile("Resource Start Day  is in past...");
						   $errmsg="Sorry, the 'drip end date' for this protected content is in the past... You can find the drip setting for this content in the content responder tab of this product.";
						  logToFile("DAP004");
						  $access=false;
						  continue;
						  //return $resource;
						  //$_SESSION['DAP_ERROR'] = $ERROR_CODES["DAP004"];
						  //$_SESSION['DAP_ERROR_URL'] = $row['error_page_url'];
						  //return FALSE;
					  }
					  //logToFile("Start Day and End Day check passed...");
					  } else {
						  logToFile("Start Day and End Day are empty or ZERO.. not checking...");
					  }
				  } //end of config allow post cancel access
				  if(!Dap_Resource::isCountAvailable($uid, $row['url'])) {
					  logToFile("Click Count is Negative...");
					  $access=false;
					  continue;
				  }
				  if(!Dap_Resource::displayResource($row['url'])) {
					  logToFile("This Resource is not displayable...");
					   $errmsg="Sorry, this Resource is not displayable...... You can find the drip setting for this content in the content responder tab of this product.";
					  $access=false;
					  continue;
				  }
				  //grant access - we should reach here ONLY IF THE PRODUCT RESOURCE RELATIONSHIP IS CLEAN AND ALLOWED.
				  //return $resource;
				  //$_SESSION['DAP_ERROR'] = $ERROR_CODES["DAP002"];
				  //logToFile("Granting Access To Resource URL:".$row["url"].", Resource ID:".$row["resource_id"]);
				  if($row['name'] == "") {
					  $name = $row['url'];
				  }
				  else {
					  $name = mb_convert_encoding($row["name"], "UTF-8", "auto");
					  //$name = "";
				  }
  
				  $name = stripslashes($name);
				  logToFile("Granting Access To Resource URL:".$row["url"].", Resource ID:".$row["resource_id"]);
				  $access=true;
				  break;
				  
				  //logToFile("HTML: " . $html);
			  } //while
			  
			  if($entered==false) {
				  logToFile("user does not have access to product under which content is protected.");
				  $errmsg="The user or user/product status is NOT active OR the user does not have access to any product under which this content is protected.";
				  $accesserrstr=$errmsg;
				  return -1;
			  }
			  
			  if ($access!=true) {
				  //user has access to the products under which this content is dripped but the access end date is likely in the past. 
				  logToFile("inactproduct (-3) =" . $access);
				  $accesserrstr=$errmsg;
				  return -1;
			  }
			  else {
			  	return 0; //true;
			  }
			 
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			$access=false;
			return $access;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			$access=false;
			return $access;
		}	
		
		//user has access to the products under which this content is dripped but the access end date is likely in the past. 
		logToFile("inactproduct (-3) =" . $access);
		$accesserrstr=$errmsg;
		return -1;
		
	}
	
	
	public static function loadAllFileResourcesForUserUnderCondDripProduct($userId,$productId,$rettype="array") {
		try {

			//Load resource details from database
			$dap_dbh = Dap_Connection::getConnection();
			
			
			$sql = "select 
					fr.id, fr.url, fr.name, fr.display_in_list, prj.id as ID, prj.credits_assigned, excerpt, prj.display_order as display_order,
					prj.is_free, prj.start_day, prj.end_day, DATE_FORMAT(prj.start_date, '%m-%d-%Y') as start_date, DATE_FORMAT(prj.end_date, '%m-%d-%Y') as end_date, prj.num_clicks, prj.status as product_resource_status
			from
				dap_products p,
				dap_products_resources_jn prj,
				dap_file_resources fr,
				dap_users u,
				dap_users_products_jn upj
			where
				u.id =:userId and
				p.id =:productId and
				u.status = 'A' and 
				prj.resource_id = fr.id and 					
				prj.resource_type = 'F' and
				p.id = prj.product_id and
				p.status = 'A' and
				upj.user_id = u.id and
				upj.product_id = p.id and
				upj.status = 'A'";			
					
				
			$stmt = $dap_dbh->prepare($sql);
			
			logToFile("Dap_FileResource.class.php: productId=". $productId,LOG_DEBUG_DAP);
		
			$stmt->bindParam(':productId', $productId, PDO::PARAM_INT);	
			$stmt->bindParam(':userId', $userId, PDO::PARAM_INT);	
			$stmt->execute();
			
			$resourceArray = array();
		
			while ($obj = $stmt->fetch()) {
	
				$resourceArray[] = $obj;
				logToFile("Dap_FileResource.class.php: id=". $obj["id"], LOG_DEBUG_DAP);
				logToFile("Dap_FileResource.class.php: resource found=". $obj["name"], LOG_DEBUG_DAP);
				logToFile("Dap_FileResource.class.php: resource URL found=". $obj["url"], LOG_DEBUG_DAP);
				//logToFile("Dap_FileResource.class.php: resource found=". $resourceArray[0].fr.name, LOG_DEBUG_DAP);
				logToFile("Dap_FileResource.class.php: prj.credits_assigned found=". $obj['prj.credits_assigned'], LOG_DEBUG_DAP);
			}
		    if($rettype == "array") 
			  return $resourceArray;
			else 
			  return $obj;
		
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}
	}

	/*
		Return active file resources (as of today) associated with this User Product association.

	*/	
	
	
	public function getActiveResourcesCondPassed($orderBy="desc", $limit=10000, $returnFormat="HTML") {
		try {
			logToFile("Dap_UsersResources.getActiveResourcesCondPassed() - Init...User Id:".$this->user_id.", Product Id:".$this->product_id);
			$html = "";
			
			$product = Dap_Product::loadProduct($this->product_id);
		
			$sql = "select 
			upj.transaction_id as transid,
			TO_DAYS(now()) as today,
			TO_DAYS(upj.access_start_date) as access_start_days,
			TO_DAYS(upj.access_end_date) as access_end_days,
			prj.resource_id as resource_id,
			p.error_page_url as error_page_url,
			fr.url as url,
			fr.name as name,
			duc.result as result,
			prj.cond_drip_order
			from
				dap_products p,
				dap_products_resources_jn prj,
				dap_file_resources fr,
				dap_users u,
				dap_users_products_jn upj,
				dap_users_cond_content duc
			where
				u.id =:uid and
				p.id =:product_id and
				u.status = 'A' and 
				prj.resource_id = fr.id and 					
				prj.resource_type = 'F' and
				p.id = prj.product_id and
				p.status = 'A' and
				upj.user_id = u.id and
				upj.product_id = p.id and
				upj.status = 'A' and
				duc.user_id = u.id and
				duc.product_id = p.id and
				duc.resource_id = prj.resource_id and
				prj.cond_drip_order > 0
			order by 
				 prj.cond_drip_order asc,prj.display_order desc, fr.id asc
			limit 0, $limit
				";

				//	now() between upj.access_start_date and upj.access_end_date	and
				//	(TO_DAYS(NOW()) - TO_DAYS(access_start_date)) between prj.start_day and prj.end_day
			
			//echo "sql: $sql<br>"; exit;
			$dap_dbh = Dap_Connection::getConnection();
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':uid', $this->user_id, PDO::PARAM_INT);
			$stmt->bindParam(':product_id', $this->product_id, PDO::PARAM_INT);
			$stmt->execute();
			
			$html = "<ul class=\"dap_product_links_list\">";
			$resources=array();
			//lets loop over the resource list
			while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
				
				if($returnFormat!="HTML") {
					$resources[]=$row;
					continue;
				}
				
				$row["name"] = mb_convert_encoding($row["name"], "UTF-8", "auto");
				logToFile("COND Resource URL:".$row["url"]);
				
				if(!Dap_Resource::displayResource($row['url'])) {
					//logToFile("This Resource is not displayable...");
					continue;
				}
				//grant access - we should reach here ONLY IF THE PRODUCT RESOURCE RELATIONSHIP IS CLEAN AND ALLOWED.
				//return $resource;
				//$_SESSION['DAP_ERROR'] = $ERROR_CODES["DAP002"];
				//logToFile("Granting Access To Resource URL:".$row["url"].", Resource ID:".$row["resource_id"]);
				if($row['name'] == "") {
					$name = $row['url'];
				}
				else {
					$name = mb_convert_encoding($row["name"], "UTF-8", "auto");
					//$name = "";
				}

				$name = stripslashes($name);
				
				$result = $row["result"];
				
				if($result=="P")
					$html .= "<li><a href='".stripslashes($row['url'])."'>".stripslashes($name)."</a> - Course Complete!</li>";
				else
					$html .= "<li><a href='".stripslashes($row['url'])."'>".stripslashes($name)."</a>- Course not Complete</li>";
				//logToFile("HTML: " . $html);
			}
			
			if($returnFormat!="HTML") {
				logToFile("returning cond drip resources");
				return $resources;
			}
			//logToFile("html: $html"); 
			if($html == "<ul class=\"dap_product_links_list\">") {
				$html .= "<li>".USER_LINKS_NOLINKSFOUND_TEXT."</li>";
			}
			
			$html .= "</ul>";
			
			return $html;
			
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}		

	}
	
	public function getActiveResourcesCondNotPassedFirst($orderBy="desc", $limit=10000, $returnFormat="HTML") {
		try {
			logToFile("Dap_UsersResources.getActiveResourcesCondPassed() - Init...User Id:".$this->user_id.", Product Id:".$this->product_id);
			$html = "";
			
			$product = Dap_Product::loadProduct($this->product_id);
		
			$sql = "select 
			 upj.transaction_id as transid,
			TO_DAYS(now()) as today,
			TO_DAYS(upj.access_start_date) as access_start_days,
			TO_DAYS(upj.access_end_date) as access_end_days,
			prj.resource_id as resource_id,
			p.error_page_url as error_page_url,
			fr.url as url,
			fr.name as name,
			duc.result as result,
			prj.cond_drip_order
			from
				dap_products p,
				dap_products_resources_jn prj,
				dap_file_resources fr,
				dap_users u,
				dap_users_products_jn upj,
				dap_users_cond_content duc
			where
				u.id =:uid and
				p.id =:product_id and
				u.status = 'A' and 
				prj.resource_id = fr.id and 					
				prj.resource_type = 'F' and
				p.id = prj.product_id and
				p.status = 'A' and
				upj.user_id = u.id and
				upj.product_id = p.id and
				upj.status = 'A' and
				duc.user_id = u.id and
				duc.product_id = p.id and
				duc.resource_id = prj.resource_id and
				duc.result is NULL or result != 'P' and
				prj.cond_drip_order > 0
			order by 
				 prj.cond_drip_order asc,prj.display_order desc, fr.id asc
			limit 1
				";

				//	now() between upj.access_start_date and upj.access_end_date	and
				//	(TO_DAYS(NOW()) - TO_DAYS(access_start_date)) between prj.start_day and prj.end_day
			
			//echo "sql: $sql<br>"; exit;
			$dap_dbh = Dap_Connection::getConnection();
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':uid', $this->user_id, PDO::PARAM_INT);
			$stmt->bindParam(':product_id', $this->product_id, PDO::PARAM_INT);
			$stmt->execute();
			
			$html = "<ul class=\"dap_product_links_list\">";
			$resources=array();
			//lets loop over the resource list
			while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
				
				if($returnFormat!="HTML") {
					$resources[]=$row;
					continue;
				}
				
				$row["name"] = mb_convert_encoding($row["name"], "UTF-8", "auto");
				logToFile("COND Resource URL:".$row["url"]);
				
				if(!Dap_Resource::displayResource($row['url'])) {
					//logToFile("This Resource is not displayable...");
					continue;
				}
				//grant access - we should reach here ONLY IF THE PRODUCT RESOURCE RELATIONSHIP IS CLEAN AND ALLOWED.
				//return $resource;
				//$_SESSION['DAP_ERROR'] = $ERROR_CODES["DAP002"];
				//logToFile("Granting Access To Resource URL:".$row["url"].", Resource ID:".$row["resource_id"]);
				if($row['name'] == "") {
					$name = $row['url'];
				}
				else {
					$name = mb_convert_encoding($row["name"], "UTF-8", "auto");
					//$name = "";
				}

				$name = stripslashes($name);
				
				$result = $row["result"];
				
				if($result=="P")
					$html .= "<li><a href='".stripslashes($row['url'])."'>".stripslashes($name)."</a> - Course Complete!</li>";
				else
					$html .= "<li><a href='".stripslashes($row['url'])."'>".stripslashes($name)."</a>- Course not Complete</li>";
				//logToFile("HTML: " . $html);
			}
			
			if($returnFormat!="HTML") {
				logToFile("returning cond drip resources");
				return $resources;
			}
			//logToFile("html: $html"); 
			if($html == "<ul class=\"dap_product_links_list\">") {
				$html .= "<li>".USER_LINKS_NOLINKSFOUND_TEXT."</li>";
			}
			
			$html .= "</ul>";
			
			return $html;
			
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}		

	}
	
	public function getActiveResourcesCondUpcoming($orderBy="desc", $limit=10000, $returnFormat="HTML") {
		try {
			logToFile("Dap_UsersResources.getActiveResourcesCondUpcoming() - Init...User Id:".$this->user_id.", Product Id:".$this->product_id);
			$html = "";
			
			$product = Dap_Product::loadProduct($this->product_id);
		
			$sql = "select 
			upj.transaction_id as transid,
			TO_DAYS(now()) as today,
			TO_DAYS(upj.access_start_date) as access_start_days,
			TO_DAYS(upj.access_end_date) as access_end_days,
			prj.resource_id as resource_id,
			p.error_page_url as error_page_url,
			fr.url as url,
			fr.name as name,
			duc.result as result,
			prj.cond_drip_order
			from
				dap_products p,
				dap_products_resources_jn prj,
				dap_file_resources fr,
				dap_users u,
				dap_users_products_jn upj,
				dap_users_cond_content duc
			where
				u.id =:uid and
				p.id =:product_id and
				u.status = 'A' and 
				prj.resource_id = fr.id and 					
				prj.resource_type = 'F' and
				p.id = prj.product_id and
				p.status = 'A' and
				upj.user_id = u.id and
				upj.product_id = p.id and
				upj.status = 'A' and
				duc.user_id = u.id and
				duc.product_id = p.id and
				duc.resource_id = prj.resource_id and
				duc.result is NULL OR result != 'P' and
				prj.cond_drip_order > 0
			order by 
				 prj.cond_drip_order asc,prj.display_order desc, fr.id asc
			limit 0, $limit
				";

				//	now() between upj.access_start_date and upj.access_end_date	and
				//	(TO_DAYS(NOW()) - TO_DAYS(access_start_date)) between prj.start_day and prj.end_day
			
			//echo "sql: $sql<br>"; exit;
			$dap_dbh = Dap_Connection::getConnection();
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':uid', $this->user_id, PDO::PARAM_INT);
			$stmt->bindParam(':product_id', $this->product_id, PDO::PARAM_INT);
			$stmt->execute();
			
			$html = "<ul class=\"dap_product_links_list\">";
			$resources=array();
			//lets loop over the resource list
			while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
				
				if($returnFormat!="HTML") {
					$resources[]=$row;
					continue;
				}
				
				$row["name"] = mb_convert_encoding($row["name"], "UTF-8", "auto");
				logToFile("COND Resource URL:".$row["url"]);
				
				if(!Dap_Resource::displayResource($row['url'])) {
					//logToFile("This Resource is not displayable...");
					continue;
				}
				//grant access - we should reach here ONLY IF THE PRODUCT RESOURCE RELATIONSHIP IS CLEAN AND ALLOWED.
				//return $resource;
				//$_SESSION['DAP_ERROR'] = $ERROR_CODES["DAP002"];
				//logToFile("Granting Access To Resource URL:".$row["url"].", Resource ID:".$row["resource_id"]);
				if($row['name'] == "") {
					$name = $row['url'];
				}
				else {
					$name = mb_convert_encoding($row["name"], "UTF-8", "auto");
					//$name = "";
				}

				$name = stripslashes($name);
				
				$result = $row["result"];
				
				if($result=="P")
					$html .= "<li><a href='".stripslashes($row['url'])."'>".stripslashes($name)."</a> - Course Complete!</li>";
				else
					$html .= "<li><a href='".stripslashes($row['url'])."'>".stripslashes($name)."</a>- Course not Complete</li>";
				//logToFile("HTML: " . $html);
			}
			
			if($returnFormat!="HTML") {
				logToFile("returning cond drip resources");
				return $resources;
			}
			//logToFile("html: $html"); 
			if($html == "<ul class=\"dap_product_links_list\">") {
				$html .= "<li>".USER_LINKS_NOLINKSFOUND_TEXT."</li>";
			}
			
			$html .= "</ul>";
			
			return $html;
			
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}		

	}

	public function getActiveResourcesCondUpcomingLater($orderBy="desc", $limit=10000, $returnFormat="HTML") {
		try {
			logToFile("Dap_UsersResources.getActiveResourcesCondUpcomingLater() - Init...User Id:".$this->user_id.", Product Id:".$this->product_id);
			$html = "";
			
			$product = Dap_Product::loadProduct($this->product_id);
		
			$sql = "select distinct (fr.id),
			upj.transaction_id as transid,
			TO_DAYS(now()) as today,
			TO_DAYS(upj.access_start_date) as access_start_days,
			TO_DAYS(upj.access_end_date) as access_end_days,
			prj.resource_id as resource_id,
			p.error_page_url as error_page_url,
			fr.url as url,
			fr.name as name,
			prj.cond_drip_order
			from
				dap_products p,
				dap_products_resources_jn prj,
				dap_file_resources fr,
				dap_users u,
				dap_users_products_jn upj
			where
				u.id =:uid and
				p.id =:product_id and
				u.status = 'A' and 
				prj.resource_id = fr.id and 					
				prj.resource_type = 'F' and
				prj.cond_drip_order > 0 and
				p.id = prj.product_id and
				p.status = 'A' and
				upj.user_id = u.id and
				upj.product_id = p.id and
				upj.status = 'A' and
				prj.resource_id NOT IN (select resource_id from dap_users_cond_content ducc where
				ducc.user_id = u.id and
				ducc.product_id = p.id)
			order by 
				 prj.cond_drip_order asc,prj.display_order desc, fr.id asc
			limit 0, $limit
				";

				//	now() between upj.access_start_date and upj.access_end_date	and
				//	(TO_DAYS(NOW()) - TO_DAYS(access_start_date)) between prj.start_day and prj.end_day
			
			//echo "sql: $sql<br>"; exit;
			$dap_dbh = Dap_Connection::getConnection();
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':uid', $this->user_id, PDO::PARAM_INT);
			$stmt->bindParam(':product_id', $this->product_id, PDO::PARAM_INT);
			$stmt->execute();
			
			$html = "<ul class=\"dap_product_links_list\">";
			$resources=array();
			//lets loop over the resource list
			while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
				
				if($returnFormat!="HTML") {
					$resources[]=$row;
					continue;
				}
				
				$row["name"] = mb_convert_encoding($row["name"], "UTF-8", "auto");
				logToFile("COND Resource URL:".$row["url"]);
				
				if(!Dap_Resource::displayResource($row['url'])) {
					//logToFile("This Resource is not displayable...");
					continue;
				}
				//grant access - we should reach here ONLY IF THE PRODUCT RESOURCE RELATIONSHIP IS CLEAN AND ALLOWED.
				//return $resource;
				//$_SESSION['DAP_ERROR'] = $ERROR_CODES["DAP002"];
				//logToFile("Granting Access To Resource URL:".$row["url"].", Resource ID:".$row["resource_id"]);
				if($row['name'] == "") {
					$name = $row['url'];
				}
				else {
					$name = mb_convert_encoding($row["name"], "UTF-8", "auto");
					//$name = "";
				}

				$name = stripslashes($name);
				
				$result = $row["result"];
				
				if($result=="P")
					$html .= "<li><a href='".stripslashes($row['url'])."'>".stripslashes($name)."</a> - Course Complete!</li>";
				else
					$html .= "<li><a href='".stripslashes($row['url'])."'>".stripslashes($name)."</a>- Course not Complete</li>";
				//logToFile("HTML: " . $html);
			}
			
			if($returnFormat!="HTML") {
				logToFile("returning cond drip resources");
				return $resources;
			}
			//logToFile("html: $html"); 
			if($html == "<ul class=\"dap_product_links_list\">") {
				$html .= "<li>".USER_LINKS_NOLINKSFOUND_TEXT."</li>";
			}
			
			$html .= "</ul>";
			
			return $html;
			
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}		

	}
	
	public function getActiveResources($sss="N", $orderBy="desc", $limit=10000, $returnFormat="HTML") {
		try {
			logToFile("Dap_UsersResources.getActiveResources() - Init...User Id:".$this->user_id.", Product Id:".$this->product_id);
			logToFile("Dap_UsersResources.getActiveResources() - SSS=" . $sss);
			$html = "";
			
			$product = Dap_Product::loadProduct($this->product_id);
			$isSSSMaster=$product->getIs_master();
			logToFile("userlinks.inc: isSSSMaster=". $isSSSMaster);
			
			if (($sss == "N") || ($isSSSMaster == "Y")){
				$sql = "select 
						upj.transaction_id as transid,
						TO_DAYS(now()) as today,
						TO_DAYS(upj.access_start_date) as access_start_days,
						TO_DAYS(upj.access_end_date) as access_end_days,
						prj.is_free as is_free,
						prj.start_day as start_day,
						prj.end_day as end_day,
						TO_DAYS(prj.start_date) as res_start_days,
						TO_DAYS(prj.end_date) as res_end_days,
						prj.num_clicks as num_clicks,
						prj.resource_id as resource_id,
						p.error_page_url as error_page_url,
						fr.url as url,
						fr.name as name
				from
					dap_products p,
					dap_products_resources_jn prj,
					dap_file_resources fr,
					dap_users u,
					dap_users_products_jn upj				
				where
					u.id =:uid and
					p.id =:product_id and
					u.status = 'A' and 
					prj.resource_id = fr.id and 					
					prj.resource_type = 'F' and
					p.id = prj.product_id and
					p.status = 'A' and
					upj.user_id = u.id and
					upj.product_id = p.id and
					upj.status = 'A' 
				order by 
					start_day $orderBy,
					res_start_days $orderBy,
					display_order $orderBy,
					prj.num_clicks $orderBy
				limit 0, $limit
					";
			}
			else {
				
				   $hasAccess=Dap_UserCredits::hasAccessTo($this->user_id, $this->product_id); 
				   $sssHasAccess=true;
				    logToFile("Dap_usersproducts.php:  hasAccess=" . $hasAccess);
				   
				   if($hasAccess) {
					   $allowAccessToFutureContentAutomatically=$product->getAllowAccessToFutureContent();
				   	   logToFile("functions.php:  allowAccessToFutureContentAutomatically=" . $allowAccessToFutureContentAutomatically . " for productId=". $this->product_id);
				   
					   if($allowAccessToFutureContentAutomatically == "Y") {	
				   
						   $sql = "select DISTINCT 
							upj.transaction_id as transid,
							TO_DAYS(now()) as today,
							TO_DAYS(upj.access_start_date) as access_start_days,
							TO_DAYS(upj.access_end_date) as access_end_days,
							prj.is_free as is_free,
							prj.start_day as start_day,
							prj.end_day as end_day,
							TO_DAYS(prj.start_date) as res_start_days,
							TO_DAYS(prj.end_date) as res_end_days,
							prj.num_clicks as num_clicks,
							prj.resource_id as resource_id,
							p.error_page_url as error_page_url,
							fr.url as url,
							fr.name as name
							from
								dap_products p,
								dap_products_resources_jn prj,
								dap_file_resources fr,
								dap_users u,
								dap_users_products_jn upj,
								dap_users_credits duc
							where
								u.id =:uid and
								p.id =:product_id and
								u.status = 'A' and 
								prj.resource_id = fr.id and 					
								prj.resource_type = 'F' and
								p.id = prj.product_id and
								p.status = 'A' and
								upj.user_id = u.id and
								upj.product_id = p.id and
								upj.status = 'A' and
								duc.user_id = u.id and
								duc.product_id = p.id 
							order by 
								fr.name, prj.display_order
							limit 0, $limit
								";
					   }
					   else {
						   $sql = "select DISTINCT 
							upj.transaction_id as transid,
							TO_DAYS(now()) as today,
							TO_DAYS(upj.access_start_date) as access_start_days,
							TO_DAYS(upj.access_end_date) as access_end_days,
							prj.is_free as is_free,
							prj.start_day as start_day,
							prj.end_day as end_day,
							TO_DAYS(prj.start_date) as res_start_days,
							TO_DAYS(prj.end_date) as res_end_days,
							prj.num_clicks as num_clicks,
							prj.resource_id as resource_id,
							p.error_page_url as error_page_url,
							fr.url as url,
							fr.name as name
							from
								dap_products p,
								dap_products_resources_jn prj,
								dap_file_resources fr,
								dap_users u,
								dap_users_products_jn upj,
								dap_users_credits duc
							where
								u.id =:uid and
								p.id =:product_id and
								u.status = 'A' and 
								prj.resource_id = fr.id and 					
								prj.resource_type = 'F' and
								p.id = prj.product_id and
								p.status = 'A' and
								upj.user_id = u.id and
								upj.product_id = p.id and
								upj.status = 'A' and
								duc.user_id = u.id and
								duc.product_id = p.id and
								duc.resource_id = fr.id
							order by 
								fr.name, prj.display_order
							limit 0, $limit
								";
					   }
				   }
				   else {
					   
					    logToFile("functions.php:  no access in user credits");
						
					   	$sql = "select 
						upj.transaction_id as transid,
						TO_DAYS(now()) as today,
						TO_DAYS(upj.access_start_date) as access_start_days,
						TO_DAYS(upj.access_end_date) as access_end_days,
						prj.is_free as is_free,
						prj.start_day as start_day,
						prj.end_day as end_day,
						TO_DAYS(prj.start_date) as res_start_days,
						TO_DAYS(prj.end_date) as res_end_days,
						prj.num_clicks as num_clicks,
						prj.resource_id as resource_id,
						p.error_page_url as error_page_url,
						fr.url as url,
						fr.name as name
				from
					dap_products p,
					dap_products_resources_jn prj,
					dap_file_resources fr,
					dap_users u,
					dap_users_products_jn upj,
					dap_users_credits duc
				where
					u.id =:uid and
					p.id =:product_id and
					u.status = 'A' and 
					prj.resource_id = fr.id and 					
					prj.resource_type = 'F' and
					p.id = prj.product_id and
					p.status = 'A' and
					upj.user_id = u.id and
					upj.product_id = p.id and
					upj.status = 'A' and
					duc.user_id = u.id and
					duc.product_id = p.id and
					duc.resource_id = prj.resource_id
				order by 
					fr.name, prj.display_order
				limit 0, $limit
					";
				   }
			}
				//	now() between upj.access_start_date and upj.access_end_date	and
				//	(TO_DAYS(NOW()) - TO_DAYS(access_start_date)) between prj.start_day and prj.end_day
			
			//echo "sql: $sql<br>"; exit;
			$dap_dbh = Dap_Connection::getConnection();
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':uid', $this->user_id, PDO::PARAM_INT);
			$stmt->bindParam(':product_id', $this->product_id, PDO::PARAM_INT);
			$stmt->execute();
			
			$html = "<ul class=\"dap_product_links_list\">";
			$post_cancel_access = Dap_Config::get("POST_CANCEL_ACCESS");
			if(isset($post_cancel_access)) {
				$post_cancel_access = strtolower($post_cancel_access);
			}		
			
			$resources=array();			

			//lets loop over the resource list
			while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
				if($returnFormat!="HTML") {
					$resources[]=$row;
					continue;
				}
				
				$row["name"] = mb_convert_encoding($row["name"], "UTF-8", "auto");
				logToFile("Resource URL:".$row["url"]);
				//logToFile("Resource ID:".$row["resource_id"]);
				//logToFile("Today:".$row["today"]);
				//echo "<br>";
				//logToFile("Product Access Start Days:".$row["access_start_days"]);
				//echo "<br>";
				//logToFile("Product Access End Days:" . $row["access_end_days"]);
				//echo "<br>";
				//logToFile("Resource Start Day:" . $row["start_day"]);
				//echo "<br>";
				//logToFile("Resource End Day:" . $row["end_day"]);
				//echo "<br>";
				//logToFile("Resource Start (Date)DAYS:" . $row["res_start_days"]);
				//echo "<br>";
				//logToFile("Resource End (Date)DAYS:" . $row["res_end_days"]);
				//echo "<br>";
				//logToFile("Product Resource Num Clicks:" . $row["num_clicks"]);
				//echo "<br>";
				
				//product is SIGNUP only, then check if resource is free
				// -1 - direct sign up for free resources
				// -2 - admin sign up - for free resources
				// -3 - admin paid sign up - for all resources
				// TODO: WE NEED TO COME UP WITH SPECIAL TRANS ID FOR SIGNUP ONLY.
				//TODO: ADMIN ADDED USER-PRODUCT RELATIONSHIP IS NOT WORKING. because the transid is put in as 0.
				
				/** 
				if((($row["transid"] == "-2") || ($row["transid"] == "-1")) && (strtolower($row["is_free"]) != "y")) {
					//logToFile("Not Free Resource, but User is FREE...");
					//logToFile("DAP005");
					continue;
					//return $resource;			
					//$_SESSION['DAP_ERROR'] = $ERROR_CODES["DAP005"];
					//$_SESSION['DAP_ERROR_URL'] = $row['error_page_url'];
					//return FALSE;			
				}
				*/
				
			//lets present two modes of operation 
			if($sssHasAccess){
				logToFile("DAP_UsersProducts.class.php: getActiveResources(): SSS product, show content list");
			}
			else if($post_cancel_access == 'y') {
				//we have dates on the resource
				if($row["res_start_days"] <> 0 && $row["res_start_days"] <> "" &&
					$row["res_end_days"] <> 0 && $row["res_end_days"] <> "" ) {
					//set resource start days 
					$resource_start_days = $row["res_start_days"];
					$resource_end_days = $row["res_end_days"];
				}
							
				//we have "days" on the resource
				if($row["start_day"] <> 0 && $row["start_day"] <> "" &&
					$row["end_day"] <> 0 && $row["end_day"] <> "" ) {
					//set resource start days 
					$resource_start_days = $row["access_start_days"] + $row["start_day"] - 1 ;
					$resource_end_days = $row["access_start_days"] + $row["end_day"] - 1 ;
					
					//logToFile("We have 'days' on the resource"); 
					//logToFile("resource_start_days: $resource_start_days"); 
					//logToFile("resource_end_days: $resource_end_days"); 
					//logToFile("User's row[access_start_days]: " . $row["access_start_days"]); 
					
					
					/**
						So if resource "days" are hard-coded, but resource end day is in the past,
						then do not allow access. Will help offer expiring bonuses even though post-cancel-access is yes.
					*/
					if($row["today"] > $resource_end_days ) { //Expiring Bonuses
						//logToFile("Sorry: The 'end day' for this content is in the past...");
						//logToFile("DAP001");
						continue;
					}					
				}

				//if resource starts in future, lets not grant access.
				if($row["today"] < $resource_start_days ) {
					//logToFile("Resource Start Date is in future...");
					//logToFile("DAP001");
					continue;
				}					

				
				//
				// If resource ends before upj start date - then no acesss. This could only happen 
				//    when calendar dates are used at the resource level.
				// If resource starts after upj end date - then no access. This could only happen
				//    when calendar dates are used at the resource level.
				//
				//
				if($resource_end_days < $row["access_start_days"] ||
					$resource_start_days > $row["access_end_days"]) {
					//logToFile("Product Start Date is in future...");
					//logToFile("Resource Start Days:".$resource_start_days);
					//logToFile("Resource End Days:".$resource_end_days);
					//logToFile("Access Start Days:".$row["access_start_days"]);
					//logToFile("Access End Days:".$row["access_end_days"]);
					//logToFile("DAP005");
					//logToFile($ERROR_CODES["DAP005"]);
					continue;						
				}				
			
			} else {				
				//Product did not lauch yet.
				if($row["today"] < $row["access_start_days"]) {
					//logToFile("Product Start Date is in future...");
					//logToFile("DAP001");
					continue;
					//return $resource;						
					//$_SESSION['DAP_ERROR'] = $ERROR_CODES["DAP001"];
					//$_SESSION['ERROR_URL'] = $row['error_page_url'];
					//return FALSE;
				}
				//Product expired 
				if($row["today"] > $row["access_end_days"]) {
					//logToFile("Product End Date is in past...");
					//logToFile("DAP002");
					continue;
				}
				//product is available.
				//check start date(days).
				if($row["res_start_days"] <> 0 && $row["res_start_days"] <> "" &&
					$row["res_end_days"] <> 0 && $row["res_end_days"] <> "" ) {
					//resource is available in future.
					if($row["today"] < $row["res_start_days"]) {
						//logToFile("Resource Start Date  is in future...");
						//logToFile("DAP003");
						continue;
					}
					//resource  expired.
					if($row["today"] > $row["res_end_days"]) {
						//logToFile("Resource End Date  is in past...");
						//logToFile("DAP004");
						continue;
					}
					//logToFile("Start Days(Date) and End Days(Date) check passed...");
	
				} else {
					//logToFile("Start Days(Date) and End Days(Date) are empty or ZERO.. not checking...");
				}
				//check start day
				$lag_days = $row["today"] - $row["access_start_days"] + 1;
				//check resource start and end day only if they are both non zero. 
				if($row["start_day"] <> 0 && $row["start_day"] <> "" &&
					$row["end_day"] <> 0 && $row["end_day"] <> "" ) {

					//resource is available in future.
					if($lag_days < $row["start_day"]) {
						//logToFile("Lag Days:".$lag_days);
						//logToFile("Start Day:".$row["start_day"]);
						//logToFile("Resource Start Day  is in future...");
						//logToFile("DAP003");
						continue;
						//return $resource;
						//$_SESSION['DAP_ERROR'] = $ERROR_CODES["DAP003"];
						//$_SESSION['DAP_ERROR_URL'] = $row['error_page_url'];
						//return FALSE;
					}
					//resource availability expired.
					if($lag_days > $row["end_day"]) {
						//logToFile("Lag Days:".$lag_days);
						//logToFile("End Days:".$row["end_day"]);
						//logToFile("Resource Start Day  is in past...");
						//logToFile("DAP004");
						continue;
						//return $resource;
						//$_SESSION['DAP_ERROR'] = $ERROR_CODES["DAP004"];
						//$_SESSION['DAP_ERROR_URL'] = $row['error_page_url'];
						//return FALSE;
					}
					//logToFile("Start Day and End Day check passed...");
					} else {
						//logToFile("Start Day and End Day are empty or ZERO.. not checking...");
					}
				} //end of config allow post cancel access
				if(!Dap_Resource::isCountAvailable($this->user_id, $row['url'])) {
					//logToFile("Click Count is Negative...");
					continue;
				}
				if(!Dap_Resource::displayResource($row['url'])) {
					//logToFile("This Resource is not displayable...");
					continue;
				}
				//grant access - we should reach here ONLY IF THE PRODUCT RESOURCE RELATIONSHIP IS CLEAN AND ALLOWED.
				//return $resource;
				//$_SESSION['DAP_ERROR'] = $ERROR_CODES["DAP002"];
				//logToFile("Granting Access To Resource URL:".$row["url"].", Resource ID:".$row["resource_id"]);
				if($row['name'] == "") {
					$name = $row['url'];
				}
				else {
					$name = mb_convert_encoding($row["name"], "UTF-8", "auto");
					//$name = "";
				}

				$name = stripslashes($name);
				$html .= "<li><a href='".stripslashes($row['url'])."'>".stripslashes($name)."</a></li>";
				//logToFile("HTML: " . $html);
			}
			
			if($returnFormat!="HTML")
				return $resources;
				
			//logToFile("html: $html"); 
			if($html == "<ul class=\"dap_product_links_list\">") {
				$html .= "<li>".USER_LINKS_NOLINKSFOUND_TEXT."</li>";
			}
			$html .= "</ul>";
			return $html;
			
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}		

	}

	public function getActiveResourcesNew($sss="N", $orderBy="desc", $limit=10000, $returnFormat="HTML", $nocontent, $clicktostarttext,$numberoflinks) {
		try {
			logToFile("Dap_UsersResources.getActiveResources() - Init...User Id:".$this->user_id.", Product Id:".$this->product_id);
			logToFile("Dap_UsersResources.getActiveResources() - SSS=" . $sss);
			$html = "";
			
			$product = Dap_Product::loadProduct($this->product_id);
			$isSSSMaster=$product->getIs_master();
			logToFile("userlinks.inc: isSSSMaster=". $isSSSMaster);
			
			if (($sss == "N") || ($isSSSMaster == "Y")){
				$sql = "select 
						upj.transaction_id as transid,
						TO_DAYS(now()) as today,
						TO_DAYS(upj.access_start_date) as access_start_days,
						TO_DAYS(upj.access_end_date) as access_end_days,
						prj.is_free as is_free,
						prj.start_day as start_day,
						prj.end_day as end_day,
						TO_DAYS(prj.start_date) as res_start_days,
						TO_DAYS(prj.end_date) as res_end_days,
						prj.num_clicks as num_clicks,
						prj.resource_id as resource_id,
						p.error_page_url as error_page_url,
						fr.url as url,
						fr.name as name
				from
					dap_products p,
					dap_products_resources_jn prj,
					dap_file_resources fr,
					dap_users u,
					dap_users_products_jn upj				
				where
					u.id =:uid and
					p.id =:product_id and
					u.status = 'A' and 
					prj.resource_id = fr.id and 					
					prj.resource_type = 'F' and
					p.id = prj.product_id and
					p.status = 'A' and
					upj.user_id = u.id and
					upj.product_id = p.id and
					upj.status = 'A' 
				order by 
					start_day $orderBy,
					res_start_days $orderBy,
					display_order $orderBy,
					prj.num_clicks $orderBy
				limit 0, $limit
					";
			}
			else {
				
				   $hasAccess=Dap_UserCredits::hasAccessTo($this->user_id, $this->product_id); 
				   $sssHasAccess=true;
				    logToFile("Dap_usersproducts.php:  hasAccess=" . $hasAccess);
				   
				   if($hasAccess) {
					   $allowAccessToFutureContentAutomatically=$product->getAllowAccessToFutureContent();
				   	   logToFile("functions.php:  allowAccessToFutureContentAutomatically=" . $allowAccessToFutureContentAutomatically . " for productId=". $this->product_id);
				   
					   if($allowAccessToFutureContentAutomatically == "Y") {	
				   
						   $sql = "select DISTINCT 
							upj.transaction_id as transid,
							TO_DAYS(now()) as today,
							TO_DAYS(upj.access_start_date) as access_start_days,
							TO_DAYS(upj.access_end_date) as access_end_days,
							prj.is_free as is_free,
							prj.start_day as start_day,
							prj.end_day as end_day,
							TO_DAYS(prj.start_date) as res_start_days,
							TO_DAYS(prj.end_date) as res_end_days,
							prj.num_clicks as num_clicks,
							prj.resource_id as resource_id,
							p.error_page_url as error_page_url,
							fr.url as url,
							fr.name as name
							from
								dap_products p,
								dap_products_resources_jn prj,
								dap_file_resources fr,
								dap_users u,
								dap_users_products_jn upj,
								dap_users_credits duc
							where
								u.id =:uid and
								p.id =:product_id and
								u.status = 'A' and 
								prj.resource_id = fr.id and 					
								prj.resource_type = 'F' and
								p.id = prj.product_id and
								p.status = 'A' and
								upj.user_id = u.id and
								upj.product_id = p.id and
								upj.status = 'A' and
								duc.user_id = u.id and
								duc.product_id = p.id 
							order by 
								fr.name, prj.display_order
							limit 0, $limit
								";
					   }
					   else {
						   $sql = "select DISTINCT 
							upj.transaction_id as transid,
							TO_DAYS(now()) as today,
							TO_DAYS(upj.access_start_date) as access_start_days,
							TO_DAYS(upj.access_end_date) as access_end_days,
							prj.is_free as is_free,
							prj.start_day as start_day,
							prj.end_day as end_day,
							TO_DAYS(prj.start_date) as res_start_days,
							TO_DAYS(prj.end_date) as res_end_days,
							prj.num_clicks as num_clicks,
							prj.resource_id as resource_id,
							p.error_page_url as error_page_url,
							fr.url as url,
							fr.name as name
							from
								dap_products p,
								dap_products_resources_jn prj,
								dap_file_resources fr,
								dap_users u,
								dap_users_products_jn upj,
								dap_users_credits duc
							where
								u.id =:uid and
								p.id =:product_id and
								u.status = 'A' and 
								prj.resource_id = fr.id and 					
								prj.resource_type = 'F' and
								p.id = prj.product_id and
								p.status = 'A' and
								upj.user_id = u.id and
								upj.product_id = p.id and
								upj.status = 'A' and
								duc.user_id = u.id and
								duc.product_id = p.id and
								duc.resource_id = fr.id
							order by 
								fr.name, prj.display_order
							limit 0, $limit
								";
					   }
				   }
				   else {
					   
					    logToFile("functions.php:  no access in user credits");
						
					   	$sql = "select 
						upj.transaction_id as transid,
						TO_DAYS(now()) as today,
						TO_DAYS(upj.access_start_date) as access_start_days,
						TO_DAYS(upj.access_end_date) as access_end_days,
						prj.is_free as is_free,
						prj.start_day as start_day,
						prj.end_day as end_day,
						TO_DAYS(prj.start_date) as res_start_days,
						TO_DAYS(prj.end_date) as res_end_days,
						prj.num_clicks as num_clicks,
						prj.resource_id as resource_id,
						p.error_page_url as error_page_url,
						fr.url as url,
						fr.name as name
				from
					dap_products p,
					dap_products_resources_jn prj,
					dap_file_resources fr,
					dap_users u,
					dap_users_products_jn upj,
					dap_users_credits duc
				where
					u.id =:uid and
					p.id =:product_id and
					u.status = 'A' and 
					prj.resource_id = fr.id and 					
					prj.resource_type = 'F' and
					p.id = prj.product_id and
					p.status = 'A' and
					upj.user_id = u.id and
					upj.product_id = p.id and
					upj.status = 'A' and
					duc.user_id = u.id and
					duc.product_id = p.id and
					duc.resource_id = prj.resource_id
				order by 
					fr.name, prj.display_order
				limit 0, $limit
					";
				   }
			}
				 
			//echo "sql: $sql<br>"; exit;
			$dap_dbh = Dap_Connection::getConnection();
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':uid', $this->user_id, PDO::PARAM_INT);
			$stmt->bindParam(':product_id', $this->product_id, PDO::PARAM_INT);
			$stmt->execute();
			
			$html = '<table class="dap_product_links_list report_table table" id="reportTable'.$this->product_id.'"><thead><tr> <th></th></tr></thead><tbody>';
			$post_cancel_access = Dap_Config::get("POST_CANCEL_ACCESS");
			if(isset($post_cancel_access)) {
				$post_cancel_access = strtolower($post_cancel_access);
			}		
			
			$resources=array();			

			//lets loop over the resource list
			while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
				if($returnFormat!="HTML") {
					$resources[]=$row;
					continue;
				}
				
				$row["name"] = mb_convert_encoding($row["name"], "UTF-8", "auto");
				logToFile("Resource URL:".$row["url"]);
				 
				
			//lets present two modes of operation 
			if($sssHasAccess){
				logToFile("DAP_UsersProducts.class.php: getActiveResources(): SSS product, show content list");
			}
			else if($post_cancel_access == 'y') {
				//we have dates on the resource
				if($row["res_start_days"] <> 0 && $row["res_start_days"] <> "" &&
					$row["res_end_days"] <> 0 && $row["res_end_days"] <> "" ) {
					//set resource start days 
					$resource_start_days = $row["res_start_days"];
					$resource_end_days = $row["res_end_days"];
				}
							
				//we have "days" on the resource
				if($row["start_day"] <> 0 && $row["start_day"] <> "" &&
					$row["end_day"] <> 0 && $row["end_day"] <> "" ) {
					//set resource start days 
					$resource_start_days = $row["access_start_days"] + $row["start_day"] - 1 ;
					$resource_end_days = $row["access_start_days"] + $row["end_day"] - 1 ;
					 
					/**
						So if resource "days" are hard-coded, but resource end day is in the past,
						then do not allow access. Will help offer expiring bonuses even though post-cancel-access is yes.
					*/
					if($row["today"] > $resource_end_days ) { //Expiring Bonuses
						 
						continue;
					}					
				}

				//if resource starts in future, lets not grant access.
				if($row["today"] < $resource_start_days ) {
					//logToFile("Resource Start Date is in future...");
					//logToFile("DAP001");
					continue;
				}					

			 
				if($resource_end_days < $row["access_start_days"] ||
					$resource_start_days > $row["access_end_days"]) {
				 
					continue;						
				}				
			
			} else {				
				//Product did not lauch yet.
				if($row["today"] < $row["access_start_days"]) {
					 
					continue;
				 
				}
				//Product expired 
				if($row["today"] > $row["access_end_days"]) {
					 
					continue;
				}
				 
				if($row["res_start_days"] <> 0 && $row["res_start_days"] <> "" &&
					$row["res_end_days"] <> 0 && $row["res_end_days"] <> "" ) {
					//resource is available in future.
					if($row["today"] < $row["res_start_days"]) {
						 
						continue;
					}
					//resource  expired.
					if($row["today"] > $row["res_end_days"]) {
					 
						continue;
					}
				 
	
				} else {
					//logToFile("Start Days(Date) and End Days(Date) are empty or ZERO.. not checking...");
				}
				//check start day
				$lag_days = $row["today"] - $row["access_start_days"] + 1;
				//check resource start and end day only if they are both non zero. 
				if($row["start_day"] <> 0 && $row["start_day"] <> "" &&
					$row["end_day"] <> 0 && $row["end_day"] <> "" ) {

					//resource is available in future.
					if($lag_days < $row["start_day"]) {
						 
						continue;
					 
					}
					//resource availability expired.
					if($lag_days > $row["end_day"]) {
						 
						continue;
					 
					}
					 
					} else {
						//logToFile("Start Day and End Day are empty or ZERO.. not checking...");
					}
				} //end of config allow post cancel access
				if(!Dap_Resource::isCountAvailable($this->user_id, $row['url'])) {
					//logToFile("Click Count is Negative...");
					continue;
				}
				if(!Dap_Resource::displayResource($row['url'])) {
					//logToFile("This Resource is not displayable...");
					continue;
				}
				 
				if($row['name'] == "") {
					$name = $row['url'];
				}
				else {
					$name = mb_convert_encoding($row["name"], "UTF-8", "auto");
					//$name = "";
				}

				$name = stripslashes($name);
				$html .= "<tr class='list-group-item'> <td>
                    <label class='check_icon'><i class='fa fa-check-square'></i>".stripslashes($name)."</label>
                <a href='".stripslashes($row['url'])."' target='_blank' class='btn btn-primary btn-sm'>".$clicktostarttext."</a>
              </td></tr>";
				//logToFile("HTML: " . $html);
			}
			
			if($returnFormat!="HTML")
				return $resources;
				
			//logToFile("html: $html"); 
			/*if($html == "<table class=\"dap_product_links_list\">") {
				//$html .= "<li><p>".USER_LINKS_NOLINKSFOUND_TEXT."</p></li>";
				$html .= "<tr><p>".$nocontent."</p></li>";
			}*/
			$html .= "</tbody></table>";
			return $html;
			
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}		

	}



	
	public function getActiveResourcesNewContent($sss="N", $orderBy="desc", $limit=10000, $returnFormat="HTML", $nocontent, $clicktostarttext,$numberoflinks, $contentdata) {
		try {
			logToFile("Dap_UsersResources.getActiveResources() - Init...User Id:".$this->user_id.", Product Id:".$this->product_id);
			logToFile("Dap_UsersResources.getActiveResources() - SSS=" . $sss);
			$html = "";
			
			$product = Dap_Product::loadProduct($this->product_id);
			$isSSSMaster=$product->getIs_master();
			logToFile("userlinks.inc: isSSSMaster=". $isSSSMaster);
			
			if (($sss == "N") || ($isSSSMaster == "Y")){
				$sql = "select 
						upj.transaction_id as transid,
						TO_DAYS(now()) as today,
						TO_DAYS(upj.access_start_date) as access_start_days,
						TO_DAYS(upj.access_end_date) as access_end_days,
						prj.is_free as is_free,
						prj.start_day as start_day,
						prj.end_day as end_day,
						TO_DAYS(prj.start_date) as res_start_days,
						TO_DAYS(prj.end_date) as res_end_days,
						prj.num_clicks as num_clicks,
						prj.resource_id as resource_id,
						p.error_page_url as error_page_url,
						fr.url as url,
						fr.name as name
				from
					dap_products p,
					dap_products_resources_jn prj,
					dap_file_resources fr,
					dap_users u,
					dap_users_products_jn upj				
				where
					u.id =:uid and
					p.id =:product_id and
					u.status = 'A' and 
					prj.resource_id = fr.id and 					
					prj.resource_type = 'F' and
					p.id = prj.product_id and
					p.status = 'A' and
					upj.user_id = u.id and
					upj.product_id = p.id and
					upj.status = 'A' 
				order by 
					start_day $orderBy,
					res_start_days $orderBy,
					display_order $orderBy,
					prj.num_clicks $orderBy
				limit 0, $limit
					";
			}
			else {
				
				   $hasAccess=Dap_UserCredits::hasAccessTo($this->user_id, $this->product_id); 
				   $sssHasAccess=true;
				    logToFile("Dap_usersproducts.php:  hasAccess=" . $hasAccess);
				   
				   if($hasAccess) {
					   $allowAccessToFutureContentAutomatically=$product->getAllowAccessToFutureContent();
				   	   logToFile("functions.php:  allowAccessToFutureContentAutomatically=" . $allowAccessToFutureContentAutomatically . " for productId=". $this->product_id);
				   
					   if($allowAccessToFutureContentAutomatically == "Y") {	
				   
						   $sql = "select DISTINCT 
							upj.transaction_id as transid,
							TO_DAYS(now()) as today,
							TO_DAYS(upj.access_start_date) as access_start_days,
							TO_DAYS(upj.access_end_date) as access_end_days,
							prj.is_free as is_free,
							prj.start_day as start_day,
							prj.end_day as end_day,
							TO_DAYS(prj.start_date) as res_start_days,
							TO_DAYS(prj.end_date) as res_end_days,
							prj.num_clicks as num_clicks,
							prj.resource_id as resource_id,
							p.error_page_url as error_page_url,
							fr.url as url,
							fr.name as name
							from
								dap_products p,
								dap_products_resources_jn prj,
								dap_file_resources fr,
								dap_users u,
								dap_users_products_jn upj,
								dap_users_credits duc
							where
								u.id =:uid and
								p.id =:product_id and
								u.status = 'A' and 
								prj.resource_id = fr.id and 					
								prj.resource_type = 'F' and
								p.id = prj.product_id and
								p.status = 'A' and
								upj.user_id = u.id and
								upj.product_id = p.id and
								upj.status = 'A' and
								duc.user_id = u.id and
								duc.product_id = p.id 
							order by 
								fr.name, prj.display_order
							limit 0, $limit
								";
					   }
					   else {
						   $sql = "select DISTINCT 
							upj.transaction_id as transid,
							TO_DAYS(now()) as today,
							TO_DAYS(upj.access_start_date) as access_start_days,
							TO_DAYS(upj.access_end_date) as access_end_days,
							prj.is_free as is_free,
							prj.start_day as start_day,
							prj.end_day as end_day,
							TO_DAYS(prj.start_date) as res_start_days,
							TO_DAYS(prj.end_date) as res_end_days,
							prj.num_clicks as num_clicks,
							prj.resource_id as resource_id,
							p.error_page_url as error_page_url,
							fr.url as url,
							fr.name as name
							from
								dap_products p,
								dap_products_resources_jn prj,
								dap_file_resources fr,
								dap_users u,
								dap_users_products_jn upj,
								dap_users_credits duc
							where
								u.id =:uid and
								p.id =:product_id and
								u.status = 'A' and 
								prj.resource_id = fr.id and 					
								prj.resource_type = 'F' and
								p.id = prj.product_id and
								p.status = 'A' and
								upj.user_id = u.id and
								upj.product_id = p.id and
								upj.status = 'A' and
								duc.user_id = u.id and
								duc.product_id = p.id and
								duc.resource_id = fr.id
							order by 
								fr.name, prj.display_order
							limit 0, $limit
								";
					   }
				   }
				   else {
					   
					    logToFile("functions.php:  no access in user credits");
						
					   	$sql = "select 
						upj.transaction_id as transid,
						TO_DAYS(now()) as today,
						TO_DAYS(upj.access_start_date) as access_start_days,
						TO_DAYS(upj.access_end_date) as access_end_days,
						prj.is_free as is_free,
						prj.start_day as start_day,
						prj.end_day as end_day,
						TO_DAYS(prj.start_date) as res_start_days,
						TO_DAYS(prj.end_date) as res_end_days,
						prj.num_clicks as num_clicks,
						prj.resource_id as resource_id,
						p.error_page_url as error_page_url,
						fr.url as url,
						fr.name as name
				from
					dap_products p,
					dap_products_resources_jn prj,
					dap_file_resources fr,
					dap_users u,
					dap_users_products_jn upj,
					dap_users_credits duc
				where
					u.id =:uid and
					p.id =:product_id and
					u.status = 'A' and 
					prj.resource_id = fr.id and 					
					prj.resource_type = 'F' and
					p.id = prj.product_id and
					p.status = 'A' and
					upj.user_id = u.id and
					upj.product_id = p.id and
					upj.status = 'A' and
					duc.user_id = u.id and
					duc.product_id = p.id and
					duc.resource_id = prj.resource_id
				order by 
					fr.name, prj.display_order
				limit 0, $limit
					";
				   }
			}
				 
			//echo "sql: $sql<br>"; exit;
			$dap_dbh = Dap_Connection::getConnection();
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':uid', $this->user_id, PDO::PARAM_INT);
			$stmt->bindParam(':product_id', $this->product_id, PDO::PARAM_INT);
			$stmt->execute();
			
			$html = '<table class="dap_product_links_list report_table table" id="reportTable'.$this->product_id.'"> <thead><th> </th></thead><tbody>';
			$post_cancel_access = Dap_Config::get("POST_CANCEL_ACCESS");
			if(isset($post_cancel_access)) {
				$post_cancel_access = strtolower($post_cancel_access);
			}		
			
			$resources=array();			

			//lets loop over the resource list
			while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
				if($returnFormat!="HTML") {
					$resources[]=$row;
					continue;
				}
				
				$row["name"] = mb_convert_encoding($row["name"], "UTF-8", "auto");
				logToFile("Resource URL:".$row["url"]);
				 
				
			//lets present two modes of operation 
			if($sssHasAccess){
				logToFile("DAP_UsersProducts.class.php: getActiveResources(): SSS product, show content list");
			}
			else if($post_cancel_access == 'y') {
				//we have dates on the resource
				if($row["res_start_days"] <> 0 && $row["res_start_days"] <> "" &&
					$row["res_end_days"] <> 0 && $row["res_end_days"] <> "" ) {
					//set resource start days 
					$resource_start_days = $row["res_start_days"];
					$resource_end_days = $row["res_end_days"];
				}
							
				//we have "days" on the resource
				if($row["start_day"] <> 0 && $row["start_day"] <> "" &&
					$row["end_day"] <> 0 && $row["end_day"] <> "" ) {
					//set resource start days 
					$resource_start_days = $row["access_start_days"] + $row["start_day"] - 1 ;
					$resource_end_days = $row["access_start_days"] + $row["end_day"] - 1 ;
					 
					/**
						So if resource "days" are hard-coded, but resource end day is in the past,
						then do not allow access. Will help offer expiring bonuses even though post-cancel-access is yes.
					*/
					if($row["today"] > $resource_end_days ) { //Expiring Bonuses
						 
						continue;
					}					
				}

				//if resource starts in future, lets not grant access.
				if($row["today"] < $resource_start_days ) {
					//logToFile("Resource Start Date is in future...");
					//logToFile("DAP001");
					continue;
				}					

			 
				if($resource_end_days < $row["access_start_days"] ||
					$resource_start_days > $row["access_end_days"]) {
				 
					continue;						
				}				
			
			} else {				
				//Product did not lauch yet.
				if($row["today"] < $row["access_start_days"]) {
					 
					continue;
				 
				}
				//Product expired 
				if($row["today"] > $row["access_end_days"]) {
					 
					continue;
				}
				 
				if($row["res_start_days"] <> 0 && $row["res_start_days"] <> "" &&
					$row["res_end_days"] <> 0 && $row["res_end_days"] <> "" ) {
					//resource is available in future.
					if($row["today"] < $row["res_start_days"]) {
						 
						continue;
					}
					//resource  expired.
					if($row["today"] > $row["res_end_days"]) {
					 
						continue;
					}
				 
	
				} else {
					//logToFile("Start Days(Date) and End Days(Date) are empty or ZERO.. not checking...");
				}
				//check start day
				$lag_days = $row["today"] - $row["access_start_days"] + 1;
				//check resource start and end day only if they are both non zero. 
				if($row["start_day"] <> 0 && $row["start_day"] <> "" &&
					$row["end_day"] <> 0 && $row["end_day"] <> "" ) {

					//resource is available in future.
					if($lag_days < $row["start_day"]) {
						 
						continue;
					 
					}
					//resource availability expired.
					if($lag_days > $row["end_day"]) {
						 
						continue;
					 
					}
					 
					} else {
						//logToFile("Start Day and End Day are empty or ZERO.. not checking...");
					}
				} //end of config allow post cancel access
				if(!Dap_Resource::isCountAvailable($this->user_id, $row['url'])) {
					//logToFile("Click Count is Negative...");
					continue;
				}
				if(!Dap_Resource::displayResource($row['url'])) {
					//logToFile("This Resource is not displayable...");
					continue;
				}
				 
				if($row['name'] == "") {
					$name = $row['url'];
				}
				else {
					$name = mb_convert_encoding($row["name"], "UTF-8", "auto");
					//$name = "";
				}

				$name = stripslashes($name);
				$contentdataNew  =  str_replace( 'Lorem Ipsum is simply dummy text', $name, $contentdata); 
				 
				if($clicktostarttext ==""){				
					$html .= "<tr class='list-group-item'> <td>						 
					<a href='".stripslashes($row['url'])."' target='_blank' class='btn btn-primary btn-sm'>".$contentdataNew."</a>
				  </td></tr>";
				}else{
					$html .= "<tr class='list-group-item'> <td>
						<label class='check_icon'><i class='fa fa-check-square'></i><div>".$contentdataNew."</div></label>
						<a href='".stripslashes($row['url'])."' target='_blank' class='btn btn-primary btn-sm'>".$clicktostarttext."</a>
					</td></tr>";				  
					
				}
				
				//logToFile("HTML: " . $html);
			}
			
			if($returnFormat!="HTML")
				return $resources;
				
			//logToFile("html: $html"); 
			/*if($html == "<table class=\"dap_product_links_list\">") {
				//$html .= "<li><p>".USER_LINKS_NOLINKSFOUND_TEXT."</p></li>";
				$html .= "<tr><p>".$nocontent."</p></li>";
			}*/
			$html .= "</tbody></table>";
			return $html;
			
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}		

	}



	public function getActiveResourcesNewContentForCourse($sss="N", $orderBy="desc", $limit=10000, $returnFormat="HTML", $nocontent, $clicktostarttext,$numberoflinks, $contentdata, $module_id,$mod_name, $course_progress,$add_lessclass = '') {
		try {
			logToFile("Dap_UsersResources.getActiveResourcesNewContentForCourse() - Init...User Id:".$this->user_id.", Product Id:".$this->product_id);
			logToFile("Dap_UsersResources.getActiveResourcesNewContentForCourse() - SSS=" . $sss." module_id=" . $module_id);
			 
			$html = "";
			
			$product = Dap_Product::loadProduct($this->product_id);
			$isSSSMaster=$product->getIs_master();
			logToFile("userlinks.inc: isSSSMaster=". $isSSSMaster);
			
			if (($sss == "N") || ($isSSSMaster == "Y")){
				 
				$sql = "select 
						upj.transaction_id as transid,
						TO_DAYS(now()) as today,
						TO_DAYS(upj.access_start_date) as access_start_days,
						TO_DAYS(upj.access_end_date) as access_end_days,
						prj.is_free as is_free,
						prj.start_day as start_day,
						prj.end_day as end_day,
						TO_DAYS(prj.start_date) as res_start_days,
						TO_DAYS(prj.end_date) as res_end_days,
						prj.num_clicks as num_clicks,
						prj.resource_id as resource_id,
						prj.module_id as module_id,
						p.error_page_url as error_page_url,
						fr.url as url,
						fr.name as name
				from
					dap_products p,
					dap_products_resources_jn prj,
					dap_file_resources fr,
					dap_users u,
					dap_users_products_jn upj				
				where
					u.id =:uid and
					p.id =:product_id and
					prj.module_id =:module_id and
					u.status = 'A' and 
					prj.resource_id = fr.id and 					
					prj.resource_type = 'F' and
					p.id = prj.product_id and
					p.status = 'A' and
					upj.user_id = u.id and
					upj.product_id = p.id and
					upj.status = 'A' 
				order by 
					start_day $orderBy,
					res_start_days $orderBy,
					display_order $orderBy,
					prj.num_clicks $orderBy
				limit 0, $limit
					";
			}
			else {
				
				   $hasAccess=Dap_UserCredits::hasAccessTo($this->user_id, $this->product_id); 
				   $sssHasAccess=true;
				     
				   if($hasAccess) {
					   $allowAccessToFutureContentAutomatically=$product->getAllowAccessToFutureContent();
				   	   logToFile("functions.php:  allowAccessToFutureContentAutomatically=" . $allowAccessToFutureContentAutomatically . " for productId=". $this->product_id);
				   
					   if($allowAccessToFutureContentAutomatically == "Y") {	
				   
						   $sql = "select DISTINCT 
							upj.transaction_id as transid,
							TO_DAYS(now()) as today,
							TO_DAYS(upj.access_start_date) as access_start_days,
							TO_DAYS(upj.access_end_date) as access_end_days,
							prj.is_free as is_free,
							prj.start_day as start_day,
							prj.end_day as end_day,
							TO_DAYS(prj.start_date) as res_start_days,
							TO_DAYS(prj.end_date) as res_end_days,
							prj.num_clicks as num_clicks,
							prj.module_id as module_id,
							prj.resource_id as resource_id,
							p.error_page_url as error_page_url,
							fr.url as url,
							fr.name as name
							from
								dap_products p,
								dap_products_resources_jn prj,
								dap_file_resources fr,
								dap_users u,
								dap_users_products_jn upj,
								dap_users_credits duc
							where
								u.id =:uid and
								p.id =:product_id and
								u.status = 'A' and 
								prj.resource_id = fr.id and 					
								prj.resource_type = 'F' and
								p.id = prj.product_id and
								p.status = 'A' and
								upj.user_id = u.id and
								prj.module_id =:module_id and
								upj.product_id = p.id and
								upj.status = 'A' and
								duc.user_id = u.id and
								duc.product_id = p.id 
							order by 
								fr.name, prj.display_order
							limit 0, $limit
								";
					   }
					   else {
						    
						   $sql = "select DISTINCT 
							upj.transaction_id as transid,
							TO_DAYS(now()) as today,
							TO_DAYS(upj.access_start_date) as access_start_days,
							TO_DAYS(upj.access_end_date) as access_end_days,
							prj.is_free as is_free,
							prj.start_day as start_day,
							prj.module_id as module_id,
							prj.end_day as end_day,
							TO_DAYS(prj.start_date) as res_start_days,
							TO_DAYS(prj.end_date) as res_end_days,
							prj.num_clicks as num_clicks,
							prj.resource_id as resource_id,
							p.error_page_url as error_page_url,
							fr.url as url,		
							fr.name as name
							from
								dap_products p,
								dap_products_resources_jn prj,
								dap_file_resources fr,
								dap_users u,
								dap_users_products_jn upj,
								dap_users_credits duc
							where
								u.id =:uid and
								p.id =:product_id and
								u.status = 'A' and 
								prj.resource_id = fr.id and 					
								prj.resource_type = 'F' and
								prj.module_id =:module_id and
								p.id = prj.product_id and
								p.status = 'A' and
								upj.user_id = u.id and
								upj.product_id = p.id and
								upj.status = 'A' and
								duc.user_id = u.id and
								duc.product_id = p.id and
								duc.resource_id = fr.id
							order by 
								fr.name, prj.display_order
							limit 0, $limit
								";
					   }
				   }
				   else {
					   
					    logToFile("functions.php:  no access in user credits");
						
					   	$sql = "select 
						upj.transaction_id as transid,
						TO_DAYS(now()) as today,
						TO_DAYS(upj.access_start_date) as access_start_days,
						TO_DAYS(upj.access_end_date) as access_end_days,
						prj.is_free as is_free,
						prj.start_day as start_day,
						prj.module_id as module_id,
						prj.end_day as end_day,
						TO_DAYS(prj.start_date) as res_start_days,
						TO_DAYS(prj.end_date) as res_end_days,
						prj.num_clicks as num_clicks,
						prj.resource_id as resource_id,
						p.error_page_url as error_page_url,
						fr.url as url,
						fr.name as name
				from
					dap_products p,
					dap_products_resources_jn prj,
					dap_file_resources fr,
					dap_users u,
					dap_users_products_jn upj,
					dap_users_credits duc
				where
					u.id =:uid and
					p.id =:product_id and
					u.status = 'A' and 
					prj.resource_id = fr.id and 	
					prj.module_id =:module_id and				
					prj.resource_type = 'F' and
					p.id = prj.product_id and
					p.status = 'A' and
					upj.user_id = u.id and
					upj.product_id = p.id and
					upj.status = 'A' and
					duc.user_id = u.id and
					duc.product_id = p.id and
					duc.resource_id = prj.resource_id
				order by 
					fr.name, prj.display_order
				limit 0, $limit
					";
				   }
			}
				 
			 
			$dap_dbh = Dap_Connection::getConnection();
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':uid', $this->user_id, PDO::PARAM_INT);
			$stmt->bindParam(':product_id', $this->product_id, PDO::PARAM_INT);
			$stmt->bindParam(':module_id', $module_id, PDO::PARAM_INT);
			$stmt->execute();
			$course_progress_allow = false;
			 
			$html = ' <table class="dap_product_links_list report_table table course_structure" id="reportTable'.$this->product_id.$module_id.'"> <thead><th>'.$mod_name.'</th></thead><tbody>';
			$post_cancel_access = Dap_Config::get("POST_CANCEL_ACCESS");
			if(isset($post_cancel_access)) {
				$post_cancel_access = strtolower($post_cancel_access);
			}		
			
			$resources=array();			
			
			//lets loop over the resource list
			while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
				if($returnFormat!="HTML") {
					$resources[]=$row;
					continue;
				}
				
				$row["name"] = mb_convert_encoding($row["name"], "UTF-8", "auto");
				logToFile("Resource URL New:".$row["url"]);
				 
				
			//lets present two modes of operation 
			if($sssHasAccess){
				logToFile("DAP_UsersProducts.class.php: getActiveResources(): SSS product, show content list");
			}
			else if($post_cancel_access == 'y') {
				//we have dates on the resource
				if($row["res_start_days"] <> 0 && $row["res_start_days"] <> "" &&
					$row["res_end_days"] <> 0 && $row["res_end_days"] <> "" ) {
					//set resource start days 
					$resource_start_days = $row["res_start_days"];
					$resource_end_days = $row["res_end_days"];
				}
							
				//we have "days" on the resource
				if($row["start_day"] <> 0 && $row["start_day"] <> "" &&
					$row["end_day"] <> 0 && $row["end_day"] <> "" ) {
					//set resource start days 
					$resource_start_days = $row["access_start_days"] + $row["start_day"] - 1 ;
					$resource_end_days = $row["access_start_days"] + $row["end_day"] - 1 ;
					 
					/**
						So if resource "days" are hard-coded, but resource end day is in the past,
						then do not allow access. Will help offer expiring bonuses even though post-cancel-access is yes.
					*/
					if($row["today"] > $resource_end_days ) { //Expiring Bonuses
						 
						continue;
					}					
				}

				//if resource starts in future, lets not grant access.
				if($row["today"] < $resource_start_days ) {
					//logToFile("Resource Start Date is in future...");
					//logToFile("DAP001");
					continue;
				}					

			 
				if($resource_end_days < $row["access_start_days"] ||
					$resource_start_days > $row["access_end_days"]) {
				 
					continue;						
				}				
			
			} else {				
				//Product did not lauch yet.
				if($row["today"] < $row["access_start_days"]) {
					 
					continue;
				 
				}
				//Product expired 
				if($row["today"] > $row["access_end_days"]) {
					 
					continue;
				}
				 
				if($row["res_start_days"] <> 0 && $row["res_start_days"] <> "" &&
					$row["res_end_days"] <> 0 && $row["res_end_days"] <> "" ) {
					//resource is available in future.
					if($row["today"] < $row["res_start_days"]) {
						 
						continue;
					}
					//resource  expired.
					if($row["today"] > $row["res_end_days"]) {
					 
						continue;
					}
				 
	
				} else {
					//logToFile("Start Days(Date) and End Days(Date) are empty or ZERO.. not checking...");
				}
				//check start day
				$lag_days = $row["today"] - $row["access_start_days"] + 1;
				//check resource start and end day only if they are both non zero. 
				if($row["start_day"] <> 0 && $row["start_day"] <> "" &&
					$row["end_day"] <> 0 && $row["end_day"] <> "" ) {

					//resource is available in future.
					if($lag_days < $row["start_day"]) {
						 
						continue;
					 
					}
					//resource availability expired.
					if($lag_days > $row["end_day"]) {
						 
						continue;
					 
					}
					 
					} else {
						//logToFile("Start Day and End Day are empty or ZERO.. not checking...");
					}
				} //end of config allow post cancel access
				if(!Dap_Resource::isCountAvailable($this->user_id, $row['url'])) {
					//logToFile("Click Count is Negative...");
					continue;
				}
				if(!Dap_Resource::displayResource($row['url'])) {
					//logToFile("This Resource is not displayable...");
					continue;
				}
				 
				if($row['name'] == "") {
					$name = $row['url'];
				}
				else {
					$name = mb_convert_encoding($row["name"], "UTF-8", "auto");
					//$name = "";
				}
				
				/******disable/enable calculations*************/
					
				$btndisable = '';
				$lesson_url = $row['url'];
				
				if($add_lessclass){
					$add_lessclass = " enable_modlessclass ";
					$lesson_url = $row['url'];
				}else if($course_progress == 'notallow'){
					 $lesson_url = 'javascript:void(0)';
					$add_lessclass = " disable_modlessclass ";
				}
				
				 if($course_progress_allow){
					 $lesson_url = 'javascript:void(0)';
					 $btndisable = 'btndisable';
					 $add_lessclass = " disable_modlessclass ";
				 }	 
					 				 
				 if($course_progress == 'notallow'){					 
					 $course_progress_allow = true;
				 }
				 
				 $userId = $this->user_id;
				 $course_id = $this->product_id;
				 $lessonexist = DAP_UserCourseProgress::loadByCourseIdModuleIdlessonIduserId($course_id , $module_id, $row['resource_id'], $userId );
				 
				 //logToFile("course_id=" .$course_id." module_id=" .$module_id." resource_id=".$row['resource_id']." userId" .$userId); 
				 //logToFile("lessonexist: " .count($lessonexist)); 
				 
				 $checked_tick = '';
				 if(isset($lessonexist) ){
					  $checked_tick = 'checked_tick';
					   $course_progress_allow = false;
					   $btndisable = '';
					   $lesson_url = $row['url'];
					   $add_lessclass = " enable_modlessclass ";
				  }
			
				/******disable/enable calculations ends*************/
				
				$name = stripslashes($name);
				$contentdataNew  =  str_replace( 'Lorem Ipsum is simply dummy text', $name, $contentdata); 
				 
				if($clicktostarttext ==""){				
					$html .= "<tr class='list-group-item'> <td>						 
					<a href='".stripslashes($lesson_url)."' target='_blank' class='btn btn-primary btn-sm ".$btndisable."'>".$contentdataNew."</a>
				  </td></tr>";
				}else{
					$html .= "<tr class='list-group-item  ".$add_lessclass."'> <td>
						<label class='check_icon'><i class='fa fa-check-square ".$checked_tick."'></i><div>".$contentdataNew."</div></label>
						<a href='".stripslashes($lesson_url)."' target='_blank' class='btn btn-primary btn-sm'>".$clicktostarttext."</a>
					</td></tr>";				  
					
				}
				
			  
			}
			
			if($returnFormat!="HTML")
				return $resources;
				
			//logToFile("html: $html"); 
			/*if($html == "<table class=\"dap_product_links_list\">") {
				//$html .= "<li><p>".USER_LINKS_NOLINKSFOUND_TEXT."</p></li>";
				$html .= "<tr><p>".$nocontent."</p></li>";
			}*/
			$html .= "</tbody></table>";
			return $html;
			
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}		

	}




	/*
		Return FUTURE file resources (as of today) associated with this User Product association.

	*/	
	public function getFutureResources($sss="N", $orderBy="desc", $limit=10000, $makeLinksClickable="Y", $returnFormat="HTML") {
		try {
			//logToFile("Dap_UsersResources.getActiveResources() - Init...User Id:".$this->user_id.", Product Id:".$this->product_id);
			$html = "";
			if ($sss == "N") {
				$sql = "select 
						upj.transaction_id as transid,
						TO_DAYS(now())+1 as today,
						TO_DAYS(upj.access_start_date) as access_start_days,
						TO_DAYS(upj.access_end_date) as access_end_days,
						prj.is_free as is_free,
						prj.start_day as start_day,
						prj.end_day as end_day,
						TO_DAYS(prj.start_date) as res_start_days,
						TO_DAYS(prj.end_date) as res_end_days,
						prj.num_clicks as num_clicks,
						prj.resource_id as resource_id,
						p.error_page_url as error_page_url,
						fr.url as url,
						fr.name as name
				from
					dap_products p,
					dap_products_resources_jn prj,
					dap_file_resources fr,
					dap_users u,
					dap_users_products_jn upj				
				where
					u.id =:uid and
					p.id =:product_id and
					u.status = 'A' and 
					prj.resource_id = fr.id and 
					prj.resource_type = 'F' and
					p.id = prj.product_id and
					p.status = 'A' and
					upj.user_id = u.id and
					upj.product_id = p.id and
					upj.status = 'A' 
				order by 
					start_day $orderBy,
					res_start_days $orderBy,
					prj.num_clicks $orderBy
				limit 0, $limit
					";
			}
			else {
				$sql = "
				select 
					upj.transaction_id as transid,
					TO_DAYS(now())+1 as today,
					TO_DAYS(upj.access_start_date) as access_start_days,
					TO_DAYS(upj.access_end_date) as access_end_days,
					prj.is_free as is_free,
					prj.start_day as start_day,
					prj.end_day as end_day,
					TO_DAYS(prj.start_date) as res_start_days,
					TO_DAYS(prj.end_date) as res_end_days,
					prj.num_clicks as num_clicks,
					prj.resource_id as resource_id,
					p.error_page_url as error_page_url,
					fr.url as url,
					fr.name as name
				from
					dap_products p,
					dap_products_resources_jn prj,
					dap_file_resources fr,
					dap_users u,
					dap_users_products_jn upj,
					dap_users_credits duc
				where
					u.id =:uid and
					p.id =:product_id and
					u.status = 'A' and 
					prj.resource_id = fr.id and 
					prj.resource_type = 'F' and
					p.id = prj.product_id and
					p.status = 'A' and
					upj.user_id = u.id and
					upj.product_id = p.id and
					upj.status = 'A' and
					duc.user_id = u.id and
					duc.product_id = p.id and
					duc.resource_id = prj.resource_id
				order by 
					fr.name, prj.display_order
				limit 0, $limit
					";
				
			}
				//	now() between upj.access_start_date and upj.access_end_date	and
				//	(TO_DAYS(NOW()) - TO_DAYS(access_start_date)) between prj.start_day and prj.end_day
			
			//echo "sql: $sql<br>"; exit;
			$dap_dbh = Dap_Connection::getConnection();
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':uid', $this->user_id, PDO::PARAM_INT);
			$stmt->bindParam(':product_id', $this->product_id, PDO::PARAM_INT);
			$stmt->execute();
			
			$html = "<ul class=\"dap_product_links_list\">";
			//lets loop over the resource list
			while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
				//product is SIGNUP only, then check if resource is free
				// -1 - direct sign up for free resources
				// -2 - admin sign up - for free resources
				// -3 - admin paid sign up - for all resources
				//TODO: WE NEED TO COME UP WITH SPECIAL TRANS ID FOR SIGNUP ONLY.
				//TODO: ADMIN ADDED USER-PRODUCT RELATIONSHIP IS NOT WORKING. because the transid is put in as 0.
				
				/** 
				if((($row["transid"] == "-2") || ($row["transid"] == "-1")) && (strtolower($row["is_free"]) != "y")) {
					//logToFile("Not Free Resource, but User is FREE...");
					//logToFile("DAP005");
					continue;
					//return $resource;			
					//$_SESSION['DAP_ERROR'] = $ERROR_CODES["DAP005"];
					//$_SESSION['DAP_ERROR_URL'] = $row['error_page_url'];
					//return FALSE;			
				}
				*/
			
			if($returnFormat!="HTML") {
				$resources[]=$row;
				continue;
			}
				
			logToFile("---------------------------------------------------------"); 
			//logToFile("url: " . $row["url"]);
			//logToFile("today: " . $row["today"]);
			$comingInDays = "";
			//logToFile("start_day: " . $row["start_day"]); 
			//logToFile("resource_start_days: $resource_start_days");
			
			/**
				What we need:
				$row["today"]
				res_start_days - start DATE
				start_day - start DAY
			*/
			
			//logToFile("resource_end_days: $resource_end_days"); 
			//logToFile("User's row[access_start_days]: " . $row["access_start_days"]); 
			
			//we have dates on the resource
			if($row["res_start_days"] <> 0 && $row["res_start_days"] <> "" &&
				$row["res_end_days"] <> 0 && $row["res_end_days"] <> "" ) {
				//set resource start days 
				$resource_start_days = $row["res_start_days"];
				$resource_end_days = $row["res_end_days"];
			}
							
			//we have "days" on the resource
			if($row["start_day"] <> 0 && $row["start_day"] <> "" &&
				$row["end_day"] <> 0 && $row["end_day"] <> "" ) {
				//set resource start days 
				$resource_start_days = $row["access_start_days"] + $row["start_day"] - 1 ;
				$resource_end_days = $row["access_start_days"] + $row["end_day"] - 1 ;
				
				//logToFile("We have 'days' on the resource"); 
				logToFile("resource_start_days: $resource_start_days"); 
			}
			
			//if resource start dau was in past, then user already has access - so ignore for future content list
			if($row["today"] > $resource_start_days ) {
				logToFile("Resource Start Date is in past...");
				logToFile("DAP001");
				continue;
			}					

				
			//Product expired 
			if($row["today"] > $row["access_end_days"]) {
				//logToFile("Product End Date is in past...");
				logToFile("DAP002");
				continue;
			}
			//check start day
			$lag_days = $row["today"] - $row["access_start_days"] + 1;
			//check resource start and end day only if they are both non zero. 
			if($row["start_day"] <> 0 && $row["start_day"] <> "" &&
				$row["end_day"] <> 0 && $row["end_day"] <> "" ) {

				//resource is available in future.
				if($lag_days > $row["start_day"]) {
					//logToFile("Lag Days:".$lag_days);
					//logToFile("Start Day:".$row["start_day"]);
					//logToFile("Resource Start Day  is in future...");
					logToFile("DAP003");
					continue;
					//return $resource;
					//$_SESSION['DAP_ERROR'] = $ERROR_CODES["DAP003"];
					//$_SESSION['DAP_ERROR_URL'] = $row['error_page_url'];
					//return FALSE;
				}
				//resource availability expired.
				if($lag_days > $row["end_day"]) {
					//logToFile("Lag Days:".$lag_days);
					//logToFile("End Days:".$row["end_day"]);
					//logToFile("Resource Start Day  is in past...");
					logToFile("DAP004");
					continue;
					//return $resource;
					//$_SESSION['DAP_ERROR'] = $ERROR_CODES["DAP004"];
					//$_SESSION['DAP_ERROR_URL'] = $row['error_page_url'];
					//return FALSE;
				}
				//logToFile("Start Day and End Day check passed...");
				} else {
					//logToFile("Start Day and End Day are empty or ZERO.. not checking...");
				}
			//} //end of config allow post cancel access
				if(!Dap_Resource::isCountAvailable($this->user_id, $row['url'])) {
					//logToFile("Click Count is Negative...");
					continue;
				}
				if(!Dap_Resource::displayResource($row['url'])) {
					//logToFile("This Resource is not displayable...");
					continue;
				}
				//grant access - we should reach here ONLY IF THE PRODUCT RESOURCE RELATIONSHIP IS CLEAN AND ALLOWED.
				//return $resource;
				//$_SESSION['DAP_ERROR'] = $ERROR_CODES["DAP002"];
				//logToFile("Granting Access To Resource URL:".$row["url"].", Resource ID:".$row["resource_id"]);
				if($row['name'] == "") {
					$name = $row['url'];
				}
				else {
					$name = mb_convert_encoding($row["name"], "UTF-8", "auto");
					//$name = "";
				}

				$name = stripslashes($name);
				$comingInDays = intval($resource_start_days) - intval($row["today"]) + 1;
				$comingInDaysPrefix = str_replace("XXX",$comingInDays,USER_LINKS_COMINGSOON_PREFIX_TEXT);

				if($makeLinksClickable == "Y") {
					$html .= "<li>$comingInDaysPrefix <a href='".stripslashes($row['url'])."'>".stripslashes($name)."</a></li>";
				} else {
					$html .= "<li>$comingInDaysPrefix ".stripslashes($name)."</li>";
				}
				
				//logToFile("HTML: " . $html);
			}
			if($returnFormat!="HTML") {
				logToFile("returning regular drip upcoming resources");
				return $resources;
			}
			
			if($html == "<ul id=\"dap_product_links_list\">") {
				$html .= "<li>".USER_LINKS_NOLINKSFOUND_TEXT."</li>";
			}
			$html .= "</ul>";
			logToFile("getFutureResource(): ".$html);
			return $html;
			
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}		

	}


	public function getFutureResourcesNew($sss="N", $orderBy="desc", $limit=10000, $makeLinksClickable="Y", $returnFormat="HTML", $nocontentnew, $numberoflinks, $upcoming_text, $upcomingdata) {
		try {
			//logToFile("Dap_UsersResources.getActiveResources() - Init...User Id:".$this->user_id.", Product Id:".$this->product_id);
			$html = "";
			if ($sss == "N") {
				$sql = "select 
						upj.transaction_id as transid,
						TO_DAYS(now())+1 as today,
						TO_DAYS(upj.access_start_date) as access_start_days,
						TO_DAYS(upj.access_end_date) as access_end_days,
						prj.is_free as is_free,
						prj.start_day as start_day,
						prj.end_day as end_day,
						TO_DAYS(prj.start_date) as res_start_days,
						TO_DAYS(prj.end_date) as res_end_days,
						prj.num_clicks as num_clicks,
						prj.resource_id as resource_id,
						p.error_page_url as error_page_url,
						fr.url as url,
						fr.name as name
				from
					dap_products p,
					dap_products_resources_jn prj,
					dap_file_resources fr,
					dap_users u,
					dap_users_products_jn upj				
				where
					u.id =:uid and
					p.id =:product_id and
					u.status = 'A' and 
					prj.resource_id = fr.id and 
					prj.resource_type = 'F' and
					p.id = prj.product_id and
					p.status = 'A' and
					upj.user_id = u.id and
					upj.product_id = p.id and
					upj.status = 'A' 
				order by 
					start_day $orderBy,
					res_start_days $orderBy,
					prj.num_clicks $orderBy
				limit 0, $limit
					";
			}
			else {
				$sql = "
				select 
					upj.transaction_id as transid,
					TO_DAYS(now())+1 as today,
					TO_DAYS(upj.access_start_date) as access_start_days,
					TO_DAYS(upj.access_end_date) as access_end_days,
					prj.is_free as is_free,
					prj.start_day as start_day,
					prj.end_day as end_day,
					TO_DAYS(prj.start_date) as res_start_days,
					TO_DAYS(prj.end_date) as res_end_days,
					prj.num_clicks as num_clicks,
					prj.resource_id as resource_id,
					p.error_page_url as error_page_url,
					fr.url as url,
					fr.name as name
				from
					dap_products p,
					dap_products_resources_jn prj,
					dap_file_resources fr,
					dap_users u,
					dap_users_products_jn upj,
					dap_users_credits duc
				where
					u.id =:uid and
					p.id =:product_id and
					u.status = 'A' and 
					prj.resource_id = fr.id and 
					prj.resource_type = 'F' and
					p.id = prj.product_id and
					p.status = 'A' and
					upj.user_id = u.id and
					upj.product_id = p.id and
					upj.status = 'A' and
					duc.user_id = u.id and
					duc.product_id = p.id and
					duc.resource_id = prj.resource_id
				order by 
					fr.name, prj.display_order
				limit 0, $limit
					";
				
			}
			 
			//echo "sql: $sql<br>"; exit;
			$dap_dbh = Dap_Connection::getConnection();
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':uid', $this->user_id, PDO::PARAM_INT);
			$stmt->bindParam(':product_id', $this->product_id, PDO::PARAM_INT);
			$stmt->execute();
			
			 
			$html = '<table class="dap_product_links_list report_table table" id="dap_product_links_list'.$this->product_id.'"> <thead><th></th><th></th></thead><tbody>';
			//lets loop over the resource list
			while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
			 
			if($returnFormat!="HTML") {
				$resources[]=$row;
				continue;
			}
				
				
		 	//echo "<pre>";	print_r($row ); die;
			logToFile("---------------------------------------------------------"); 
			logToFile("url: " . $row["url"]);
			logToFile("todaytodaytoday: " . $row["today"]);
			$comingInDays = "";
			 
			//we have dates on the resource
			if($row["res_start_days"] <> 0 && $row["res_start_days"] <> "" &&
				$row["res_end_days"] <> 0 && $row["res_end_days"] <> "" ) {
				//set resource start days 
				$resource_start_days = $row["res_start_days"];
				$resource_end_days = $row["res_end_days"];
			}
							
			//we have "days" on the resource
			if($row["start_day"] <> 0 && $row["start_day"] <> "" &&
				$row["end_day"] <> 0 && $row["end_day"] <> "" ) {
				//set resource start days 
				$resource_start_days = $row["access_start_days"] + $row["start_day"] - 1 ;
				$resource_end_days = $row["access_start_days"] + $row["end_day"] - 1 ;
				
				//logToFile("We have 'days' on the resource"); 
				logToFile("resource_start_days: $resource_start_days"); 
			}
			
			//echo " resource_start_days =" . $resource_start_days;
			//echo " today =" . $row["today"];
			//if resource start dau was in past, then user already has access - so ignore for future content list
			if($row["today"] > $resource_start_days ) {
				logToFile("Resource Start Date is in past...");
				logToFile("DAP001");
				continue;
			}					

				
			//Product expired 
			if($row["today"] > $row["access_end_days"]) {
				//logToFile("Product End Date is in past...");
				logToFile("DAP002");
				continue;
			}
			//check start day
			$lag_days = $row["today"] - $row["access_start_days"] + 1;
			//check resource start and end day only if they are both non zero. 
			if($row["start_day"] <> 0 && $row["start_day"] <> "" &&
				$row["end_day"] <> 0 && $row["end_day"] <> "" ) {

				//resource is available in future.
				if($lag_days > $row["start_day"]) {
					 
					logToFile("DAP003");
					continue;
					 
				}
				//resource availability expired.
				if($lag_days > $row["end_day"]) {
					 
					logToFile("DAP004");
					continue;
				 
				}
				//logToFile("Start Day and End Day check passed...");
				} else {
					//logToFile("Start Day and End Day are empty or ZERO.. not checking...");
				}
			//} //end of config allow post cancel access
				if(!Dap_Resource::isCountAvailable($this->user_id, $row['url'])) {
					//logToFile("Click Count is Negative...");
					continue;
				}
				if(!Dap_Resource::displayResource($row['url'])) {
					//logToFile("This Resource is not displayable...");
					continue;
				}
				//grant access - we should reach here ONLY IF THE PRODUCT RESOURCE RELATIONSHIP IS CLEAN AND ALLOWED.
 
				if($row['name'] == "") {
					$name = $row['url'];
				}
				else {
					$name = mb_convert_encoding($row["name"], "UTF-8", "auto");
					//$name = "";
				}

				$name = stripslashes($name);
				
				$comingInDays = intval($resource_start_days) - intval($row["today"]) + 1;
				/*$comingInDaysPrefix = str_replace("XXX",$comingInDays,USER_LINKS_COMINGSOON_PREFIX_TEXT);

				if($makeLinksClickable == "Y") {
					$html .= "<tr><td>$comingInDaysPrefix <a href='".stripslashes($row['url'])."'>".stripslashes($name)."</a></td></tr>";
				} else {
					$html .= "<tr><td>$comingInDaysPrefix ".stripslashes($name)."</td></tr>";
				}*/
				
				$upcomingDaysText =  str_replace("4 Days", $comingInDays, $upcoming_text);
				$name = stripslashes($name);
				$upcomingdataNew  =  str_replace( 'Lorem Ipsum is simply dummy text', $name, $upcomingdata);	 
				$upcomingdataNew  =  str_replace( 'Lorem Ipsum has been the', $name, $upcomingdata);	 
				
				if($makeLinksClickable == "Y") {
					$html .= "<tr><td><a href='".stripslashes($row['url'])."'>".$upcomingdataNew."</a></td><td> ".$upcomingDaysText." </td></tr>";
				} else {
					$html .= "<tr><td>".stripslashes($name)."</td><td> ".$upcomingDaysText." </td></tr>";
				}
				
				//logToFile("HTML: " . $html);
			}
			/*if($returnFormat!="HTML") {
				logToFile("returning regular drip upcoming resources");
				return $resources;
			}*/
		 
			$html .= "</tbody></table>";
			//logToFile("getFutureResource(): ".$html);
			return $html;
			
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}		

	}

	
	public function getFutureResourcesNewForCourse($sss="N", $orderBy="desc", $limit=10000, $makeLinksClickable="Y", $returnFormat="HTML", $nocontentnew, $numberoflinks, $upcoming_text, $upcomingdata, $module_id) {
		try {
			//logToFile("Dap_UsersResources.getActiveResources() - Init...User Id:".$this->user_id.", Product Id:".$this->product_id);
			$html = "";
			if ($sss == "N") {
				$sql = "select 
						upj.transaction_id as transid,
						TO_DAYS(now())+1 as today,
						TO_DAYS(upj.access_start_date) as access_start_days,
						TO_DAYS(upj.access_end_date) as access_end_days,
						prj.is_free as is_free,
						prj.start_day as start_day,
						prj.end_day as end_day,
						prj.module_id as module_id,
						TO_DAYS(prj.start_date) as res_start_days,
						TO_DAYS(prj.end_date) as res_end_days,
						prj.num_clicks as num_clicks,
						prj.resource_id as resource_id,
						p.error_page_url as error_page_url,
						fr.url as url,
						fr.name as name
				from
					dap_products p,
					dap_products_resources_jn prj,
					dap_file_resources fr,
					dap_users u,
					dap_users_products_jn upj				
				where
					u.id =:uid and
					p.id =:product_id and
					prj.module_id =:module_id and
					u.status = 'A' and 
					prj.resource_id = fr.id and 
					prj.resource_type = 'F' and
					p.id = prj.product_id and
					p.status = 'A' and
					upj.user_id = u.id and
					upj.product_id = p.id and
					upj.status = 'A' 
				order by 
					start_day $orderBy,
					res_start_days $orderBy,
					prj.num_clicks $orderBy
				limit 0, $limit
					";
			}
			else {
				$sql = "
				select 
					upj.transaction_id as transid,
					TO_DAYS(now())+1 as today,
					TO_DAYS(upj.access_start_date) as access_start_days,
					TO_DAYS(upj.access_end_date) as access_end_days,
					prj.is_free as is_free,
					prj.start_day as start_day,
					prj.end_day as end_day,
					prj.module_id as module_id,
					TO_DAYS(prj.start_date) as res_start_days,
					TO_DAYS(prj.end_date) as res_end_days,
					prj.num_clicks as num_clicks,
					prj.resource_id as resource_id,
					p.error_page_url as error_page_url,
					fr.url as url,
					fr.name as name
				from
					dap_products p,
					dap_products_resources_jn prj,
					dap_file_resources fr,
					dap_users u,
					dap_users_products_jn upj,
					dap_users_credits duc
				where
					u.id =:uid and
					p.id =:product_id and
					prj.module_id =:module_id and
					u.status = 'A' and 
					prj.resource_id = fr.id and 
					prj.resource_type = 'F' and
					p.id = prj.product_id and
					p.status = 'A' and
					upj.user_id = u.id and
					upj.product_id = p.id and
					upj.status = 'A' and
					duc.user_id = u.id and
					duc.product_id = p.id and
					duc.resource_id = prj.resource_id
				order by 
					fr.name, prj.display_order
				limit 0, $limit
					";
				
			}
			 
			//echo "sql: $sql<br>"; exit;
			$dap_dbh = Dap_Connection::getConnection();
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':uid', $this->user_id, PDO::PARAM_INT);
			$stmt->bindParam(':product_id', $this->product_id, PDO::PARAM_INT);
			$stmt->bindParam(':module_id', $module_id, PDO::PARAM_INT);
			$stmt->execute();
			
			 
			$html = '<table class="dap_product_links_list report_table table" id="dap_product_links_list'.$this->product_id.'"> <thead><th></th><th></th></thead><tbody>';
			//lets loop over the resource list
			while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
			 
			if($returnFormat!="HTML") {
				$resources[]=$row;
				continue;
			}
				
				
		 	//echo "<pre>";	print_r($row ); die;
			logToFile("---------------------------------------------------------"); 
			logToFile("url: " . $row["url"]);
			logToFile("todaytodaytoday: " . $row["today"]);
			$comingInDays = "";
			 
			//we have dates on the resource
			if($row["res_start_days"] <> 0 && $row["res_start_days"] <> "" &&
				$row["res_end_days"] <> 0 && $row["res_end_days"] <> "" ) {
				//set resource start days 
				$resource_start_days = $row["res_start_days"];
				$resource_end_days = $row["res_end_days"];
			}
							
			//we have "days" on the resource
			if($row["start_day"] <> 0 && $row["start_day"] <> "" &&
				$row["end_day"] <> 0 && $row["end_day"] <> "" ) {
				//set resource start days 
				$resource_start_days = $row["access_start_days"] + $row["start_day"] - 1 ;
				$resource_end_days = $row["access_start_days"] + $row["end_day"] - 1 ;
				
				//logToFile("We have 'days' on the resource"); 
				logToFile("resource_start_days: $resource_start_days"); 
			}
			
			//echo " resource_start_days =" . $resource_start_days;
			//echo " today =" . $row["today"];
			//if resource start dau was in past, then user already has access - so ignore for future content list
			if($row["today"] > $resource_start_days ) {
				logToFile("Resource Start Date is in past...");
				logToFile("DAP001");
				continue;
			}					

				
			//Product expired 
			if($row["today"] > $row["access_end_days"]) {
				//logToFile("Product End Date is in past...");
				logToFile("DAP002");
				continue;
			}
			//check start day
			$lag_days = $row["today"] - $row["access_start_days"] + 1;
			//check resource start and end day only if they are both non zero. 
			if($row["start_day"] <> 0 && $row["start_day"] <> "" &&
				$row["end_day"] <> 0 && $row["end_day"] <> "" ) {

				//resource is available in future.
				if($lag_days > $row["start_day"]) {
					 
					logToFile("DAP003");
					continue;
					 
				}
				//resource availability expired.
				if($lag_days > $row["end_day"]) {
					 
					logToFile("DAP004");
					continue;
				 
				}
				//logToFile("Start Day and End Day check passed...");
				} else {
					//logToFile("Start Day and End Day are empty or ZERO.. not checking...");
				}
			//} //end of config allow post cancel access
				if(!Dap_Resource::isCountAvailable($this->user_id, $row['url'])) {
					//logToFile("Click Count is Negative...");
					continue;
				}
				if(!Dap_Resource::displayResource($row['url'])) {
					//logToFile("This Resource is not displayable...");
					continue;
				}
				//grant access - we should reach here ONLY IF THE PRODUCT RESOURCE RELATIONSHIP IS CLEAN AND ALLOWED.
 
				if($row['name'] == "") {
					$name = $row['url'];
				}
				else {
					$name = mb_convert_encoding($row["name"], "UTF-8", "auto");
					//$name = "";
				}

				$name = stripslashes($name);
				
				$comingInDays = intval($resource_start_days) - intval($row["today"]) + 1;
				/*$comingInDaysPrefix = str_replace("XXX",$comingInDays,USER_LINKS_COMINGSOON_PREFIX_TEXT);

				if($makeLinksClickable == "Y") {
					$html .= "<tr><td>$comingInDaysPrefix <a href='".stripslashes($row['url'])."'>".stripslashes($name)."</a></td></tr>";
				} else {
					$html .= "<tr><td>$comingInDaysPrefix ".stripslashes($name)."</td></tr>";
				}*/
				
				$upcomingDaysText =  str_replace("4 Days", $comingInDays, $upcoming_text);
				$name = stripslashes($name);
				$upcomingdataNew  =  str_replace( 'Lorem Ipsum is simply dummy text', $name, $upcomingdata);	 
				$upcomingdataNew  =  str_replace( 'Lorem Ipsum has been the', $name, $upcomingdata);	 
				
				if($makeLinksClickable == "Y") {
					$html .= "<tr><td><a href='".stripslashes($row['url'])."'>".$upcomingdataNew."</a></td><td> ".$upcomingDaysText." </td></tr>";
				} else {
					$html .= "<tr><td>".stripslashes($name)."</td><td> ".$upcomingDaysText." </td></tr>";
				}
				
				//logToFile("HTML: " . $html);
			}
			/*if($returnFormat!="HTML") {
				logToFile("returning regular drip upcoming resources");
				return $resources;
			}*/
		 
			$html .= "</tbody></table>";
			//logToFile("getFutureResource(): ".$html);
			return $html;
			
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}		

	}

	


	//For a given user, load products that user does NOT have access to
	public static function loadProductsNoAccess($userId) {
		try {
			$dap_dbh = Dap_Connection::getConnection();
			$userProductRelArray = array();
			$sss_order_by = Dap_Config::get("SSS_ORDER_BY");
			$sql = "";
	
			switch ($sss_order_by) {
				case "Most-Popular":
				$sql = "SELECT 
					upj.product_id as id, 
					count(product_id) as counta 
				FROM 
					dap_users_products_jn upj, 
					dap_products p
				where
					p.is_master = 'N' and 
					p.self_service_allowed = 'Y' and 
					p.id not in (SELECT product_id FROM dap_users_products_jn WHERE user_id = :userId) 
				group by 
					upj.product_id order by counta desc";
				break;
			
				case "Oldest-First":
				$sql = "select id from dap_products where is_master = 'N' and self_service_allowed = 'Y' and id not in ( SELECT product_id FROM dap_users_products_jn WHERE user_id = :userId) order by id asc";
				break;

				case "Newest-First":
				$sql = "select id from dap_products where is_master = 'N' and self_service_allowed = 'Y' and id not in ( SELECT product_id FROM dap_users_products_jn WHERE user_id = :userId ) order by id desc";
				break;

				case "Alpha-Asc":
				$sql = "select id from dap_products where is_master = 'N' and self_service_allowed = 'Y' and id not in ( SELECT product_id FROM dap_users_products_jn WHERE user_id = :userId ) order by name asc";
				break;

				case "Alpha-Desc":
				$sql = "select id from dap_products where is_master = 'N' and self_service_allowed = 'Y' and id not in ( SELECT product_id FROM dap_users_products_jn WHERE user_id = :userId ) order by name desc";
			}



			//logToFile($sql,LOG_DEBUG_DAP);
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':userId', $userId, PDO::PARAM_INT);
			$stmt->execute();	
			
			while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
				$userProduct = new Dap_UsersProducts();
				$userProduct->setProduct_id($row['id']);
				$userProductRelArray[] = $userProduct;
			}
			
			$stmt = null;
			$dap_dbh = null;
			
			return $userProductRelArray;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}		
	}	

//For a given user, load products that user does NOT have access to
	public static function loadChildProductsForAMaster($userId, $master_product_id) {
		try {
			$dap_dbh = Dap_Connection::getConnection();
			$userProductRelArray = array();
			$sss_order_by = Dap_Config::get("SSS_ORDER_BY");
			$sql = "";
			
			$sql = "SELECT 
					p.id as id, 
					count(p.id) as counta 
				FROM 
					dap_products p,
					dap_products_mc_sss_jn dmcsss
				where
					p.is_master = 'N' and 
					p.self_service_allowed = 'Y' and
					dmcsss.child_product_id = p.id and
					dmcsss.master_product_id = :master_product_id and
					p.selfservice_start_date <= CURDATE( ) and
					p.selfservice_end_date >= CURDATE( )
				group by 
					p.id order by counta desc";
				
				
			switch ($sss_order_by) {
				case "Most-Popular":
				break;
			/*
				case "Oldest-First":
				$sql = "select id from dap_products where is_master = 'N' and self_service_allowed = 'Y' and id not in ( SELECT product_id FROM dap_users_products_jn WHERE user_id = :userId) order by id asc";
				break;

				case "Newest-First":
				$sql = "select id from dap_products where is_master = 'N' and self_service_allowed = 'Y' and id not in ( SELECT product_id FROM dap_users_products_jn WHERE user_id = :userId ) order by id desc";
				break;

				case "Alpha-Asc":
				$sql = "select id from dap_products where is_master = 'N' and self_service_allowed = 'Y' and id not in ( SELECT product_id FROM dap_users_products_jn WHERE user_id = :userId ) order by name asc";
				break;

				case "Alpha-Desc":
				$sql = "select id from dap_products where is_master = 'N' and self_service_allowed = 'Y' and id not in ( SELECT product_id FROM dap_users_products_jn WHERE user_id = :userId ) order by name desc";*/
			}

			//logToFile($sql,LOG_DEBUG_DAP);
			
			logToFile("In loadChildProductsForAMaster"); 
			
			$stmt = $dap_dbh->prepare($sql);
	//		$stmt->bindParam(':userId', $userId, PDO::PARAM_INT);
			$stmt->bindParam(':master_product_id', $master_product_id, PDO::PARAM_INT);

			$stmt->execute();	
			
			logToFile("after loadChildProductsForAMaster"); 
			
			while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
				$userProduct = new Dap_UsersProducts();
				$userProduct->setProduct_id($row['id']);
				$userProductRelArray[] = $userProduct;
			}
			
			$stmt = null;
			$dap_dbh = null;
			
			return $userProductRelArray;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}		
	}	

	//For a given user, load products that user does NOT have access to
	public static function loadMasterProductsSSS($userId) {
		try {
			$dap_dbh = Dap_Connection::getConnection();
			$userProductRelArray = array();
			$sss_order_by = Dap_Config::get("SSS_ORDER_BY");
			$sql = "";
	
			$sql = "SELECT 
				duc.product_id as id, 
				duc.credits_earned,
				duc.credits_spent
			FROM 
				dap_users_products_jn upj,
				dap_products p,
				dap_users_credits duc
			where
				upj.product_id = p.id and
				p.is_master = 'Y' and 
				p.self_service_allowed = 'Y' and
				duc.product_id = p.id and
				duc.credits_earned > 0 and
				duc.user_id = :userId and 
				duc.product_id = upj.product_id and
				duc.user_id = upj.user_id
			group by 
				upj.product_id";
		
			//logToFile($sql,LOG_DEBUG_DAP);
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':userId', $userId, PDO::PARAM_INT);
			$stmt->execute();	
			
			while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
				$userCredits = new Dap_UserCredits();
				logToFile("Dap_UsersProducts.class.php: masterproductId=" . $row['id']);
				
				$userCredits->setProduct_id($row['id']);
				$userCredits->setCredits_earned($row['credits_earned']);
				$userCredits->setCredits_spent($row['credits_spent']);
				$userCreditsRelArray[] = $userCredits;
			}
			
			$stmt = null;
			$dap_dbh = null;
			
			return $userCreditsRelArray;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}		
	}	
	
	public static function activate($code, $user, $productId) {
		try {
			$dap_dbh = Dap_Connection::getConnection();
			$dap_dbh->beginTransaction(); //begin the transaction
			
			//First activate user
			$sql = "update 
						dap_users 
					set
						status = 'A',
						signup_date = '" . date("Y-m-d H:i:s") . "',
						ipaddress = '" . getIpOfUser() . "'
					where
						activation_key = '" . $code . "' and
						status = 'U'
					";
						
			$stmt = $dap_dbh->prepare($sql);
			$stmt->execute();
			$stmt = null;

			//Now activate user-products join table
			$userId = $user->getId();

			$sql = "update 
						dap_users_products_jn
					set
						status = 'A',
						access_start_date = '" . date("Y-m-d") . "'
					where
						user_id = :userId and
						product_id = :productId and
						status = 'I'
					";
			
			//logToFile("-----------------Sql: $sql"); 
			//logToFile("userId: $userId, productId: $productId"); 
						
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':userId', $userId, PDO::PARAM_INT);
			$stmt->bindParam(':productId', $productId, PDO::PARAM_INT);
			$stmt->execute();
			$dap_dbh->commit(); //commit the transaction
			
			//lets make sure we really updated something.
			$count = $stmt->rowCount();
			$credits=0;
			
			if($count > 0) { //User was indeed activated, so send welcome email to user
			
			// add credits if SSS product (upon activation)		
			  $product = Dap_Product::loadProduct($productId);
			  $userProduct = Dap_UsersProducts::load($userId, $productId);
			  $recurring="N";
			  $transId='-1';
			  if($userProduct != NULL) {
				$recurring="Y"; // user already has access to the recurring product
			  }
			  
			  
			  global $includeList;
			  global $classname;
			  
			  $includeList = array();
			  $classname = array();
			  
			  registeredPlugins($includeList, $email, "Add", $product);
			  
			  foreach ($includeList as $key => $value) {
				logToFile( "Dap_UsersProducts.class.php: activate(): INCLUDELIST=" . $key . ", Value=" . $value );
				if (stristr($value, "vbulletin")) {
					//nothing to do yet.. wait till all chaining rules are done for final list of valid products for user		
				}
				else {
					if(defined('PLUGIN_NOTIFY_UPON_DOUBLE_OPT_IN')) {
						if($product->getAllow_free_signup() == "Y") {
							if( ($product->getDouble_optin_subject() != "") && ($product->getDouble_optin_body() != "") ) {
								$notify=false;
								Dap_UsersProducts::pluginAdd($userId, $productId, $value, $product);
								logToFile( "Dap_UsersProducts.class.php: activate(): trigger plugin notification..." );		
							}
						}
					}
				}
			  }
			  
				if(defined('PLUGIN_NOTIFY_UPON_DOUBLE_OPT_IN')) {
					if($product->getAllow_free_signup() == "Y") {
						if( ($product->getDouble_optin_subject() != "") && ($product->getDouble_optin_body() != "") ) {
								logToFile("(Dap_UsersProducts.addUsersProducts()):activate() going to call the automation function",LOG_DEBUG_DAP);
								/* This function is for implementing the automation rules */
								try{
									Dap_UsersProducts::DAPApplyAutomationRules($productId,$userId,$product,"add");
								}
								catch(Exception $e){
									logToFile("(Dap_UsersProducts.addUsersProducts()):activate(),Automation Exception is ".$e->getMessage(),LOG_DEBUG_DAP);
								}
						
							logToFile( "Dap_UsersProducts.class.php: activate(): trigger Dap AUtomation",LOG_DEBUG_DAP );		
						}
					}
				}
			  
				
			  
			  
			  if (($product->getCredits() > 0) && ($product->getSelf_service_allowed() == "Y")) {
				logToFile("Dap_UsersProducts.addUsersProducts(): activate() : SSS: recurring=".$recurring,LOG_DEBUG_DAP); 
				$productId=$product->getId();
				$isSSSMaster=$product->getIs_master();
				
				if( strtolower($product->getIs_recurring()) != "y") {
				  $credits=$product->getCredits(); // free product (onetime) and user getting access for first time
				}
				else if ($recurring == "N") //first time adding user to recurring product
				  $credits=$product->getCredits();
				else { //recurring payment, user already exists
				  if( strtolower($product->getIs_recurring()) == "y") {
					$credits=$product->getRecurringCredits();
				  }
				  else {
					logToFile("Dap_UsersProducts.addUsersProducts(): activate() : SSS: it's a recurring payment for a non-recurring product (free product), no credits assigned. Looks like same user is trying to re-sign for the free product to earn credits. To prevent free product/signup abuse, no credits assigned",LOG_DEBUG_DAP); 
				  }
				}
				if($credits > 0) {
				  if($isSSSMaster == "Y") {
					logToFile("Dap_UsersProducts.addUsersProducts(): activate(): SSS: addign child, credits added to total",LOG_DEBUG_DAP); 
					Dap_UserCredits::addCredits($userId, $productId, $transId, $credits, 0, "By Signup - FREE");
				  }else {
					logToFile("Dap_UsersProducts.addUsersProducts(): activate(): SSS: addign child, credits added to total",LOG_DEBUG_DAP); 
					Dap_UserCredits::redeemCreditsAtProductLevel($userId, $productId, $credits, "Admin Added-Manual FREE");
				  }
				}
			  }
				
			  logToFile("sending welcome email to " . $user->getEmail(),LOG_DEBUG_DAP); 
			  sendUserProductWelcomeEmail($userId, $productId);
				
				//TODO send activation/welcome email to admin	
			}
		  	
			$stmt = null;
			$dap_dbh = null;

			return;
		} catch (PDOException $e) {
			$dap_dbh->rollback();
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			$dap_dbh->rollback();
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}	
	}
	
	
	public static function activateUserAllProducts($user) {
		try {
			$dap_dbh = Dap_Connection::getConnection();
			$dap_dbh->beginTransaction(); //begin the transaction
			
			//First activate user
			$sql = "update 
						dap_users 
					set
						status = 'A',
						signup_date = '" . date("Y-m-d H:i:s") . "'
					where
						activation_key = '" . $user->getActivation_key() . "' and
						status = 'U'
					";
						
			$stmt = $dap_dbh->prepare($sql);
			$stmt->execute();
			$stmt = null;

			//Now activate user-products join table
			$userId = $user->getId();

			$sql = "update 
						dap_users_products_jn
					set
						status = 'A',
						access_start_date = '" . date("Y-m-d") . "'
					where
						user_id = :userId and
						status = 'I'
					";
			
			//logToFile("-----------------Sql: $sql"); 
			//logToFile("userId: $userId, productId: $productId"); 
			
			$userId = $user->getId();
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':userId', $userId, PDO::PARAM_INT);
			$stmt->execute();
			$dap_dbh->commit(); //commit the transaction
			
			$stmt = null;
			$dap_dbh = null;

			return;
		} catch (PDOException $e) {
			$dap_dbh->rollback();
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			$dap_dbh->rollback();
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}	
	}

	public static function directSignupSubmit($user, $coupon_code="", $product_id, $coupon_id="", $isPaid="n") {
		try {
			
			$userDB = null;
			$username = $user->getUser_name();
			$email = $user->getEmail();
			$first_name = $user->getFirst_name();
			$last_name = $user->getLast_name();
			
			//logToFile("username in directSignupSubmit: " . $username); 
			
			//Check if username exists in db, and it matches email of same user, only then proceed forward
			if( ($username != "") && (Dap_User::isInUse("email",$user->getEmail()) || Dap_User::isInUse("user_name",$user->getUser_name()) )) {
				$userDB = Dap_User::loadUserByEmailAndUsername($user->getEmail(), $user->getUser_name());
				if(  !isset($userDB) || ($userDB == null) ) { 
					//no record found for this email/username combo - so separate users have the email and username already in use, so error
					$msg = "Sorry, username/email already in use. <br/>Please go 'back' and pick a different username & email, <br/>or use the correct email/username combination if you are <br/>an existing user";
					header( "Location:error.php?msg=" . urlencode($msg) );
					exit;
				}
				
				//If existing user whose email/username in match that of email/username from form, 
				//then simply update db data with incoming form data
				if(  isset($userDB) && ($userDB != null) ) {
					$first_name = ($user->getFirst_name() != "") ? $user->getFirst_name() : $userDB->getFirst_name();
					$last_name = ($user->getLast_name() != "") ? $user->getLast_name() : $userDB->getLast_name();
					$user_name = ($user->getUser_name() != "") ? $user->getUser_name() : $userDB->getUser_name();
					$email = ($user->getEmail() != "") ? $user->getEmail() : $userDB->getEmail();
					$address1 = ($user->getAddress1() != "") ? $user->getAddress1() : $userDB->getAddress1();
					$address2 = ($user->getAddress2() != "") ? $user->getAddress2() : $userDB->getAddress2();
					$city = ($user->getCity() != "") ? $user->getCity() : $userDB->getCity();
					$state = ($user->getState() != "") ? $user->getState() : $userDB->getState();
					$zip = ($user->getZip() != "") ? $user->getZip() : $userDB->getZip();
					$country = ($user->getCountry() != "") ? $user->getCountry() : $userDB->getCountry();
					$phone = ($user->getPhone() != "") ? $user->getPhone() : $userDB->getPhone();
					$fax = ($user->getFax() != "") ? $user->getFax() : $userDB->getFax();
					$company = ($user->getCompany() != "") ? $user->getCompany() : $userDB->getCompany();
					$title = ($user->getTitle() != "") ? $user->getTitle() : $userDB->getTitle();
					$paypal_email = ($user->getPaypal_email() != "") ? $user->getPaypal_email() : $userDB->getPaypal_email();
					
					$userDB->setFirst_name($first_name);
					$userDB->setLast_name($last_name);
					
					if (!isset($user_name) || ($user_name == "")) {
						$userDB->setUser_name(NULL);
					}
					else {
						//check to be sure
						/*$uname=generateUsername("Dap_UsersProducts.class.php.directSignupSubmit()",$email,$first_name,$last_name);
						$user->setUser_name($uname);
						logToFile("Dap_UsersProducts.class.php.directSignupSubmit: existing user whose email/username in match that of email/username from form: ".$uname,LOG_INFO_DAP); */
						$userDB->setUser_name($user_name);
					}
					
					$userDB->setEmail($email);
					$userDB->setAddress1($address1);
					$userDB->setAddress2($address2);
					$userDB->setCity($city);
					$userDB->setState($state);
					$userDB->setZip($zip);
					$userDB->setCountry($country);
					$userDB->setPhone($phone);
					$userDB->setFax($fax);
					$userDB->setCompany($company);
					$userDB->setTitle($title);
					$userDB->setPaypal_email($paypal_email);
					
					$userDB->update();
					
					$uid = Dap_UsersProducts::addNewUserToProduct($email, $first_name, $last_name, $username, $product_id, $isPaid, "A", $coupon_id);
					return $userDB;
					
					//Now check: If existing user does not already have access to incoming product, then give access. If not, DO NOT extend and simply return.
					//if ( $userDB->hasEverHadAccessTo($product_id) ) {
						//Don't extend and simply return
						//return $userDB;
						
						//logToFile("User already has access to product, so just returning"); 
						//$msg = "MSG_ALREADY_SIGNEDUP";
						//$msg = "Sorry, it appears that you have previously signed up for this product.<br/>So, no further action required from you at this time. Feel free to go 'back' <br/>and continue visiting the rest of our site.";
						//header( "Location:error.php?msg=" . urlencode($msg) );
						//exit;
					//} else {
						//Add to product and return
						//logToFile("About to add existing user to product, coupon_id=". $coupon_id); 
						//$uid = Dap_UsersProducts::addNewUserToProduct($email, $first_name, $last_name, $username, $product_id, $isPaid, "A", $coupon_id);
						//return $userDB;
					//}
				}
				
			}
			
			/**
				If it comes here, then it is a form without even a username field.
				Now, it could be...
				1) Existing user trying to sign up for new product
				2) Totally new user where both email and username are not taken and are still available
			*/
			
			//logToFile("Here in dSS"); 
			
			//First check if Existing user trying to sign up for new product
			if( ($username == "") && (Dap_User::isInUse("email",$user->getEmail())) ) {
				//logToFile("username is blank and email " . $user->getEmail() . " is in use"); 
				$userDB = Dap_User::loadUserByEmail($user->getEmail());
				if( isset($userDB) && ($userDB != null) ) {
					$uid = Dap_UsersProducts::addNewUserToProduct($email, $first_name, $last_name, $user_name, $product_id, $isPaid, "A", $coupon_id);
					return $userDB;
					
					/**
					if ( $userDB->hasEverHadAccessTo($product_id) ) {
						//logToFile("User already has access to product, so just returning"); 
						$msg = "MSG_ALREADY_SIGNEDUP";
						//$msg = "Sorry, it appears that you have previously signed up for this product.<br/>So, no further action required from you at this time. Feel free to go 'back' <br/>and continue visiting the rest of our site.";
						header( "Location:error.php?msg=" . urlencode($msg) );
						exit;
					} else {
						//Add to product and return
						//logToFile("About to add existing user to product, coupon_id=". $coupon_id); 
						$uid = Dap_UsersProducts::addNewUserToProduct($email, $first_name, $last_name, $user_name, $product_id, $isPaid, "A", $coupon_id);
						return $userDB;
					}
					*/
				}
			}
			
			
			
			//Totally new user			
			//First add user to product
						
			$first_name = ($user->getFirst_name() != "") ? $user->getFirst_name() : '';
			$last_name = ($user->getLast_name() != "") ? $user->getLast_name() : '';
			$user_name = ($user->getUser_name() != "") ? $user->getUser_name() : NULL;
			$password = ($user->getPassword() != "") ? $user->getPassword() : "";
			
			if (!isset($user_name) || ($user_name == "")) {
				$uname=generateUsername("Dap_UsersProducts.class.php.directSignupSubmit()",$user->getEmail(),$user->getFirst_name(),$user->getLast_name());
				$user->setUser_name($uname);
				logToFile("Dap_UsersProducts.class.php: directSignupSubmit(): username set to ".$uname,LOG_INFO_DAP);
				//$user->setUser_name(NULL);
			}
			
			$email = ($user->getEmail() != "") ? $user->getEmail() : '';
			
			//logToFile("About to add new user to product, coupon_id=". $coupon_id); 
			
			$userNew=NULL;
			$product = Dap_Product::loadProduct($product_id);
			if( !isset($product) || ($product == NULL) ) return $userNew;
			
			$userNew = new Dap_User();
			
			$userNew->setEmail($email);
			$userNew->setFirst_name($first_name);
			$userNew->setLast_name($last_name);

			if ($username != "")
				$userNew->setUser_name($user_name);
			else {
				//$user->setUser_name(NULL);
				$uname=generateUsername("Dap_UsersProducts.class.php.directSignupSubmit()",$email,$first_name,$last_name);
				if($uname=="") {
					$uname=NULL;
					logToFile("Dap_UsersProducts.class.php: directSignupSubmit(): username set to NULL",LOG_INFO_DAP);
				}
				$userNew->setUser_name($uname);
				logToFile("Dap_UsersProducts.class.php: directSignupSubmit(): username set to ".$uname,LOG_INFO_DAP);
			}								  
			//Figure out what should be user's status
			if( ($product->getDouble_optin_subject() == "") || ($product->getDouble_optin_body() == "") ) {
				//This is single optin, so take what caller sent as $activeStatus
				$userStatus = (strtolower($activeStatus) == "u") ? "U" : "A";
			} else {
				//Double optin. So ignore what caller sent in as $activeStatus and set user status to "U"
				$userStatus = "U";
			}
			$userNew->setStatus($userStatus);
			
			logToFile("Dap_UsersProducts.addNewUserToProduct userStatus:  userStatus=". $userStatus);
			logToFile("Dap_UsersProducts.addNewUserToProduct create new user:  username=". $username);
			
			$address1 = $user->getAddress1();
			$address2 = $user->getAddress2();
			$city = $user->getCity();
			$state = $user->getState();
			$zip = $user->getZip();
			$country = $user->getCountry();
			$phone = $user->getPhone();
			$fax = $user->getFax();
			$company = $user->getCompany();
			$title = $user->getTitle();
			$paypal_email = $user->getPaypal_email();		
			$gdpr_consent = $user->getGDPRConsent();			
			$gdpr_compliance_date = $user->getGDPRCompliance_date();	
			//$userNew->setPassword($password);
			//logToFile("user_name is ". $user_name); 
			//logToFile("directsignupsubmit(): phone is ". $phone); 
			
			$userNew->setFirst_name($first_name );
			$userNew->setLast_name($last_name);
			$userNew->setEmail($email );
			if($password != "") $userNew->setPassword($password);
			$userNew->setAddress1($address1);
			$userNew->setAddress2($address2);
			$userNew->setCity($city);
			$userNew->setState($state);
			$userNew->setZip($zip);
			$userNew->setCountry($country);
			$userNew->setPhone($phone);
			$userNew->setFax($fax);
			$userNew->setCompany($company);
			$userNew->setTitle($title);
			$userNew->setPaypal_email($paypal_email);
			$userNew->setGDPRConsent($gdpr_consent);
			$userNew->setGDPRCompliance_date($gdpr_compliance_date);
			
			
			$uid = $userNew->create();
			  // check if custom field present
			foreach($_REQUEST as $key=>$value) {
				logToFile("Dap_UsersProducts.class.php: key=" . $key . " value=" . $value, LOG_DEBUG_DAP);		
					
				if (strstr($key, "custom_")) {	
					if ($keyval = substr($key, 7)) {
						$customFld = Dap_CustomFields::loadCustomfieldsByName($keyval);
						logToFile("Dap_UsersProducts.class.php: loadCustomfieldsByName(): keyval=" . $keyval, LOG_DEBUG_DAP);		
						
						if ($customFld) {
							$id = $customFld->getId();
							logToFile("Dap_UsersProducts.class.php: customFld Id = " . $id, LOG_DEBUG_DAP);		
							
							$usercustom = new Dap_UserCustomFields();
							$usercustom->setUser_id($uid);
							$usercustom->setCustom_id($id);
							$usercustom->setCustom_value($value);
							
							$cf = Dap_UserCustomFields::loadUserCustomFieldsByCustomFieldId($id, $uid);
							if ($cf) {
								logToFile("Dap_UsersProducts.class.php: call update() to update value=" . $value, LOG_DEBUG_DAP);
								$usercustom->update();
							}
							else {
								logToFile("Dap_UsersProducts.class.php: call create() to add custom value=" . $nv[1], LOG_DEBUG_DAP);
								$usercustom->create();
							}
						}
					}
				}
			}
			
			
			
			$uid = Dap_UsersProducts::addNewUserToProduct($email, $first_name, $last_name, $user_name, $product_id, $isPaid, "A", $coupon_id, $password);
			return $userNew;
		} catch (PDOException $e) {
			//$dap_dbh->rollback();
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			//$dap_dbh->rollback();
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}	
	}

	
	public static function getLoggedInURL($user="") {
		global $_POST;
		$session = Dap_Session::getSession();
		//if($session->isAdmin()) {
			//return "/dap/admin/";
			//exit;
		//} else {
			//logToFile("POST['request']: " . $_POST['request']);
		
		//Starting DAP v4.5, admin logging in via DAP login form
		//will no longer be redirected to DAP admin
		$redirectURL = Dap_Config::get("LOGGED_IN_URL");
		if( (!isset($user)) || ($user=="") )
			$user = $session->getUser();			
		$noRenewalRedirection=false;
		$userProducts = Dap_UsersProducts::loadProducts($user->getId());
		foreach ($userProducts as $userProduct) {
			//check of any active product
			$productId = $userProduct->getProduct_id();
			logToFile("check if any active products...Id: " . $productId); 
			$product = Dap_Product::loadProduct( $productId );
			if(isset($product)) {
			$hasAccess = $user->hasAccessTo($productId);
			if($hasAccess) {
				logToFile("user has active access to : " . $productId); 
				$noRenewalRedirection=true;
			}		
			}			
		}		
		
		
		/* If renewal redirect is enabled, then it gets highest priority */
		//If user has exactly 1 expired product, then redirect to product-specific renewal redirect URL
		//If > 1 expired products, then redirect to GLOBAL renewal redirect URL
		$redirectToRenewalURL = (Dap_Config::get("REDIR_TO_RENEW_URL") == "Y") ? true : false;
		
		if($noRenewalRedirection==false) {
		if($redirectToRenewalURL) {
			logToFile("redirectToRenewalURL is true"); 
			$productCountExpired = $user->hasAccessToHowManyExpiredProducts();
			logToFile("productCountExpired: " . $productCountExpired); 
			if($productCountExpired != 0) {
				logToFile("has expired products");
				if( $productCountExpired == 1 ) {
					$productId = Dap_UsersProducts::loadSingleExpiredProduct($user->getId());
					$product = Dap_Product::loadProduct( $productId );
					$redirectURL = ($product->getRenewal_redirect_url() != "") ? $product->getRenewal_redirect_url() : $redirectURL;
				} else if($productCountExpired > 1) {
					logToFile("productCountExpired > 1"); 	
					$redirectURL = (Dap_Config::get("RENEWAL_REDIR_URL") != "") ? Dap_Config::get("RENEWAL_REDIR_URL") : $redirectURL;
				}
				return $redirectURL;
			}
		}
		}
		//If it doesn't match any of the above, then no renewal redirection required
		//logToFile("No redirection done, redirectURL: $redirectURL"); 
		//If has access to exactly 1 product, then redirect to product-specific landing page
		//If =0 or >1, then redirect site wide LOGGED_IN_URL
		$productCount = $user->hasAccessToHowManyDistinctProducts();
		
		//logToFile("productCount: $productCount");
		if( $productCount == 1 ) {
			$userProducts = Dap_UsersProducts::loadProducts($user->getId());
			foreach ($userProducts as $userProduct) {
				$productId = $userProduct->getProduct_id();
				//logToFile("productId: $productId"); 
				$product = Dap_Product::loadProduct( $productId );
				if ($product->getLogged_in_url() != "") {
					$redirectURL = $product->getLogged_in_url();
					//logToFile("redirectURL: $redirectURL");
				} 
				break;
			}
		}
		
		return $redirectURL;
	}
	
	
	public function loadSingleExpiredProduct($userId) {
		try {
			$dap_dbh = Dap_Connection::getConnection();
			$productId = 0;
			
			//Return product_id of expired product
			$sql = "select
						product_id
					from
						dap_users_products_jn
					where
						user_id = :userId and
						CURDATE() > access_end_date";
						
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':userId', $userId, PDO::PARAM_INT);
			$stmt->execute();
			
			if ($row = $stmt->fetch()) {
				$productId = $row["product_id"];
			}
			
			$sql = null;
			$stmt = null;
			$dap_dbh = null; 
			
			return $productId;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}	
	}	
	
	
	/** Returns string */
	public static function toggleProductStatus($userId, $productId, $productStatusCurrent) {
		try {
			logToFile("toggleProductStatus, userId: $userId"); 
			$dap_dbh = Dap_Connection::getConnection();
			$productStatusNew = "";
			$sql = "";
			$stmt = null;
			
			if($productStatusCurrent == "A") $productStatusNew = "I";
			if($productStatusCurrent == "I") $productStatusNew = "A";

			$sql = "update
						dap_users_products_jn
					set
						status = :productStatusNew
					where
						user_id = :userId and
						product_id = :productId
					";
			//logToFile("sql: $sql"); 
			//logToFile("userStatus: $userStatus , newUserStatus: $newUserStatus"); 
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':userId', $userId, PDO::PARAM_INT);
			$stmt->bindParam(':productId', $productId, PDO::PARAM_INT);
			$stmt->bindParam(':productStatusNew', $productStatusNew, PDO::PARAM_STR);
			$stmt->execute();
			
			$stmt = null;
			$dap_dbh = null;
			
			return "User/Product status successfully updated";
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			return $e->getMessage();
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			return $e->getMessage();
		}
	}	
	
	
	public static function resendEmail($userId, $productId, $actionType) {
		$product = Dap_Product::loadProduct($productId);
		$user = Dap_User::loadUserById($userId);
		$response = "";
		
		if( ($actionType == "DO") && ($product->getDouble_optin_subject() != "") && ($product->getDouble_optin_body() != "") ) {
			$result=sendUserProductActivationEmail($user, $productId);
			if($result!="")return $result;
			$response = "Double-Optin email sent successfully!";
		} else if ($actionType == "WE") {
			$result=sendUserProductWelcomeEmail($userId, $productId);
			if($result!="")return $result;
			$response = "Welcome email sent successfully!";
		}
		
		return $response;
	}
	
	
	public function isAccessCurrent($userId, $productId) {
		try {
			$dap_dbh = Dap_Connection::getConnection();
			$current = false;
			
			$sql = "select
						*
					from
						dap_users_products_jn
					where
						user_id = :userId and
						product_id = :productId and
						CURDATE() > access_end_date";
						
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':userId', $userId, PDO::PARAM_INT);
			$stmt->bindParam(':productId', $productId, PDO::PARAM_INT);
			$stmt->execute();
			
			if ($row = $stmt->fetch()) {
				//Access is current
				$current = true;
			}
			
			$sql = null;
			$stmt = null;
			$dap_dbh = null; 
			
			return $current;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}	
	}
	
	
	//Check to see if given "date" is less than user's access end date 
	//for given product(s) (one or more separated by commas)
	//Used primarily by DAP shortcode
	public function isContentDateValid($userId, $productIds, $date) {
		try {
			$dap_dbh = Dap_Connection::getConnection();
			$current = false;
			
			//logToFile("isContentDateValid: $userId, $productIds, $date"); 
			
			$sql = "select
						*
					from
						dap_users_products_jn
					where
						user_id = :userId and
						product_id in (" . $productIds . ") and
						'".$date."' <= access_end_date";
						
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':userId', $userId, PDO::PARAM_INT);
			//$stmt->bindParam(':productId', $productId, PDO::PARAM_INT);
			$stmt->execute();
			
			if ($row = $stmt->fetch()) {
				//Access is current
				//logToFile("found row"); 
				$current = true;
			}
			
			$sql = null;
			$stmt = null;
			$dap_dbh = null; 
			
			//$currentVal = $current ? 'true' : 'false';
			//logToFile("returning $currentVal");
			return $current;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}	
	}
	
	
	public function isUserEligible($userId, $productId) {
		try {
			$dap_dbh = Dap_Connection::getConnection();
			$current = false;
			
			//logToFile("isContentDateValid: $userId, $productIds, $date"); 

			$sql = "select
						u.id,
						u.first_name,
						u.last_name,
						u.email,
						u.password
					from
						dap_users_products_jn upj,
						dap_users u
					where
						upj.product_id = :productId and
						upj.status =  'A' and
						u.id = upj.user_id and
						u.status = 'A' and 
						u.opted_out = 'N' and 
						u.id = :userId and
						CURDATE() <= upj.access_end_date";
						
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':userId', $userId, PDO::PARAM_INT);
			$stmt->bindParam(':productId', $productId, PDO::PARAM_INT);
			$stmt->execute();
			
			if ($row = $stmt->fetch()) {
				//Access is current
				logToFile("DAP_USersProducts.php: isUserEligible: found row"); 
				return true;
			}
			
			$sql = null;
			$stmt = null;
			$dap_dbh = null; 
			
			//$currentVal = $current ? 'true' : 'false';
			//logToFile("returning $currentVal");

		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}	
		
		
		return false;
	}
	
	/*  This function is used to apply automation rules for different products. */
	 
	public static function DAPApplyAutomationRules($productId,$userId,$product,$type){		
		logToFile("(Dap_UsersProducts,DAPApplyAutomationRules()), Entered , Called for $type rules , for product = ".$productId,LOG_DEBUG_DAP);
		
		logToFile("(Dap_UsersProducts,DAPApplyAutomationRules()), Going to check GDPR rules first",LOG_DEBUG_DAP);
		$GDPRdata = self::DAPcheckGDPRrules($userId);

		if(isset($GDPRdata['applyautomation']) && $GDPRdata['applyautomation'] == "no"){
			logToFile("(Dap_UsersProducts,DAPApplyAutomationRules()), GDPR rules dont allow to send data. So dont apply automation rules.",LOG_DEBUG_DAP);
			return;
		}
		
		try{		
			$automationId = Dap_ExternalNotifications::DoesAutomationExist($productId); /* will check if automation is present for product or not and return the automation*/
			
			if($automationId != ""){
				logToFile("(Dap_UsersProducts,DAPApplyAutomationRules()), automation id is " . $automationId,LOG_DEBUG_DAP);	
				logToFile("(Dap_UsersProducts,DAPApplyAutomationRules()), automation is present, now get the rules for $type product trigger" ,LOG_DEBUG_DAP);
				
				$data = Dap_ExternalNotifications::GetAllAutomationRules($productId,$automationId,$type);
				
				if(count($data)>0){
					logToFile("(Dap_UsersProducts,DAPApplyAutomationRules()), automation has got actions ",LOG_DEBUG_DAP);
					$lldocroot = defined('SITEROOT') ? SITEROOT : $_SERVER['DOCUMENT_ROOT'];
					$filename = $lldocroot . "/dap/inc/functions_automation.php";
					logToFile("(Dap_UsersProducts.DAPApplyAutomationRules()), functions_automation file path is ".$filename,LOG_DEBUG_DAP);
					include_once($filename);

					for($i=0;$i<count($data);$i++){
						logToFile("(Dap_UsersProducts.DAPApplyAutomationRules()),destination = ".$data[$i]['destination'],LOG_DEBUG_DAP);	
							
						if($data[$i]['destination'] != "dap"){
							
							/* Going to append GDPR tags with the normal tags in each automation action */
							if($GDPRdata['gdprtag'] != "" && $data[$i]['action_type'] == "add"){
							 	$val = $data[$i]['value'];
							 	$val = explode("||",$val);
							 	$data[$i]['value'] = $val[0]."||".$val[1].",".$GDPRdata['gdprtag']."||".$val[2]; /* append tags here*/
							}
									
							$params = ConvertRulesIntoParams($data[$i]);
							logToFile("(Dap_UsersProducts.DAPApplyAutomationRules()),params = ".$params,LOG_DEBUG_DAP);
							if($data[$i]['action_type'] == "add"){
								logToFile("(Dap_UsersProducts.DAPApplyAutomationRules()),action_type is Add so call pluginAdd",LOG_DEBUG_DAP);
								Dap_UsersProducts::pluginAdd($userId, $productId, $params, $product);
							}
							else if($data[$i]['action_type'] == "remove"){
								logToFile("(Dap_UsersProducts.DAPApplyAutomationRules()),action_type is Remove so call pluginRemove",LOG_DEBUG_DAP);
								Dap_UsersProducts::pluginRemove($userId, $productId, $params, $product,'',false);
							}
						}else{
							logToFile("(Dap_UsersProducts.DAPApplyAutomationRules()) destination is DAP , so skip",LOG_DEBUG_DAP);
							continue;
							$product_id = explode("||",$data[$i]['value']);
							$product_id = $product_id[0];
							if($data[$i]['action_type'] == "add"){
								logToFile("(Dap_UsersProducts.DAPApplyAutomationRules()) action is add to product, target product id is  ".$product_id,LOG_DEBUG_DAP);
								/* first of all we are going to check if user has access to the product or not */	
								try{
									$user = Dap_User::loadUserById($userId);
									if(isset($user)){
										$userProduct = Dap_UsersProducts::load($userId, $product_id);
										if (!isset($userProduct)) {
											$access_id = Dap_UsersProducts::addUserToProduct($user->getEmail(), $user->getFirst_name(), $user->getLast_name(), $product_id, "n", "A");
											logToFile("Dap_UsersProducts.php: DAPApplyAutomationRules():Automation  user given access to target product = ".$product_id, LOG_DEBUG_DAP);	
										} 
										else {
											logToFile("Dap_UsersProducts.php: DAPApplyAutomationRules():  user already has access to target product ".$product_id, LOG_DEBUG_DAP);	
										}
									}
								}
								catch(Exception $e){
									logToFile("(Dap_UsersProducts.DAPApplyAutomationRules()),could not add to target product because  = ".$e->getMessage(),LOG_DEBUG_DAP);
								}	
							}
							else if($data[$i]['action_type'] == "remove"){
								logToFile("(Dap_UsersProducts.DAPApplyAutomationRules()) action is remove from product, target product id is  ".$product_id,LOG_DEBUG_DAP);
								try {
									Dap_UsersProducts::removeUsersProducts($userId, $product_id, -1, 1);
								} catch (Exception $e) {
									logToFile("Dap_UsersProducts.php: DAPApplyAutomationRules,Could not remove from target product because " . $e->getMessage());
								}
							}
						}
					}
					
				}						
				else{
					logToFile("(Dap_UsersProducts.DAPApplyAutomationRules()), automation has got no actions ",LOG_DEBUG_DAP);
				}
			}
			else{
				logToFile("(Dap_UsersProducts.DAPApplyAutomationRules()) No automation exists for productid ".$productId,LOG_DEBUG_DAP);
			}
			
		} /* try */
		catch(Exception $e){
			logToFile("Dap_UsersProducts.class.php: DAPApplyAutomationRules,Error is (): ".$e->getMessage(), LOG_INFO_DAP);
		}	
		logToFile("(Dap_UsersProducts,DAPApplyAutomationRules()), Exit",LOG_DEBUG_DAP);
		return;
	}
	
	
	public static function DAPcheckGDPRrules($userId = ""){
		logToFile("(Dap_UsersProducts,DAPcheckGDPRrules()), Enter",LOG_DEBUG_DAP);
		
		// first of all get the user field for GDPR
		
		$GDPRConsentDAP = "";
		if($userId != ""){
			logToFile("(Dap_UsersProducts,DAPcheckGDPRrules()),Get User field for GDPR",LOG_DEBUG_DAP);
			try{
				$user = Dap_User::loadUserById($userId);
				if(isset($user) && $user != ""){
					$GDPRConsentDAP = $user->getGDPRConsent();
				}
			}
			catch(Exception $e){
				logToFile("(Dap_UsersProducts,DAPcheckGDPRrules()), Exception while getting user GDPR field = ".$e->getMessage(),LOG_DEBUG_DAP);
				return;
			}
		}

		$GDPRarray = array(); // will be returning this array to automation function
		$GDPRApplicable=false;
	//	$_SESSION['GDPRConsent'] = 'yes';
	//	unset($_SESSION['GDPRConsent']);
	
		// check if we are able to track whether existing user is GDPR Trackable or not
		if($GDPRConsentDAP == "" && $_SESSION['GDPRConsent'] == ""){
			logToFile("(Dap_UsersProducts,DAPcheckGDPRrules()),This means that GDPR is not trackable for this existing User, So now we have to check for the filter existing users flag",LOG_DEBUG_DAP);
			
			try{
				$GDPRdata = Dap_GDPR::load();
				if(isset($GDPRdata) && $GDPRdata!=""){
					
					//first of all check for country checkbox
					if($GDPRdata->getUser_country_for_gdpr() == "Y"){
						logToFile("(Dap_UsersProducts,DAPcheckGDPRrules()),The filter by country flag is set , so first look for user country in user table",LOG_DEBUG_DAP);
						
						if(isset($user)){
							$country = $user->getCountry();
							logToFile("(Dap_UsersProducts,DAPcheckGDPRrules()),country = ".$country,LOG_DEBUG_DAP);
							
							if($country != "" && $country != "-1" && $country != "select"){
								$code = DAPgetCountryCodeByName(ucfirst($country));
								logToFile("(Dap_UsersProducts,DAPcheckGDPRrules()),country code = ".$code,LOG_DEBUG_DAP);
							
								if($code != ""){
									// now check if it a GDPR country
									
									$status = "";
									$gdpr_status_list = dapGetCountryGDPRStatus();
									if($gdpr_status_list){
										foreach($gdpr_status_list as $key=>$value){
											if(strtolower($key) == strtolower($code)){
												$status = $value;
												break;
											}
										}
									}
									logToFile("(Dap_UsersProducts,DAPcheckGDPRrules()),status = ".$status,LOG_DEBUG_DAP);
									if($status == 1){ //gdpr country
										$GDPRConsentDAP = "GDPRConsentNO";
									}
								}
							}
						}
						
					}
					
					if($GDPRConsentDAP == ""){
						if($GDPRdata->getFilter_existing_users() == "Y"){
							logToFile("(Dap_UsersProducts,DAPcheckGDPRrules()),The filter Existing user flag is set to Y , so we have to filter the transaction for them as GDPR and have set the consent as GDPRConsentNO",LOG_DEBUG_DAP);
							$GDPRConsentDAP = "GDPRConsentNO";
							$GDPRarray['gdprtag'] = "GDPRExistingUser";
						}
						else{
							logToFile("(Dap_UsersProducts,DAPcheckGDPRrules()),The filter Existing user flag is set to N ,So no need to apply the GDPR filter for this transaction",LOG_DEBUG_DAP);	
						}
					}
					
				}
			}
			catch(Exception $e){
				logToFile("(Dap_UsersProducts,DAPcheckGDPRrules()), Exception while getting GDPR rules= ".$e->getMessage(),LOG_DEBUG_DAP);
			}

		}

		if((isset($_SESSION['GDPRConsent']) && ($_SESSION['GDPRConsent'] != "" && $_SESSION['GDPRConsent'] != "NOT_GDPR_USER")) || ($GDPRConsentDAP != "" && $GDPRConsentDAP != "NOT_GDPR_USER")) {
			$GDPRApplicable=true;
		}
		
		if($GDPRApplicable == true) {			
			logToFile("(Dap_UsersProducts,DAPcheckGDPRrules()), GDPRApplicable is applicable",LOG_DEBUG_DAP);
			
			// first of all get the GDPRdata settings from DAP
			try{
				$GDPRdata = Dap_GDPR::load();
				if(isset($GDPRdata) && $GDPRdata != ""){
					$filterTrans = $GDPRdata->getFilter_gdpr_transactions();
					$sendTag     = $GDPRdata->getSend_gdpr_tags();
				}
				else{
					$filterTrans = "N";
					$sendTag     = "N";
				}
				
			}
			catch(Exception $e){
				logToFile("(Dap_UsersProducts,DAPcheckGDPRrules()), Exception = ".$e->getMessage(),LOG_DEBUG_DAP);
			}
			
			logToFile("(Dap_UsersProducts,DAPcheckGDPRrules()),filterTrans = ".$filterTrans." ,sendTag = ".$sendTag,LOG_DEBUG_DAP);
		
			if (strtolower( $_SESSION['GDPRConsent'] ) == "GDPR_CONSENT_YES" || $GDPRConsentDAP == "GDPR_CONSENT_YES") { // GDPR applicable and consent given	
				logToFile("(Dap_UsersProducts,DAPcheckGDPRrules()), Consent is given",LOG_DEBUG_DAP);
				$GDPRarray['applyautomation'] = "yes";
				if($sendTag != "" && $sendTag == "Y"){
					$GDPRarray['gdprtag'] = "GDPRConsentYES";
				}
				else{
					$GDPRarray['gdprtag'] = "";
				}
	
			} 
			else { // GDPR applicable but consent not given	
				if ($filterTrans != "" && $filterTrans == "N") {  // filter GDPR is not checked		
					logToFile("(Dap_UsersProducts,DAPcheckGDPRrules()), Consent not given,but filter transaction is N ,so apply automations and plugin notifications",LOG_DEBUG_DAP);
					$GDPRarray['applyautomation'] = "yes";			
					if($sendTag != "" && $sendTag == "Y" && $GDPRarray['gdprtag'] == ""){ //if sendGDPRtag is set to yes
						$GDPRarray['gdprtag'] = "GDPRConsentNO";
					}
					else if($GDPRarray['gdprtag'] != ""){
						$GDPRarray['gdprtag'] = "GDPRExistingUser"; // This is for the existing users for which we cant know about GDPR
					}
					else{
						$GDPRarray['gdprtag'] = "";
					}
				}
				else { // leave automation because consent not received and filter gdpr is set to yes
					logToFile("(Dap_UsersProducts,DAPcheckGDPRrules()), Consent not given,but filter transaction is Y ,so  cant apply automations and plugin notifications",LOG_DEBUG_DAP);
					$GDPRarray['applyautomation'] = "no";
					$GDPRarray['gdprtag'] = "";
				}

			}
		}
		else { // GDPR not applicable so apply automation rules
			logToFile("(Dap_UsersProducts,DAPcheckGDPRrules()), GDPRApplicable is not applicable",LOG_DEBUG_DAP);
			$GDPRarray['applyautomation'] = "yes";
			$GDPRarray['gdprtag'] = "";
		}
		
		logToFile("(Dap_UsersProducts,DAPcheckGDPRrules()), Exit",LOG_DEBUG_DAP);
		return $GDPRarray;
	}
	
	
	public static function storeSPCInvoiceDetailsInTheJobQueue($emailId, $invoiceId, $btnId, $transactionDate, $subject, $body , $adminemail) {
		try {
			$actionType = "SENDSPCINVOICE";
			
			
			$subject= mb_convert_encoding($subject, "UTF-8", "auto");
			$messagebody = mb_convert_encoding($body, "UTF-8", "auto");
		
			$payload = $emailId."||".$invoiceId."||". $btnId . "||" . $transactionDate . "||" . $subject . "||" . $messagebody ."||". $adminemail ;
			$status = "NEW";
			
			$dap_dbh = Dap_Connection::getConnection();
			$key = mktime();
                        //Insert into dap_mass_actions
			
			logToFile("Dap_UsersProducts.class.php:storeSPCInvoiceDetailsInTheJobQueue. payload - $payload");
						
			$sql = "insert into dap_mass_actions
									(actionType, actionKey, payload, status)
									values
									(:actionType, :key, :payload, 'NEW')";
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':actionType', $actionType, PDO::PARAM_STR);
			$stmt->bindParam(':key', $key, PDO::PARAM_STR);
			$stmt->bindParam(':payload', $payload, PDO::PARAM_STR);
			$stmt->execute();
			$stmt = null;
			$dap_dbh = null;
			
			return;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}		
		
	}
	
	/**********New function Load users by productID **********/
 
	public static function loadUsersByProductId($access_source_product_id , $noaccess_source_product_id) {
	
		try {
			//logToFile("productIds: $productIds"); 
			$dap_dbh = Dap_Connection::getConnection();
			$userDataArray = array();
				/*$sql = "
				
					select
						u.email
					from
						dap_users_products_jn upj,
						dap_users u,
						dap_products p
					where
						upj.product_id in (select upj.user_id from dap_users_products_jn where product_id in ($access_source_product_id)) and ";
					if($noaccess_source_product_id != "") {
						$sql .= " upj.user_id not in (select upj.user_id from dap_users_products_jn where product_id in ($noaccess_source_product_id)) and ";
				}*/
						
				$sql = "
				
					select
						u.email
					from
						dap_users_products_jn upj,
						dap_users u,
						dap_products p
					where
						upj.product_id in ($access_source_product_id) and ";		
				if($noaccess_source_product_id != "") {
						$sql .= " upj.user_id not in ($noaccess_source_product_id) and ";
				}
				
				$sql .= "
						upj.status =  'A' and
						upj.product_id = p.id and
						upj.user_id = u.id
						";
		 
			$stmt = $dap_dbh->prepare($sql);
			
			 
			//$stmt->bindParam(':productIds', $productIds, PDO::PARAM_STR);
			$stmt->execute();
			
			while ($row = $stmt->fetch()) {
				//$count = $row["count"];
				$userDataArray[] = $row;
			}
			
			$sql = null;
			$stmt = null;
			$dap_dbh = null; 
			
			return $userDataArray; 
			
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}	
	}
	
	public static function 	DAPCancelSubscriptionInPaymentGateway($chainedProduct,$userId){
		$lldocroot = defined('SITEROOT') ? SITEROOT : $_SERVER['DOCUMENT_ROOT'];
		if(file_exists($lldocroot . "/dap/dap-changeSubscriptionStatus.php")) 
			include_once ($lldocroot . "/dap/dap-changeSubscriptionStatus.php");
		
		logToFile("(Dap_UsersProducts,DAPCancelSubscriptionInPaymentGateway()), Enter". $userId,LOG_DEBUG_DAP);
		
		$userDetails = Dap_User::loadUserById($userId);
		
		if(isset($userDetails)){
			$email = $userDetails->getEmail(); 
			$transDetails = Dap_Transactions::loadTransactionsByEmailAndProductName($email, $chainedProduct);	
			
			if(isset($transDetails)){
				logToFile("(Dap_UsersProducts,DAPCancelSubscriptionInPaymentGateway()), trans found",LOG_DEBUG_DAP);				
				$transNumFilter=$transDetails->getTrans_num();
				$paymentProcessor=$transDetails->getPayment_processor();
				logToFile("(Dap_UsersProducts,DAPCancelSubscriptionInPaymentGateway()), transNumFilter". $transNumFilter,LOG_DEBUG_DAP);				
				logToFile("(Dap_UsersProducts,DAPCancelSubscriptionInPaymentGateway()), paymentProcessor". $paymentProcessor,LOG_DEBUG_DAP);				
				$source = 'ADMIN';
				$action = 'CANCEL';
				$profile_id = '';
				
				logToFile("(Dap_UsersProducts,DAPCancelSubscriptionInPaymentGateway()),calling processCancellationByChanining()",LOG_DEBUG_DAP);
				processCancellationByChanining($chainedProduct,$profile_id,$action,$source,$paymentProcessor,$transNumFilter, $userDetails);	
				return;
			}else{
				logToFile("(Dap_UsersProducts,DAPCancelSubscriptionInPaymentGateway()) no such transaction, returning",LOG_DEBUG_DAP);
				return;
			}
		}else{
			logToFile("(Dap_UsersProducts,DAPCancelSubscriptionInPaymentGateway()) no such user, returning",LOG_DEBUG_DAP);
			return;	
		}
		

	}
		

} 
