<?php

define('CHUNK_SIZE', 1024*1024); // Size (in bytes) of tiles chunk						
	
	function getFileContent($filename) {
		$blogpath = urldecode($_SESSION["blogpath"]);
		$showsidebar = urldecode($_SESSION["showsidebar"]);
		$sidebartemplate = urldecode($_SESSION["sidebartemplate"]);
		$pagetemplate = urldecode($_SESSION["pagetemplate"]);
		
		if($showsidebar == "YES") {
		  $template_path=$blogpath."/wp-content/plugins/dapsociallogin/includes/templates/" . $sidebartemplate . "/custom" . $filename;
		}
		else {
		  $template_path=$blogpath."/wp-content/plugins/dapsociallogin/includes/templates/" . $pagetemplate . "/custom" . $filename;
		}
		//logToFile("creditStore.inc: template_path NAME=" . $template_path);
		
		if(file_exists($template_path)) {
			
		  $daplogin_form_content = file_get_contents($template_path);
		}
		else {
		
		  if($showsidebar == "YES") {
			$template_path=$blogpath."/wp-content/plugins/dapsociallogin/includes/templates/" . $sidebartemplate .  "/" . $filename;
		  }
		  else {
			$template_path=$blogpath."/wp-content/plugins/dapsociallogin/includes/templates/" . $pagetemplate . "/" .  $filename;
		  }
		
		  $login_form_content = file_get_contents($template_path);
		}
		
		return $login_form_content;
	}
	
	
	function getTheWPFolderName($url)
	{
		$nowww = preg_replace('/www\./','',$url);
		$domain = parse_url($nowww);
		//logToFile("domain=" .$domain["host"],LOG_DEBUG_DAP);
		return $domain["path"];
	}
	
	function removeQueryStringDSH($current_url_with_query_string)
	{
	//logToFile("current_url_with_query_string=".$current_url_with_query_string,LOG_DEBUG_DAP);
	 
		if(strpos($current_url_with_query_string, '?') > 0) {
		  $current_url_without_query_string = substr($current_url_with_query_string, 0, strpos($current_url_with_query_string, '?')); // This line is the key
		  //logToFile("current_url_without_query_string=".$current_url_without_query_string,LOG_DEBUG_DAP);
		  return $current_url_without_query_string;
		}
		  
		return $current_url_with_query_string;
	}

	function getIpOfUser() {
		$ip = "";
		if (isset($_SERVER['HTTP_X_FORWARD_FOR'])) {
			$ip = $_SERVER['HTTP_X_FORWARD_FOR'];
		} else {
			$ip = $_SERVER['REMOTE_ADDR'];
		}
		logToFile("ip address: $ip",LOG_INFO_DAP);
		return $ip;
	}
	
	
	function processDAPCredits ($user) {
//	   logToFile("processdapcredits(): COOKIE VAL, ENTER=". $_COOKIE["cssocialmedia"]);	 
	 // if ($_COOKIE["cssocialmedia"] != '') { 
		$session = Dap_Session::getSession();
		$user = $session->getUser();
		$user = Dap_User::loadUserById($user->getId()); //reload User object
		
		$usercreditsperpost = new Dap_Credits();
		$usercreditsperpost->setUserid($user->getId());
		$credits_available_now = $user->getCredits_available();
		
		//Linkedin
		if ($_COOKIE["daplinkedincredits"] != '') {
		  $usercreditsperpost->setType("LINKEDIN");	
		  $creditsstring=$_COOKIE["daplinkedincredits"];
		  $credits_available_now=$credits_available_now+$daplinkedincredits;
		  //logToFile("processdapcredits(): COOKIE VAL, daplinkedincredits=". $_COOKIE["daplinkedincredits"]);	 
		  assignDAPCredits($user,$usercreditsperpost,$creditsstring,$credits_available_now,$creditsAquired);
		  setcookie("daplinkedincredits", '', time() - 3600, '/');	//expire cookie
		}
		if ($_COOKIE["dapgpluscredits"] != '') {
		  $usercreditsperpost->setType("GPLUS");	
		  $creditsstring=$_COOKIE["dapgpluscredits"];
		  $credits_available_now=$credits_available_now+$dapgpluscredits;
		  //logToFile("processdapcredits(): COOKIE VAL, dapgpluscredits=". $_COOKIE["dapgpluscredits"]);	 
		  assignDAPCredits($user,$usercreditsperpost,$creditsstring,$credits_available_now,$creditsAquired);
		  setcookie("dapgpluscredits", '', time() - 3600, '/');	//expire cookie
		} 
		if ($_COOKIE["daptwittercredits"] != '') {
		  $usercreditsperpost->setType("TWITTER");	
		  $creditsstring=$_COOKIE["daptwittercredits"];
		  $credits_available_now=$credits_available_now+$daptwittercredits;
		  //logToFile("processdapcredits(): COOKIE VAL, daptwittercredits=". $_COOKIE["daptwittercredits"]);	 
		  assignDAPCredits($user,$usercreditsperpost,$creditsstring,$credits_available_now,$creditsAquired);
		  setcookie("daptwittercredits", '', time() - 3600, '/');	//expire cookie
		} 
		if ($_COOKIE["dapfbcredits"] != '') {
		  $usercreditsperpost->setType("FACEBOOK");	
		  $creditsstring=$_COOKIE["dapfbcredits"];
		  $credits_available_now=$credits_available_now+$dapfbcredits;
		  //logToFile("processdapcredits(): COOKIE VAL, dapfbcredits=". $_COOKIE["dapfbcredits"]);	 
		  assignDAPCredits($user,$usercreditsperpost,$creditsstring,$credits_available_now,$creditsAquired);
		  setcookie("dapfbcredits", '', time() - 3600, '/');	//expire cookie
		} 
		
		//if ($_COOKIE["daplinkedincredits"] != '') {
//		 setcookie("cssocialmedia", '', time() - 3600, '/');	//expire cookie
	  //} //if ($_COOKIE["cssocialmedia"] != '') 
	  
	} //function


	function assignDAPCredits ($user,$usercreditsperpost,$creditsstring,$credits_available_now,$creditsAquired) {
	  $updateuser=false;
	  $cstype = $usercreditsperpost->getType();	
	  if($cstype == "FACEBOOK") $addorupdatefb="A";
	  if($cstype == "TWITTER") $addorupdatetwitter="A";
	  if($cstype == "LINKEDIN") $addorupdatelinkedin="A";
	  if($cstype == "GPLUS") $addorupdategplus="A";
	  
	  $used=0;
	  $fbused=0;
	  $twitterused=0;
	  $gplusused==0;
	  $linkedinused=0;
		  
	  $cscredits = explode("||", $creditsstring);
	  $count = count($cscredits);      
	  for($i=0;$i<$count;$i++){
		//logToFile("processdapcredits(): COUNT=". $count);	 
		//logToFile("processdapcredits(): i=" .  $i . ", cscredits=". $cscredits[$i]);
		
		$cscredit = explode("::", $cscredits[$i]);
		//logToFile("processdapcredits(): COUNT CREDITS=". count($cscredits));	 
		
		if(count($cscredit)) {
		  $socialmedia=	$cscredit[0];
		  $permalink = $cscredit[1];
		//  logToFile("processdapcredits(): COUNT   permalink=". $permalink );	 
		  $current_postid = $cscredit[2];
		  //logToFile("processdapcredits(): COUNT current_postid =". $current_postid);	 
		  $creditsAquired = $cscredit[3];      
		 // logToFile("processdapcredits(): COUNT creditsAquired =". $creditsAquired);	 
		  $usercreditsperpost->setPostid($current_postid);
		  $dapcreditsqueryresults = Dap_Credits::loadCreditsUsedByUserIdAndPostIdAndType($user->getId(),$current_postid,$socialmedia);
		  
	      $usercreditsperpost->setTitle($permalink);
		  foreach ($dapcreditsqueryresults as $result ) { 
			if($result) {
			  $type=$result->getType();
			  $currentCredits=$result->getCredits();
			  if($type=="FACEBOOK") {
				$fbused=$result->getUsed();
				$addorupdatefb="U";
			  }else if($type=="TWITTER") {
				$twitterused=$result->getUsed();
				$addorupdatetwitter="U";
			  }else if($type=="LINKEDIN") {
				$linkedinused=$result->getUsed();
				//logToFile("dapcredits found linkedinused=". $linkedinused);	
				$addorupdatelinkedin="U";
			  }else if($type=="GPLUS") {
				$gplusused=$result->getUsed();
				$addorupdategplus="U";
			  }
			  $used=$used+$result->getUsed();;
			}
		  } //end for
		  
		  if ($fbused >= $maxlikesallowedperbutton) {//for the post
			$givefbcredits="N";
		  }
		  if ($twitterused >= $maxlikesallowedperbutton) {//for the post
			$givetwittercredits="N";
		  }
		  if ($linkedinused >= $maxlikesallowedperbutton) {//for the post
			logToFile("linkedinused=". $linkedinused . " and maxallowred=" . $maxlikesallowedperbutton);	
			$givelinkedincredits="N";
		  }
		  if ($gplusused >= $maxlikesallowedperbutton) {//for the post
			$givegpluscredits="N";
		  }
		  
		  /*logToFile("functions_admin.php: processDAPCredits(): daplinkedincredits current_postid: " . $current_postid,LOG_DEBUG_DAP);
		  logToFile("functions_admin.php: processDAPCredits(): daplinkedincredits permalink: " . $permalink,LOG_DEBUG_DAP);
		  logToFile("functions_admin.php: processDAPCredits(): daplinkedincredits credits_available_now: " . $credits_available_now,LOG_DEBUG_DAP);
		  */
		  
		  if($addorupdatelinkedin=="A") {
			$updateuser=true;  
			$usercreditsperpost->setUsed(1);
			$usercreditsperpost->setCredits($creditsAquired);
			$usercreditsperpost->create();
			//logToFile("creditStore_submit.php: added daplinkedincredits credits=1",LOG_DEBUG_DAP);
		  } else if ($addorupdatelinkedin == "U") {
			$updateuser=true;  
			$usercreditsperpost->setUsed($linkedinused+1);
			
		//	logToFile("creditStore_submit.php: updated linkedinused, currentCredits=".$currentCredits,LOG_DEBUG_DAP);
	   //	logToFile("creditStore_submit.php: updated linkedinused, creditsAquired=".$creditsAquired,LOG_DEBUG_DAP);
			$usercreditsperpost->setCredits($creditsAquired+$currentCredits);
			$usercreditsperpost->update(); 
		//  logToFile("creditStore_submit.php: updated linkedinused=".$linkedinused,LOG_DEBUG_DAP);
		  }
		
		  if($addorupdatetwitter=="A") {
			  $updateuser=true;
			$usercreditsperpost->setUsed(1);
			$usercreditsperpost->setCredits($creditsAquired);
			$usercreditsperpost->create();
			//logToFile("creditStore_submit.php: added daptwittercredits credits=1",LOG_DEBUG_DAP);
		  } else if ($addorupdatetwitter == "U") {
			  $updateuser=true;
			$usercreditsperpost->setUsed($twitterused+1);
			//$currentCredits=$usercreditsperpost->getCredits();
			$usercreditsperpost->setCredits($creditsAquired+$currentCredits);
			$usercreditsperpost->update(); 
			//logToFile("creditStore_submit.php: updated twitterused=".$twitterused,LOG_DEBUG_DAP);
		  }
		  
		  if($addorupdatefb=="A") {
			  $updateuser=true;
			$usercreditsperpost->setUsed(1);
			$usercreditsperpost->setCredits($creditsAquired);
			$usercreditsperpost->create();
			//logToFile("creditStore_submit.php: added dapfbcredits credits=1",LOG_DEBUG_DAP);
		  } else if ($addorupdatefb == "U") {
			$updateuser=true;
			if($creditsAquired < 0) {
			   logToFile("functions.php: assignDAPCredits: dapfbcredits unlike event.. reduce earned credits: " . $dapfbcredits,LOG_DEBUG_DAP);
			   $usercreditsperpost->setUsed($fbused-1);
			   $usercreditsperpost->setCredits($currentCredits+$creditsAquired);
			   $newcredits=$currentCredits+$creditsAquired;
			   logToFile("functions.php: assignDAPCredits: dapfbcredits unlike complete, newcredits=" . $newcredits,LOG_DEBUG_DAP);
			   
			   setcookie("cssocialmedia" . $current_postid, '', time() - 3600, '/');	//expire cookie
		    }
			else {
				$usercreditsperpost->setUsed($fbinused+1);
				$usercreditsperpost->setCredits($creditsAquired+$currentCredits);
			}
			//$currentCredits=$usercreditsperpost->getCredits();
			
			$usercreditsperpost->update(); 
			//logToFile("creditStore_submit.php: updated fbinused=".$fbinused,LOG_DEBUG_DAP);
		  }
		  
		  if($addorupdategplus=="A") {
			  $updateuser=true;
			$usercreditsperpost->setUsed(1);
			$usercreditsperpost->setCredits($creditsAquired);
			$usercreditsperpost->create();
			//logToFile("creditStore_submit.php: added dapgpluscredits credits=1",LOG_DEBUG_DAP);
		  } else if ($addorupdategplus == "U")  {
			  $updateuser=true;
			$usercreditsperpost->setUsed($gplusused+1);
			//$currentCredits=$usercreditsperpost->getCredits();
			$usercreditsperpost->setCredits($creditsAquired+$currentCredits);
			$usercreditsperpost->update(); 
			//logToFile("creditStore_submit.php: updated gplusused=".$gplusused,LOG_DEBUG_DAP);
		  }
		  if($updateuser) {
			$credits_available_now = $credits_available_now + $creditsAquired;
		    $user->updateCredits($credits_available_now);
		  }
		}//each credit info - count(linkedincredit) > 0
	  } //for multiple credit updates in cookie (linkedincredits)
	}
		  
		  
	function validate($email, $user_password) {
		//This function expects plain-text password, as authenticateUser will encrypt it later
		$authenticated = false;
		logToFile("Validate email: ".$email);
		if ( ($email != "") && ($user_password != "") ) {
			$user = Dap_User::authenticateUser($email, $user_password);
			if(!empty($user)) {
				logToFile("Authenticated OK",LOG_DEBUG_DAP); 
				$authenticated = true;
				$session = Dap_Session::getSession();
				$user = Dap_User::loadUserByEmail($email);
				$session->setUser($user);
				$_SESSION['dap_session'] = $session;
				//for external systems - wordpress, etc
				$_SESSION['dap_first_name'] = $user->getFirst_name();
				$_SESSION['dap_email'] = $user->getEmail();
				//$_SESSION['dap_member_home_page'] = Dap_Config::get("MEMBER_HOME_PAGE");
				//$_SESSION['dap_password'] = $user->getPassword();
			}
		}
		$authenticatedString = ($authenticated) ? 'true' : 'false';
		logToFile("User: ".$email.", Authenticated: ".$authenticatedString,LOG_INFO_DAP);
		return $authenticated;
	}

	
	/**
		This function is for DAP admin to log in AS another user
		Expects email & password of DAP admin, as well as email of another user
	*/
	
	function validateAs($email, $user_password, $emailAs) {
		//This function expects plain-text password, as authenticateUser will encrypt it later
		$authenticated = false;
		logToFile("Validate email: ".$email);
		if ( ($email != "") && ($user_password != "") ) {
			$user = Dap_User::authenticateUser($email, $user_password);
			if(!empty($user)) {
				logToFile("DAP Admin Authenticated OK",LOG_DEBUG_DAP); 
				$authenticated = true;
				
				//Now log in the emailAs user
				$session = Dap_Session::getSession();
				$user = Dap_User::loadUserByEmail($emailAs);
				$session->setUser($user);
				$_SESSION['dap_session'] = $session;
				//for external systems - wordpress, etc
				$_SESSION['dap_first_name'] = $user->getFirst_name();
				$_SESSION['dap_email'] = $user->getEmail();
				//$_SESSION['dap_member_home_page'] = Dap_Config::get("MEMBER_HOME_PAGE");
				//$_SESSION['dap_password'] = $user->getPassword();
			}
		}
		$authenticatedString = ($authenticated) ? 'true' : 'false';
		logToFile("User: ".$email.", Authenticated: ".$authenticatedString,LOG_INFO_DAP);
		return $authenticated;
	}

	/**
		Authenticate the request url.
		Return TRUE if authorized.
		Return FALSE if not authorized.


		Note: This function need to return as fast as it could possibly.
			Return TRUE (authorized)  could possibly mean the resource is OPEN .
			Use this function ONLY to decide to serve up the url or not.
		NOTE: This method assumes relatively short session times and DOES NOT consider
			situations such as a resource becoming protected between the time it was OPEN and the time user access it.
			Basic data sync between session and database issues need to be resolved.
		NOTE: requestUrl should be cleanced enough not to create situations where user can craft it such that it can become array of entries.
	**/

	function isURLAllowed($requestUrl) {

		$ERROR_CODES = array(
							"DAP001" => "Sorry, you do not have access to this content.",
							"DAP002" => "Sorry, your access to this content has expired.",
							"DAP003" => "Sorry, this content is not yet available to you.",
							"DAP004" => "Sorry, your access to this content has expired.",
							"DAP005" => "Sorry, this is premium content available only to paid members.",
							"DAP006" => "Sorry, this is Members-Only content. Please login to access this..."
						);
		
		$lockImage = "/dap/images/lock.gif";
		
		$creditstore=false;
	  	if(defined("CREDITSTORE")) $creditstore=true;
	  		
		if( file_exists($_SERVER['DOCUMENT_ROOT'] . "/dap/images/customlock.gif") ) {
			$lockImage = "/dap/images/customlock.gif";
		} else if( file_exists($_SERVER['DOCUMENT_ROOT'] . "/dap/images/customlock.jpg") ) {
			$lockImage = "/dap/images/customlock.jpg";
		}
		
		$TEXT_CODES = array(
							"DAP001" => "<img src='" . $lockImage . "' align='center'><h2>Sorry, you do not have access to this content.</h2>",
							"DAP002" => "<img align='center' src='" . $lockImage . "'><h2>Sorry, your access to this content has expired.</h2>",
							"DAP003" => "<img align='center' src='" . $lockImage . "'><h2>Sorry, this content is not yet available to you.</h2>",
							"DAP004" => "<img align='center' src='" . $lockImage . "'><h2>Sorry, your access to this content has expired.</h2>",
							"DAP005" => "<img align='center' src='" . $lockImage . "'><h2>Sorry, this is premium content available only to paid members.</h2>",
							"DAP006" => "<img align='center' src='" . $lockImage . "'><h2>Sorry, this is Members-Only content</h2>"
						);							

		$resource = new Dap_FileResource();
		$resource->setUrl($requestUrl);

		if(!isset($requestUrl)) {
			$requestUrl = $_SERVER['REQUEST_URI'];
			//logToFile("Request URI:".$requestUrl);
		}
	//	logToFile("--------------------------");
		//logToFile("Request URI:".$requestUrl);
		//check if the requestUrl is part of already authenticated urls list from session.
		$cache = Dap_Config::get("ACCESS_CACHE_CONTROL_DB");
		//logToFile("DB Cache ?:".$cache);
		try {
			//if( ($cache == 'Y') && isUrlInSession($requestUrl) ) {
				//return $resource;
				//return TRUE;
			//}
			//if the url is not protected, then add it to session.
			if(!Dap_Resource::isResourceProtected($requestUrl)) {
				//addUrlToSession($requestUrl,TRUE);
			//	logToFile("This URI is OPEN:".$requestUrl);
				return $resource;
				//return TRUE;
			}
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			$resource->setError_id("DAP004");
			$resource->addError($ERROR_CODES["DAP004"]);
			$resource->addError(getErrorPageByResource($requestUrl));
			$resource->addError($TEXT_CODES["DAP004"]);
			return $resource;
		}	
		//we are at stage where url is protected and we need to decide if we let this user access the resource.
		// Either user purchased a product and expired access
		//   Or user did not purchase the product
		//lets check purchased products to see if this request qualifies
		// NOTE:  For now we assume user id is  'uid' in session.
		$session = Dap_Session::getSession();
		$user = $session->getUser(); ////Dap_User::loadLoggedInUser();
		$uid = NULL;
		if(is_null($user)) {
			//logToFile("user object is null"); 
			//Check if feed user
			if(defined('DAP_FEED_USER_ID')) {
				$uid = DAP_FEED_USER_ID;
			} else {
				//logToFile("No user found or User Is Not Logged In..");
				$resource->setError_id("DAP006");
				$resource->addError($ERROR_CODES["DAP006"]);
				$resource->addError(Dap_Config::get("LOGIN_URL"));
				$resource->addError($TEXT_CODES["DAP006"]);
				//$resource->addError(getErrorPageByResource($requestUrl));
				return $resource;
				//$_SESSION['ERROR'] = $ERROR_CODES["DAP006"];
				//$_SESSION['ERROR_URL'] = getErrorPageByResource($requestUrl);
				//return FALSE;
			}
		} else {
			$uid = $user->getId();
			//logToFile("uid: $uid"); 
		}
		//NOTE: the following query should result in only one resource. If we get multiple, just take first one.
		//implement simple logic to loop thru and give access if you can. Or route to last product error pages.
		$sql = "select
					upj.transaction_id as transid,
					upj.redeem_type as redeem_type,
					TO_DAYS(now()) as today,
					TO_DAYS(upj.access_start_date) as access_start_days,
					TO_DAYS(upj.access_end_date) as access_end_days,
					prj.is_free as is_free,
					prj.start_day as start_day,
					prj.end_day as end_day,
					TO_DAYS(prj.start_date) as res_start_days,
					TO_DAYS(prj.end_date) as res_end_days,
					prj.num_clicks as num_clicks,
					prj.product_id as product_id,
					prj.resource_id as resource_id,
					prj.credits_assigned as credits_assigned,
					p.error_page_url as error_page_url
			from
				dap_products p,
				dap_products_resources_jn prj,
				dap_file_resources fr,
				dap_users u,
				dap_users_products_jn upj
			where
				u.id =:uid and
				u.status = 'A' and
				fr.url =:requesturl and
				prj.resource_id = fr.id and
				prj.resource_type = 'F' and
				p.id = prj.product_id and
				p.status = 'A' and
				upj.user_id = u.id and
				upj.product_id = p.id and
				upj.status = 'A' and
				(
					(
						prj.start_day != 0 and
						( (TO_DAYS(now()) - TO_DAYS(upj.access_start_date) + 1) >= prj.start_day ) and
						( (TO_DAYS(now()) - TO_DAYS(upj.access_end_date) + 1) <= prj.end_day)
					) 
					or
					(
						prj.start_date != 0 and
						( date(now()) >= prj.start_date )
					) 
					or
					(
						( date(now()) >= upj.access_start_date ) and
						( date(now()) <= upj.access_end_date )
					) 
				)
			order by
				upj.access_end_date desc,
				prj.end_day desc,
				access_end_days desc,
				prj.num_clicks asc
				";
			//	now() between upj.access_start_date and upj.access_end_date	and
			//	(TO_DAYS(NOW()) - TO_DAYS(access_start_date)) between prj.start_day and prj.end_day

		//echo "sql: $sql<br>"; exit;
	//	logToFile("SQL:".$sql);
		$dap_dbh = Dap_Connection::getConnection();
		$stmt = $dap_dbh->prepare($sql);
		$stmt->bindParam(':uid', $uid, PDO::PARAM_INT);
		$stmt->bindParam(':requesturl', $requestUrl, PDO::PARAM_STR);
		$stmt->execute();
		//$result = mysql_query($sql) or trigger_error("Database Error",E_USER_WARNING);
		/*
			Single resource can be assigned to multiple products.
			We need to loop thru each product resource relationship and see if any row is eligible for access.

			We do series of checks to if url is blocked. If any test decides its blocked, we goto next item in loop.
			If none of the tests for a single row decides its blocked, then we break the loop and give access.

		*/
		$post_cancel_access = Dap_Config::get("POST_CANCEL_ACCESS");
		if(isset($post_cancel_access)) {
			$post_cancel_access = strtolower($post_cancel_access);
		}
		//$post_cancel_access = Dap_Config::
		while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {

			//we have atleast one product that user signed up
			// NOTE: SIGNUP IS DIFFERENT FROM PAID.
			//logToFile("Today:".$row["today"]);
			//echo "<br>";
			//logToFile("Product Access Start Days:".$row["access_start_days"]);
			//echo "<br>";
			//logToFile("Product Access End Days:" . $row["access_end_days"]);
			//echo "<br>";
			//logToFile("Resource Start Day:" . $row["start_day"]);
			//echo "<br>";
			//logToFile("Resource End Day:" . $row["end_day"]);
			//echo "<br>";
			//logToFile("Resource Start (Date)DAYS:" . $row["res_start_days"]);
			//echo "<br>";
			//logToFile("Resource End (Date)DAYS:" . $row["res_end_days"]);
			//echo "<br>";
			//logToFile("Product Resource Num Clicks:" . $row["num_clicks"]);
			//echo "<br>";

			//product is SIGNUP only, then check if resource is free
			// -1 - direct sign up for free resources
			// -2 - admin sign up - for free resources
			// -3 - admin paid sign up - for all resources
			
			/** 
				09/12/2011: No longer matter if user is free or content is free.
				If user has access to the product, then he gets access to the content
				So commenting out if... section just below
			*/
			
			/**
			if((($row["transid"] == "-2") || ($row["transid"] == "-1")) && (strtolower($row["is_free"]) != "y")) {
				//logToFile("Not Free Resource, but User is FREE...");
				$resource->setError_id("DAP005");
				$resource->addError($ERROR_CODES["DAP005"]);
				$resource->addError( $row['error_page_url']);
				$resource->addError($TEXT_CODES["DAP005"]);
				continue;
				//return $resource;
				//$_SESSION['DAP_ERROR'] = $ERROR_CODES["DAP005"];
				//$_SESSION['DAP_ERROR_URL'] = $row['error_page_url'];
				//return FALSE;
			}
			*/

			//lets present two modes of operation 
			
			//logToFile("SSS:  uid:".$uid." product_id:".$row["product_id"].":resource_id:".$row["resource_id"].":credits_assigned:".$row["credits_assigned"]);
			$product = Dap_Product::loadProduct($row["product_id"]);
	  		
	  	
	  		
			if(  ( ($row["redeem_type"] != NULL) && ($row["redeem_type"] != "") ) || (($row["credits_assigned"] != NULL) && ($row["credits_assigned"] > 0) && $creditstore) || ((isset($product) && ($product->getSelf_service_allowed() == "Y") && ($product->getIs_master() == "N") && $creditstore)) ){
				// check user credits
				//logToFile("SSS:  uid:".$uid." product_id:".$row["product_id"].":resource_id:".$row["resource_id"]);
				
				$usercred = Dap_UserCredits::loadCreditsPerResource($uid, $row["product_id"], $row["resource_id"]);
				
			
				if ( ($usercred == null) || ($usercred == "") ) {
				
						//logToFile("usercredit missing",LOG_DEBUG_DAP); 
						$resource->setError_id("DAP001");
						$resource->addError($ERROR_CODES["DAP001"]);
						$resource->addError( $row['error_page_url']);
						$resource->addError($TEXT_CODES["DAP001"]);
						continue;	
				}
				
			
			} else if($post_cancel_access == 'y') {
				//logToFile("Post cancel = Y"); 
				
				//Product did not launch yet.
				if($row["today"] < $row["access_start_days"]) {
					//logToFile("Product Start Date is in future...");
					$resource->setError_id("DAP001");
					$resource->addError($ERROR_CODES["DAP001"]);
					$resource->addError( $row['error_page_url']);
					$resource->addError($TEXT_CODES["DAP001"]);
					continue;
				}
				
				//logToFile("SSS:  uid:".$uid." product_id:".$row["product_id"].":resource_id:".$row["resource_id"]);
				// ADDED FOR SSS - 05/14/2011
				
				//logToFile("row[today]: " . $row["today"]); 
				
				//we have dates on the resource
				if($row["res_start_days"] <> 0 && $row["res_start_days"] <> "" &&
					$row["res_end_days"] <> 0 && $row["res_end_days"] <> "" ) {
					//set resource start days 
					$resource_start_days = $row["res_start_days"];
					$resource_end_days = $row["res_end_days"];
				}
							
				//we have days on the resource
				if($row["start_day"] <> 0 && $row["start_day"] <> "" &&
					$row["end_day"] <> 0 && $row["end_day"] <> "" ) {
					//set resource start days 
					$resource_start_days = $row["access_start_days"] + $row["start_day"] - 1;
					$resource_end_days = $row["access_start_days"] + $row["end_day"] - 1;

					//logToFile("We have 'days' on the resource"); 
					//logToFile("resource_start_days: $resource_start_days"); 
					//logToFile("resource_end_days: $resource_end_days"); 
					//logToFile("User's row[access_start_days]: " . $row["access_start_days"]); 

					/**
						So if resource "days" are hard-coded, but resource end day is in the past,
						then do not allow access. Will help offer expiring bonuses even though post-cancel-access is yes.
					*/
					if($row["today"] > $resource_end_days ) { //Expiring Bonuses
						//logToFile("Sorry: The 'end day' for this content is in the past...");
						$resource->setError_id("DAP001");
						$resource->addError($ERROR_CODES["DAP001"]);
						$resource->addError( $row['error_page_url']);
						$resource->addError($TEXT_CODES["DAP001"]);
						continue;
					}
				}
				//logToFile("Resource Start Days:".$resource_start_days);
				//logToFile("Resource End Days:".$resource_end_days);
				
				//if resource starts in future, lets not grant access.
				if($row["today"] < $resource_start_days ) {
					//logToFile("Resource Start Date is in future...");
					$resource->setError_id("DAP001");
					$resource->addError($ERROR_CODES["DAP001"]);
					$resource->addError( $row['error_page_url']);
					$resource->addError($TEXT_CODES["DAP001"]);
					continue;
				}					

				//
				// If resource ends before upj start date - then no acesss. This could only happen 
				//    when calendar dates are used at the resource level.
				// If resource starts after upj end date - then no access. This could only happen
				//    when calendar dates are used at the resource level.
				//
				//
				if( ($resource_end_days < $row["access_start_days"]) || ($resource_start_days > $row["access_end_days"]) ) {
					logToFile("Product Start Date is in future...");
					logToFile("Access Start Days:".$row["access_start_days"]);
					logToFile("Access End Days:".$row["access_end_days"]);
					$resource->setError_id("DAP005");
					$resource->addError($ERROR_CODES["DAP005"]);
					$resource->addError( $row['error_page_url']);
					$resource->addError($TEXT_CODES["DAP005"]);
					continue;						
				}				
			
			} else { //Post Cancel = "N"
				
				//logToFile("HERE");
				//Product did not lauch yet.
				if($row["today"] < $row["access_start_days"]) {
				//	logToFile("Product Start Date is in future...");
					$resource->setError_id("DAP001");
					$resource->addError($ERROR_CODES["DAP001"]);
					$resource->addError( $row['error_page_url']);
					$resource->addError($TEXT_CODES["DAP001"]);
					continue;
					//return $resource;
					//$_SESSION['DAP_ERROR'] = $ERROR_CODES["DAP001"];
					//$_SESSION['ERROR_URL'] = $row['error_page_url'];
					//return FALSE;
				}
				//Product expired
				if($row["today"] > $row["access_end_days"]) {
					//logToFile("Product End Date is in past...");
					$resource->setError_id("DAP002");
					$resource->addError($ERROR_CODES["DAP002"]);
					$resource->addError( $row['error_page_url']);
					$resource->addError($TEXT_CODES["DAP002"]);
					continue;
					//return $resource;
					//$_SESSION['DAP_ERROR'] = $ERROR_CODES["DAP002"];
					//$_SESSION['DAP_ERROR_URL'] = $row['error_page_url'];
					//return FALSE;
				}
				//logToFile("SSS:  credits assigned:".$row["credits_assigned"]);
				
				//logToFile("SSS:  uid:".$uid." product_id:".$row["product_id"].":resource_id:".$row["resource_id"]);
				// ADDED FOR SSS - 05/14
				if(($row["credits_assigned"] != NULL) && ($row["credits_assigned"] > 0) && ($creditstore)) {
					// check user credits
					//logToFile("SSS:  uid:".$uid." product_id:".$row["product_id"].":resource_id:".$row["resource_id"]);
					logToFile("SSS: loadCreditsPerResource");
					$usercred = Dap_UserCredits::checkUserAccessToThisCreditsResource($uid, $row["product_id"], $row["resource_id"]);
			
					if (($usercred != null) && ($usercred != "")) {
						logToFile("usercredit row exists",LOG_DEBUG_DAP); 
						
					}
					else {
						//logToFile("usercredit missing",LOG_DEBUG_DAP); 
						$resource->setError_id("DAP001");
						$resource->addError($ERROR_CODES["DAP001"]);
						$resource->addError( $row['error_page_url']);
						$resource->addError($TEXT_CODES["DAP001"]);
						continue;	
					}
				} else {  //added upto here for SSS
				
					//product is available.
					//check start date(days).
					if($row["res_start_days"] <> 0 && $row["res_start_days"] <> "" &&
						$row["res_end_days"] <> 0 && $row["res_end_days"] <> "" ) {
		
						//resource is available in future.
						if($row["today"] < $row["res_start_days"]) {
							//logToFile("Resource Start Date  is in future...");
							$resource->setError_id("DAP003");
							$resource->addError($ERROR_CODES["DAP003"]);
							$resource->addError( $row['error_page_url']);
							$resource->addError($TEXT_CODES["DAP003"]);
							continue;
						}
						//resource  expired.
						if($row["today"] > $row["res_end_days"]) {
							//logToFile("Resource End Date  is in past...");
							$resource->setError_id("DAP004");
							$resource->addError($ERROR_CODES["DAP004"]);
							$resource->addError( $row['error_page_url']);
							$resource->addError($TEXT_CODES["DAP004"]);
							continue;
						}
		
					} //else {
						//logToFile("Start Days(Date) and End Days(Date) are empty or ZERO.. not checking...");
					//}
					//check start day
					$lag_days = $row["today"] - $row["access_start_days"] + 1;
					//check resource start and end day only if they are both non zero. 
					if($row["start_day"] <> 0 && $row["start_day"] <> "" &&
						$row["end_day"] <> 0 && $row["end_day"] <> "" ) {
		
						//resource is available in future.
						if($lag_days < $row["start_day"]) {
							$resource->setError_id("DAP003");
							$resource->addError($ERROR_CODES["DAP003"]);
							$resource->addError( $row['error_page_url']);
							$resource->addError($TEXT_CODES["DAP003"]);
							continue;
							//return $resource;
							//$_SESSION['DAP_ERROR'] = $ERROR_CODES["DAP003"];
							//$_SESSION['DAP_ERROR_URL'] = $row['error_page_url'];
							//return FALSE;
						}
						//resource availability expired.
						if($lag_days > $row["end_day"]) {
							//logToFile("Lag Days:".$lag_days);
							//logToFile("End Days:".$row["end_day"]);
							$resource->setError_id("DAP004");
							$resource->addError($ERROR_CODES["DAP004"]);
							$resource->addError( $row['error_page_url']);
							$resource->addError($TEXT_CODES["DAP004"]);
							continue;
							//return $resource;
							//$_SESSION['DAP_ERROR'] = $ERROR_CODES["DAP004"];
							//$_SESSION['DAP_ERROR_URL'] = $row['error_page_url'];
						//return FALSE;
						}
					} //else {
						//logToFile("Start Day and End Day are empty or ZERO.. not checking...");
					//}
					//resource is available in future.
				} /// SSS - end else
			}
			//grant access - we should reach here ONLY IF THE PRODUCT RESOURCE RELATIONSHIP IS CLEAN AND ALLOWED.
			
			try {
				//logToFile("functions.php in try : ".$requestUrl); 
				//addUrlToSession($requestUrl, FALSE);
				$resource = new Dap_FileResource();
				$resource->setUrl($requestUrl);
				return $resource;	
			
			} catch (Exception $e) {
				logToFile($e->getMessage(),LOG_FATAL_DAP);
				$resource->setError_id("DAP004");
				$resource->addError($ERROR_CODES["DAP004"]);
				$resource->addError(getErrorPageByResource($requestUrl));
				$resource->addError($TEXT_CODES["DAP004"]);
			}
			//reset any Resource errrors detected in previous loops and clear them before we return true.
			return $resource;
			//return TRUE;
		}


		//else {
			//we have some product that has this resource, but user did not sign up for it yet.
		//	$_SESSION['DAP_ERROR'] = $ERROR_CODES["DAP005"];
		//	$_SESSION['DAP_ERROR_URL'] = getErrorPageByResource($requestUrl); //$row['error_page_url'];
			//return FALSE;
		//}
		//now check if we have any error messages. If we do, that means we failed access check - no access.
		$errId = $resource->getError_id();
		//logToFile("FINAL: error:".$errId); 
		
		if(!isset($errId)) {
			//we have some product that has this resource, but user did not sign up for it yet.
			$resource = new Dap_FileResource();
			$resource->setError_id("DAP005");
			$resource->addError($ERROR_CODES["DAP005"]);
			$resource->addError(getErrorPageByResource($requestUrl));
			$res=getErrorPageByResource($requestUrl);
		//	logToFile("FINAL: res:".$res); 
			$resource->addError($TEXT_CODES["DAP005"]);
		}
		return $resource;
	}

	function isUrlInSession($requestUrl) {
		//check open url session array
		$urls = Dap_Session::get(SN_OPEN_URIS);
		if(isset($urls)) {
			//get array of authenticated urls
			$Authenticated_URLs = $urls;
			if (in_array($requestUrl, $Authenticated_URLs)) {
				//echo "URLAllowed from SESSION.<br>";
				//logToFile("Allow URL From Session:".$requestUrl);
				return TRUE;
			}
		}
		//check Authenticated urls
		$urls = Dap_Session::get(SN_AUTH_URIS);
		if(isset($urls)) {
			//get array of authenticated urls
			$Authenticated_URLs = $urls;
			if (in_array($requestUrl, $Authenticated_URLs)) {
				//echo "URLAllowed from SESSION.<br>";
				//logToFile("Allow URL From Session:".$requestUrl);
				//lets do the resource check only on auth urls
				$session = Dap_Session::getSession();
				$user = $session->getUser(); 
				//if($user != NULL && isset($user)) {
					//Dap_Resource::isResourceClickCountOK($user->getId(), $requestUrl);
				//}
				return true;
			}
		}		//
		return false;
	}

	/*
	This adds a given url to session cache.
	If $open is TRUE, then it adds to cache of open urls
	If $open is FALSE, then it adds to cache of protected urls. - THIS SECURITY SHOULD HAVE BEEN CHECKED ALREADY.

	*/
	function addUrlToSession($requestUrl,$open) {
		//logToFile("Adding URL To Session:".$requestUrl);
		if($open) {
			$urls = Dap_Session::get(SN_OPEN_URIS);
			if(isset($urls)) {
				$Open_URLs = $urls;
				array_push($Open_URLs,$requestUrl);
				Dap_Session::set(SN_OPEN_URIS,$Open_URLs);
			} else {
				$Open_URLs = array();
				array_push($Open_URLs,$requestUrl);
				Dap_Session::set(SN_OPEN_URIS,$Open_URLs);
			}
		} else {
			$urls = Dap_Session::get(SN_AUTH_URIS);
			if(isset($urls)) {
				$Authenticated_URLs = $urls;
				array_push($Authenticated_URLs,$requestUrl);
				Dap_Session::set(SN_AUTH_URIS,$Authenticated_URLs);
			} else {
				$Authenticated_URLs = array();
				array_push($Authenticated_URLs,$requestUrl);
				Dap_Session::set(SN_AUTH_URIS,$Authenticated_URLs);
			}
			//lets do the resource check only on auth urls
			//$session = Dap_Session::getSession();
			//$user = $session->getUser(); 
			//if($user != NULL && isset($user)) {
				//Dap_Resource::isResourceClickCountOK($user->getId(), $requestUrl);
			//}
			//TODO INCREMENT CLICK COUNT
			//Dap_UserResource::incClick_count($_SESSION[Dap_Config::getSession_user_id()]);
		}
	}




	/*
		Return a product error page given a resource url.
		Look up resource url into product_resource_jn and then lookup product to deduce the error page url.
		Always take only records that are Active (A)
		If nothing is found, then return site level error page.

	*/
	function getErrorPageByResource($requestUrl) {
		return Dap_Product::getErrorPageByResource($requestUrl);
	}


	// Read a file and display its content chunk by chunk
	if( !function_exists("readfile_chunked_dap") ) {
		function readfile_chunked_dap($filename, $retbytes = TRUE) {
			$buffer = '';
			$cnt =0;
			//$handle = fopen($filename, 'rb');
			$handle = fopen($filename, 'rb');
			if ($handle === false) {
			  return false;
			}
			while (!feof($handle)) {
				$buffer = fread($handle, CHUNK_SIZE);
				echo $buffer;
				ob_flush();
				flush();
				if ($retbytes) {
					$cnt += strlen($buffer);
				}
			}
			$status = fclose($handle);
			if ($retbytes && $status) {
			  return $cnt; // return num. bytes delivered like readfile() does.
			}
			return $status;
		}
	}


	/*
	//Serve the file requested.
	// If the file type if php, then include it.
	*/


	function serveFile($filename) {
		$filename = trim($filename, '/');
		$filename = DAP_ROOT . "../" . $filename;
	 	logToFile("Serving...*".$filename."*");
	 	logToFile("Directory Of Request...*".dirname($filename)."*");
		$cwdname = dirname($filename);
		if (!file_exists($filename)) {
	 		logToFile("File Not Found..*".$filename."*", LOG_INFO_DAP);
			header('Status: 404 Not Found1');
			header('HTTP/1.0 404 Not Found1');
			return; //die();
			//die("NO FILE HERE");
		}

		$ctype = getMimeType($filename);

		switch ($ctype) {
			//executable php
			case "php":
				$wd_was = getcwd();
				foreach ($_REQUEST as $key => $value) {
					logToFile( "Request:$key => $value" );
				}
				logToFile("Changing Directory To: $cwdname");
				if(chdir($cwdname) === TRUE) {
					logToFile("File Dir Is:".dirname(__FILE__));
					logToFile("Successfully Changed The Dir.".getcwd());
				}
				logToFile("Including Php File: ".basename($filename));
				logToFile("Including Php File: ".$filename);

				//need to set some variables such as php_self as otherwise they will be set to the dapclient php
				$_SERVER['PHP_SELF'] = $_GET['dapref'];
				#include basename($filename);
				//include $absolute_file;
				include $filename;
				chdir($wd_was);
				return;
				break;
		}

		header("Content-Type: $ctype");
		header("Content-Length: ".@filesize($filename));
		if( !ini_get('safe_mode') ){
        	@set_time_limit(300);
        } 
		//set_time_limit(0);
		//@readfile("$filename") or die("File not found.");
		@readfile_chunked_dap($filename);
		flush();
    	ob_flush();
	}

	function dapDebug($msg) {
		if(isset($_SESSION['log'])) {
			$log = $_SESSION['log'];
			array_push($log,$msg);
			$_SESSION['log'] = $log;
		} else {
			//$log = array();
			//unset($_SESSION['log']);
			$log = array();
			$_SESSION['log'] = $log;
			logToFile("Init Log.");
		}
	}

	function replaceFillers($fileName, $orig, $dest) {
		$data = file_get_contents($fileName);
		$data = str_replace ($orig, $dest, $data);
		return $data;
	} // End replaceFillers()

	function dapErrorHandler($errnum,$errmsg,$file,$lineno){
	  if($errnum==E_USER_WARNING){
	    echo 'Error: '.$errmsg.'<br />File: '.$file.'<br />Line: '.$lineno;
		//logToFile("createUser:".$sql.":".mysql_error());
	    exit();
	  }
	}

	//get just the resource for dap from a string. String could be just the request_uri or it could be full url
	function getResourceFromString($url) {
		$url = @parse_url($url, PHP_URL_PATH);
		//echo $url;
		$url = rawurldecode($url);
		//echo $url;
		$parse_vars = explode("&",$url);
		//parse_str($url, $parse_vars);
		//print_r($parse_vars);
		//$keys = array_keys($parse_vars);
		//$url = $keys[0];
		$url = $parse_vars[0];
		$url = trim($url, "/");
		$url = trim($url, "_");
		$url = trim($url, " ");
		$url = "/".$url;
		return $url;
	}
	
	function getResourceFromUserRequest() {
		$url = $_SERVER['REQUEST_URI'];
		$file = $_SERVER['SCRIPT_FILENAME'];
		$path_info = $_SERVER['PATH_INFO'];
		$req_uri = $_SERVER['REQUEST_URI'];
		//$req_uri_array = explode('?', $req_uri);
		//$req_uri = $req_uri_array[0];
		//decode the request uri
		//$req_uri = rawurldecode($req_uri);
		//
		//parse_str($req_uri, $parse_vars);
		//print_r($parse_vars);
		//$keys = array_keys($parse_vars);
		//$url = $keys[0];
		//$url = trim($url, "/");
		$url = getResourceFromString($req_uri);
		logToFile("Request Coming In: URI:".$url);
		logToFile("Request Coming In: File:".$file);
		logToFile("Dap Ref:".$_GET['dapref']);
		logToFile("Path Info:".$path_info);
		// build the URL in the address bar
		//$requested_url  = ( isset($_SERVER['HTTPS'] ) && strtolower($_SERVER['HTTPS']) == 'on' ) ? 'https://' : 'http://';
		//$requested_url .= $_SERVER['HTTP_HOST'];
		//$requested_url .= $_SERVER['REQUEST_URI'];
		//logToFile("Request_URL:".$requested_url);
		//$original = @parse_url($requested_url);
		//$url = $original['path'];
		return $url;
	}
	
	function add_include_path ($path)
	{
		foreach (func_get_args() AS $path)
		{
			if (!file_exists($path) OR (file_exists($path) && filetype($path) !== 'dir'))
			{
				trigger_error("Include path '{$path}' not exists", E_USER_WARNING);
				continue;
			}
	
			$paths = explode(PATH_SEPARATOR, get_include_path());
	
			if (array_search($path, $paths) === false)
				array_push($paths, $path);
	
			set_include_path(implode(PATH_SEPARATOR, $paths));
		}
	}
	
	function remove_include_path ($path)
	{
		foreach (func_get_args() AS $path)
		{
			$paths = explode(PATH_SEPARATOR, get_include_path());
	
			if (($k = array_search($path, $paths)) !== false)
				unset($paths[$k]);
			else
				continue;
	
			if (!count($paths))
			{
				trigger_error("Include path '{$path}' can not be removed because it is the only", E_USER_NOTICE);
				continue;
			}
	
			set_include_path(implode(PATH_SEPARATOR, $paths));
		}
	}


	function validateLogins($email, $ip) {
		return Dap_User::authenticateLogins($email, $ip);
	}
	
	function pluginLogin($email,$password="",$rememberMe=false) {
		$includeList = array();
		//logToFile( "functions.php : ENTER pluginLogin()" );
		registeredPlugins($includeList, $email, "login");
		//logToFile( "functions.php : called  registeredPlugins()" );
		$lldocroot = defined('SITEROOT') ? SITEROOT : $_SERVER['DOCUMENT_ROOT'];
		
		foreach ($includeList as $key => $value) {
			logToFile( "functions.php : pluginLogin(): " . $key . "=" . $value );
			
			if (stristr($value, "dap_xenapi")) {
				//require_once($lldocroot.'/dap/plugins/dap_xenapi/XenForoSDK.php');
				$filename = $lldocroot . '/dap/plugins/dap_xenapi/XenForoSDK.php';
		
				require_once($filename);
			//	logToFile( "functions.php : pluginLogin(): included xenforosdk.php");
				$sdk = new XenForoSDK;
				$rememberMe=true;
				//logToFile( "functions.php : pluginLogin(): xenforo: validateLogin(): $email $password");
				$xenforouser = $sdk->validateLogin($email,$password, $rememberMe, true);
				
				if(!isset($xenforouser) || ($xenforouser=="")) {
					logToFile( "functions.php : pluginLogin(): xenforo login failed for user=" . $email);
				}
				else {
				// Login user
					$user = $sdk->login($xenforouser, $rememberMe); // no validation
					//logToFile( "functions.php : pluginLogin(): xenforo login SUCCESSFUL for user=" . $email);
				}

			}
			else if (stristr($value, "vbulletin")) {
			  include_once ($value);
			  $forum = new Dap_Vbulletin();
			  $errmsg = $forum->login($email,$password);
			}
		}
	}
	
	
	function pluginLogout() {
		$includeList = array();
		$email="";
		registeredPlugins($includeList, $email, "logout");
		$lldocroot = defined('SITEROOT') ? SITEROOT : $_SERVER['DOCUMENT_ROOT'];
		foreach ($includeList as $key => $value) {
			
			logToFile( "functions.php : pluginLogout(): " . $key . "=" . $value );
			
			if (stristr($value, "dap_xenapi")) {
				//require_once($lldocroot.'/dap/plugins/dap_xenapi/XenForoSDK.php');
				$filename = $lldocroot . '/dap/plugins/dap_xenapi/XenForoSDK.php';
				require_once($filename);
			//	logToFile( "functions.php : pluginLogin(): included xenforosdk.php");
				$sdk = new XenForoSDK;
				$sdk->logout();
			}
			else if (stristr($value, "vbulletin")) {
				include_once ($value);
				$forum = new Dap_Vbulletin();
				$errmsg = $forum->logout();
			}
		}
	}
	
	function registeredPlugins (&$includeList, $email, $action, &$product="") {
		// get the list of all plugins to include based on actiontype (login/add/remove/update)
		
		//logToFile( "functions.php : registeredPlugins(): ENTER");
				
		if(defined("VBFORUMPATH")) {
			$lldocroot = defined('SITEROOT') ? SITEROOT : $_SERVER['DOCUMENT_ROOT'];
			$filename = $lldocroot . '/dap/plugins/vbulletin/Dap_Vbulletin.class.php';
			if (file_exists($filename)) {
					$includeList[] = 	$filename;
			}
		}
		
		$lldocroot = defined('SITEROOT') ? SITEROOT : $_SERVER['DOCUMENT_ROOT'];
		$filename = $lldocroot . '/dap/plugins/dap_xenapi/dap_xenapi.class.php';
		
		if(defined("XENFOROFORUMPATH") && ( ($action=="login") || ($action=="logout") ) ) {
			//logToFile( "functions.php : registeredPlugins(): added xenforo to login list");
			$includeList[] = 	$filename;
		}
	
		$subscribeList = "";
		if ($product != "") {
			if ($action == "Add") {
				$subscribeList = trim($product->getSubscribeTo());
			}
		 	else if ($action == "Remove") {
				$subscribeList = trim($product->getUnsubscribeFrom());
			}
			
		}
		
		if($subscribeList == "") return;
			
		$subscribtions = explode(",",$subscribeList);
		foreach ($subscribtions as $subscribeTo) {
			//if (file_exists($filename)) {
					$includeList[] = $subscribeTo;
			//		$path[] = $filename;
			//}
		}
		
		foreach ($includeList as $include) {
				logToFile( "functions.php : registeredPlugins() Plugin Name = : " . $include );
			//	logToFile( "functions.php : registeredPlugins() Plugin Name = : " . $filename );
		}
	}
	
	
	function displayTemplate($name) {
      //$data = Dap_Templates::getContentByName("ACTIVATION_EMAIL_CONTENT");
      $data = Dap_Templates::getContentByName($name);
      echo $data;
  	}
	
	
	function removeSlashesDAP($item) { 
		if (get_magic_quotes_gpc() == 0) return($item);
		if (is_array($item)) {
			while(list($k,$v) = each($item)) {
				$item[$k]= removeSlashesDAP($v);
			}
		} else {
			if (is_string($item)) {
				$item= stripslashes($item);
			}
		}
		return($item);
	}  
	
	
	function registerUser($source, $autoLogin="Y", $productId) {
	  
	  logToFile("email=".$_POST["email_address"]);
	  
	  if($_REQUEST["daplistbuildercredits"]=="Y") 
	    $daplistbuildercredits="Y";
		
	  //Since DAP v4.3: First check if product is even eligible for free signup
	  foreach ($_REQUEST as $key => $value) {
		  if($daplistbuildercredits=="Y") {
		  	$value = urldecode(stripslashes($value));
			if($value=="undefined")$value="";
		  }
		  //$req .= "&$key=$value";
		  $_POST[$key] = $value;
		  logToFile($source . ": " . $key . "=" . $value);
	  }
	    
	  
	  $product = Dap_Product::loadProduct($productId);
	  if( !isset($product) || ($product == NULL) || ($product->getStatus() == "I") ) {
		  if($daplistbuildercredits=="Y") {
		    //echo MSG_INVALID_PRODUCT;
			return MSG_INVALID_PRODUCT;
		  }
		  header("Location:error.php?msg=MSG_INVALID_PRODUCT");
		  exit;
	  }
	  $allow_free_signup = $product->getAllow_free_signup();
	  
	  if( is_null($allow_free_signup) || ($allow_free_signup == "") ) {
		  $allow_free_signup = "N";
	  }
	  if($allow_free_signup == "N") {
		  if($daplistbuildercredits=="Y") {
		    //echo MSG_INVALID_PRODUCT;
			return MSG_INVALID_PRODUCT;
		  }
		  header("Location:error.php?msg=MSG_INVALID_PRODUCT");
		  exit;
	  }
	  //End v4.3 allow_free_signup check
	  
	  
	  /*
		  Three possible use cases.
		  1) New user (so new product association)
		  2) Existing member, new product
		  3) Existing member, old product (don't extend)
	  */
  
	  //Core "User" data
	  
	  logToFile($source . ": PRODUCTID = " . $productId);
	  
	  
	  
	  $first_name = "";
	  $last_name = "";
	  $email = "";
	  
	  if( isset($_POST['email']) && ($_POST['email'] != "")) {
		$email = $_POST["email"];
	  }
	  else if( isset($_POST['email_address']) && ($_POST['email_address'] != "")) {
		$_POST["email"] = $_POST["email_address"];
		$email = $_POST["email_address"];
	  }
	  else if( isset($_POST['Email']) && ($_POST['Email'] != "")) {
		$email = $_POST["Email"];
	  }
	  
	  if( (isset($_POST['first_name'])) && ($_POST['first_name'] != "")) {
		  $first_name =  addslashes($_POST['first_name']);
	  } else if( isset($_POST['First_Name']) && ($_POST['First_Name'] != "")) {
		$first_name = $_POST["First_Name"];
	  } else if( (isset($_POST['name'])) && ($_POST['name'] != "")) {
		  $pieces = explode("+",addslashes($_POST['name']));
		  $first_name = $pieces[0];
		  $last_name = $pieces[1];
	  } else if( (isset($_POST['requireUsername'])) && ($_POST['requireUsername'] != "")) {
		  $first_name =  addslashes($_POST['user_name']);
	  } else {
		  $pieces = explode("@",$_POST['email']);
		  $first_name = $pieces[0];
	  }
	  
	  logToFile("email in signup_submit.php: " . $email); 
  
	  if( ($last_name == "") && isset($_POST['last_name']) ) {
		  $last_name = addslashes($_POST['last_name']);
	  }
	  
	  logToFile("first_name in signup_submit.php: " . $first_name); 
	  logToFile("last_name in signup_submit.php: " . $last_name); 
  
	  $user_name = isset($_POST['user_name']) ? addslashes($_POST['user_name']) : "";
	  $password = isset($_POST['password']) ? addslashes($_POST['password']) : "";
	  $address1 = isset($_POST['address1']) ? addslashes($_POST['address1']) : "";
	  $address2 = isset($_POST['address2']) ? addslashes($_POST['address2']) : "";
	  $zip = isset($_POST['zip']) ? addslashes($_POST['zip']) : "";
	  
	  //arpreach
	  $address1 = isset($_POST['address_1']) ? addslashes($_POST['address_1']) : $address1;
	  $address2 = isset($_POST['address_2']) ? addslashes($_POST['address_2']) : $address2;
	  $zip = isset($_POST['postal_code']) ? addslashes($_POST['postal_code']) : $zip;
	  
	  
	  
	  $city = isset($_POST['city']) ? addslashes($_POST['city']) : "";
	  $state = isset($_POST['state']) ? addslashes($_POST['state']) : "";
	  
	  $country = isset($_POST['country']) ? addslashes($_POST['country']) : "";
	  $phone = isset($_POST['phone']) ? addslashes($_POST['phone']) : "";
	  $fax = isset($_POST['fax']) ? addslashes($_POST['fax']) : "";
	  $company = isset($_POST['company']) ? addslashes($_POST['company']) : "";
	  $title = isset($_POST['title']) ? addslashes($_POST['title']) : "";
	  $paypal_email = isset($_POST['paypal_email']) ? addslashes($_POST['paypal_email']) : "";
	  $gdpr_consent = isset($_POST['gdpr_consent']) ? addslashes($_POST['gdpr_consent']) : "";
	  $gdpr_compliance_date = isset($_POST['gdpr_compliance_date']) ? addslashes($_POST['gdpr_compliance_date']) : "";
	 
	  
	  //logToFile("signup_submit.php:  paypal_email=". $paypal_email, LOG_FATAL_DAP);
	  
	  //Non-user data
	  if (isset($_POST['coupon_code'])) {
		  if ($_POST['coupon_code'] == "") {
			  if($daplistbuildercredits=="Y") {
				//echo MSG_MISSING_COUPON;
				return MSG_MISSING_COUPON;
			  }
			  header("Location:error.php?msg=MSG_MISSING_COUPON");
			  exit;	
		  }
	  }
	  
	  $coupon_code = isset($_POST['coupon_code']) ? addslashes($_POST['coupon_code']) : "";
						  
	  if( $coupon_code != "" ) {
		  if (validateCouponCode($productId, $coupon_code) == false ) {
			  if($daplistbuildercredits=="Y") {
				//echo MSG_INVALID_COUPON;
				return MSG_INVALID_COUPON;
			  }
			  header("Location:error.php?msg=MSG_INVALID_COUPON");
			  exit;
		  } else {
			  if (!updateUsage($coupon_code)) {
				  logToFile("signup_submit.php: Failed to update coupon actual usage of coupon code: $coupon_code",LOG_FATAL_DAP);
			  }
		  }
		  
		  $coupon = Dap_Coupon::loadCouponByCode($coupon_code); //loads coupon details from db
		  $couponId = $coupon->getId();
	  }	
	  
	  
	  $ipaddress = getIpOfUser();
	  $thirdParty = true;
	  $redirect = isset($_POST['redirect']) ? addslashes($_POST['redirect']) : "";
	  if($redirect == "") {
		  $redirect = Dap_Config::get("LOGIN_URL");
		  $thirdParty = false;
	  }
	  
	  logToFile($source . ": redirect=" . $redirect,LOG_FATAL_DAP);
	   
	 // logToFile("signup_submit.php:call requireUsername=Y",LOG_DEBUG_DAP);
	  
	  $redirURL = "";
	  $msg = "SUCCESS_CREATION";
	  $user = null;
	  
	  //Basic validation
	  if( ($first_name == "") || 
		  ($email == "") || 
		  ($productId == "") || 
		  strpos($_POST['email'], "\r") || 
		  strpos($_POST['email'], "\n") || 
		  ( isset($_POST['user_name']) && ($_POST['user_name'] == "") && ($_POST['requireUsername'] == "Y") )
	  ) {
		  
		   logToFile("signup_submit.php: $first_name, $email, $productId",LOG_DEBUG_DAP);
		   
		  if($daplistbuildercredits=="Y") {
			  //echo MSG_MANDATORY;
			  return MSG_MANDATORY;
		  }
		  header("Location:error.php?msg=MSG_MANDATORY");
		  exit;
	  }
	  
	  if( ($first_name == "Your First Name") || 
		  ($email == "Your E-mail Address") ) {
		  if($daplistbuildercredits=="Y") {
			  //echo MSG_MANDATORY;
			  return MSG_MANDATORY;
		  }
	  }
	  
	  $email = $email;
	  logToFile($source . ": email=" . $email,LOG_FATAL_DAP);
	  
	  if( validateEmailFormat($email) === false ) {
		  logToFile("signup_submit.php:call validateEmailFormat()",LOG_FATAL_DAP);
		  if($daplistbuildercredits=="Y") {
			  //echo MSG_INVALID_EMAIL;
			  return MSG_INVALID_EMAIL;
		  }
		  header("Location:error.php?msg=MSG_INVALID_EMAIL");
		  exit;
	  }
	  
	  if($password != "") {
		  if( !preg_match("/^[a-zA-Z0-9]+$/", $password) ) {
			  if($daplistbuildercredits=="Y") {
			  	//echo MSG_INVALID_EMAIL;
			  	return MSG_INVALID_EMAIL;
		  	  }
			  header("Location:error.php?msg=MSG_INVALID_PASS");
			  exit;
		  }
	  }
	  
	  
	   logToFile("signup_submit.php:call USERNAME=" . $_REQUEST["user_name"],LOG_DEBUG_DAP);
	  if( isset($_REQUEST["user_name"]) && ($_REQUEST["user_name"]!="") && ($_REQUEST["requireUsername"] == "Y")) {
		   logToFile("signup_submit.php:call requireUsername=Y",LOG_DEBUG_DAP);
		   $user = Dap_User::loadUserByUsername($email,$_REQUEST["user_name"]);
		   if($user) {
				header("Location:error.php?msg=MSG_USERNAME_TAKEN");
				exit;
		   }
	  }
	  //logToFile("About to loadUserByEmail"); 
	  $user = Dap_User::loadUserByEmail($email);
	  
	  /**
	  	If user status is Inactive, or user/product status is Inactive
	  	then DO NOT proceed. Enough to check for user/product inactive
	  	because user cannot be inactive when userproduct is active. And
		when activation link is clicked, it will also activate user
		status. So checking for one is sufficient.
	  */
	  $skipAdd=false;
	  if ( isset($user) ) {
	  	  $userProduct = Dap_UsersProducts::load($user->getId(), $productId);
		  if(($userProduct) && ($userProduct->getStatus() == "I")) {
			  logToFile("UserProduct status is Inactive"); 
			  //Resend activation email
			  sendUserProductActivationEmail($user, $productId);
			   if($daplistbuildercredits=="Y") {
			  	//echo MSG_INVALID_EMAIL;
			  	return MSG_ALREADY_INACTIVE;
		  	  }
			  header("Location:error.php?msg=MSG_ALREADY_INACTIVE");
			  return;
		  }
		  else if(($userProduct) && ($userProduct->getStatus() != "I")){
		   logToFile("UserProduct status is active.. user signing up again for the same product. check if SKIPADDIFUSERPRODUCTEXISTS is set to Y in dap-config.php"); 
		  if(defined(SKIPADDIFUSERPRODUCTEXISTS) && (SKIPADDIFUSERPRODUCTEXISTS=="Y") )
			logToFile("SKIPADDIFUSERPRODUCTEXISTS: ".SKIPADDIFUSERPRODUCTEXISTS);
			$skipAdd=true;
			$msg = MSG_ALREADY_SIGNEDUP;
		  }
	  }
	  
	  //$autoLogin="Y";
	  $doubleoptinproduct=false;
	  if ( isset($user) || ( ($product->getDouble_optin_subject() != "") && ($product->getDouble_optin_body() != "")) ) { 
		  logToFile("user is set or double optin enabled, so autoLogin = 'N'"); 
		  if ( ($product->getDouble_optin_subject() != "") && ($product->getDouble_optin_body() != "") ) {
			  $doubleoptinproduct=true;
		  }
		  $autoLogin = "N"; 
	  }
				
	  if ( 
			(Dap_Config::get("DISALLOW_DUPLICATE_IPS") == "Y") ||
			
			( defined("DISALLOW_DUPLICATE_IPS") && (DISALLOW_DUPLICATE_IPS == "Y") )
		) {
		  //check if current user's IP already used by another email id
		  $isDuplicate = Dap_User::checkIfDuplicateFreeUser($email, $ipaddress);
		  logToFile("Yup, duplicate"); 
		  if ($isDuplicate) { //It's a duplicate free sign up for different product. Don't allow
		  	logToFile("Redirecting to error page"); 
			//return MSG_DUPLICATE;
		  	@header("Location:error.php?msg=MSG_DUPLICATE");
			logToFile("here"); 
			exit;
		  }
	  }
	  
	  
	  if(!$skipAdd) {			
	  try {
		  $user = new Dap_User();
		  $user->setFirst_name($first_name);
		  $user->setLast_name($last_name);
		  $user->setUser_name($user_name);
		  $user->setEmail($email);
		  
		  if($password != "") $user->setPassword($password);
		  
		  $user->setAddress1($address1);
		  $user->setAddress2($address2);
		  $user->setCity($city);
		  $user->setState($state);
		  $user->setZip($zip);
		  $user->setCountry($country);
		  $user->setPhone($phone);
		  $user->setFax($fax);
		  $user->setCompany($company);
		  $user->setTitle($title);
		  $user->setPaypal_email(urldecode($paypal_email));
		  $user->setGDPRConsent($gdpr_consent);
		  $user->setGDPRCompliance_date($gdpr_compliance_date);

		  //logToFile("About to call directSignupSubmit"); 
		  $user = Dap_UsersProducts::directSignupSubmit($user, $coupon_code, $productId, $couponId);
	  
		  if(isset($user)) {
			  $uid = $user->getId();
			  $_SESSION['uid'] = $uid;
			  $_SESSION['AFF_LINK'] = SITE_URL_DAP . "/dap/a/?a=".$uid;
			  
			  // check if custom field present
			  foreach($_REQUEST as $key=>$value) {
				  //logToFile("signup_submit.php: key=" . $key . " value=" . $value, LOG_DEBUG_DAP);		
					  
				  if (strstr($key, "custom_")) {	
					  if ($keyval = substr($key, 7)) {
						  $customFld = Dap_CustomFields::loadCustomfieldsByName($keyval);
						  //logToFile("signup_submit.php: loadCustomfieldsByName(): keyval=" . $keyval, LOG_DEBUG_DAP);		
						  
						  if ($customFld) {
							  $id = $customFld->getId();
							  //logToFile("signup_submit.php: customFld Id = " . $id, LOG_DEBUG_DAP);		
							  
							  $usercustom = new Dap_UserCustomFields();
							  $usercustom->setUser_id($uid);
							  $usercustom->setCustom_id($id);
							  $usercustom->setCustom_value($value);
							  
							  $cf = Dap_UserCustomFields::loadUserCustomFieldsByCustomFieldId($id, $uid);
							  if ($cf) {
								  //logToFile("signup_submit.php: call update() to update value=" . $value, LOG_DEBUG_DAP);
								  $usercustom->update();
							  }
							  else {
								  //logToFile("signup_submit.php: call create() to add custom value=" . $nv[1], LOG_DEBUG_DAP);
								  $usercustom->create();
							  }
						  }
					  }
				  }
			  }
			  
			  
			  /** ------------------ START AFFILIATE RESOLUTION -------------------- */		
			  
			  //Process affiliate stuff during sign up ONLY if single-optin product
			  //Ignore if double-optin
			  
			  //Credit affiliate (if one exists) for free signup
			   if( !($doubleoptinproduct) &&  isset($user) && isset($_COOKIE['dapa'])) {
				  $affiliate_id = "";
				  //$session = Dap_Session::getSession();
				  //$user = $session->getUser();
				  $user_id = $user->getId();
				  $user = Dap_User::loadUserById($user_id); //reload User object
				  $loginCount = $user->getLogin_Count();
				  //logToFile("loginCount: $loginCount"); 
				  
				  /**
					  First check if user has existing affilaite. 
					  If yes, then use that.
					  If no, then first check if loginCount is < 1. 
						  If yes, then use cookie affiliate
						  If no, then do nothing
				  */
					  
				  $existingAffiliateId = $user->getAffiliate();
				  if ( isset($existingAffiliateId) && ($existingAffiliateId != null) ) {
					  $affiliate_id = $existingAffiliateId;
					  //logToFile("affiliate id existing: $affiliate_id",LOG_DEBUG_DAP);
				  } else if( intval($loginCount) <= 1) { //affiliate credit only for first login
					  $affiliate_id = $_COOKIE['dapa'];
					  //logToFile("affiliate id from cookie: $affiliate_id",LOG_DEBUG_DAP);
				  }
				  
				  
				  if(
					 ($affiliate_id != "") 
					 &&
					 ( (Dap_Config::get("ALLOW_SELF_REFERRAL") == "Y") || ($affiliate_id != $user_id) )
					 &&  
					 ( intval($user_id) > intval($affiliate_id) ) 
				   ) {
					   
						$allowaffprocessing=true;	  
						$affCommission = Dap_AffCommissions::load($affiliate_id, $productId);
						if($affCommission != null){
							$affOwnsProduct = $affCommission->getAffOwnsProduct(); 
							if($affOwnsProduct == "Y") {
								//check if aff has product
								$affuser = Dap_User::loadUserById($affiliate_id);
								if(isset($affuser)) {
									$hasAccess = $affuser->hasAccessTo($productId);	
									if(!$hasAccess) {
										logToFile("registerUser(): affliate ($affliate_id) required to own product ($productId) but does not have access to $productId",LOG_DEBUG_DAP);	
										logToFile("registerUser(): can't continue affiliate processing",LOG_DEBUG_DAP);	
										$allowaffprocessing=false;
									}
								}
							}

						}
					  
					  if($allowaffprocessing){
					   
						  //1. Figure out all products for this user, for which no affiliate id has been set
						  $ProductListArray = Dap_AffReferrals::getProductsPendingAffiliateStamping($user_id);
						  
						  if( sizeof($ProductListArray) != 0 ){
							  //Process Affiliate Lead
							  Dap_AffReferrals::processAffiliation($affiliate_id, $user_id,$ProductListArray);
							  
							  //Once lead has been paid, unset affiliate cookie
							  //setcookie("dapa","-1",time()-3600,"/");
							  //unset($_COOKIE['dapa']);
						  }
					  }
					  
					  //If no products found, still give credit to affiliate for referral
					  //if( sizeof($ProductListArray) == 0 ) {
						  //logToFile("No product found - but affiliate found, so giving credit for referral to $affiliate_id",LOG_DEBUG_DAP);
						  //$ProductListArray = array(0 => -1);
						  
						  //Process Affiliate Credit
						  //Dap_AffReferrals::processAffiliation($affiliate_id, $user_id, $ProductListArray);
					  //}
					  
				  } //end-if
  
			  } //end-if
			  
		  } //end if isset user
		  
		  /** ------------------ END AFFILIATE RESOLUTION -------------------- */		
		  
		  //Load full user and update other info if available
		  //$user = Dap_User::loadUserById($uid);
		  
		  // going to send mail stuff for GDPRconsentNo if needed
		  
		if($gdpr_consent == "GDPR_CONSENT_NO" && $source = "signup_submit"){// checking source here for form builder
		//	logToFile("functions.php:registerUser(), GDPR consent not given, So now check whetehr to notify admin or not",LOG_DEBUG_DAP);
			try{
				$gdpr_settings = Dap_GDPR::load();
				if(isset($gdpr_settings)) {
					$send_admin_email = $gdpr_settings->getSend_admin_email();
					
					if($send_admin_email == "Y"){
						logToFile("functions.php:registerUser(), GDPR settings say to notify admin for GDPRConsent not given",LOG_DEBUG_DAP);
						
						$subject = '[DAP GDPR Decline Notification] User declined GDPR Terms';
						$msg = "This user declined to give GDPR consent on your Opt-in page:".
								"Email: ".$user->getEmail().", Fistname:".$user->getFirst_name().", Lastname: ".$user->getLast_name();
						
						$adminEmail = Dap_Config::get('ADMIN_EMAIL');
						if($adminEmail!="")
							sendEmail($adminEmail, $subject, $msg);
					}
					else{
						//logToFile("functions.php:registerUser(), GDPR settings say not to notify admin for GDPRConsent not given",LOG_DEBUG_DAP);
					}
				}
			}
			catch(Exception $e){
				logToFile("functions.php:registerUser(), Exception while getting gdpr_settings ".$e->getMessge(),LOG_INFO_DAP);
			}
		}
		  
	  } catch (PDOException $e) {
		  logToFile($e->getMessage(),LOG_FATAL_DAP);
		  $msg = $e->getMessage();
	  } catch (Exception $e) {
		  logToFile($e->getMessage(),LOG_FATAL_DAP);
		  $msg = $e->getMessage();
	  }		
	  
	  } // skipadd as user already has access to product 
	  else {
		  logToFile("signup_submit.php: user resigning to same product, skip adding user to product redirecting to authenticate.php to auto login user : " . $autoLogin);
		  
		  if ($daplistbuildercredits == "Y") { 
		  	return MSG_ALREADY_SIGNEDUP;
		  }
	  }
		  
	  logToFile("signup_submit.php: redirecting to authenticate.php to auto login user : " . $autoLogin);
	  
	  //autologin new user //11/06/2011
	  if(isset($user) && ($autoLogin == "Y")) {
		//logToFile("dap-authenticate.php: redirecting to authenticate.php to auto login user". $record_id);
		logToFile("signup_submit.php: redirecting to authenticate.php to auto login user");
		
		if ($daplistbuildercredits == "Y") {
			$password = $user->getPassword();
			$ret = authUser($email, $password);
			return $ret;
		}
		
		if (isset($_REQUEST['redirect'])) {
		  //logToFile("authenticate.php: redirecting to". $_REQUEST['redirect']);
		  //logToFile("authenticate.php: email=" . urlencode($email) . "&password=" . $user->getPassword() . "&submitted=Y&request=".$_REQUEST['redirect']);
		  header("Location: /dap/authenticate.php?email=" . urlencode($email) . "&password=" . $user->getPassword() . "&submitted=Y&request=".$_REQUEST['redirect']."&daplistbuildercredits=" . $daplistbuildercredits);
		} else {
		  header("Location: /dap/authenticate.php?email=" . urlencode($email) . "&password=" . $user->getPassword() . "&submitted=Y"."&daplistbuildercredits=" . $daplistbuildercredits);
		}
		
	   logToFile($source . ": autologin is YES, redirect=" . $redirect,LOG_FATAL_DAP);
	   return 0;
	  }
	  
	  
	   logToFile($source . ": no-autologin, redirect=" . $redirect,LOG_FATAL_DAP);
	   
	  //Redirect to 'redirect' (if available) or member home page
	  if ($skipAdd) {
	   logToFile("functions.php: registerUser(): skipAdd. user re-signing to same product, redirect to : " . $redirect,LOG_DEBUG_DAP); 
	   $redirect=getCallbackURLWithoutQueryString($redirect);
	   logToFile("functions.php: registerUser(): skipAdd. getCallbackURLWithoutQueryString=" . $redirect,LOG_DEBUG_DAP); 
	   $redirURL =  $redirect . "?msg=" . $msg;
	   logToFile("functions.php: registerUser(): skipAdd. user re-signing to same product, redirURL: " . $redirURL,LOG_DEBUG_DAP); 
	  }
	  else 	if($thirdParty == true) {
		  $redirURL = $redirect;
	  } else {
		  $redirURL =  $redirect . "?msg=" . $msg;
	  }
	  
	  if($daplistbuildercredits=="Y") {
		 logToFile("functions.php: daplistbuildercredits (double-optin product so no auto-login) but signup completed successfully",LOG_DEBUG_DAP); 
		 if( $doubleoptinproduct == false) {
			return 0; 
		 }
		 if(defined(MSG_THANKYOU_SIGNUP_ACTIVATION)) 
		 	return MSG_THANKYOU_SIGNUP_ACTIVATION;
		 else 
		 	return MSG_THANKYOU_SIGNUP; // double optin in signup successful but do not show hidden content to STU until user completes activation
		 
	  }
	  header("Location: " . urldecode($redirURL));
	  return;
	}
	
	function authUser($email, $password) {
				
		if( ($email != "") && ($password != "") && validateLogins($email, getIpOfUser()) && validate($email,$password) ) {
			logToFile("authUser(): Everything appears ok with login"); 
			
			logToFile("authUser(): pluginLogin: calling",LOG_DEBUG_DAP); 
			pluginLogin($email);
			logToFile("authUser(): pluginLogin: complete",LOG_DEBUG_DAP); 
			$session = Dap_Session::getSession();
			logToFile("authUser(): calling session get user",LOG_DEBUG_DAP); 
			$user = $session->getUser();
			
			if($user) {
			  $user = Dap_User::loadUserById($user->getId()); //reload User object
			  processDAPCredits($user);
			}
			
			logToFile("authUser(): got user" . SITEROOT,LOG_DEBUG_DAP);
			$lldocroot = defined('SITEROOT') ? SITEROOT : $_SERVER['DOCUMENT_ROOT'];
			include_once($lldocroot . "/dap/admin/affiliateResolution.php");
		
			logToFile("authUser(): included",LOG_DEBUG_DAP);
			
			return 0;
			
		} else {
			//Invalid password...
			return INVALID_PASSWORD_MSG;
		}
		
	}
	
	function getCallbackURLWithoutQueryString($current_url_with_query_string)
	{
	logToFile("current_url_with_query_string=".$current_url_with_query_string,LOG_DEBUG_DAP);
	 
	if(strpos($current_url_with_query_string, '?') > 0) {
	  $current_url_without_query_string = substr($current_url_with_query_string, 0, strpos($current_url_with_query_string, '?')); // This line is the key
	  logToFile("current_url_without_query_string=".$current_url_without_query_string,LOG_DEBUG_DAP);
	  return $current_url_without_query_string;
	}
	  
	return $current_url_with_query_string;
	}
	
	
	function createOrUpdateUserAccount($email,$cpassword,$caller="paypalcoupon:",$allowUpdate=false)  // Paypal express checkout 
	{
		include ("countryCodes.php");
		
		$notloggedinbutusingexistingemail=false;
		$user = Dap_User::loadUserByEmail($email);
		if(!isset($user)) {
			logToFile("$caller :see if the paypal email field has this user's email");
			$user = Dap_User::loadUserByPaypalEmail($email);
			if(isset($user)) 
				$notloggedinbutusingexistingemail=true;
		}
		else {
			$notloggedinbutusingexistingemail=true;
		}
		
		$newuser=false;
		if(!isset($user)) {
			$user = new Dap_User();
			if($_SESSION['GDPRConsent']){
				$user->setGDPRConsent($_SESSION['GDPRConsent']);
			}else{
				$user->setGDPRConsent('');
			}
			
			if($_SESSION['gdpr_compliance_date']){
				$user->setGDPRCompliance_date($_SESSION['gdpr_compliance_date']);
			}else{
				$user->setGDPRCompliance_date('');
			}
			
			logToFile("$caller :CheckingUser: New User");
			if(isset($_SESSION["first_name"]) && ($_SESSION["first_name"] != "")) {
				$user->setFirst_name( $_SESSION["first_name"] );
				logToFile("$caller: FIRST=" . $_SESSION["first_name"], LOG_DEBUG_DAP);
			}
		
			if(isset($_SESSION["last_name"]) && ($_SESSION["last_name"] != "")) {
				$user->setLast_name( $_SESSION["last_name"] );
			}
			
			$user->setEmail( $email );	
			if($cpassword != "")
				$user->setPassword($cpassword);
			
			$newuser=true;
		}
		
		if( ((isset($user)) && ($notloggedinbutusingexistingemail==false)) || ($allowUpdate==true)) {
			if(isset($_SESSION["address1"]) && ($_SESSION["address1"] != "")) {
				$user->setAddress1( $_SESSION["address1"] );
			}
			if($_SESSION['GDPRConsent']){
				$user->setGDPRConsent($_SESSION['GDPRConsent']);
			}else{
				$user->setGDPRConsent('');
			}
			
			if($_SESSION['gdpr_compliance_date']){
				$user->setGDPRCompliance_date($_SESSION['gdpr_compliance_date']);
			}else{
				$user->setGDPRCompliance_date('');
			}
			
			if(isset($_SESSION["city"]) && ($_SESSION["city"] != "")) {
				$user->setCity( $_SESSION["city"] );
			}
			
			if(isset($_SESSION["zip"]) && ($_SESSION["zip"] != "")) {
				$user->setZip( $_SESSION["zip"] );
			}
			
			if(isset($_SESSION["phone"]) && ($_SESSION["phone"] != "")) {
				$user->setPhone( $_SESSION["phone"] );
			}
			logToFile("$caller: createaccount: phone number=".$_SESSION["phone"], LOG_DEBUG_DAP);
			if(isset($_SESSION["company"]) && ($_SESSION["company"] != "")) {
				$user->setCompany( $_SESSION["company"] );
			}
			
			logToFile("$caller: createaccount: company=".$_SESSION["company"], LOG_DEBUG_DAP);
			
			if(isset($_SESSION["address2"]) && ($_SESSION["address2"] != "")) {
				$user->setAddress2( $_SESSION["address2"] );
			}
			logToFile("$caller: createaccount: address2=".$_SESSION["address2"], LOG_DEBUG_DAP);
			
			
			if(isset($_SESSION["country"]) && ($_SESSION["country"] != "")) {
				$code = array_search($_SESSION["country"], $countrycodes); 
				logToFile("paypalCoupon.php: COUNTRY=" . $_SESSION["country"], LOG_DEBUG_DAP);
				
				if($code != "") {
					$params['country']=$code;
					$user->setCountry( $code );
					if( ($code == "US") && (isset($_SESSION["state"])) && ($_SESSION["state"] != "")) {
						$statecode=convert_state_to_abbreviation($_SESSION["state"]);
						logToFile("$caller: STATE CODE=" . $statecode, LOG_DEBUG_DAP);
						if($statecode != "") {
							$user->setState( $statecode );
						}
					}
				}
			}
			$_SESSION["userexistsbutallow"]="Y";
			
			if($newuser) {
				logToFile("$caller: created NEW user successfully", LOG_DEBUG_DAP);
				$user->setStatus("P");
				$firstname=$_SESSION["first_name"];
				$lastname=$_SESSION["last_name"];
				
				$uname=generateUsername("$caller: ",$email,$firstname,$lastname);
				if($uname=="") {
					$uname=NULL;
					logToFile("$caller: username set to NULL",LOG_INFO_DAP);
				}
				else { 
					logToFile("$caller: username set to".$uname,LOG_INFO_DAP);
					$user->setUser_name($uname);
				}
				
				$user->create();
			}
			else {
				$user->update();
			}
			
			$user = Dap_User::loadUserByEmail($email);
			logToFile("$caller: created NEW user successfully", LOG_DEBUG_DAP);
		
			$userId=$user->getId();
			logToFile("$caller: updateCustomFields(): allowUpdate= yes", LOG_DEBUG_DAP);
			if ( isset($_SESSION['howdidyouhearaboutus']) && ($_SESSION['howdidyouhearaboutus'] != "") ) {
				$customFld = Dap_CustomFields::loadCustomfieldsByName("howdidyouhearaboutus");
				logToFile("$caller: updateCustomFields(): called loadCustomfieldsByName", LOG_DEBUG_DAP);
				if ($customFld) {
					$id = $customFld->getId();
					logToFile("$caller: updateCustomFields(): id=" . $id, LOG_DEBUG_DAP);
					
					$usercustom = new Dap_UserCustomFields();
				
					$usercustom->setUser_id($userId);
					$usercustom->setCustom_value($_SESSION['howdidyouhearaboutus']);
					$usercustom->setCustom_id($id);
					
					$cf = Dap_UserCustomFields::loadUserCustomFieldsByCustomFieldId($id, $userId );
					if ($cf) {
						logToFile("$caller: updateCustomFields(): call update to update value=" . $_SESSION['howdidyouhearaboutus'], LOG_DEBUG_DAP);
						$usercustom->update();
					}
					else {
						logToFile("$caller: updateCustomFields(): call create to add custom value=" . $_SESSION['howdidyouhearaboutus'], LOG_DEBUG_DAP);
						$usercustom->create();
					}
				}
			}
			if ( isset($_SESSION['comments']) && ($_SESSION['comments'] != "") ) {
				$customFld = Dap_CustomFields::loadCustomfieldsByName("comments");
				logToFile("$caller: updateCustomFields(): called comments", LOG_DEBUG_DAP);
				if ($customFld) {
					$id = $customFld->getId();
					logToFile("$caller: updateCustomFields(): id=" . $id, LOG_DEBUG_DAP);
					
					$usercustom = new Dap_UserCustomFields();
				
					$usercustom->setUser_id($userId);
					$usercustom->setCustom_value($_SESSION['comments']);
					$usercustom->setCustom_id($id);
					
					$cf = Dap_UserCustomFields::loadUserCustomFieldsByCustomFieldId($id, $userId);
					if ($cf) {
						logToFile("$caller: updateCustomFields(): call update to update value=" . $_SESSION['comments'], LOG_DEBUG_DAP);
						$usercustom->update();
					}
					else {
						logToFile("$caller: updateCustomFields(): call create to add custom value=" . $_SESSION['comments'], LOG_DEBUG_DAP);
						$usercustom->create();
					}
				}
			}
		
			if(isset($_SESSION["customfieldval"])) {
				$customfieldval = $_SESSION["customfieldval"];
			  	$cfallarr = explode(",", $customfieldval);
				$count = count($cfallarr);      
				for($i=0;$i<$count;$i++){
				  //logToFile("processdapcredits(): COUNT=". $count);	 
				  //logToFile("processdapcredits(): i=" .  $i . ", cscredits=". $cscredits[$i]);
				    $cfarr = explode(":", $cfallarr[$i]);
					logToFile("$caller: custom field name=".  $cfarr[0]);	 
					logToFile("$caller: custom field val=".  $cfarr[1]);
					$name=$cfarr[0];
					if ($keyval = substr($name, 7)) {
						  $customFld = Dap_CustomFields::loadCustomfieldsByName($keyval);
						  logToFile("$caller: loadCustomfieldsByName(): keyval=" . $keyval, LOG_DEBUG_DAP);		
						  if ($customFld) {
							  $id = $customFld->getId();
							  logToFile("$caller: customFld Id = " . $id, LOG_DEBUG_DAP);		
							  
							  $usercustom = new Dap_UserCustomFields();
							  
							  $usercustom->setUser_id($userId);
							  $usercustom->setCustom_id($id);
							  $usercustom->setCustom_value($cfarr[1]);
							  
							  $cf = Dap_UserCustomFields::loadUserCustomFieldsByCustomFieldId($id, $userId);
							  if ($cf) {
								  logToFile("$caller:  updateCustomFields(): call update() to update value=" . $cfarr[1], LOG_DEBUG_DAP);
								  $usercustom->update();
							  }
							  else {
								  logToFile("$caller:  updateCustomFields(): call create() to add custom value=" . $cfarr[1], LOG_DEBUG_DAP);
								  $usercustom->create();
							  }
						  }
					}
					
				}
				
			}
		}
		
	}
	
	
	function convert_state_to_abbreviation($state_name) {
		switch ($state_name) {
		case "Alabama":
		return "AL";
		break;
		case "Alaska":
		return "AK";
		break;
		case "Arizona":
		return "AZ";
		break;
		case "Arkansas":
		return "AR";
		break;
		case "California":
		return "CA";
		break;
		case "Colorado":
		return "CO";
		break;
		case "Connecticut":
		return "CT";
		break;
		case "Delaware":
		return "DE";
		break;
		case "Florida":
		return "FL";
		break;
		case "Georgia":
		return "GA";
		break;
		case "Hawaii":
		return "HI";
		break;
		case "Idaho":
		return "ID";
		break;
		case "Illinois":
		return "IL";
		break;
		case "Indiana":
		return "IN";
		break;
		case "Iowa":
		return "IA";
		break;
		case "Kansas":
		return "KS";
		break;
		case "Kentucky":
		return "KY";
		break;
		case "Louisana":
		return "LA";
		break;
		case "Maine":
		return "ME";
		break;
		case "Maryland":
		return "MD";
		break;
		case "Massachusetts":
		return "MA";
		break;
		case "Michigan":
		return "MI";
		break;
		case "Minnesota":
		return "MN";
		break;
		case "Mississippi":
		return "MS";
		break;
		case "Missouri":
		return "MO";
		break;
		case "Montana":
		return "MT";
		break;
		case "Nebraska":
		return "NE";
		break;
		case "Nevada":
		return "NV";
		break;
		case "New Hampshire":
		return "NH";
		break;
		case "New Jersey":
		return "NJ";
		break;
		case "New Mexico":
		return "NM";
		break;
		case "New York":
		return "NY";
		break;
		case "North Carolina":
		return "NC";
		break;
		case "North Dakota":
		return "ND";
		break;
		case "Ohio":
		return "OH";
		break;
		case "Oklahoma":
		return "OK";
		break;
		case "Oregon":
		return "OR";
		break;
		case "Pennsylvania":
		return "PA";
		break;
		case "Rhode Island":
		return "RI";
		break;
		case "South Carolina":
		return "SC";
		break;
		case "South Dakota":
		return "SD";
		break;
		case "Tennessee":
		return "TN";
		break;
		case "Texas":
		return "TX";
		break;
		case "Utah":
		return "UT";
		break;
		case "Vermont":
		return "VT";
		break;
		case "Virginia":
		return "VA";
		break;
		case "Washington":
		return "WA";
		break;
		case "Washington D.C.":
		return "DC";
		break;
		case "West Virginia":
		return "WV";
		break;
		case "Wisconsin":
		return "WI";
		break;
		case "Wyoming":
		return "WY";
		break;
		case "Alberta":
		return "AB";
		break;
		case "British Columbia":
		return "BC";
		break;
		case "Manitoba":
		return "MB";
		break;
		case "New Brunswick":
		return "NB";
		break;
		case "Newfoundland & Labrador":
		return "NL";
		break;
		case "Northwest Territories":
		return "NT";
		break;
		case "Nova Scotia":
		return "NS";
		break;
		case "Nunavut":
		return "NU";
		break;
		case "Ontario":
		return "ON";
		break;
		case "Prince Edward Island":
		return "PE";
		break;
		case "Quebec":
		return "QC";
		break;
		case "Saskatchewan":
		return "SK";
		break;
		case "Yukon Territory":
		return "YT";
		break;
		default:
		return $state_name;
		}
    }


	function clearCartSession() {

		if(isset($_SESSION["stripeToken"])) {
			$_SESSION["stripeToken"]="";
			unset($_SESSION["stripeToken"]);
		}
		
		if(isset($_SESSION["cpassword"])) {
			$_SESSION["cpassword"]="";
			unset($_SESSION["cpassword"]);
		}
		
		if(isset($_SESSION["userexistsbutallow"])) {
			$_SESSION["userexistsbutallow"]="";
			unset($_SESSION["userexistsbutallow"]);
		}
		
		if(isset($_SESSION["first_name"])) {
			$_SESSION["first_name"]="";
			unset($_SESSION["first_name"]);
			
			$_SESSION["last_name"]="";
			unset($_SESSION["last_name"]);
			
			$_SESSION["address1"]="";
			unset($_SESSION["address1"]);
			
			$_SESSION["city"]="";
			unset($_SESSION["city"]);
			
			$_SESSION["state"]="";
			unset($_SESSION["state"]);
			
			$_SESSION["zip"]="";
			unset($_SESSION["zip"]);	
		}
	}
	
	function generateUsername($caller,$email,$firstname,$lastname) {
		//value=1 USERNAME_FIRST_LAST
		//value=2 USERNAME_1STPARTEM
		//value=3 USERNAME_FIRSTLAST3
		//value=4 USERNAME_RANDOM8
		//value=5 USERNAME_USERPICK
		
		$option1=Dap_Config::get("OPTION1");
		$option2=Dap_Config::get("OPTION2");
		$option3=Dap_Config::get("OPTION3");
		
		$optionArr=array();
		
		$optionArr[0]=$option1;
		$optionArr[1]=$option2;
		$optionArr[2]=$option3;

		$i=0;
		while($i<count($optionArr)) {
			logToFile("$caller: generateUsername(): $i, try option=" . $optionArr[$i], LOG_DEBUG_DAP);	
			switch(	$optionArr[$i] ) {
				case 1:
					$username=$firstname.$lastname;
					break;
				case 2:
					$namearr=explode("@",$email);
					$username=$namearr[0];
					break;
				case 3:
					$username=$firstname.$lastname.mt_rand(100,999);
					break;
				case 4:
					$username=random_string(8);
					break;
				case 5:
					$username="userpick";
					break;
			}
			logToFile("$caller: generateUsername():" . $username, LOG_DEBUG_DAP);	
			if($username!="") {
				//check if already taken, if yes continue, if available return this username
				if($username=="userpick")
					return "";
				$isInUse=Dap_User::isInUse("user_name",$username);
				if($isInUse==FALSE) {
					logToFile("$caller: generateUsername(): username=username generated successfully using " . $optionArr[$i], LOG_DEBUG_DAP);	
					return $username;
				}
			}
			$i++;
		}
		logToFile("$caller: generateUsername(): no username found: " . $username, LOG_DEBUG_DAP);	
	}
	
	
	function generateUsernameOLD($caller,$email,$firstname,$lastname) {
		
		
		$username_first_last=Dap_Config::get("USERNAME_FIRST_LAST");
		$username_1stpartem=Dap_Config::get("USERNAME_1STPARTEM");
		$username_firstlast3=Dap_Config::get("USERNAME_FIRSTLAST3");
	//	$username_random8=Dap_Config::get("USERNAME_RANDOM8");
	//	$username_userpick=Dap_Config::get("USERNAME_USERPICK");
		
		$optionArr=array();
		
		$optionArr[$username_first_last]="firstlast";
		$optionArr[$username_1stpartem]="1stpartem";
		$optionArr[$username_firstlast3]="firstlast3";
	//	$optionArr[$username_random8]="random8";
	//	$optionArr[$username_userpick]="userpick";
				
		$i=1;
		while($i<count($optionArr)) {
			logToFile("$caller: generateUsername(): $i, try option=" . $optionArr[$i], LOG_DEBUG_DAP);	
			switch(	$optionArr[$i] ) {
				case "firstlast":
					$username=$firstname.$lastname;
					break;
				case "1stpartem":
					$namearr=explode("@",$email);
					$username=$namearr[0];
					break;
				case "firstlast3":
					$username=$firstname.$lastname.mt_rand(100,999);
					break;
				case "random8":
					$username=random_string(8);
					break;
				case "userpick":
				$username="userpick";
				break;
			}
			logToFile("$caller: generateUsername():" . $username, LOG_DEBUG_DAP);	
			if($username!="") {
				//check if already taken, if yes continue, if available return this username
				if($username=="userpick")
					return "";
				$isInUse=Dap_User::isInUse("user_name",$username);
				if($isInUse==FALSE) {
					logToFile("$caller: generateUsername(): username=username generated successfully using " . $optionArr[$i], LOG_DEBUG_DAP);	
					return $username;
				}
			}
			$i++;
		}
		logToFile("$caller: generateUsername(): no username found: " . $username, LOG_DEBUG_DAP);	
	}
	
	
	function random_string($length) {
	  $key = '';
	  $keys = array_merge(range(0, 9), range('a', 'z'));
  
	  for ($i = 0; $i < $length; $i++) {
		  $key .= $keys[array_rand($keys)];
	  }
  
	  return $key;
	}


	
	function dapGetCountryGDPRStatus() {
		$gdpr_status = array();
		try{
			$countries = Dap_GDPRCountries::loadGDPRCountries();
			foreach($countries AS $key=>$value){
				$status = Dap_GDPRCountries::getGDPRCountryStatus($value);
				$gdpr_status[$value] = $status;
			}
		}
		catch(Exception $e){
			logToFile("functions.php:dapGetCountryGDPRStatus(), exception".$e->getMessage());
		}
		
		/*$gdpr_status = array('BE' => '1',
		'BG' => '1',
		'CZ' => '1',
		'DK' => '1',
		'DE' => '1',
		'EE' => '1',
		'IE' => '1',
		'EL' => '1',
		'ES' => '1',
		'FR' => '1',
		'HR' => '1',
		'IT' => '1',
		'CY' => '1',
		'LV' => '1',
		'LT' => '1',
		'LU' => '1',
		'HU' => '1',
		'MT' => '1',
		'NL' => '1',
		'AT' => '1',
		'PL' => '1',
		'PT' => '1',
		'RO' => '1',
		'SK' => '1',
		'SI' => '1',
		'FI' => '1',
		'SE' => '1',
		'GB' => '1',
		);*/

		return $gdpr_status;
	}

	function dapGetGDPRStatus($ip){
		
		if(defined('GDPRTESTING') && (GDPRTESTING=="Y")) {
			logToFile("functions.php:GDPR in test mode.. treat all users as GDPR", LOG_DEBUG_DAP);
			return 1;
		}
		$code = dapGetCountryCodeByIp($ip);
		logToFile("functions.php:dapGetGDPRStatus() called: code=".$code, LOG_DEBUG_DAP);
		$status = 0;
		$gdpr_status_list = dapGetCountryGDPRStatus();
		if($gdpr_status_list){
			foreach($gdpr_status_list as $key=>$value){
				if($key == $code ){
					$status = $value;
					break;
				}
			}
		}
		logToFile("functions.php:dapGetGDPRStatus() called gdprstatus" .$status, LOG_DEBUG_DAP);

		return $status;
	}
	
	function dapGetCountryCodeByIp($ipaddress) {
		logToFile("functions.php:dapGetCountryCodeByIp() called" . $ipaddress, LOG_DEBUG_DAP);
		$return_data = '';
		$ip_data = @json_decode(file_get_contents("http://www.geoplugin.net/json.gp?ip=" . $ipaddress));
		if ($ip_data && $ip_data->geoplugin_countryName != null) {
			$return_data= $ip_data->geoplugin_countryCode;
		}else{
			$ip_data = @json_decode(file_get_contents("https://ipfind.co?ip=" . $ipaddress));
			if ($ip_data && $ip_data->country != null) {
				$return_data = $ip_data->country_code;
			}
		}
		return $return_data;
	}

	function findGDPRCountryFromOrderDetails($email){
		logToFile("functions.php:findGDPRCountryFromOrderDetails() called email = " . $email, LOG_DEBUG_DAP);
		$data = array();
		
		try{
			$user = Dap_User::loadUserByEmail($email);
			if(isset($user)){
				$country = Dap_Transactions::loadOrderCountryFromEmail($email);
				logToFile("functions.php:findGDPRCountryFromOrderDetails() country = " . ucfirst($country), LOG_DEBUG_DAP);
			
				if($country != "" && $country != -1){
					// Now check if country is GDPR or not
					if(strtolower($country) == "united states of america" || strtolower($country) == "usa"){
						$code = "US"; // i have done this because in the array that contains country names and code , we can have only keys and in some cases there is USA,United States or United States of America. SO we can have only one key for this.
					}
					else{
						$code = DAPgetCountryCodeByName(ucfirst($country));
					}
					
					logToFile("functions.php:findGDPRCountryFromOrderDetails() countryCode = " . $code, LOG_DEBUG_DAP);
					
					$status = "";
					// Now get status for all the countries
					$gdpr_status_list = dapGetCountryGDPRStatus();
					if($gdpr_status_list){
						foreach($gdpr_status_list as $key=>$value){
							if(strtolower($key) == strtolower($code)){
								$status = $value;
								break;
							}
						}
					}
					
					if($status == 1){
						$data['code'] = 1;
						$data['country'] = $country;
						$data['msg'] = "GDPR Country";
						logToFile("functions.php:findGDPRCountryFromOrderDetails()  Country", LOG_DEBUG_DAP);
					}
					else{
						$data['code'] = 2;
						$data['country'] = $country;
						$data['msg'] = "Not a GDPR Country";	
						logToFile("functions.php:findGDPRCountryFromOrderDetails() Not a GDPR Country", LOG_DEBUG_DAP);
					}
					
					
					if($user->getCountry() == "" || $user->getCountry() == "-1" || $user->getCountry() == "Select Country"){
						// Now need to update the country in users table
						logToFile("functions.php:findGDPRCountryFromOrderDetails() going to update country in users table", LOG_DEBUG_DAP);
						try{
							$user->setCountry($country);
							$user->update();
							
						}
						catch(Exception $e){
							logToFile("functions.php:findGDPRCountryFromOrderDetails() cant update the user country", LOG_DEBUG_DAP);
						}
					}
					logToFile("functions.php:findGDPRCountryFromOrderDetails() now return", LOG_DEBUG_DAP);
					return $data;
					
				}
				else{
					logToFile("functions.php:findGDPRCountryFromOrderDetails() country = not found", LOG_DEBUG_DAP);
					$data['code'] = 3;
					$data['country'] = "";
					$data['msg'] = "No Country Found";
				}
			}
			else{
				logToFile("functions.php:findGDPRCountryFromOrderDetails(),user does not exist in DAP ", LOG_DEBUG_DAP);
				$data['code'] = 3;
				$data['country'] = "";
				$data['msg'] = "User does not exist in DAP";
			}
		}
		catch(Exception $e){
			logToFile("functions.php:findGDPRCountryFromOrderDetails() Exception while getting user ".$e->getMessage(), LOG_DEBUG_DAP);
		}
		return $data;
	}


	function applyGDPRRules($email){
		$GDPRConsentDAP = "";
		if($email != ""){
			try{
				$user = Dap_User::loadUserByEmail($email);
				if(isset($user) && $user != ""){
					$GDPRConsentDAP = $user->getGDPRConsent();
				}
				else{
					return false;
				}
			}
			catch(Exception $e){
				logToFile("(function.php,applyGDPRRules()), Exception while getting user GDPR field = ".$e->getMessage(),LOG_DEBUG_DAP);
			}
		}
		else{
			return false;
		}

		$GDPRApplicable=false;
		
		// check if we are able to track whether existing user is GDPR Trackable or not
		if($GDPRConsentDAP == "" && $_SESSION['GDPRConsent'] == ""){

			try{
				$GDPRdata = Dap_GDPR::load();
				if(isset($GDPRdata) && $GDPRdata!=""){
					// first check if use_country_for_gdpr is set or not,Here we are checking the $GDPRdata->getFilter_gdpr_transactions() == "N" because even if we get the GDPR country for the user but if filter GDPR is set to yes, we wont be sending the emails anyway.
				
					if($GDPRdata->getUser_country_for_gdpr() == "Y"){
						$country = $user->getCountry(); // we are not doing isset of user becuase we have already done it in the start
						
						if($country != "" && $country != "-1" && $country != "select"){
							$code = DAPgetCountryCodeByName(ucfirst($country));
							
							if($code != ""){
								// now check if it a GDPR country
								
								$status = "";
								$gdpr_status_list = dapGetCountryGDPRStatus();
								if($gdpr_status_list){
									foreach($gdpr_status_list as $key=>$value){
										if(strtolower($key) == strtolower($code)){
											$status = $value;
											break;
										}
									}
								}
								if($status == 1){ //gdpr country
									$GDPRConsentDAP = "GDPRConsentNO";
								}
								else{ // not gdpr country
									return true;
								}
							}
						}
					}
	
					
					//This means that GDPR is not trackable for this existing User, So now we have to check for the filter existing users flag
					
					if($GDPRdata->getFilter_existing_users() == "Y" && $GDPRConsentDAP == ""){
						if($GDPRdata->getFilter_gdpr_transactions() == "N"){
							// if filter transaction is set to N we will send the emails
							return true;
						}
						else{
							// cant send emails because filter existing is set to Y and filter transaction is Y
							return false;
						}
						
					} 
					
				}
			}
			catch(Exception $e){
				logToFile("(functions.php,applyGDPRRules()), Exception while getting GDPR rules= ".$e->getMessage(),LOG_DEBUG_DAP);
			}

		}

		if(isset($_SESSION['GDPRConsent']) || ($GDPRConsentDAP != "" && $GDPRConsentDAP != "NOT_GDPR_USER")) {
			$GDPRApplicable=true;
		}
		
		if($GDPRApplicable == true) { 			

			// first of all get the GDPRdata settings from DAP
			try{
				$GDPRdata = Dap_GDPR::load();
				if(isset($GDPRdata) && $GDPRdata != ""){
					$filterTrans = $GDPRdata->getFilter_gdpr_transactions();
				}
				else{
					$filterTrans = "N";	
				}
				
			}
			catch(Exception $e){
				logToFile("(functions.php,applyGDPRRules()), Exception while loading GDPR rules= ".$e->getMessage(),LOG_DEBUG_DAP);
			}

			if (strtolower( $_SESSION['GDPRConsent'] ) == "yes" || $GDPRConsentDAP == "GDPR_CONSENT_YES") { // GDPR applicable and consent given	
				return true;
			} 
			else { // GDPR applicable but consent not given	
				if ($filterTrans != "" && $filterTrans == "N") {  // filter GDPR is not checked	so we will send emails	
					return true;
				}
				else { // cant send emails because consent not received and filter gdpr is set to yes
					return false;
				}

			}
		}
		else { // GDPR not applicable so apply automation rules
			return true;
		}

	}
	
function DAPgetCountryCodeByName($country) {
    $country_code = array('AF' => 'Afghanistan',
        'AX' => 'Aland Islands',
        'AL' => 'Albania',
        'DZ' => 'Algeria',
        'AS' => 'American Samoa',
        'AD' => 'Andorra',
        'AO' => 'Angola',
        'AI' => 'Anguilla',
        'AQ' => 'Antarctica',
        'AG' => 'Antigua and Barbuda',
        'AR' => 'Argentina',
        'AM' => 'Armenia',
        'AW' => 'Aruba',
        'AU' => 'Australia',
        'AT' => 'Austria',
        'AZ' => 'Azerbaijan',
        'BS' => 'Bahamas the',
        'BH' => 'Bahrain',
        'BD' => 'Bangladesh',
        'BB' => 'Barbados',
        'BY' => 'Belarus',
        'BE' => 'Belgium',
        'BZ' => 'Belize',
        'BJ' => 'Benin',
        'BM' => 'Bermuda',
        'BT' => 'Bhutan',
        'BO' => 'Bolivia',
        'BA' => 'Bosnia and Herzegovina',
        'BW' => 'Botswana',
        'BV' => 'Bouvet Island Bouvetoya',
        'BR' => 'Brazil',
        'IO' => 'British Indian Ocean Territory Chagos Archipelago',
        'VG' => 'British Virgin Islands',
        'BN' => 'Brunei Darussalam',
        'BG' => 'Bulgaria',
        'BF' => 'Burkina Faso',
        'BI' => 'Burundi',
        'KH' => 'Cambodia',
        'CM' => 'Cameroon',
        'CA' => 'Canada',
        'CV' => 'Cape Verde',
        'KY' => 'Cayman Islands',
        'CF' => 'Central African Republic',
        'TD' => 'Chad',
        'CL' => 'Chile',
        'CN' => 'China',
        'CX' => 'Christmas Island',
        'CC' => 'Cocos Keeling Islands',
        'CO' => 'Colombia',
        'KM' => 'Comoros the',
        'CD' => 'Congo',
        'CG' => 'Congo the',
        'CK' => 'Cook Islands',
        'CR' => 'Costa Rica',
        'CI' => 'Cote d\'Ivoire',
        'HR' => 'Croatia',
        'CU' => 'Cuba',
        'CY' => 'Cyprus',
        'CZ' => 'Czech Republic',
        'DK' => 'Denmark',
        'DJ' => 'Djibouti',
        'DM' => 'Dominica',
        'DO' => 'Dominican Republic',
        'EC' => 'Ecuador',
        'EG' => 'Egypt',
        'SV' => 'El Salvador',
        'GQ' => 'Equatorial Guinea',
        'ER' => 'Eritrea',
        'EE' => 'Estonia',
        'ET' => 'Ethiopia',
        'FO' => 'Faroe Islands',
        'FK' => 'Falkland Islands Malvinas',
        'FJ' => 'Fiji the Fiji Islands',
        'FI' => 'Finland',
        'FR' => 'France',
        'GF' => 'French Guiana',
        'PF' => 'French Polynesia',
        'TF' => 'French Southern Territories',
        'GA' => 'Gabon',
        'GM' => 'Gambia the',
        'GE' => 'Georgia',
        'DE' => 'Germany',
        'GH' => 'Ghana',
        'GI' => 'Gibraltar',
        'GR' => 'Greece',
        'GL' => 'Greenland',
        'GD' => 'Grenada',
        'GP' => 'Guadeloupe',
        'GU' => 'Guam',
        'GT' => 'Guatemala',
        'GG' => 'Guernsey',
        'GN' => 'Guinea',
        'GW' => 'Guinea-Bissau',
        'GY' => 'Guyana',
        'HT' => 'Haiti',
        'HM' => 'Heard Island and McDonald Islands',
        'VA' => 'Holy See Vatican City State',
        'HN' => 'Honduras',
        'HK' => 'Hong Kong',
        'HU' => 'Hungary',
        'IS' => 'Iceland',
        'IN' => 'India',
        'ID' => 'Indonesia',
        'IR' => 'Iran',
        'IQ' => 'Iraq',
        'IE' => 'Ireland',
        'IM' => 'Isle of Man',
        'IL' => 'Israel',
        'IT' => 'Italy',
        'JM' => 'Jamaica',
        'JP' => 'Japan',
        'JE' => 'Jersey',
        'JO' => 'Jordan',
        'KZ' => 'Kazakhstan',
        'KE' => 'Kenya',
        'KI' => 'Kiribati',
        'KP' => 'Korea',
        'KR' => 'Korea',
        'KW' => 'Kuwait',
        'KG' => 'Kyrgyz Republic',
        'LA' => 'Lao',
        'LV' => 'Latvia',
        'LB' => 'Lebanon',
        'LS' => 'Lesotho',
        'LR' => 'Liberia',
        'LY' => 'Libyan Arab Jamahiriya',
        'LI' => 'Liechtenstein',
        'LT' => 'Lithuania',
        'LU' => 'Luxembourg',
        'MO' => 'Macao',
        'MK' => 'Macedonia',
        'MG' => 'Madagascar',
        'MW' => 'Malawi',
        'MY' => 'Malaysia',
        'MV' => 'Maldives',
        'ML' => 'Mali',
        'MT' => 'Malta',
        'MH' => 'Marshall Islands',
        'MQ' => 'Martinique',
        'MR' => 'Mauritania',
        'MU' => 'Mauritius',
        'YT' => 'Mayotte',
        'MX' => 'Mexico',
        'FM' => 'Micronesia',
        'MD' => 'Moldova',
        'MC' => 'Monaco',
        'MN' => 'Mongolia',
        'ME' => 'Montenegro',
        'MS' => 'Montserrat',
        'MA' => 'Morocco',
        'MZ' => 'Mozambique',
        'MM' => 'Myanmar',
        'NA' => 'Namibia',
        'NR' => 'Nauru',
        'NP' => 'Nepal',
        'AN' => 'Netherlands Antilles',
        'NL' => 'Netherlands the',
        'NC' => 'New Caledonia',
        'NZ' => 'New Zealand',
        'NI' => 'Nicaragua',
        'NE' => 'Niger',
        'NG' => 'Nigeria',
        'NU' => 'Niue',
        'NF' => 'Norfolk Island',
        'MP' => 'Northern Mariana Islands',
        'NO' => 'Norway',
        'OM' => 'Oman',
        'PK' => 'Pakistan',
        'PW' => 'Palau',
        'PS' => 'Palestinian Territory',
        'PA' => 'Panama',
        'PG' => 'Papua New Guinea',
        'PY' => 'Paraguay',
        'PE' => 'Peru',
        'PH' => 'Philippines',
        'PN' => 'Pitcairn Islands',
        'PL' => 'Poland',
        'PT' => 'Portugal=> Portuguese Republic',
        'PR' => 'Puerto Rico',
        'QA' => 'Qatar',
        'RE' => 'Reunion',
        'RO' => 'Romania',
        'RU' => 'Russian Federation',
        'RW' => 'Rwanda',
        'BL' => 'Saint Barthelemy',
        'SH' => 'Saint Helena',
        'KN' => 'Saint Kitts and Nevis',
        'LC' => 'Saint Lucia',
        'MF' => 'Saint Martin',
        'PM' => 'Saint Pierre and Miquelon',
        'VC' => 'Saint Vincent and the Grenadines',
        'WS' => 'Samoa',
        'SM' => 'San Marino',
        'ST' => 'Sao Tome and Principe',
        'SA' => 'Saudi Arabia',
        'SN' => 'Senegal',
        'RS' => 'Serbia',
        'SC' => 'Seychelles',
        'SL' => 'Sierra Leone',
        'SG' => 'Singapore',
        'SK' => 'Slovakia Slovak Republic',
        'SI' => 'Slovenia',
        'SB' => 'Solomon Islands',
        'SO' => 'Somalia=> Somali Republic',
        'ZA' => 'South Africa',
        'GS' => 'South Georgia and the South Sandwich Islands',
        'ES' => 'Spain',
        'LK' => 'Sri Lanka',
        'SD' => 'Sudan',
        'SR' => 'Suriname',
        'SJ' => 'Svalbard & Jan Mayen Islands',
        'SZ' => 'Swaziland',
        'SE' => 'Sweden',
        'CH' => 'Switzerland=> Swiss Confederation',
        'SY' => 'Syrian Arab Republic',
        'TW' => 'Taiwan',
        'TJ' => 'Tajikistan',
        'TZ' => 'Tanzania',
        'TH' => 'Thailand',
        'TL' => 'Timor-Leste',
        'TG' => 'Togo',
        'TK' => 'Tokelau',
        'TO' => 'Tonga',
        'TT' => 'Trinidad and Tobago',
        'TN' => 'Tunisia',
        'TR' => 'Turkey',
        'TM' => 'Turkmenistan',
        'TC' => 'Turks and Caicos Islands',
        'TV' => 'Tuvalu',
        'UG' => 'Uganda',
        'UA' => 'Ukraine',
        'AE' => 'United Arab Emirates',
        'GB' => 'United Kingdom',
        'US' => 'United States',
        'UM' => 'United States Minor Outlying Islands',
        'VI' => 'United States Virgin Islands',
        'UY' => 'Uruguay Eastern Republic of',
        'UZ' => 'Uzbekistan',
        'VU' => 'Vanuatu',
        'VE' => 'Venezuela',
        'VN' => 'Vietnam',
        'WF' => 'Wallis and Futuna',
        'EH' => 'Western Sahara',
        'YE' => 'Yemen',
        'ZM' => 'Zambia',
        'ZW' => 'Zimbabwe');
        
	$key = array_search($country, $country_code);
    return $key;
}


function getCountryByIP($ipaddress){ /*get country name by IP*/
	$return_data = array('country_name' => '');
	$url = "http://www.geoplugin.net/json.gp?ip=" . $ipaddress;
	$curl = curl_init();
	curl_setopt($curl, CURLOPT_URL, $url);
	curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($curl, CURLOPT_HEADER, false);
	$data = curl_exec($curl);
	curl_close($curl);
	$data = @json_decode($data);
	
	if ($data && $data->geoplugin_countryName != null) {
		$_SESSION['country_name'] = $return_data['country_name'] = $data->geoplugin_countryName;
	}
	if($return_data['country_name'] == ''){
		$ip_data = @json_decode(file_get_contents("http://www.geoplugin.net/json.gp?ip=" . $ipaddress));
		if ($ip_data && $ip_data->geoplugin_countryName != null) {
			$_SESSION['country_name'] = $return_data['country_name'] = $ip_data->geoplugin_countryName;
		}else{
			$ip_data = @json_decode(file_get_contents("https://ipfind.co?ip=" . $ipaddress));
		
			if ($ip_data && $ip_data->country != null) {
				$_SESSION['country_name'] = $return_data['country_name'] = $ip_data->country;
			}
		}
		
	}

	return $return_data;
}


/******************Compare files *****************/


function dapCheckFiles(){
	$lldocroot = defined('SITEROOT') ? SITEROOT : $_SERVER['DOCUMENT_ROOT'];
	$dapver = floatval(DAP_VERSION);
	
	$url = "https://digitalaccesspass.com/securityupdates/".$dapver.".php/?type=dap";
	/*$raw_response = wp_remote_post($url);
	$listOfFiles = unserialize($raw_response['body']);*/
	
	$curl = curl_init();
	curl_setopt($curl, CURLOPT_URL, $url);
	curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($curl, CURLOPT_HEADER, false);
	$data = curl_exec($curl);
	curl_close($curl);
	$data = @json_decode($data);
	$listOfFiles = $data;
	//echo $listOfFiles[0];die;
	
	/*if(file_exists(plugin_dir_path(__FILE__).'/includes/compare/'.$dapver.'.php')){
		include_once (plugin_dir_path(__FILE__).'/includes/compare/'.$dapver.'.php');  */
		
		Dap_SecurityScanReport::delete();
	if(count($listOfFiles) > 1 && $listOfFiles != ''){	
		
		if (file_exists($lldocroot . "/dap/dap-config.php"))
			include_once ($lldocroot . "/dap/dap-config.php");  
		
		$dir = $lldocroot.'/dap';
		
		$results = getDirContentsDAP($dir);
		
		
		foreach($listOfFiles as $files){
			$newListOfFiles[] = $lldocroot.$files;
		}
		
		$extraFiles = array();
		
		foreach($results as $result){
			
			if(substr($result, -1) == '/') {
				$result_new = substr($result, 0, -1);
				
				$result_new = explode('/' , $result_new);
				$finalValue = end($result_new);
				array_pop($result_new);
				
				$folder = implode('/', $result_new);
			}else{
				$result_new = explode('/' , $result);
				$finalValue = end($result_new);
				array_pop($result_new);
				
				$folder = implode('/', $result_new);
			}
			
			if(!in_array($result , $newListOfFiles)){
				array_push($extraFiles, $result);
				
				$scanReport = new Dap_SecurityScanReport();
				
				$scanReport->setFileName($finalValue);
				$scanReport->setFilePath($folder);
				$scanReport->setDate(date('Y-m-d H:m:s'));
				
				$scanReport->create();
				
			}
		}
	}else{
		logToFile("functions.php: Sorry, scan is not supported in this version of DAP. Your DAP version is".$dapver, LOG_DEBUG_DAP);
		Dap_SecurityScanReport::delete();
		
	}		
	return;
	//print_r($extraFiles);die;
}

function getDirContentsDAP($dir, &$results = array()){
	
    $files = scandir($dir);
	
    foreach($files as $key => $value){
        $path = realpath($dir.DIRECTORY_SEPARATOR.$value);
        if(!is_dir($path)) {
            $results[] = $path;
        } else if($value != "." && $value != "..") {
            getDirContentsDAP($path, $results);
            $results[] = $path;
        }
    }

    return $results;
}


function processAffiliateHistory($user_id,$action , $product_id, $credit_earned, $comments){
	logToFile("functions. php processAffiliateHistory(): enter",LOG_DEBUG_DAP); 			
	$credit_spent =0; 
	$ip = $_SERVER['REMOTE_ADDR'];
	$country = '';
	$page_id =0;
	$date= date("Y-m-d H:i:s"); 
	$value = '';
	$course_data = '';
	
	$credit_history_obj = new DAP_CreditsHistory();
	$credit_history_obj->setUserId($user_id);
	$credit_history_obj->setAction($action);		
	$credit_history_obj->setCreditsSpent($credit_spent);
	$credit_history_obj->setIp($ip);
	$credit_history_obj->setCountry($country);
	$credit_history_obj->setPageId($page_id);
	$credit_history_obj->setProductId($product_id);
	$credit_history_obj->setValue($value);
	$credit_history_obj->setCourseData($course_data);
	$credit_history_obj->setComments($comments);
	$credit_history_obj->setTimeStamp($date);

	$credit_history_obj->setCreditsEarned($credit_earned);
	$credit_history_obj->create();	
	
	logToFile("functions. php processAffiliateHistory(): returning",LOG_DEBUG_DAP); 			
} 
 

/***Check if credits earned*****/
function checkIfEligibleForCredits($type, $productId="", $userId) {
		logToFile("functions. php checkIfEligibleForCredits(): type ". $type,LOG_DEBUG_DAP); 			
		$SELF_SERVICE_ENABLED = Dap_Config::get("SELF_SERVICE_ENABLED");
		
		if($SELF_SERVICE_ENABLED =="N"){
			logToFile("functions.php checkIfEligibleForCredits(): notEligible for credits SELF_SERVICE_ENABLED =".$SELF_SERVICE_ENABLED." type ". $type ,LOG_DEBUG_DAP); 			
			return false;
		}	 

		if($type == "registration" || $type ==  "purchase" || $type == "recurring_credits" || $type == "page_visit" || $type == "social_share"){
			 
			$getcredits = Dap_ActionPoints::loadByActionAndValue($type, $productId);
			logToFile("functions.php checkIfEligibleForCredits(): enter getcredits=".count($getcredits),LOG_DEBUG_DAP);
			 
			if(isset($getcredits) && count($getcredits) >0 ){
				/****If getcredits then do this**********/ 
				$set_max_limit = $getcredits[0]->getMaxLimit();
				$res_credits = $getcredits[0]->getCredits();
				$res_maxcredits = $getcredits[0]->getMaxCredits();	
				
				// If set_max_limit is no means no limit award credits
				if($set_max_limit =="no"){
					return $res_credits;				
				}else{
							
					if ($res_maxcredits >= $res_credits ){
						return $res_credits;
					}else{
						logToFile("functions.php checkIfEligibleForCredits(): type=". $type." notEligible for credits  max credts is less" ,LOG_DEBUG_DAP); 
						return false;
					} 
				}			
				 
			}else{
				logToFile("functions.php checkIfEligibleForCredits(): type=". $type."  notEligible for credits , credits assign is 0 or not in action table",LOG_DEBUG_DAP); 
				return false;					 
			} 
	 
		} else if(  $type == "course_completed" || $type == "unit_completed" || $type == "quiz_completed" ||  $type == "module_completed" ){
			 
			$getcredits = Dap_ActionPoints::loadByActionAndValue($type, $productId);
			//logToFile("functions. php checkIfProductInPoints(): enter getcredits=".count($getcredits),LOG_DEBUG_DAP);
			 						
			if(isset($getcredits) && count($getcredits) >0 ){			
				
				/****If getcredits then do this**********/ 				
				$set_max_limit = $getcredits[0]->getMaxLimit();								
				$res_credits = $getcredits[0]->getCredits();
				$res_maxcredits = $getcredits[0]->getMaxCredits();	
				
				// If set_max_limit is no means no limit award credits
				if($set_max_limit =="no"){
					return $res_credits;				
				}else{							
					if ($res_maxcredits >= $res_credits ){
						return $res_credits;
					}else{
						logToFile("functions. php checkIfProductInPoints(): type=". $type." notEligible for credits  max credts is less" ,LOG_DEBUG_DAP); 
						return false;
					}
				}
						
				 
			}else{				
				
				if( $type ==  "module_completed"  ||  $type ==  "unit_completed"){
					
					logToFile("functions.php checkIfEligibleForCredits(): if there are common points for action module or unit" ,LOG_DEBUG_DAP);
					//$getmoduleid = $getcredits[0]->getModuleId();
					$productIds =  explode('||', $productId);		
					if( $type ==  "module_completed" ){						 			
						$mod_ids =  $productIds[0];	
						if($mod_ids =="all"){
							$productId =  $mod_ids.'||'.$productIds[0] ;	
						}
					}
					
					if( $type ==  "unit_completed" ){						 			
						$unit_ids =  $productIds[0];	
						if($unit_ids =="all"){							 
							$productId =  $unit_ids.'||'.$productIds[1].'||'.$productIds[2] ;
						}
					}					
					
					$getcredits = Dap_ActionPoints::loadByActionAndValue($type, $productId);
					if(isset($getcredits) && count($getcredits) >0 ){
						/****If getcredits then do this**********/ 							
						$set_max_limit = $getcredits[0]->getMaxLimit();								
						$res_credits = $getcredits[0]->getCredits();
						$res_maxcredits = $getcredits[0]->getMaxCredits();	
						
						// If set_max_limit is no means no limit award credits
						if($set_max_limit =="no"){
							return $res_credits;				
						}else{							
							if ($res_maxcredits >= $res_credits ){
								return $res_credits;
							}else{
								logToFile("functions.php checkIfEligibleForCredits(): type=". $type." notEligible for credits  max credts is less" ,LOG_DEBUG_DAP); 
								return false;
							}
						}							
						 	
					}
									
				} else	{
					logToFile("functions.php checkIfEligibleForCredits(): type=". $type."  notEligible for credits , credits assign is 0 or not in action table",LOG_DEBUG_DAP); 
					return false;
									
				} 		 	
									 
			} 
	
		}else if($type == "login" || $type == "comments"  ||  $type == "surveymonkey" ||  $type == "thrive_quiz" || $type == "thriveovation"){
			logToFile("functions.php checkIfEligibleForCredits(): checking action in db",LOG_DEBUG_DAP); 	
			$getcredits = Dap_ActionPoints::loadByAction($type);

			if($type == "comments" ){
				 if(isset($getcredits) && count($getcredits) > 0){		
    				$res_val = $getcredits[0]->getValue();	
    				if($res_val != 'all'){		
    					$getcredits = Dap_ActionPoints::loadByActionAndValue("comments", $productId);
    				} 
			    }
			}			 
 
			if(isset($getcredits) && count($getcredits) > 0){			 
				logToFile("functions. php checkIfEligibleForCredits():  action ".$type."  credits are greater than 0",LOG_DEBUG_DAP); 	
				$res_credits = $getcredits[0]->getCredits();
				$res_maxcredits = $getcredits[0]->getMaxCredits();
				$set_max_limit = $getcredits[0]->getMaxLimit();
				// If set_max_limit is no means no limit award credits
				if($set_max_limit =="no"){
					return $res_credits;				
				}else{							
					if ($res_maxcredits >= $res_credits ){
						logToFile("functions.php checkIfEligibleForCredits(): action ".$type."  not reached max",LOG_DEBUG_DAP); 	
						return $res_credits;
					}else{	
						logToFile("functions.php checkIfProductInPoints():  action ".$type." notEligible for credits return false" ,LOG_DEBUG_DAP); 				
						return false;
					} 
				}
				
			}else{
				logToFile("functions.php checkIfProductInPoints():  action ".$type."  notEligible for credits , credits assign is 0 or not in action table",LOG_DEBUG_DAP); 
				return false;					 
			}
		
		}		
  	 
}
 
 
 
 /*add to  User Credits table function*/ 
 function addUserCredits($type, $productId="", $userId, $pageId, $page_url, $title=""){
	 
		$SELF_SERVICE_ENABLED = Dap_Config::get("SELF_SERVICE_ENABLED");
		 
		if($SELF_SERVICE_ENABLED =="N"){
			logToFile("functions.php addUserCredits():  action ".$type."  notEligible for credits SELF_SERVICE_ENABLED =".$SELF_SERVICE_ENABLED ,LOG_DEBUG_DAP); 			
			return false;
		}
		
		 logToFile("functions.php addUserCredits(): enter SELF_SERVICE_ENABLED= ".$SELF_SERVICE_ENABLED." and type=".$type ,LOG_DEBUG_DAP);
		 
		 if($pageId ==""){		 
			$pageId = 0;
		 }
		$date= date("Y-m-d H:i:s"); 
		$comment ="";
		$course_id ="";		
		$course_data ="";				
		$ipaddress = $_SERVER['REMOTE_ADDR'];
		/*****Get the country details*******/
		/*$country_details = getCountryByIP($ipaddress);
		$country = '';
		if(isset($country_details['country_name'])){
			$country = $country_details['country_name'];
		}*/
		$country = "-";
		if($type == "registration" || $type ==  "purchase" || $type == "recurring_credits" ){
			$getcredits = Dap_ActionPoints::loadByActionAndValue($type, $productId);
		}else if( $type == "page_visit" || $type == "social_share" ){
			$getcredits = Dap_ActionPoints::loadByActionAndValue($type, $pageId);
			$productId = 0;
		}else if($type == "login" ||  $type == "surveymonkey" ||  $type == "thrive_quiz" || $type=="thriveovation"){
			$getcredits = Dap_ActionPoints::loadByAction($type);
			$productId = 0;			 
		}else if(  $type == "course_completed" || $type == "module_completed" || $type == "unit_completed" || $type == "quiz_completed"  ){
			$getcredits = Dap_ActionPoints::loadByActionAndValue($type, $pageId);
			
			if(isset($getcredits) && count($getcredits) > 0){
			}else{   // If no data found then check for value 'all'
				if( $type ==  "module_completed"  ||  $type ==  "unit_completed"){
					
					$pageIdval ="";
					$pageIds =  explode('||', $pageId);		
					if( $type ==  "module_completed" ){						 			
						$pageIdval =   'all||'.$pageIds[1] ;
						$getcredits = Dap_ActionPoints::loadByActionAndValue($type, $pageIdval);
					}
					
					if( $type ==  "unit_completed" ){						 			
						$pageIdval =  'all||'.$pageIds[1].'||'.$pageIds[2] ; 
						$getcredits = Dap_ActionPoints::loadByActionAndValue($type, $pageIdval);
						if(isset($getcredits) && count($getcredits) > 0){
							
						}else{
							$pageIdval =  'all||all||'.$pageIds[2] ;							 
							$getcredits = Dap_ActionPoints::loadByActionAndValue($type, $pageIdval);
						}
					}
					
		  
					logToFile("functions.php addUserCredits(): row exist in db ".count($getcredits)." type=".$type ,LOG_DEBUG_DAP);			 								
				} 
			}
				
			
 
		}else if($type == "comments" || $type == "social_share" ){
			$getcreditsData = Dap_ActionPoints::loadByAction($type);
			$productId = 0;			
			if(isset($getcreditsData) && count($getcreditsData) > 0){
				$res_val = $getcreditsData[0]->getValue();			 
				if($res_val != 'all'){
					$getcredits = Dap_ActionPoints::loadByActionAndValue($type, $pageId);
				}else{
					$getcredits = $getcreditsData;
				}
			}
			 			
		}	
		 	 
		if(isset($getcredits) && count($getcredits) > 0){
			
			/****If getcredits then do this**********/ 					
				$res_credits = $getcredits[0]->getCredits();
				$res_maxcredits = $getcredits[0]->getMaxCredits();
				$duration = $getcredits[0]->getDuration();							
				$res_val = $getcredits[0]->getValue();				
				$set_max_limit = $getcredits[0]->getMaxLimit();
				
				$res_maxcreditsisgreater = false; 
				 // If set_max_limit is no it means no limit to  award credits
				 if($set_max_limit =="no"){
					  $res_maxcreditsisgreater = true;
					  $res_maxcredits = 999999;
				 }else{
					 if ($res_maxcredits >= $res_credits ){
						 $res_maxcreditsisgreater = true;
					 }
				 }
				 
				 logToFile("functions.php addUserCredits(): max limit set to =".$set_max_limit."  type=".$type ,LOG_DEBUG_DAP);
				 
				//check if max limit reached for user.	if yes, return false;	if no, return credits;
				if ($res_maxcreditsisgreater == true){
			
						$obj = new DAP_UserCreditsLimit(); 
						$value = $productId;
						 
						/******load user_credits_limit table*************/	
						if($type == "registration"){						
							$result =  DAP_UserCreditsLimit::loadByUserIdAndActionAndValue($userId, $type, $productId);
							$comment = "Points awarded for registration";							 
							
						}elseif($type == "login"){						 
							 $result = DAP_UserCreditsLimit::loadByUserIdAndActionAndValue($userId, "login", $productId) ;
							 $comment = "Points awarded for login.";
							 $value = $productId;
							 
						}elseif($type == "page_visit" || $type == "social_share" || $type == "comments" ){		
					 			 
							$result = DAP_UserCreditsLimit::loadByUserIdAndActionAndValue($userId, $type, $pageId);
							$comment = "Points awarded for page visit.";
							if($type == "comments"){
								$comment = "Points awarded for blog comment.";
							} 
							if($type == "social_share"){
								$comment = "Points awarded for social share.";
							} 
							$value = $pageId;
						 	 
						}else if($type == "purchase" || $type == "recurring_credits"){		
							$result =  DAP_UserCreditsLimit::loadByUserIdAndActionAndValue($userId, $type, $productId);
							if($type == "purchase"){
								$comment = "Points awarded for purchase.";
							}else{
								$comment = "Points awarded for recurring payment.";
							}
							 $value = $productId;
							
						}else if($type == "course_completed" || $type == "module_completed" || $type == "unit_completed" || $type == "quiz_completed" ){
							logToFile("functions. php addUserCredits():  new type=".$type  ,LOG_DEBUG_DAP);
							
							$course_id =$productId;		
							$course_data =$pageId;	
							if( $type == "quiz_completed" ){
								$course_id = "";		
								$course_data = "";	
							}
							
							$value =$title;
							$result = DAP_UserCreditsLimit::loadByUserIdAndActionAndValue($userId, $type, $pageId);
							if($type == "course_completed"){
								$comment = "Points awarded for course completion.";
							}
							if($type == "module_completed"){
								$comment = "Points awarded for module completion.";
							}
							if($type == "unit_completed"){
								$comment = "Points awarded for unit completion.";
							}
							if($type == "quiz_completed"){
								$comment = "Points awarded for quiz completion.";
							}					
					
						}else if( $type == "surveymonkey" || $type == "thrive_quiz" || $type == "thriveovation"){
							$result = DAP_UserCreditsLimit::loadByUserIdAndAction($userId, $type);
							$comment = "Points awarded for survey completion.";
							if($type == "thrive_quiz"){
								$comment = "Points awarded for quiz completion.";
							}else if($type == "thriveovation"){
								$comment = "Points awarded to user for leaving a review (Thrive Ovation)";	
							}
							$value = 0;
						} 
						
						$obj = new DAP_UserCreditsLimit(); 
						$obj->setUserId($userId);						
						$obj->setValue($value);
						$obj->setCreditsEarned( $res_credits ); 
						$obj->setTotalCredits( $res_credits ); 
						$obj->setComments( $comment ); 
						$obj->setStartCreditsDate( $date ); 
						$obj->setLastCreditsDate( $date ); 
						$obj->setAction($type); 
						 
						logToFile("functions.php addUserCredits():  type=".$type." and  pageid=".$pageId ,LOG_DEBUG_DAP);
						if( $type == "course_completed" || $type == "module_completed" || $type == "unit_completed" || $type == "quiz_completed" ){							 
							$obj->setValue($pageId);							 
						}
						
		
						$updatetable ="no";

						if(isset($result) && count($result)>0){
							 
							$earned_credits_in_duration = $result->getCreditsEarned(); 
							$total_credits = $result->getTotalCredits(); 							 
							$start_credits_date = $result->getStartCreditsDate(); 
							$last_credits_date = $result->getLastCreditsDate();						 
							$type = $result->getAction();	
							$id = $result->getId();	
										
							$date1 = new DateTime(date('Y-m-d', strtotime($start_credits_date)));
							$date2 = new DateTime(date('Y-m-d', strtotime($date)));
							$newdate = $date1->diff($date2)->days; 
							$days = $newdate + 1;
							//logToFile("functions.php addUserCredits():  earned_credits_in_duration=".$earned_credits_in_duration." and  max credits=".$res_maxcredits,LOG_DEBUG_DAP); 
							 
							/****Check if days are less or equal**********/							 
							if ($days <= $duration) {								
								//logToFile("functions.php addUserCredits(): duration=".$duration." and days=".$days,LOG_DEBUG_DAP);  
							
							//added for id credits is set to 0
							if($res_credits > 0){
									//check if the earned_credits_in_duration less  than maxcredits
									if ($earned_credits_in_duration < $res_maxcredits) {																	
										$earned_credits_total = $res_credits + $earned_credits_in_duration;	
										$added_credits = $res_maxcredits - $earned_credits_in_duration;
										
										logToFile("functions.php addUserCredits():  earned_credits_total=".$earned_credits_total." and  max res_maxcredits=".$res_maxcredits,LOG_DEBUG_DAP); 
										
										//check if the earned_credits_in_duration exceeds to the  max_credits , then set earned_credits_in_duration to max_credits
										if ($earned_credits_total <= $res_maxcredits) {
											$earned_credits_total = $res_credits + $earned_credits_in_duration;											
											$total_credits = $res_credits + $total_credits;
											 
										} else{
											$earned_credits_total = $res_maxcredits;											
											$total_credits = $added_credits + $total_credits;
											$res_credits = $added_credits;										
										}
																	
										$obj->setCreditsEarned( $earned_credits_total ); 
										$obj->setTotalCredits( $total_credits ); 
										$obj->setLastCreditsDate( $date ); 										 
										$updatetable ="yes";
										$obj->update();
										logToFile("functions.php addUserCredits(): user eligible to get credits , assign credits" ,LOG_DEBUG_DAP); 		
									}else{
										$updatetable ="no";
										logToFile("functions.php addUserCredits(): max credits is less , noteligible to get credits",LOG_DEBUG_DAP); 
										return false;	
									} 
							}else{
									//check if the earned_credits_in_duration less  than maxcredits
									if ($earned_credits_in_duration <= $res_maxcredits) {																	
										$earned_credits_total = $res_credits + $earned_credits_in_duration;	
										$added_credits = $res_maxcredits - $earned_credits_in_duration;
										//check if the earned_credits_in_duration exceeds to the  max_credits , then set earned_credits_in_duration to max_credits
										if ($earned_credits_total <= $res_maxcredits) {
											$earned_credits_total = $res_credits + $earned_credits_in_duration;											
											$total_credits = $res_credits + $total_credits;
											 
										} else{
											$earned_credits_total = $res_maxcredits;											
											$total_credits = $added_credits + $total_credits;
											$res_credits = $added_credits;										
										}
																	
										$obj->setCreditsEarned( $earned_credits_total ); 
										$obj->setTotalCredits( $total_credits ); 
										$obj->setLastCreditsDate( $date ); 										 
										$updatetable ="yes";
										$obj->update();
										logToFile("functions.php addUserCredits(): user eligible to get credits , assign credits" ,LOG_DEBUG_DAP); 		
									}else{
										$updatetable ="no";
										logToFile("functions.php addUserCredits(): max credits is less , noteligible to get credits",LOG_DEBUG_DAP); 
										return false;	
									}
								}
							
								
							} else {
									logToFile("functions.php addUserCredits(): user eligible to get credits , assign credits" ,LOG_DEBUG_DAP); 	
									$updatetable ="yes";
									$total_credits = $res_credits + $total_credits;
									$obj->setCreditsEarned( $res_credits ); 
									$obj->setTotalCredits( $total_credits ); 
									$obj->setStartCreditsDate( $date );  
									$obj->setLastCreditsDate( $date );  
									$obj->update();  
							}
							
						}else{ 
							logToFile("functions.php addUserCredits(): user eligible to get credits , assign credits " ,LOG_DEBUG_DAP); 
							$updatetable ="yes";														
							$obj->create();
						}
						
						if($updatetable ==	"yes"){							
						 
							 // create history 
							$history_data = array(
									'user_id'=>$userId,
									'action'=>$type,
									'credit_earned'=>$res_credits,
									'credit_spent'=>'0',
									'ip'=>$ipaddress,
									'country'=>$country,
									'page_id'=>$productId,
									'product_id'=>$pageId,
									'value'=>$value,
									'comments'=>$comment,
									'course_id'=>$course_id,
									'course_data'=>$course_data,
							);										
							createCreditHistory($history_data);	
							
							//Added for when credits is 0, only send email if credits >0
							if($res_credits > 0){
								// Send Email Notification	
								if($type == "registration" || $type == "purchase" || $type == "recurring_credits"){						
									sendEmailNotification($type, $pageId, $userId, $credit_earnd, $page_url, $productId, $title);
									
								}elseif($type == "login" || $type == "page_visit" || $type == "course_completed" || $type == "module_completed" || $type == "unit_completed" || 
								$type == "quiz_completed" || $type == "comments" || $type == "social_share" ||  $type == "surveymonkey" ||  $type == "thrive_quiz" || $type == "thriveovation"){						 
									sendEmailNotification($type, $pageId, $userId, $res_credits, $page_url,'', $title);																
								}
								
								//update user credits in dap_user table
								if($type == "registration" || $type == "login" || $type == "purchase" || $type == "recurring_credits" || $type == "page_visit" || $type == "comments" 
								|| $type == "social_share" || $type == "course_completed" || $type == "module_completed" || $type == "unit_completed" || $type == "quiz_completed" ||
								 $type == "surveymonkey" ||  $type == "thrive_quiz" || $type == "thriveovation"){	
									$user = Dap_User::loadUserById($userId);
									if (isset($user)) {
										$creditsAvailable = $user->getCredits_available();
										logToFile("functions.php addUserCredits(): creditsAvailable=".$creditsAvailable." set in dap_user" ,LOG_DEBUG_DAP); 
										$creditsAvailableUpdated = $creditsAvailable + $res_credits;									 
										$user->setCredits_available($creditsAvailableUpdated);
										$user->update(); 									
									}
									logToFile("functions.php addUserCredits() calling dapAssignUserBadges() to assign badge to user if eligible " );	
									dapAssignUserBadges($userId);	
								} 
								
							}
							return true;				 
						}else{
							logToFile("functions.php addUserCredits(): noteligible to get credits",LOG_DEBUG_DAP); 
							return false;							
						}	
				 }else{
					 logToFile("functions.php addUserCredits(): noteligible to get credits max credits is less ",LOG_DEBUG_DAP); 
					 return false;	
				 }	 			
		 }else{
			 logToFile("functions.php addUserCredits(): noteligible to get credits",LOG_DEBUG_DAP); 
			 return false;	
		 }	
		  
 }
  
 

function createCreditHistory($data = ''){	
	$date= date("Y-m-d H:i:s"); 
	$user_id = '';
	$action = '';
	$credit_earned = '';
	$credit_spent = '';
	$ip = '';
	$country = '';
	$page_id = '';
	$product_id = '';
	$value = '';
	$comments = '';
	$course_id = '';
	$course_data = '';
	$ip = '';
	if(is_array($data)){
		
		if(isset($data['user_id'])){ $user_id = $data['user_id'];}
		if(isset($data['action'])){ $action = $data['action'];}
		if(isset($data['credit_earned'])){ $credit_earned = $data['credit_earned'];}
		if(isset($data['credit_spent'])){ $credit_spent = $data['credit_spent'];}
		if(isset($data['ip'])){ $ip = $data['ip'];}
		if(isset($data['country'])){ $country = $data['country'];}
		if(isset($data['page_id'])){ $page_id = $data['page_id'];}
		if(isset($data['product_id'])){ $product_id = $data['product_id'];}
		if(isset($data['value'])){ $value = $data['value'];}
		if(isset($data['comments'])){ $comments = $data['comments'];}
		if(isset($data['course_id'])){ $course_id = $data['course_id'];}
		if(isset($data['course_data'])){ $course_data = $data['course_data'];}
	}
 
	if($_SESSION['cs_pageid'] ==""){
	  $_SESSION['cs_pageid'] = 0;
	}
	
	if($page_id =="" || $page_id ==0){
		$page_id = $_SESSION['cs_pageid'];
	}
	logToFile("functions.php createCreditHistory(): type=".$action." course_id=".$course_id."course_data= ".$course_data ,LOG_DEBUG_DAP); 
	if(  $action == "course_completed" || $action == "module_completed" || $action == "unit_completed" || $action == "quiz_completed" ){
		$product_id= $page_id;							 
	}	
	
	$credit_history_obj = new DAP_CreditsHistory();
	$credit_history_obj->setUserId($user_id);
	$credit_history_obj->setAction($action);
	$credit_history_obj->setCreditsEarned($credit_earned);
	$credit_history_obj->setCreditsSpent($credit_spent);
	$credit_history_obj->setIp($ip);
	$credit_history_obj->setCountry($country);
	$credit_history_obj->setPageId($page_id);
	$credit_history_obj->setProductId($product_id);
	$credit_history_obj->setValue($value);
	$credit_history_obj->setCourseId($course_id);
	$credit_history_obj->setCourseData($course_data);
	$credit_history_obj->setComments($comments);
	$credit_history_obj->setTimeStamp($date);
	$credit_history_obj->create();
	
	logToFile("functions.php createCreditHistory() : insert  in credits_history table" ); 
 	
}

/****** function to Send user email notification********/
function sendEmailNotification($type, $pageId, $userId, $credit_earnd, $page_url, $product_id, $title){
	
	$SELF_SERVICE_ENABLED = Dap_Config::get("SELF_SERVICE_ENABLED");
	//logToFile("functions. php sendEmailNotification(): enter type".$type ,LOG_DEBUG_DAP);
	if($SELF_SERVICE_ENABLED =="N"){			
		return false;
	}
	
	$user = Dap_User::loadUserById($userId);
	if($user == NULL){
		return 'user not exist';
	}	
	
	$user_email = $user->getEmail();	
	$cs_email_obj_data = DAP_CreditsNotification::loadByActionAndStatus($type); 
	 
	if($cs_email_obj_data){
		$status = $cs_email_obj_data->getStatus();
		 logToFile("functions.php sendEmailNotification():  status".$status,LOG_DEBUG_DAP); 
		if($status == '1'){
			$subject = $cs_email_obj_data->getSubject();
			$bodyText = $cs_email_obj_data->getBody();
			  
			$fromName = '';
			$fromEmail = '';
			$email_obj = DAP_EmailSetting::loadById(1);
			if($email_obj){
				$fromName = $email_obj->getName();
				$fromEmail = $email_obj->getEmail();
				
			}
			
			if(isset($title) && $title != ""){
				
				if($type == "course_completed" ){
					
					$page_titles = explode('||', $title);					
					if(isset($page_titles)){						
						if(isset($page_titles[0])){
							$coursetitle = $page_titles[0];
						} 
					}
					$bodyText = str_replace("%%WPCOURSEWARE_COURSE_NAME%%", $coursetitle, $bodyText); 
					$subject = str_replace("%%WPCOURSEWARE_COURSE_NAME%%", $coursetitle, $subject); 						
					
				}else if($type == "module_completed" || $type == "unit_completed" || $type == "quiz_completed"){
					$page_titles = explode('||', $title);					 
					if($type == "module_completed" ){
						
						if(isset($page_titles)){
							 	
							if(isset($page_titles[0])){
								$moduletitle = $page_titles[0];
							} 
							if(isset($page_titles[1])){
								$coursetitle = $page_titles[1];
							} 	
						}
				
						$bodyText = str_replace("%%WPCOURSEWARE_MODULE_NAME%%",$moduletitle, $bodyText); 
						$subject = str_replace("%%WPCOURSEWARE_MODULE_NAME%%",$moduletitle, $subject); 						
						$bodyText = str_replace("%%WPCOURSEWARE_COURSE_NAME%%", $coursetitle, $bodyText); 
						$subject = str_replace("%%WPCOURSEWARE_COURSE_NAME%%", $coursetitle, $subject); 
						
					}
					
					if($type == "unit_completed" ){
						
						if(isset($page_titles)){						 
							if(isset($page_titles[0])){
								$unittitle = $page_titles[0];
							} 				 		
							if(isset($page_titles[1])){
								$moduletitle = $page_titles[1];
							} 
							if(isset($page_titles[2])){
								$coursetitle = $page_titles[2];
							} 		
						}
						$bodyText = str_replace("%%WPCOURSEWARE_UNIT_NAME%%", $unittitle, $bodyText); 
						$subject = str_replace("%%WPCOURSEWARE_UNIT_NAME%%", $unittitle, $subject); 
						$bodyText = str_replace("%%WPCOURSEWARE_MODULE_NAME%%",$moduletitle, $bodyText); 
						$subject = str_replace("%%WPCOURSEWARE_MODULE_NAME%%",$moduletitle, $subject); 						
						$bodyText = str_replace("%%WPCOURSEWARE_COURSE_NAME%%", $coursetitle, $bodyText); 
						$subject = str_replace("%%WPCOURSEWARE_COURSE_NAME%%", $coursetitle, $subject); 
					}
					
					if($type == "quiz_completed" ){						
						if(isset($page_titles)){							 
							if(isset($page_titles[0])){
								$quiztitle = $page_titles[0];
							} 													
							if(isset($page_titles[1])){
								$unittitle = $page_titles[1];
							} 				 		
							if(isset($page_titles[2])){
								$moduletitle = $page_titles[2];
							} 
							if(isset($page_titles[3])){
								$coursetitle = $page_titles[3];
							} 			
						}				
						$bodyText = str_replace("%%WPCOURSEWARE_QUIZ_NAME%%", $quiztitle, $bodyText); 
						$subject = str_replace("%%WPCOURSEWARE_QUIZ_NAME%%", $quiztitle, $subject); 
						$bodyText = str_replace("%%WPCOURSEWARE_UNIT_NAME%%", $unittitle, $bodyText); 
						$subject = str_replace("%%WPCOURSEWARE_UNIT_NAME%%", $unittitle, $subject); 
						$bodyText = str_replace("%%WPCOURSEWARE_MODULE_NAME%%",$moduletitle, $bodyText); 
						$subject = str_replace("%%WPCOURSEWARE_MODULE_NAME%%",$moduletitle, $subject); 						
						$bodyText = str_replace("%%WPCOURSEWARE_COURSE_NAME%%", $coursetitle, $bodyText); 
						$subject = str_replace("%%WPCOURSEWARE_COURSE_NAME%%", $coursetitle, $subject); 
					}
				}else{
					$bodyText = str_replace("%%WPCOURSEWARE_QUIZ_NAME%%", "", $bodyText); 
					$bodyText = str_replace("%%WPCOURSEWARE_UNIT_NAME%%", "", $bodyText); 
					$bodyText = str_replace("%%WPCOURSEWARE_MODULE_NAME%%", "", $bodyText); 
					$bodyText = str_replace("%%WPCOURSEWARE_COURSE_NAME%%", "", $bodyText); 
					
					$subject = str_replace("%%WPCOURSEWARE_QUIZ_NAME%%", "", $subject); 
					$subject = str_replace("%%WPCOURSEWARE_UNIT_NAME%%", "", $subject); 
					$subject = str_replace("%%WPCOURSEWARE_MODULE_NAME%%", "", $subject); 
					$subject = str_replace("%%WPCOURSEWARE_COURSE_NAME%%", "", $subject); 
					
					
				}
				 
				
			}else{
				$bodyText = str_replace("%%WPCOURSEWARE_QUIZ_NAME%%", "", $bodyText); 
				$bodyText = str_replace("%%WPCOURSEWARE_UNIT_NAME%%", "", $bodyText); 
				$bodyText = str_replace("%%WPCOURSEWARE_MODULE_NAME%%", "", $bodyText); 
				$bodyText = str_replace("%%WPCOURSEWARE_COURSE_NAME%%", "", $bodyText); 
				
				$subject = str_replace("%%WPCOURSEWARE_QUIZ_NAME%%", "", $subject); 
				$subject = str_replace("%%WPCOURSEWARE_UNIT_NAME%%", "", $subject); 
				$subject = str_replace("%%WPCOURSEWARE_MODULE_NAME%%", "", $subject); 
				$subject = str_replace("%%WPCOURSEWARE_COURSE_NAME%%", "", $subject); 
			}
			
			
	 
			$bodyText = str_replace("%%CREDITS_EARNED%%", $credit_earnd, $bodyText);
			$bodyText = str_replace("%%PAGE_URL%%", $_SESSION['cs_current_url'], $bodyText);
			$subject = str_replace("%%PAGE_URL%%", $_SESSION['cs_current_url'], $subject);
			
			if($type == 'login'){
				$bodyText = str_replace("%%LOGIN_URL%%", $_SESSION['cs_current_url'], $bodyText);	
				$subject = str_replace("%%LOGIN_URL%%", $_SESSION['cs_current_url'], $subject);	
			}else if($type == 'registration' || $type == 'purchase' || $type == 'recurring_credits' ){
	 
				$product_obj = DAP_Product::loadProduct($product_id); 
				$product_name = $product_obj->getName();
				$bodyText = str_replace("%%REGISTRATION_URL%%", $_SESSION['cs_current_url'], $bodyText);
				$bodyText = str_replace("%%PRODUCT_NAME%%", $product_name, $bodyText);
				
				$subject = str_replace("%%REGISTRATION_URL%%", $_SESSION['cs_current_url'], $subject);
				$subject = str_replace("%%PRODUCT_NAME%%", $product_name, $subject);
	 
			}else if($type == 'page_visit'){
				 
				$bodyText = str_replace("%%PAGE_URL%%", $page_url, $bodyText);
				$subject = str_replace("%%PAGE_URL%%", $page_url, $subject);
			}else if($type == 'comments'){
				$bodyText = str_replace("%%PAGE_URL%%", $page_url, $bodyText);
				$subject = str_replace("%%PAGE_URL%%", $page_url, $subject);
				
			}else if($type == 'social_share'){
				$bodyText = str_replace("%%PAGE_URL%%", $page_url, $bodyText);
				$subject = str_replace("%%PAGE_URL%%", $page_url, $subject);
			}else if($type == 'redeemed_product' || $type == 'redeemed_resource'){
				
				$user_email = $user->getEmail();
				$user_password = $user->getPassword();
				
	            $product_obj = DAP_Product::loadProduct($product_id); 
				$product_name = $product_obj->getName();
				
				$credit_spent = $credit_earnd;
				
				$subject = str_replace("%%PRODUCT_NAME%%", $product_name, $subject);
				$subject = str_replace("%%EMAIL%%", $user_email, $subject);
				$subject = str_replace("%%CREDITS_SPENT%%", $credit_spent, $subject);
				$subject = str_replace("%%PASSWORD%%", $user_password, $subject);
		
		
				$bodyText = str_replace("%%PRODUCT_NAME%%", $product_name, $bodyText);
				$bodyText = str_replace("%%EMAIL%%", $user_email, $bodyText);
				$bodyText = str_replace("%%CREDITS_SPENT%%", $credit_spent, $bodyText);
				$bodyText = str_replace("%%PASSWORD%%", $user_password, $bodyText);
				
				   if($type == 'redeemed_resource'){
					   
				   }else if($type == 'redeemed_resource'){
					   
					   $name = array();
					   $url = array();
					   $resources_ids_array = $pageId;
					   if(is_array($resources_ids_array)){
							foreach($resources_ids_array as $resourceId){
								$UserResources = Dap_FileResource::loadResourceSSS($user_id, $product_id, $resourceId);
								foreach($UserResources as $UserResource){
									$credits_assigned = $UserResource['credits_assigned'];
									$url[]  = $UserResource['url'];
									$name[] = $UserResource['name'];
								}
							}
						}
						$subject = str_replace("%%RESOURCE_NAME%%", implode(", ",$name), $subject);
						$subject = str_replace("%%RESOURCE_URL%%", implode(", ",$url), $subject);
						$subject = str_replace("%%CONTENT_URL%%", implode(", ",$url), $subject);
				
						$bodyText = str_replace("%%RESOURCE_NAME%%", implode(", ",$name), $bodyText);
						$bodyText = str_replace("%%RESOURCE_URL%%", implode(", ",$url), $bodyText);
						$bodyText = str_replace("%%CONTENT_URL%%", implode(", ",$url), $bodyText);
					   
				   }
			}
			
			logToFile("functions.php sendEmailWithFromVariable():call ",LOG_DEBUG_DAP); 
			sendEmailWithFromVariable($user_email, $subject, $bodyText, $fromName, $fromEmail);
			logToFile("functions.php sendEmailNotification(): email sent",LOG_DEBUG_DAP); 
			return 'Mail send';
		}
	}
	 
}

function checkForRegisterAndPurchaseAndRecurring($cs_first_payment, $productId,$userId, $getIs_free_product, $getAllow_free_signup, $double_optin_sub,$double_optin_body,
$recurr_prod,$recurring ){
	$givePoints = 0;
	$type ="";
	$_SESSION['daploginform']="";
	unset($_SESSION['daploginform']);
	
	if($cs_first_payment == true){ 
			
			if($getAllow_free_signup == "Y") {
				if( ($double_optin_sub == "") && ($pdouble_optin_body == "") ) {
					if ($recurring == "N") {
						logToFile("Dap_UsersProducts.addUsersProducts(): SSS: recurring=".$recurring . ", doubltoptin=N, free signup=Y, addign firsttime allow",LOG_DEBUG_DAP); 
						$type ="registration";											
						/******If action is register ********/			
 			
						$givePoints = checkIfEligibleForCredits($type, $productId,$userId); 															 
			 
					}else {
						logToFile("functions.php: checkForRegisterAndPurchaseAndRecurring(): re-registring for same free product. Dont give credits doubltoptin=Y, free signup=Y",LOG_DEBUG_DAP); 
					}
				}else {
					logToFile("functions.php: checkForRegisterAndPurchaseAndRecurring(): SSS: DOUBLE OPTIN, free product: credits will be assigned during activation",LOG_DEBUG_DAP); 
				}
			}else{	
			
				if(strtolower($getIs_free_product) == "n") {
					$type ="purchase";
					$givePoints = checkIfEligibleForCredits($type, $productId,$userId); 
				}else{
					if($getAllow_free_signup != "Y") {						
						$type ="purchase";
						$givePoints = checkIfEligibleForCredits($type, $productId,$userId); 	
					}
				}
			}
					
		}else{//product already there
			if(strtolower($recurr_prod) == "y") {
				$type ="recurring_credits";
				$givePoints = checkIfEligibleForCredits($type, $productId,$userId); 
			}				  
		}		 		 
	 
		return $givePoints."||".$type;
}



function checkCSCookieForCommentAndShareAndPageVisit($userId){
	logToFile("functions.php checkCSCookieForCommentAndShareAndPageVisit(): COOKIE ".$_COOKIE['csvisits'],LOG_DEBUG_DAP); 
	if(isset($_COOKIE['cscomment'])){
		$cookieNames = explode('|' , $_COOKIE['cscomment']);
		$dontRemove = 'no';
		foreach($cookieNames as $names){
			if(isset($_COOKIE[$names])){
				$userDetails = explode('|' , $_COOKIE[$names]);				
				$data = explode('_' , $names);

				foreach($userDetails as $details){
					$detailsData = explode('::', $details);
				//	$userId = $detailsData[0];
					 
					if(isset($detailsData[2]) && $detailsData[2] != ''){
						if (file_exists($detailsData[2]."/wp-load.php")){
							//logToFile("functions.php checkCSCookieForCommentAndShareAndPageVisit(): include wp-load",LOG_DEBUG_DAP);
							require_once($detailsData[2]."/wp-load.php" );
						}
					
						//$commentStatus = checkIfCommentApproved($detailsData[1]);
						$commentStatus = 0;
						if(isset($detailsData[1])){
							logToFile("functions.php checkCSCookieForCommentAndShareAndPageVisit(): comment id ".$detailsData[1] ,LOG_DEBUG_DAP);
							$commentDetails = get_comment($detailsData[1]);	
							$commentStatus = $commentDetails->comment_approved;  		 
						}						
						
						if($commentStatus == 1){
							//logToFile("functions.php checkCSCookieForCommentAndShareAndPageVisit(): comment status ".$commentStatus ,LOG_DEBUG_DAP);
							setcookie($names, "", time() - 3600, "/");
							$_SESSION['cs_pageid'] = $data[1];
							$givePoint = checkIfEligibleForCredits("comments",$data[1],$userId); 
							
							if(isset($givePoint) && $givePoint >= 0){			
								//add to  User Credits table function 
								addUserCredits("comments", "", $userId, $data[1], "","");	
							} 
						}else{
							$dontRemove = 'yes';
						}
					}
				}
			}
		}
		if($dontRemove == 'no'){
			setcookie('cscomment', "", time() - 3600, "/");
		}
		
	}
	/******If action is facebook share********/	
	if(isset($_COOKIE['csshare']) && isset($_COOKIE['csshare_page_id'])){
		$csshare_page_ids = explode('|' , $_COOKIE['csshare_page_id']);
		foreach($csshare_page_ids as $page_id){
					
			$givePoint = checkIfEligibleForCredits("social_share",$page_id,$userId); 
			if(isset($givePoint) && $givePoint >= 0){			
				//add to  User Credits table function 
				//addUserCredits("social_share", $data[0], $user_id, "", "");	
				addUserCredits("social_share", '', $userId, $page_id, "","");	
			} 
		}		
		
		setcookie('csshare', "",time()-3600,"/"); 
		setcookie('csshare_page_id', "", time()-3600,"/");
		

	}  
	/******If action is page visits ********/	
	if(isset($_COOKIE['csvisits'])){
		$cookieNames = explode('|' , $_COOKIE['csvisits']);
		foreach($cookieNames as $names){			 
				$pageId = $names;
				logToFile("functions.php checkCSCookieForCommentAndShareAndPageVisit(): names".$names,LOG_DEBUG_DAP); 
				if($names !="" || $names != 0  || $names != null){
					$givePoint = checkIfEligibleForCredits("page_visit",$pageId,$userId); 
					if(isset($givePoint) && $givePoint >= 0){		
						//add to  User Credits table function 
						addUserCredits("page_visit", "", $userId, $pageId, "", "");	
					} 
				} 			 
		}
	  
		setcookie($_COOKIE['csvisits'], "",time()-3600,"/"); 
		setcookie('csvisits', "",  time()-3600,"/");
	}
	
	/******If action is login ********/			
		logToFile("functions.php cs login".$_SESSION['daploginform'] );			
		if(isset($_SESSION['daploginform']) && $_SESSION['daploginform'] =="yes"){
			$givePoint = checkIfEligibleForCredits("login", "",$userId); 
			if(isset($givePoint) && $givePoint >= 0){					
				//add to  User Credits table function 
				addUserCredits("login", "", $userId, "", "","");
				$_SESSION['daploginform'] ="";	
				unset($_SESSION['daploginform']);			
			} 
		}
		 	
}
 
 
function dapAssignUserBadges($userID){
	
	logToFile("functions.php dapAssignUserBadges() entered" );			
	    
	$spc_blog_path = trim(Dap_Config::get('SPC_BLOG_PATH'));
	
	$lldocroot = defined('SITEROOT') ? SITEROOT : $_SERVER['DOCUMENT_ROOT'];
	
	logToFile("functions.php dapAssignUserBadges() spc_blog_path ". $spc_blog_path );	

	if($spc_blog_path != ""){
		
		$path = $lldocroot."/".$spc_blog_path."/wp-load.php";
		logToFile("functions.php dapAssignUserBadges() path is blog ". $path );	
		if (file_exists($path)){	
			include_once($path);
		}else{
			return;	
		}
	}else{ 
		logToFile("functions.php dapAssignUserBadges() else path");	
	    //if (!isset( $blog_paths )) return;
	    $path = $lldocroot . "/wp-load.php";
		logToFile("functions.php dapAssignUserBadges() path is". $path );	
		if (file_exists($path)){
			logToFile("functions.php dapAssignUserBadges() file exists include");	
			include_once($path);
		}else{
			logToFile("functions.php dapAssignUserBadges() no file exists return");	
			return;	
		}
	}
	
	logToFile("functions.php dapAssignUserBadges() getting all active badges" );			
	
	$allBadges = GOP_Badge_Achievement::loadActiveBadges();
	
	if($allBadges != false && count($allBadges) > 0){
		logToFile("functions.php dapAssignUserBadges() got active badges" );
		foreach($allBadges as $badges){
			
			$selected_activities = $badges->getActivities();
			
		//	$selected_activities .= '|aff_refferal';
//			$selected_activities .= '|aff_referral';

			$categoriesArray = explode('|' , $selected_activities);
			$userDataArrayAff = 0;
			if(in_array('aff_refferal' , $categoriesArray)){
				$key = array_search ('aff_refferal', $categoriesArray);
				$categoriesArray[$key] = 'aff_referral';
				
			}

			$categories = implode("','" , $categoriesArray);

			$userDataArray = DAP_CreditsHistory::loadByActionTypeAndStartDateAndEndDate($categories,'','', $limit, '' , $userID);	
			
			$dapUserBadge = DAP_UsersBadges::loadByUserIdAndBadgeId($userID, $badges->getId());
			
			if(count($dapUserBadge) <= 0){
				$finalCredits = $userDataArray[0]->getCreditsEarned();
				if($finalCredits >= $badges->getCriteriaVal()){
					logToFile("functions.php dapAssignUserBadges() user is eligible for badge " . $badges->getBadgeName() );
					$assignBadge = new DAP_UsersBadges();
					$assignBadge->setUserId($userID);
					$assignBadge->setBadgeId($badges->getId());
					
					$assignBadge->create();
				}else{
					logToFile("functions.php dapAssignUserBadges() user is not eligible for badge " . $badges->getBadgeName() );	
				} 
			}else{
				logToFile("functions.php dapAssignUserBadges() user already have this badge " . $badges->getBadgeName() );		
			}
		}
	}
} 

/***common send email for stripe***/

function dapStripePaymentFailedEmail($product_details , $email, $email_type, $reason, $next_payment_attempt = ''){
	$prod_id = $product_details->getId();	
	$user_detail =  Dap_User::loadUserByEmail($email);
	logToFile("functions.php : dapStripePaymentFailedEmail() enter", LOG_DEBUG_DAP);
	$failedSetting = DAP_FailedPaymentSettings::loadByPaymentProcessorAndType("STRIPE", $email_type);
	logToFile("functions.php : dapStripePaymentFailedEmail() got result", LOG_DEBUG_DAP);
	$shouldSendEmail = $failedSetting->getSendEmail();
	$sentEmail="no";
	$action="No Action";
		
	if($shouldSendEmail == "yes") {
		try {
			logToFile("functions.php : dapStripePaymentFailedEmail() should send email", LOG_DEBUG_DAP);
				$result = sendFailedPaymentEmail($failedSetting, $user_detail, $prod_id, "STRIPE", $next_payment_attempt);
				logToFile("functions.php : dapStripePaymentFailedEmail() should send email", LOG_DEBUG_DAP);
				if($result=="") 
					$sentEmail="yes";
			}
		catch(Exception $e){
				logToFile("functions.php : dapStripePaymentFailedEmail() error " . $e->getMessage(), LOG_DEBUG_DAP);
				$sentEmail="no";
			
		}
	}	
		
		if(isset($user_detail)){
			$userId = $user_detail->getId();	
		}
		
		if($sentEmail == "yes") {
			$action="Email Sent";
		}
		$failedPayments = new DAP_UsersProductsFailedPayments();
		$failedPayments->setUserId($userId);
		$failedPayments->setProductId($prod_id);
		$failedPayments->setPaymentProcessor("STRIPE");
		$failedPayments->setTransactionType($email_type);
		$failedPayments->setReason($reason);
		$failedPayments->setAction($action); 
		$failedPayments->setTransactionDate(date("Y-M-D h:i:s"));
		$failedPayments->create();
		logToFile("functions.php : dapStripePaymentFailedEmail() added to failed", LOG_DEBUG_DAP);
		
		
	
	
}

/***common send email for stripe end***/


/***common send email for authnet***/


function dapAuthnetPaymentFailedEmail($product_details , $email, $email_type, $reason){
	$prod_id = $product_details->getId();	
	$user_detail =  Dap_User::loadUserByEmail($email);
	logToFile("functions.php : dapAuthnetPaymentFailedEmail() enter", LOG_DEBUG_DAP);
	$failedSetting = DAP_FailedPaymentSettings::loadByPaymentProcessorAndType("AUTHNET", $email_type);
	logToFile("functions.php : dapAuthnetPaymentFailedEmail() got result", LOG_DEBUG_DAP);
	if(isset($failedSetting)){
		$shouldSendEmail = $failedSetting->getSendEmail();
		$sentEmail="no";
		$action="No Action";
		
		if($shouldSendEmail == "yes") {
			try {
				logToFile("functions.php : dapAuthnetPaymentFailedEmail() should send email", LOG_DEBUG_DAP);
					$result = sendFailedPaymentEmail($failedSetting, $user_detail, $prod_id, "AUTHNET");
					logToFile("functions.php : dapAuthnetPaymentFailedEmail() should send email", LOG_DEBUG_DAP);
					if($result=="") 
						$sentEmail="yes";
				}
			catch(Exception $e){
					logToFile("functions.php : dapAuthnetPaymentFailedEmail() error " . $e->getMessage(), LOG_DEBUG_DAP);
					$sentEmail="no";
				
			}
		}	
			
			if(isset($user_detail)){
				$userId = $user_detail->getId();	
			}
			
			if($sentEmail == "yes") {
				$action="Email Sent";
			}	
				$failedPayments = new DAP_UsersProductsFailedPayments();
				$failedPayments->setUserId($userId);
				$failedPayments->setProductId($prod_id);
				$failedPayments->setPaymentProcessor("AUTHNET");
				$failedPayments->setTransactionType($email_type);
				$failedPayments->setReason($reason);
				$failedPayments->setAction($action); 
				$failedPayments->setTransactionDate(date("Y-M-D h:i:s"));
				$failedPayments->create();
				logToFile("functions.php : dapAuthnetPaymentFailedEmail() added to failed", LOG_DEBUG_DAP);
			
	}	
	
}

/***common send email for authnet end***/



function dapGetProgressBarShortcodeById($id = 0){

	return "[DAPCourseProgressBar id=".$id."][/DAPCourseProgressBar]";

}
 

/****** function to Send user email notification********/
function sendEmailNotificationCourseCompleted($type, $userId, $product_id, $unit_name, $module_name ){	
		 
	$user = Dap_User::loadUserById($userId);
	if(!isset($user)){
		return 'user not exist';
	}	
	
	$user_email = $user->getEmail();	
	$fname = $user->getFirst_name();	
	$lname = $user->getLast_name();	
	$name = $fname." ".$lname;	
	$product_obj = DAP_Product::loadProduct($product_id); 
	$product_name = $product_obj->getName();
	$course_email_subject = $product_obj->getCourseEmailSubject();
	$course_email_body = $product_obj->getCourseEmailBody();
	$module_email_subject = $product_obj->getModuleEmailSubject();
	$module_email_body = $product_obj->getModuleEmailBody();
	$lesson_email_subject = $product_obj->getLessonEmailSubject();
	$lesson_email_body = $product_obj->getLessonEmailBody();
	$site_name_dap = Dap_Config::get("SITE_NAME");
	$site_url_dap = Dap_Config::get("SITE_URL_DAP");
		
		
	if($type=="lesson")	{
		if($course_email_subject ==""){
			return 'lesson subject is missing';
		}
		$subject = $lesson_email_subject;
		$bodyText = $lesson_email_body;		
		$subject = str_replace("%%LESSON_TITLE%%",$unit_name, $subject);		
		$bodyText = str_replace("%%LESSON_TITLE%%",$unit_name, $bodyText); 
		$bodyText = str_replace("%%MODULE_TITLE%%",$module_name, $bodyText);	
		$bodyText = str_replace("%%COURSE_TITLE%%",$product_name, $bodyText);	
		$bodyText = str_replace("%%FIRST_NAME%%", $fname, $bodyText); 	 
		$bodyText = str_replace("%%LAST_NAME%%", $lname, $bodyText); 	
		$message = str_replace("%%SITE_NAME%%", $site_name_dap, $message);
		$message = str_replace("%%SITE_URL_DAP%%", $site_url_dap, $message); 
	}	
	
	if($type=="module")	{
		if($module_email_subject ==""){
			return 'module subject is missing';
		}
		$subject = $module_email_subject;
		$bodyText = $module_email_body;
		$subject = str_replace("%%MODULE_TITLE%%",$unit_name, $subject); 		 
		$bodyText = str_replace("%%MODULE_TITLE%%",$module_name, $bodyText);	
		$bodyText = str_replace("%%FIRST_NAME%%", $fname, $bodyText); 	 
		$bodyText = str_replace("%%LAST_NAME%%", $lname, $bodyText); 
		$bodyText = str_replace("%%COURSE_TITLE%%",$product_name, $bodyText);	
		$message = str_replace("%%SITE_NAME%%", $site_name_dap, $message);
		$message = str_replace("%%SITE_URL_DAP%%", $site_url_dap, $message); 
	}
			
	if($type=="course")	{
		if($course_email_subject ==""){
			return 'course subject is missing';
		}
		$subject = $course_email_subject;
		$bodyText = $course_email_body;
		$subject = str_replace("%%COURSE_TITLE%%",$unit_name, $subject); 
		$bodyText = str_replace("%%COURSE_TITLE%%",$product_name, $bodyText); 	
		$bodyText = str_replace("%%FIRST_NAME%%", $fname, $bodyText); 	 
		$bodyText = str_replace("%%LAST_NAME%%", $lname, $bodyText); 
		$message = str_replace("%%SITE_NAME%%", $site_name_dap, $message);
		$message = str_replace("%%SITE_URL_DAP%%", $site_url_dap, $message);	 
	}	 
	 
	sendEmail($user_email, $subject, $bodyText, "", "");
	logToFile("functions.php sendEmailNotificationCourseCompleted(): email sent",LOG_DEBUG_DAP); 
	return 'Mail send';
		 
	 
}  
