<?php 

//get groups from mailerlite
function DAPgetMailerLite(){
	
	$api_key = Dap_ExternalConnections::loadKeys('mailerlite' , 'mailerlite_api_key'); 
	
	if(isset($api_key)){
		$api_key = $api_key->getApi_key();
		
		$api = "http://api.mailerlite.com/api/v2/groups?apikey=$api_key";
		$request = curl_init($api); 
		curl_setopt($request, CURLOPT_HEADER, 0); 
		curl_setopt($request, CURLOPT_RETURNTRANSFER, 1); 
		curl_setopt($request, CURLOPT_FOLLOWLOCATION, true);
		$response = (string)curl_exec($request);
		curl_close($request); 
		
		$response = json_decode($response);
		return $response;
		
	}	
		
}

//get lists from activecampaign
function DAPgetActiveCampaignLists(){
	$url = Dap_ExternalConnections::loadKeys('activecampaign' , 'ac_api_url'); 
	$api_key = Dap_ExternalConnections::loadKeys('activecampaign' , 'ac_api_key');
	if(!empty($url) && !empty($api_key)){
		$url = $url->getApi_key();
		$api_key = $api_key->getApi_key();
		
		$params = array(
			'api_key'      => $api_key,
			'api_action'   => 'list_list',
			'api_output'   => 'serialize',
			'ids'          => 'all',
		);

		$query = "";
		foreach( $params as $key => $value ) $query .= urlencode($key) . '=' . urlencode($value) . '&';
		$query = rtrim($query, '& ');
		
		$url = rtrim($url, '/ ');

		if ( !function_exists('curl_init') ) die('CURL not supported. (introduced in PHP 4.0.2)');

		if ( $params['api_output'] == 'json' && !function_exists('json_decode') ) {
			die('JSON not supported. (introduced in PHP 5.2.0)');
		}

		$api = $url . '/admin/api.php?' . $query;

		$request = curl_init($api); 
		curl_setopt($request, CURLOPT_HEADER, 0); 
		curl_setopt($request, CURLOPT_RETURNTRANSFER, 1); 
		curl_setopt($request, CURLOPT_FOLLOWLOCATION, true);
		$response = (string)curl_exec($request);

		curl_close($request); 

		if ( !$response ) {
			return;
		}
		else{
			$result = unserialize($response);
			/* Unsetting extra data from array so that only list of lists is returned */
			unset($result['result_code']);
			unset($result['result_message']);
			unset($result['result_output']);
		}
	}else{
		$result = '';
	}
		return $result;
}

function DAPgetAweberLists(){
	logToFile("functions_automation.php: SPCgetAweberLists(): Enter", LOG_DEBUG_DAP);	
	$lldocroot = defined('SITEROOT') ? SITEROOT : $_SERVER['DOCUMENT_ROOT'];
	require_once($lldocroot . '/dap/inc/tp/aweber_api/aweber_api.php');
	
	try{
		$consumerKey    = Dap_Config::get('AWEBER_CONSUMER_KEY'); # put your credentials here
		$consumerSecret = Dap_Config::get('AWEBER_CONSUMER_SECR'); # put your credentials here
		$accessKey      = Dap_Config::get('AWEBER_ACCESS_KEY'); # put your credentials here
		$accessSecret   = Dap_Config::get('AWEBER_ACCESS_SECRET'); # put your credentials here
		
		$aweber = new AWeberAPI($consumerKey, $consumerSecret);
		$account = $aweber->getAccount($accessKey, $accessSecret);
		
		$aweber_user = $aweber->loadFromUrl('https://api.aweber.com/1.0/accounts');
		$id = $aweber_user->data['entries'][0]['id'];
		$lists = $aweber->loadFromUrl('https://api.aweber.com/1.0/accounts/'.$id.'/lists');
		
		$list_data = $lists->data['entries'];
		$count = count($list_data);
		$listt = array();
		for($i=0;$i<$count;$i++){
			$listt[$i]['id'] = $list_data[$i]['id'];
			$listt[$i]['name'] = $list_data[$i]['name'];
		}
		return $listt;
		logToFile("functions_automation.php: SPCgetAweberLists(): EXIT", LOG_DEBUG_DAP);
	}
	catch(Exception $e){
		logToFile("functions_automation.php: SPCgetAweberLists(): error is ".$e->getMessage(), LOG_DEBUG_DAP);	
	}
}

function DAPgetConvertkitSequence(){
	logToFile("functions.php: DAPgetConvertkitSequence(): Enter", LOG_DEBUG_DAP);
	
	$api_key = Dap_ExternalConnections::loadKeys('convertkit' , 'convertkit_api_key'); 
	
	if($api_key == ""){
		logToFile("functions.php: DAPgetConvertkitSequence(): api_key is missing", LOG_DEBUG_DAP);
		return;
	}
	
	$api_key = $api_key->getApi_key();
	
	$api_secret = Dap_ExternalConnections::loadKeys('convertkit' , 'convertkit_api_secret'); 
	$api_secret = $api_secret->getApi_key();
	
	$url = "https://api.convertkit.com/v3/sequences?api_key=".$api_key;
	$curl = curl_init ( $url );
	curl_setopt ( $curl, CURLOPT_USERAGENT, 'DAP-CONVERTKIT' );
	curl_setopt ( $curl, CURLOPT_HEADER, TRUE );
	curl_setopt ( $curl, CURLOPT_SSL_VERIFYPEER, FALSE );
	curl_setopt ( $curl, CURLOPT_RETURNTRANSFER, TRUE );
	curl_setopt ( $curl, CURLOPT_FOLLOWLOCATION, TRUE );
	curl_setopt ( $curl, CURLOPT_CONNECTTIMEOUT, 30 );
	curl_setopt ( $curl, CURLOPT_TIMEOUT, 30 );
	curl_setopt($curl, CURLOPT_CUSTOMREQUEST, 'GET');
	$response = curl_exec ( $curl ); 
	if(!$response){
		logToFile("functions.php: DAPgetConvertkitSequence(): no response returned", LOG_DEBUG_DAP);	
	}
	else{
		$str = strpos($response,'{');
		$res_string = substr($response,$str);
		$result = json_decode($res_string);
		$courses = $result->courses;
		$count = count($courses);
		$course = array();
		for($i=0;$i<$count;$i++){
			$course[$i]['id'] = $courses[$i]->id;
			$course[$i]['name'] = $courses[$i]->name;
		}
		return $course;
	}
	logToFile("functions.php: DAPgetConvertkitSequence(): Exit", LOG_DEBUG_DAP);	
}

function DAPgetConvertkitForms(){
	logToFile("functions.php: DAPgetConvertkitForms(): Enter", LOG_DEBUG_DAP);	
	$api_key = Dap_ExternalConnections::loadKeys('convertkit' , 'convertkit_api_key'); 
	
	if($api_key == ""){
		logToFile("functions.php: DAPgetConvertkitForms(): api_key missing", LOG_DEBUG_DAP);	
		return;
	}
	try{	
		$api_key = $api_key->getApi_key();

		$api_secret = Dap_ExternalConnections::loadKeys('convertkit' , 'convertkit_api_secret'); 
		$api_secret = $api_secret->getApi_key();
		
		$url = "https://api.convertkit.com/v3/forms?api_key=".$api_key;
		$curl = curl_init ( $url );
		curl_setopt ( $curl, CURLOPT_USERAGENT, 'DAP-CONVERTKIT' );
		curl_setopt ( $curl, CURLOPT_HEADER, TRUE );
		curl_setopt ( $curl, CURLOPT_SSL_VERIFYPEER, FALSE );
		curl_setopt ( $curl, CURLOPT_RETURNTRANSFER, TRUE );
		curl_setopt ( $curl, CURLOPT_FOLLOWLOCATION, TRUE );
		curl_setopt ( $curl, CURLOPT_CONNECTTIMEOUT, 30 );
		curl_setopt ( $curl, CURLOPT_TIMEOUT, 30 );
		curl_setopt($curl, CURLOPT_CUSTOMREQUEST, 'GET');
		$response = curl_exec ( $curl ); 
		if(!$response){
			logToFile("functions.php: DAPgetConvertkitForms(): no response returned", LOG_DEBUG_DAP);	
		}
		else{
			$str = strpos($response,'{');
			$res_string = substr($response,$str);
			$result = json_decode($res_string);
			$forms = $result->forms;
			$count = count($forms);
			$form = array();
			for($i=0;$i<$count;$i++){
				$form[$i]['id'] = $forms[$i]->id;
				$form[$i]['name'] = $forms[$i]->name;
			}
			return $form;
		}
		
	}
	catch(Exception $e){
		logToFile("functions.php: DAPgetConvertkitForms(): error is ".$e->getMessage(), LOG_DEBUG_DAP);	
	}
	logToFile("functions.php: DAPgetConvertkitForms(): Exit", LOG_DEBUG_DAP);	
}


function DAPgetMailchimpLists(){
	logToFile("functions.php: DAPgetMailchimpLists(): Enter", LOG_DEBUG_DAP);	
	//~ $lldocroot = defined('SITEROOT') ? SITEROOT : $_SERVER['DOCUMENT_ROOT'];
	//~ $filename = $lldocroot . "/dap/plugins/mailchimp/MCAPI.class.php";
	
	//~ if (file_exists($filename)) {
		//~ include_once($filename);
	//~ }
	//~ try{
		//~ $api_key = $api_key->getApi_key();
		//~ $api = new MCAPI($api_key);
		//~ $lists = $api->lists();
		//~ $count = count($lists['data']);
		//~ $list = array();
		//~ for($i=0;$i<$count;$i++){
			//~ $list[$i]['id'] = $lists['data'][$i]['id'];
			//~ $list[$i]['name'] = $lists['data'][$i]['name'];
		//~ }
		//~ return $list;
	//~ }
	//~ catch(Exception $e){
		//~ logToFile("functions.php: DAPgetMailchimpLists(): error is ".$e->getMessage(), LOG_DEBUG_DAP);	
	//~ }
	
	try{
		$api_key = Dap_ExternalConnections::loadKeys('mailchimp' , 'mailchimp_api_key');
		if(isset($api_key))
			$api_key = $api_key->getApi_key();
		
		if($api_key == ""){
			logToFile("functions.php: DAPgetMailchimpLists(): api_key is missing", LOG_DEBUG_DAP);	
			return;
		}
	}
	catch(Exception $e){
		logToFile("functions.php: DAPgetMailchimpLists(): error is ".$e->getMessage(), LOG_DEBUG_DAP);	
	}

	$list = array();
	$dataCenter = substr($api_key,strpos($api_key,'-')+1);
    $url = 'https://' . $dataCenter . '.api.mailchimp.com/3.0/lists?count=500';

	$ch = curl_init($url);
    curl_setopt($ch, CURLOPT_USERPWD, 'user:' . $api_key); 
    curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 10);
    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'GET');
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
                                                                                                              
    $result = curl_exec($ch);
    $result1 = json_decode($result);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
   
    if($httpCode == "200"){
		$lists = $result1->lists;
		$i = 0;
		
		foreach($lists as $key){
		   $list[$i]['id'] = $key->id;
		   $list[$i]['name'] = $key->name;
		   $i++;
		}
	}
	else{
		logToFile("functions_automation.php: DAPgetMailchimpLists(),exception=".$result1->detail, LOG_DEBUG_DAP);
	}
	
	return $list;
	
}


//get lists from drip
function DAPgetDripCampaignLists(){
	logToFile("functions_automation.php: DAPgetDripCampaignLists() ENTER ", LOG_DEBUG_DAP);
	$token = Dap_ExternalConnections::loadKeys('drip' , 'drip_api_token'); 
	$accountId = Dap_ExternalConnections::loadKeys('drip' , 'drip_account_id');
	if(!empty($token) && !empty($accountId)){
		$token = $token->getApi_key();
		$accountId = $accountId->getApi_key();
	
		if($token != "" && $accountId != ""){
			$url = "https://api.getdrip.com/v2/" . $accountId . "/campaigns/";
			$curl = curl_init ( $url );
			curl_setopt($curl, CURLOPT_FRESH_CONNECT, true);
			curl_setopt($curl, CURLOPT_FORBID_REUSE, true);
			curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
			curl_setopt($curl, CURLOPT_FOLLOWLOCATION, true);
			curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
			curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
			curl_setopt($curl, CURLOPT_CONNECTTIMEOUT, 30 );
			curl_setopt($curl, CURLOPT_TIMEOUT, 30 );
			curl_setopt($curl, CURLOPT_USERPWD, "$token:");
			curl_setopt($curl, CURLOPT_USERAGENT, 'DAP-DRIP' );	
			curl_setopt($curl, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
			curl_setopt($curl, CURLOPT_CUSTOMREQUEST, 'GET');
			
			curl_setopt($curl, CURLOPT_HEADER, TRUE);

			curl_setopt($curl, CURLOPT_URL,$url);
			curl_setopt($curl, CURLOPT_HTTPHEADER, array(
				'Accept:application/json, text/javascript, */*; q=0.01',
				'Content-Type: application/vnd.api+json',
			));

			$response = curl_exec ( $curl );
		 
			curl_close ( $curl );
			if ( !$response ) {
				logToFile("functions_automation.php: DAPgetDripCampaignLists() No result returned ", LOG_DEBUG_DAP);
				return;
			}
			else{
				logToFile("functions_automation.php: DAPgetDripCampaignLists() Got response from DRIP  ", LOG_DEBUG_DAP);
				$str = strpos($response,'{');
				$res_string = substr($response,$str);
			
				$result = json_decode($res_string);
				/* Unsetting extra data from array so that only list of lists is returned */
				/* unset($result['result_code']);
				unset($result['result_message']);			unset($result['result_output']); */
				
				$campaigns = $result->campaigns;
				return $campaigns;
			}
			
		}
	}
	else{
		logToFile("functions_automation.php: DAPgetDripCampaignLists() token does not exits ", LOG_DEBUG_DAP);
	}
	logToFile("functions_automation.php: DAPgetDripCampaignLists() EXIT ", LOG_DEBUG_DAP);
}

function DAPautomationGetallData(){
	$all_data = Dap_ExternalNotifications::loadAutomation();
	return $all_data;
}


function DAPgetAutomationById($id){
	$all_data = Dap_ExternalNotifications::loadAutomationById($id);
	return $all_data;
	
}

function DAPgetTriggersDataForAutomation($id){
	$all_data = Dap_ExternalNotifications::loadTriggersById($id);
	return $all_data;
}

function DAPgetAutomationActionData($id){
	$all_data = Dap_ExternalNotifications::loadActionByAutomationId($id);
	return $all_data;
}

function DAPgetAutomationEventsList(){
	
}

function DAPgetAutomationBtns(){
	
}

function DAPgetAutomationTriggerData(){

}

/* DAP functions */

function ConvertRulesIntoParams($action){
	$destination = $action['destination'];	
	$function = $destination."Params";
	
	logToFile("functions_automation.php:,ConvertRulesIntoParams() destination is: ".$destination, LOG_INFO_DAP);
	try{
		logToFile("functions_automation.php:,ConvertRulesIntoParams() function is: ".$function, LOG_INFO_DAP);
		/* call different functions dynamically */
		if(function_exists($function)){
			return $function($action);
		}
	}
	catch(Exception $e){
		logToFile("functions_automation.php:,ConvertRulesIntoParams() Error is (): ".$e->getMessage(), LOG_INFO_DAP);
	}
	
}

function zapierParams($data){
	logToFile("functions_automation.php:,ConvertRulesIntoParams() zapierParams ", LOG_DEBUG_DAP);
	$value = explode("||",$data['value']);
	$url = $value[0];
	$tag = $value[1];
				
	$url1 = parse_url($url);
	$url = $url1['host']."".$url1['path'];
	
	$params = "dapconnect:".$url1['scheme'].":".$url.":Y";
	return $params;
}

function activecampaignParams($data){
	
	try{
		$url = Dap_ExternalConnections::loadKeys('activecampaign', 'ac_api_url');
		$url = $url->getApi_key();
		
		$api_key = Dap_ExternalConnections::loadKeys('activecampaign','ac_api_key');
		$api_key = $api_key->getApi_key();
		
		if($api_key == "" || $url == ""){
			logToFile("functions_automation.php: activecampaignParams(): api_key or api_url missing", LOG_DEBUG_DAP);	
			return;
		}
		
		
		if($data['name'] == "ListId"){
			$value = explode('||',$data['value']);
			$list_id = $value[0];
			$tag = $value[1];
			$sendpassword = $value[2];
		}
		else if($data['name'] == "Tag"){
			$value = explode('||',$data['value']);
			$listtoaddtag = $value[0];
			$tag = $value[1];
			$sendpassword = $value[2];
		}	
		$url1 = explode('//',$url);
		$params = "activecampaign:".$url1[1].":".$api_key.":".$list_id."::".$tag."::".$listtoaddtag.":".$sendpassword;
		return $params;	
	}
	catch(Exception $e){
		logToFile("functions_automation.php:,activecampaignParams() Error is (): ".$e->getMessage(), LOG_DEBUG_DAP);
	}
}

function aweberParams($data){
	
	try{

		if($data['action_type'] == "add"){
			
			if($data['name'] == "ListId"){
				$value = explode("||",$data['value']);
				$list_id = $value[0];
				$tag = $value[1];
				$sendpassword = $value[2];
			}
			else if($data['name'] == "Tag"){
				$value = explode("||",$data['value']);
				$list_id = $value[0];
				$tag = $value[1];
				$sendpassword = $value[2];
			}
		
			$params = "aweber:".$list_id.":".$sendpassword.":".$tag.":Y"; /* 1 is for send password */
		}
		else if($data['action_type'] == "remove"){
			
			if($data['name'] == "ListId"){
				$value = explode("||",$data['value']);
				$list_id = $value[0];
				$tag = $value[1];
			}
			else if($data['name'] == "Tag"){
				$value = explode("||",$data['value']); 
				$listtoremovefrom = $value[0];
				$tag = $value[1];
			}	
			$params = "aweber:delete:".$list_id.":".$tag.":".$listtoremovefrom.":Y"; /* 1 is for send password */
		}
		

		return $params;
	}
	catch(Exception $e){
		logToFile("functions_automation.php:,mailchimpParams() Error is (): ".$e->getMessage(), LOG_DEBUG_DAP);
	}
}

function mailchimpParams($data){
	
	try{
		$api_key = Dap_ExternalConnections::loadKeys('mailchimp', 'mailchimp_api_key');
		$api_key = $api_key->getApi_key();
	
	
		if($api_key == ""){
			logToFile("functions_automation.php: mailchimpParams(): api_key missing", LOG_DEBUG_DAP);	
			return;
		}
	
		if($data['name'] == "ListId"){
	 		$value = explode("||",$data['value']);
			$list_id = $value[0];
			$tag = $value[1];
		}

		$params = "mailchimp:".$api_key.":".$list_id.":".$tag; 

		return $params;
	}
	catch(Exception $e){
		logToFile("functions_automation.php:,mailchimpParams() Error is (): ".$e->getMessage(), LOG_DEBUG_DAP);
	}
}



function mailerliteParams($data){
	try{
		$api_key = Dap_ExternalConnections::loadKeys('mailerlite' , 'mailerlite_api_key'); 
		$api_key = $api_key->getApi_key();
	
	
		if($api_key == ""){
			logToFile("functions_automation.php: mailerliteParams(): api_key missing", LOG_DEBUG_DAP);	
			return;
		}
	
		if($data['name'] == "Group"){
	 		$value = explode("||",$data['value']);
			$list_id = $value[0];
			$tag = $value[1];
			$sendpassword = $value[2];
			
		}

		$params = "mailerlite:".$api_key.":".$list_id.":".$tag.":".$sendpassword ; 

		return $params;
	}
	catch(Exception $e){
		logToFile("functions_automation.php:,mailchimpParams() Error is (): ".$e->getMessage(), LOG_DEBUG_DAP);
	}
}


function convertkitParams($data){
	
	try{
		$api_key = Dap_ExternalConnections::loadKeys('convertkit', 'convertkit_api_key');
		$api_key = $api_key->getApi_key();
		
		$api_secret = Dap_ExternalConnections::loadKeys('convertkit', 'convertkit_api_secret');
		$api_secret = $api_secret->getApi_key();
		
		if($api_key == "" || $api_secret == ""){
			logToFile("functions_automation.php: convertkitParams(): api_key or api_secret missing", LOG_DEBUG_DAP);	
			return;
		}
		
		
		if($data['name'] == "Form"){
	 		$value = explode("||",$data['value']);
			$formid = $value[0];
			$tag = $value[1];
		}
		else if($data['name'] == "Sequence"){
			$value = explode("||",$data['value']);
			$sequence = $value[0];
			$tag = $value[1];
		}
		else if($data['name'] == "Tag"){
			$value = explode("||",$data['value']);
			$tag = $value[1];
		}
		
		$params = "convertkit:".$api_key.":".$formid.":".$sequence.":".$tag.":".$api_secret;
		
		return $params;
	}
	catch(Exception $e){
		logToFile("functions_automation.php:,convertkitParams() Error is (): ".$e->getMessage(), LOG_DEBUG_DAP);
	}
}


function dripParams($data){
	
	try{
		$token = Dap_ExternalConnections::loadKeys('drip', 'drip_api_token');
		$token = $token->getApi_key();
		
		$acount_id = Dap_ExternalConnections::loadKeys('drip', 'drip_account_id');
		$acount_id = $acount_id->getApi_key();
		
		if($acount_id == "" || $token == ""){
			logToFile("functions_automation.php: dripParams(): token or acount_id missing", LOG_DEBUG_DAP);	
			return;
		}
		
		
		if($data['name'] == "Campaign"){
	 		$value = explode("||",$data['value']);
			$camp_id = $value[0];
			$tag = $value[1];
		}
		else if($data['name'] == "Tag"){
			$value = explode("||",$data['value']);
			$tag = $value[1];
		}

		$params = "drip:".$acount_id.":".$token.":".$camp_id.":".$tag;
		
		return $params;
	}
	catch(Exception $e){
		logToFile("functions_automation.php:,dripParams() Error is (): ".$e->getMessage(), LOG_DEBUG_DAP);
	}
}


/* DAP functions ends */

