<?php

$lldocroot = defined('SITEROOT') ? SITEROOT : $_SERVER['DOCUMENT_ROOT'];

if(file_exists($lldocroot . "/dap/dap-config.php"))
	include_once ($lldocroot . "/dap/dap-config.php");

//~ ini_set("display_errors", "1");
//~ error_reporting(E_ALL);

include $lldocroot.'/dap/inc/tp/aws-sdk/aws-autoloader.php';

use Aws\Ses\SesClient;
use Aws\Exception\AwsException;

//~ $aws_api_key = constant('AWS_API_KEY');
//~ $aws_secret_key = constant('AWS_SECRET_KEY');

$aws_api_key = Dap_Config::get('AWS_API_KEY');
$aws_secret_key = Dap_Config::get('AWS_SECRET_KEY');

if($aws_api_key == "" || $aws_secret_key == ""){
	logToFile("amazon.php:API_KEY or SECRET_KEY is missing",LOG_DEBUG_DAP);
	return;
}

logToFile("amazon.php:job_id = ".$job_id,LOG_DEBUG_DAP);


$SesClient = new SesClient([
    'version' => '2010-12-01',
    'region'  => 'us-east-1',
    'credentials' => array(
        'key' => $aws_api_key,
        'secret'  => $aws_secret_key,
    )
]);


$sender_email = getAdminEmail();

$char_set = 'UTF-8';

// remove the [HTML_START] from body
$body = str_replace('[HTML_START]','',$body);
$plaintext_body = $body;

$plaintext_body =  str_replace('%%FIRST_NAME%%','{{FIRST_NAME}}',$plaintext_body);
$plaintext_body =  str_replace('%%LAST_NAME%%','{{LAST_NAME}}',$plaintext_body);
$plaintext_body =  str_replace('%%EMAIL_ID%%','{{EMAIL_ID}}',$plaintext_body);
$plaintext_body =  str_replace('%%ADMIN_EMAIL%%','{{ADMIN_EMAIL}}',$plaintext_body);
$plaintext_body =  str_replace('%%PASSWORD%%','{{PASSWORD}}',$plaintext_body);
$plaintext_body =  str_replace('%%ADMIN_NAME%%','{{ADMIN_NAME}}',$plaintext_body);
$plaintext_body =  str_replace('%%SITE_NAME%%','{{SITE_NAME}}',$plaintext_body);
$plaintext_body =  str_replace('%%SITE_URL_DAP%%','{{SITE_URL_DAP}}',$plaintext_body);
$plaintext_body =  str_replace('%%UNSUB_LINK%%','{{UNSUB_LINK}}',$plaintext_body);
$plaintext_body =  str_replace('%%AFF_LINK%%','{{AFF_LINK}}',$plaintext_body);
$plaintext_body =  str_replace('%%ACTIVATION_LINK%%','{{ACTIVATION_LINK}}',$plaintext_body);

$html_body = $plaintext_body;
$plaintext_body =  str_replace("\n", "", $plaintext_body);

$admin_email = getAdminEmail();
$admin_name = Dap_Config::get("ADMIN_NAME");
$admin_name = 	mb_convert_encoding($admin_name, "UTF-8", "auto");
$site_name_dap = Dap_Config::get("SITE_NAME");
$site_url_dap = Dap_Config::get("SITE_URL_DAP");

$configuration_set = '';
$configuration_set = Dap_Config::get("AWS_CONFIG_SET");

$job_array = array();
if($job_id != "")
	$job_array[] = array('Name'=>'job_id','Value'=>$job_id);
	
$template_name = time();
logToFile("amazon.php:Going to create the template with name=".$template_name,LOG_DEBUG_DAP);
try{ 
    $result = $SesClient->createTemplate([
        'Template' => [ // REQUIRED
            'HtmlPart' => $html_body,
            'SubjectPart' => $subject,
            'TemplateName' => $template_name, // REQUIRED
            'TextPart' => $plaintext_body,
        ], 
    ]);
    logToFile("amazon.php:Template created successfully",LOG_DEBUG_DAP);
} 
catch (AwsException $e) {
    logToFile("amazon.php:template not created, Error message: ".$e->getAwsErrorMessage(),LOG_DEBUG_DAP);
}


$total_emails = count($results);
$mails_per_iteration  = 50; // max batch size of mails amazon allows
$count = round($total_emails/$mails_per_iteration);
if($count == 0)
	$count = 1;

$k = 0;


logToFile("amazon.php:Total emails to be sent=".$total_emails,LOG_DEBUG_DAP);
logToFile("amazon.php:Number of bathces that will be needed to send these=".$count,LOG_DEBUG_DAP);

for($a=0;$a<$count;$a++){
	$current_batch = array();
	for($j=0;$j<$mails_per_iteration;$j++){
		if($k<$total_emails){
			$current_batch[] = $results[$k];
		}
		else{
			break;
		}
		$k++;
	}
	
	$destinations = array();
	$i = 0; 
	foreach($current_batch AS $key){
		$destination = array();
		$email = $key['email'];
		
		if($email != "")  {
			$user = Dap_User::loadUserByEmail($email);
			if(isset($user)){
				//$destinations['ToAddresses'] = array($key['email']);
				$unsublink   = "$site_url_dap/dap/unsub.php?e=".$user->getEmail()."&c=".$user->getActivation_key();
				$aff_link = "$site_url_dap/dap/a/?a=".$user->getId();
				$activationLink = "$site_url_dap/dap/preactivate.php?c=".$user->getActivation_key()."&p=".$productId."";
				$destinations[$i] = [ 
				'Destination' => [
					'ToAddresses' => [$key['email']]  
				],
				'ReplacementTemplateData'=> json_encode(['FIRST_NAME'=>$key['first_name'], 'LAST_NAME'=>$key['last_name'],'EMAIL_ID'=>$key['email'],'ADMIN_EMAIL'=>$admin_email,'PASSWORD'=>($user->getPassword()!="")?$user->getPassword():'','ADMIN_NAME'=>$admin_name,'SITE_NAME'=>$site_name_dap,'SITE_URL_DAP'=>$site_url_dap,'UNSUB_LINK'=>$unsublink,'AFF_LINK'=>$aff_link,'ACTIVATION_LINK'=>$activationLink]),
			  ];
				$i++;
			}
		}
	}
	
	logToFile("amazon.php:Created destinations array for the ".($a+1)." batch",LOG_DEBUG_DAP);
	
	try {
		$result = $SesClient->SendBulkTemplatedEmail([

			'Destinations' => $destinations,
			'DefaultTemplateData' =>json_encode(['name'=>'user', 'subject'=>'amazon mail from dap']),
			
			'DefaultTags' => $job_array,
			'ReplyToAddresses' => [$sender_email],
			'Source' => $sender_email,
			'Message' => [
			  'Body' => [
				  'Html' => [
					  'Charset' => $char_set,
					  'Data' => $html_body,
				  ],
				  'Text' => [
					  'Charset' => $char_set,
					  'Data' => $plaintext_body,
				  ],
			  ],
			  'Subject' => [
				  'Charset' => $char_set,
				  'Data' => $subject,
			  ],
			],
			'Template' => $template_name,
			'ConfigurationSetName' => $configuration_set
		]);
		$messageId = $result['MessageId'];
		logToFile("amazon.php:Emails sent! for".($a+1)." batch",LOG_DEBUG_DAP);
		
	} catch (AwsException $e) {
		// output error message if fails
		logToFile("amazon.php:The email was not sent. Error message:".$e->getAwsErrorMessage(),LOG_DEBUG_DAP);
	}

}//for loop

logToFile("amazon.php:Now going to delete the template",LOG_DEBUG_DAP);

//now delete the template
try{ 
    $result = $SesClient->deleteTemplate([
        'TemplateName' => $template_name
    ]);
    logToFile("amazon.php:Template deleted",LOG_DEBUG_DAP);
} 
catch (AwsException $e) {
    logToFile("template coudn't be deleted, Error message: ".$e->getAwsErrorMessage(),LOG_DEBUG_DAP);
}

// now going to save the broadcast data in the reports
logToFile("amazon.php,going to save the broadcast data in the reports",LOG_DEBUG_DAP);

try{
	$obj = new Dap_EmailReports();
	$obj->setTracking_id($job_id);
	$obj->setEvent_type('BROADCAST-EMAIL');
	$obj->setTotal_emails($total_emails);
	$obj->setSource('AMAZONSES');
	$obj->setSubject($subject);
	$obj->create();
	logToFile("amazon.php,data saved for email reports",LOG_DEBUG_DAP);
}
catch(Exception $e){
	logToFile("amazon.php:error".$e->getMessage(),LOG_DEBUG_DAP);
}



